/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.GridFilteringModel;
import com.intellij.database.datagrid.GridLoader;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridSortingModel;
import com.intellij.database.dialects.DatabaseErrorHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GridDataHookUp<Row, Column> {
    @NotNull
    public Project getProject();

    @NotNull
    public GridModel<Row, Column> getModel();

    @NotNull
    public GridPagingModel<Row, Column> getPageModel();

    @Nullable
    public GridFilteringModel getFilteringModel();

    @Nullable
    public GridSortingModel<Row, Column> getSortingModel();

    @Nullable
    public GridMutator<Row, Column> getMutator();

    @NotNull
    public GridLoader<Row, Column> getLoader();

    public int getBusyCount();

    public void cancelRequests();

    public boolean isReadOnly();

    public void addRequestListener(@NotNull RequestListener<Row, Column> var1, @NotNull Disposable var2);

    public static interface RequestListener<Row, Column>
    extends EventListener {
        public void error(@NotNull GridRequestSource<Row, Column> var1, @Nullable String var2, @Nullable List<DatabaseErrorHandler.Fix> var3, @Nullable Throwable var4);

        public void updateCountReceived(@NotNull GridRequestSource<Row, Column> var1, int var2);

        public void requestFinished(@NotNull GridRequestSource<Row, Column> var1, boolean var2);
    }
}

