/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.model.DataType;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DataConsumer {
    public void setColumns(@NotNull DataRequest.Context var1, int var2, Column @NotNull [] var3, int var4);

    default public void updateColumns(@NotNull DataRequest.Context context, Column @NotNull [] columns) {
        if (context == null) {
            DataConsumer.$$$reportNull$$$0(0);
        }
        if (columns == null) {
            DataConsumer.$$$reportNull$$$0(1);
        }
    }

    public void addRows(@NotNull DataRequest.Context var1, List<Row> var2);

    public void afterLastRowAdded(@NotNull DataRequest.Context var1, int var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "columns";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/datagrid/DataConsumer";
        objectArray[2] = "updateColumns";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Composite
    extends Adapter {
        private final List<DataConsumer> delegates;

        public Composite(List<DataConsumer> delegates) {
            this.delegates = delegates;
        }

        public Composite(DataConsumer ... delegates) {
            this.delegates = Arrays.asList(delegates);
        }

        @Override
        public void setColumns(@NotNull DataRequest.Context context, int resultSetIndex, Column @NotNull [] columns, int firstRowNum) {
            if (context == null) {
                Composite.$$$reportNull$$$0(0);
            }
            if (columns == null) {
                Composite.$$$reportNull$$$0(1);
            }
            for (DataConsumer delegate : this.delegates) {
                delegate.setColumns(context, resultSetIndex, columns, firstRowNum);
            }
        }

        @Override
        public void updateColumns(@NotNull DataRequest.Context context, Column @NotNull [] columns) {
            if (context == null) {
                Composite.$$$reportNull$$$0(2);
            }
            if (columns == null) {
                Composite.$$$reportNull$$$0(3);
            }
            for (DataConsumer delegate : this.delegates) {
                delegate.updateColumns(context, columns);
            }
        }

        @Override
        public void addRows(@NotNull DataRequest.Context context, List<Row> rows) {
            if (context == null) {
                Composite.$$$reportNull$$$0(4);
            }
            for (DataConsumer delegate : this.delegates) {
                delegate.addRows(context, rows);
            }
        }

        @Override
        public void afterLastRowAdded(@NotNull DataRequest.Context context, int total) {
            if (context == null) {
                Composite.$$$reportNull$$$0(5);
            }
            for (DataConsumer delegate : this.delegates) {
                delegate.afterLastRowAdded(context, total);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/datagrid/DataConsumer$Composite";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setColumns";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateColumns";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addRows";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterLastRowAdded";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class Wrapper
    implements DataConsumer {
        public final DataConsumer delegate;

        public Wrapper(DataConsumer dataConsumer) {
            this.delegate = dataConsumer;
        }

        public boolean accepts(DataRequest.Owner owner) {
            return true;
        }

        public boolean accepts(@NotNull DataRequest.Context context) {
            if (context == null) {
                Wrapper.$$$reportNull$$$0(0);
            }
            return this.accepts(context.request.owner);
        }

        @Override
        public void setColumns(@NotNull DataRequest.Context context, int resultSetIndex, Column @NotNull [] columns, int firstRowNum) {
            if (context == null) {
                Wrapper.$$$reportNull$$$0(1);
            }
            if (columns == null) {
                Wrapper.$$$reportNull$$$0(2);
            }
            if (this.accepts(context)) {
                this.delegate.setColumns(context, resultSetIndex, columns, firstRowNum);
            }
        }

        @Override
        public void updateColumns(@NotNull DataRequest.Context context, Column @NotNull [] columns) {
            if (context == null) {
                Wrapper.$$$reportNull$$$0(3);
            }
            if (columns == null) {
                Wrapper.$$$reportNull$$$0(4);
            }
            if (this.accepts(context)) {
                this.delegate.updateColumns(context, columns);
            }
        }

        @Override
        public void addRows(@NotNull DataRequest.Context context, List<Row> rows) {
            if (context == null) {
                Wrapper.$$$reportNull$$$0(5);
            }
            if (this.accepts(context)) {
                this.delegate.addRows(context, rows);
            }
        }

        @Override
        public void afterLastRowAdded(@NotNull DataRequest.Context context, int total) {
            if (context == null) {
                Wrapper.$$$reportNull$$$0(6);
            }
            if (this.accepts(context)) {
                this.delegate.afterLastRowAdded(context, total);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/datagrid/DataConsumer$Wrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "accepts";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setColumns";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateColumns";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addRows";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterLastRowAdded";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class Adapter
    implements DataConsumer {
        @Override
        public void setColumns(@NotNull DataRequest.Context context, int resultSetIndex, Column @NotNull [] columns, int firstRowNum) {
            if (context == null) {
                Adapter.$$$reportNull$$$0(0);
            }
            if (columns == null) {
                Adapter.$$$reportNull$$$0(1);
            }
        }

        @Override
        public void addRows(@NotNull DataRequest.Context context, List<Row> rows) {
            if (context == null) {
                Adapter.$$$reportNull$$$0(2);
            }
        }

        @Override
        public void afterLastRowAdded(@NotNull DataRequest.Context context, int total) {
            if (context == null) {
                Adapter.$$$reportNull$$$0(3);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/datagrid/DataConsumer$Adapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setColumns";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addRows";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterLastRowAdded";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Column
    implements ColumnDescriptor {
        public final Set<Attribute> attributes;
        public final int columnNum;
        public final int type;
        public final String name;
        public final String typeName;
        public final String clazz;
        public final int precision;
        public final int scale;
        public final String catalog;
        public final String schema;
        public final String table;

        public Column(int columnNum, String name, int type, String typeName, String clazz) {
            this(columnNum, name, type, typeName, clazz, -1, -1, null, null, null);
        }

        public Column(int columnNum, String name, int type, String typeName, String clazz, int precision, int scale, @Nullable String catalog, @Nullable String schema, @Nullable String table) {
            this(columnNum, name, type, typeName, clazz, precision, scale, catalog, schema, table, Collections.emptySet());
        }

        public Column(int columnNum, String name, int type, String typeName, String clazz, int precision, int scale, @Nullable String catalog, @Nullable String schema, @Nullable String table, @NotNull Set<Attribute> attributes2) {
            if (attributes2 == null) {
                Column.$$$reportNull$$$0(0);
            }
            this.columnNum = columnNum;
            this.name = name;
            this.type = type;
            this.typeName = typeName;
            this.clazz = clazz;
            this.precision = precision;
            this.scale = scale;
            this.catalog = catalog;
            this.schema = schema;
            this.table = table;
            this.attributes = attributes2;
        }

        @Nullable
        public Object getValue(@NotNull Row row) {
            if (row == null) {
                Column.$$$reportNull$$$0(1);
            }
            return row.getValue(this.columnNum);
        }

        public void setValue(@NotNull Row row, Object o) {
            if (row == null) {
                Column.$$$reportNull$$$0(2);
            }
            row.values[this.columnNum] = o;
        }

        @Override
        public String getJavaClassName() {
            return this.clazz;
        }

        @NotNull
        public DataType asDataType() {
            String type = StringUtil.isEmpty((String)this.typeName) ? "unknown" : this.typeName;
            DataType dataType = DataTypeFactory.of(this.schema, type, this.precision, this.scale, null, null, false, false);
            if (dataType == null) {
                Column.$$$reportNull$$$0(3);
            }
            return dataType;
        }

        @Override
        public int getScale() {
            return this.scale;
        }

        public String toString() {
            return "Column" + this.columnNum + "{name='" + this.name + "', type=" + this.type + ", typeName='" + this.typeName + "', clazz='" + this.clazz + "', table='" + this.catalog + "'.'" + this.schema + "'.'" + this.table + "'}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Column column2 = (Column)o;
            if (this.columnNum != column2.columnNum) {
                return false;
            }
            if (this.precision != column2.precision) {
                return false;
            }
            if (this.scale != column2.scale) {
                return false;
            }
            if (this.type != column2.type) {
                return false;
            }
            if (this.catalog != null ? !this.catalog.equals(column2.catalog) : column2.catalog != null) {
                return false;
            }
            if (this.clazz != null ? !this.clazz.equals(column2.clazz) : column2.clazz != null) {
                return false;
            }
            if (this.name != null ? !this.name.equals(column2.name) : column2.name != null) {
                return false;
            }
            if (this.schema != null ? !this.schema.equals(column2.schema) : column2.schema != null) {
                return false;
            }
            if (this.table != null ? !this.table.equals(column2.table) : column2.table != null) {
                return false;
            }
            if (this.typeName != null ? !this.typeName.equals(column2.typeName) : column2.typeName != null) {
                return false;
            }
            return this.attributes.equals(column2.attributes);
        }

        public int hashCode() {
            int result = this.columnNum;
            result = 31 * result + this.type;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.typeName != null ? this.typeName.hashCode() : 0);
            result = 31 * result + (this.clazz != null ? this.clazz.hashCode() : 0);
            result = 31 * result + this.precision;
            result = 31 * result + this.scale;
            result = 31 * result + (this.catalog != null ? this.catalog.hashCode() : 0);
            result = 31 * result + (this.schema != null ? this.schema.hashCode() : 0);
            result = 31 * result + (this.table != null ? this.table.hashCode() : 0);
            result = 31 * result + Objects.hash(this.attributes.toArray());
            return result;
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getTypeName() {
            return this.typeName;
        }

        @Override
        public int getSize() {
            return this.precision;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/DataConsumer$Column";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/DataConsumer$Column";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asDataType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setValue";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        public static enum Attribute {
            ZERO_PADDING,
            ROW_ID;

        }
    }

    public static class Row {
        public final int rowNum;
        public final Object[] values;

        protected Row(int rowNum, Object[] values2) {
            this.rowNum = rowNum;
            this.values = values2;
        }

        public static Row create(int realIdx, Object[] values2) {
            return new Row(realIdx + 1, values2);
        }

        public static int toRealIdx(@NotNull Row row) {
            if (row == null) {
                Row.$$$reportNull$$$0(0);
            }
            return row.rowNum - 1;
        }

        public Object getValue(int columnNum) {
            return this.values[columnNum];
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Row row = (Row)o;
            if (this.rowNum != row.rowNum) {
                return false;
            }
            return Arrays.equals(this.values, row.values);
        }

        public int hashCode() {
            int result = this.rowNum;
            result = 31 * result + Arrays.hashCode(this.values);
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/datagrid/DataConsumer$Row", "toRealIdx"));
        }
    }
}

