/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.util.DbUIUtil;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DataAuditor {
    public void print(@NotNull DataRequest.Context var1, @NlsContexts.NotificationContent @Nullable String var2);

    public void warn(@NotNull DataRequest.Context var1, @NlsContexts.NotificationContent @Nullable String var2);

    public void error(@NotNull DataRequest.Context var1, @NlsContexts.NotificationContent @Nullable String var2, @Nullable Throwable var3);

    public void beforeStatement(@NotNull DataRequest.Context var1);

    public void afterStatement(@NotNull DataRequest.Context var1);

    public void updateCountReceived(@NotNull DataRequest.Context var1, int var2);

    public void fetchStarted(@NotNull DataRequest.Context var1, int var2);

    public void fetchFinished(@NotNull DataRequest.Context var1, int var2, int var3);

    public void requestStarted(@NotNull DataRequest.Context var1);

    public void requestFinished(@NotNull DataRequest.Context var1);

    public void txCompleted(@NotNull DataRequest.Context var1, @NotNull TxEvent var2);

    public void jobSubmitted(@NotNull DataRequest var1, @NotNull DataProducer var2);

    public void jobFinished(@NotNull DataRequest var1, @NotNull DataProducer var2);

    public static class ConsoleLogger
    extends PrintingAdapter {
        public final ConsoleView consoleView;

        public ConsoleLogger(ConsoleView view2) {
            this.consoleView = view2;
        }

        @Override
        public void rawPrint(@NotNull String s2, @NotNull ConsoleViewContentType output) {
            if (s2 == null) {
                ConsoleLogger.$$$reportNull$$$0(0);
            }
            if (output == null) {
                ConsoleLogger.$$$reportNull$$$0(1);
            }
            this.consoleView.print(s2, output);
        }

        @Override
        @NotNull
        public String rawDecorateLine(@NotNull String s2, @NotNull ConsoleViewContentType output) {
            if (s2 == null) {
                ConsoleLogger.$$$reportNull$$$0(2);
            }
            if (output == null) {
                ConsoleLogger.$$$reportNull$$$0(3);
            }
            Object object = output == ConsoleViewContentType.USER_INPUT ? s2 : DataSourceUiUtil.currentTime() + s2;
            if (object == null) {
                ConsoleLogger.$$$reportNull$$$0(4);
            }
            return object;
        }

        public void scrollToEnd() {
            if (this.consoleView instanceof ConsoleViewImpl) {
                DbUIUtil.invokeLater(() -> ((ConsoleViewImpl)this.consoleView).scrollToEnd());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "output";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/DataAuditor$ConsoleLogger";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/DataAuditor$ConsoleLogger";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "rawDecorateLine";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "rawPrint";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "rawDecorateLine";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class PrintingAdapter
    extends Adapter {
        private static final Logger LOG = Logger.getInstance(PrintingAdapter.class);

        public void rawPrint(@Nls @NotNull String s2, @NotNull ConsoleViewContentType output) {
            if (s2 == null) {
                PrintingAdapter.$$$reportNull$$$0(0);
            }
            if (output == null) {
                PrintingAdapter.$$$reportNull$$$0(1);
            }
        }

        @Nls
        @NotNull
        public String rawDecorateLine(@Nls @NotNull String s2, @NotNull ConsoleViewContentType output) {
            if (s2 == null) {
                PrintingAdapter.$$$reportNull$$$0(2);
            }
            if (output == null) {
                PrintingAdapter.$$$reportNull$$$0(3);
            }
            String string = s2;
            if (string == null) {
                PrintingAdapter.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        public void print(@NotNull DataRequest.Context context, @Nullable String message2) {
            if (context == null) {
                PrintingAdapter.$$$reportNull$$$0(5);
            }
            this.print(message2);
        }

        @Override
        public void warn(@NotNull DataRequest.Context context, @Nullable String message2) {
            if (context == null) {
                PrintingAdapter.$$$reportNull$$$0(6);
            }
            this.println(message2, ConsoleViewContentType.SYSTEM_OUTPUT);
        }

        @Override
        public void error(@NotNull DataRequest.Context context, @Nullable String message2, @Nullable Throwable th) {
            if (context == null) {
                PrintingAdapter.$$$reportNull$$$0(7);
            }
            this.error(message2, th);
        }

        public void print(@Nls String message2) {
            this.println(message2, ConsoleViewContentType.NORMAL_OUTPUT);
        }

        public void error(@Nls String message2, Throwable th) {
            if (message2 != null) {
                this.println(message2, ConsoleViewContentType.ERROR_OUTPUT);
            }
            if (th != null) {
                this.printError(th);
            }
        }

        public void printError(Throwable throwable) {
            this.error(ExceptionUtil.getUserStackTrace((Throwable)throwable, (Logger)LOG), null);
        }

        public void println(@Nls String message2, ConsoleViewContentType output) {
            if (StringUtil.isEmptyOrSpaces((String)message2)) {
                this.newLine();
            } else {
                for (String s2 : StringUtil.splitByLines((String)message2)) {
                    this.rawPrint(this.rawDecorateLine(s2, output), output);
                    this.newLine();
                }
            }
        }

        public void newLine() {
            this.rawPrint("\n", ConsoleViewContentType.NORMAL_OUTPUT);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "output";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/DataAuditor$PrintingAdapter";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/DataAuditor$PrintingAdapter";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "rawDecorateLine";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "rawPrint";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "rawDecorateLine";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "print";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "warn";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "error";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class BusyCounter
    extends Adapter {
        private final AtomicInteger count = new AtomicInteger();

        @Override
        public void jobSubmitted(@NotNull DataRequest request, @NotNull DataProducer producer) {
            if (request == null) {
                BusyCounter.$$$reportNull$$$0(0);
            }
            if (producer == null) {
                BusyCounter.$$$reportNull$$$0(1);
            }
            this.update(this.count.incrementAndGet());
        }

        @Override
        public void jobFinished(@NotNull DataRequest request, @NotNull DataProducer producer) {
            if (request == null) {
                BusyCounter.$$$reportNull$$$0(2);
            }
            if (producer == null) {
                BusyCounter.$$$reportNull$$$0(3);
            }
            this.update(this.count.decrementAndGet());
        }

        public int getCount() {
            return this.count.intValue();
        }

        protected void update(int current) {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "producer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/datagrid/DataAuditor$BusyCounter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "jobSubmitted";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "jobFinished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Wrapper
    implements DataAuditor {
        public final DataAuditor delegate;

        public Wrapper(DataAuditor delegate) {
            this.delegate = delegate;
        }

        public boolean accepts(DataRequest.Owner owner) {
            return true;
        }

        protected boolean accepts(DataRequest.Context context) {
            return this.accepts(context.request.owner);
        }

        @Override
        public void print(@NotNull DataRequest.Context context, @Nullable String message2) {
            if (context == null) {
                Wrapper.$$$reportNull$$$0(0);
            }
            if (this.accepts(context)) {
                this.delegate.print(context, message2);
            }
        }

        @Override
        public void warn(@NotNull DataRequest.Context context, @Nullable String message2) {
            if (context == null) {
                Wrapper.$$$reportNull$$$0(1);
            }
            if (this.accepts(context)) {
                this.delegate.warn(context, message2);
            }
        }

        @Override
        public void error(@NotNull DataRequest.Context context, @Nullable String message2, @Nullable Throwable th) {
            if (context == null) {
                Wrapper.$$$reportNull$$$0(2);
            }
            if (this.accepts(context)) {
                this.delegate.error(context, message2, th);
            }
        }

        @Override
        public void beforeStatement(@NotNull DataRequest.Context context) {
            if (context == null) {
                Wrapper.$$$reportNull$$$0(3);
            }
            if (this.accepts(context)) {
                this.delegate.beforeStatement(context);
            }
        }

        @Override
        public void afterStatement(@NotNull DataRequest.Context context) {
            if (context == null) {
                Wrapper.$$$reportNull$$$0(4);
            }
            if (this.accepts(context)) {
                this.delegate.afterStatement(context);
            }
        }

        @Override
        public void requestStarted(@NotNull DataRequest.Context context) {
            if (context == null) {
                Wrapper.$$$reportNull$$$0(5);
            }
            if (this.accepts(context)) {
                this.delegate.requestStarted(context);
            }
        }

        @Override
        public void updateCountReceived(@NotNull DataRequest.Context context, int updateCount2) {
            if (context == null) {
                Wrapper.$$$reportNull$$$0(6);
            }
            if (this.accepts(context)) {
                this.delegate.updateCountReceived(context, updateCount2);
            }
        }

        @Override
        public void fetchStarted(@NotNull DataRequest.Context context, int index2) {
            if (context == null) {
                Wrapper.$$$reportNull$$$0(7);
            }
            if (this.accepts(context)) {
                this.delegate.fetchStarted(context, index2);
            }
        }

        @Override
        public void fetchFinished(@NotNull DataRequest.Context context, int index2, int rowCount) {
            if (context == null) {
                Wrapper.$$$reportNull$$$0(8);
            }
            if (this.accepts(context)) {
                this.delegate.fetchFinished(context, index2, rowCount);
            }
        }

        @Override
        public void requestFinished(@NotNull DataRequest.Context context) {
            if (context == null) {
                Wrapper.$$$reportNull$$$0(9);
            }
            if (this.accepts(context)) {
                this.delegate.requestFinished(context);
            }
        }

        @Override
        public void txCompleted(@NotNull DataRequest.Context context, @NotNull TxEvent event) {
            if (context == null) {
                Wrapper.$$$reportNull$$$0(10);
            }
            if (event == null) {
                Wrapper.$$$reportNull$$$0(11);
            }
            if (this.accepts(context)) {
                this.delegate.txCompleted(context, event);
            }
        }

        @Override
        public void jobSubmitted(@NotNull DataRequest request, @NotNull DataProducer producer) {
            if (request == null) {
                Wrapper.$$$reportNull$$$0(12);
            }
            if (producer == null) {
                Wrapper.$$$reportNull$$$0(13);
            }
            if (this.accepts(request.owner)) {
                this.delegate.jobSubmitted(request, producer);
            }
        }

        @Override
        public void jobFinished(@NotNull DataRequest request, @NotNull DataProducer producer) {
            if (request == null) {
                Wrapper.$$$reportNull$$$0(14);
            }
            if (producer == null) {
                Wrapper.$$$reportNull$$$0(15);
            }
            if (this.accepts(request.owner)) {
                this.delegate.jobFinished(request, producer);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 12: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 13: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "producer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/datagrid/DataAuditor$Wrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "print";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "warn";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "error";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeStatement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterStatement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requestStarted";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateCountReceived";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fetchStarted";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fetchFinished";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requestFinished";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "txCompleted";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "jobSubmitted";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "jobFinished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class Adapter
    implements DataAuditor {
        @Override
        public void print(@NotNull DataRequest.Context context, @Nullable String message2) {
            if (context == null) {
                Adapter.$$$reportNull$$$0(0);
            }
        }

        @Override
        public void warn(@NotNull DataRequest.Context context, @Nullable String message2) {
            if (context == null) {
                Adapter.$$$reportNull$$$0(1);
            }
        }

        @Override
        public void error(@NotNull DataRequest.Context context, @Nullable String message2, @Nullable Throwable th) {
            if (context == null) {
                Adapter.$$$reportNull$$$0(2);
            }
        }

        @Override
        public void beforeStatement(@NotNull DataRequest.Context context) {
            if (context == null) {
                Adapter.$$$reportNull$$$0(3);
            }
        }

        @Override
        public void afterStatement(@NotNull DataRequest.Context context) {
            if (context == null) {
                Adapter.$$$reportNull$$$0(4);
            }
        }

        @Override
        public void requestStarted(@NotNull DataRequest.Context context) {
            if (context == null) {
                Adapter.$$$reportNull$$$0(5);
            }
        }

        @Override
        public void updateCountReceived(@NotNull DataRequest.Context context, int updateCount2) {
            if (context == null) {
                Adapter.$$$reportNull$$$0(6);
            }
        }

        @Override
        public void fetchStarted(@NotNull DataRequest.Context context, int index2) {
            if (context == null) {
                Adapter.$$$reportNull$$$0(7);
            }
        }

        @Override
        public void fetchFinished(@NotNull DataRequest.Context context, int index2, int rowCount) {
            if (context == null) {
                Adapter.$$$reportNull$$$0(8);
            }
        }

        @Override
        public void requestFinished(@NotNull DataRequest.Context context) {
            if (context == null) {
                Adapter.$$$reportNull$$$0(9);
            }
        }

        @Override
        public void txCompleted(@NotNull DataRequest.Context context, @NotNull TxEvent event) {
            if (context == null) {
                Adapter.$$$reportNull$$$0(10);
            }
            if (event == null) {
                Adapter.$$$reportNull$$$0(11);
            }
        }

        @Override
        public void jobSubmitted(@NotNull DataRequest request, @NotNull DataProducer producer) {
            if (request == null) {
                Adapter.$$$reportNull$$$0(12);
            }
            if (producer == null) {
                Adapter.$$$reportNull$$$0(13);
            }
        }

        @Override
        public void jobFinished(@NotNull DataRequest request, @NotNull DataProducer producer) {
            if (request == null) {
                Adapter.$$$reportNull$$$0(14);
            }
            if (producer == null) {
                Adapter.$$$reportNull$$$0(15);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 12: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 13: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "producer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/datagrid/DataAuditor$Adapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "print";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "warn";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "error";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeStatement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterStatement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requestStarted";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateCountReceived";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fetchStarted";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fetchFinished";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requestFinished";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "txCompleted";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "jobSubmitted";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "jobFinished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum TxEvent {
        COMPLETED(true, false),
        REVERTED(false, true),
        OWNER_DISPOSAL(false, false);

        public final boolean completed;
        public final boolean reverted;

        private TxEvent(boolean completed, boolean reverted) {
            this.completed = completed;
            this.reverted = reverted;
        }
    }
}

