/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.validation;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseArtifactList;
import com.intellij.database.dataSource.DatabaseArtifactManager;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtilCore;
import com.intellij.database.dataSource.url.template.UrlTemplate;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.dataSource.validation.NamedProgressive;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.Version;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.database.view.ui.DatabaseDriverConfigurable;
import com.intellij.database.view.ui.DriverClasspathPanel;
import com.intellij.ide.IdeBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.net.IOExceptionDialog;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseDriverValidator
extends DatabaseConfigValidator<DatabaseDriverImpl> {
    public static final String INVALID_FILES = "INVALID_FILES";

    @Override
    public Class<DatabaseDriverImpl> getTargetClass() {
        return DatabaseDriverImpl.class;
    }

    @Override
    public void collectProblems(@NotNull Project project, @NotNull DatabaseDriverImpl driver, @NotNull Consumer<? super DataSourceProblem> problems, @Nullable DatabaseConfigEditor editor) {
        if (project == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(0);
        }
        if (driver == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(1);
        }
        if (problems == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(2);
        }
        if (!driver.getTemplatesErrors().isEmpty()) {
            StringBuilder msg = new StringBuilder();
            for (Pair<UrlTemplate, String> pair : driver.getTemplatesErrors()) {
                msg.append("<br>&nbsp;&nbsp;&nbsp;&nbsp;");
                msg.append(StringUtil.escapeXmlEntities((String)((UrlTemplate)pair.getFirst()).getName())).append(" &mdash; ").append(StringUtil.escapeXmlEntities((String)((String)pair.getSecond())));
            }
            @NlsSafe String shortDesc = msg.toString();
            String longDesc = DatabaseBundle.message((String)"driver.a.href.action0.0.a.has.invalid.templates.1", (Object[])new Object[]{StringUtil.escapeXmlEntities((String)driver.getFullName()), shortDesc});
            problems.consume((Object)new DataSourceProblem(driver, null, DataSourceProblem.Level.WARNING, new DataSourceProblem.HyperText(DatabaseBundle.message((String)"notification.title.invalid.template", (Object[])new Object[0]), shortDesc, longDesc, new DataSourceProblem.Navigate(driver)), null));
        }
    }

    public static boolean isDriverFilesValid(@NotNull String artifact, @Nullable Version version, @Nullable Collection<SimpleClasspathElement> actual) {
        if (artifact == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(3);
        }
        DatabaseArtifactList artifacts = DatabaseArtifactManager.getArtifacts();
        if (version == null) {
            return actual != null && !actual.isEmpty() && DatabaseDriverValidator.isFileListExists(DatabaseDriverValidator.getUrls(actual));
        }
        return artifacts.isValid(artifact, version);
    }

    public static boolean isDriverFilesUpToDate(@NotNull DatabaseDriver driver, @NotNull List<DatabaseDriver.ArtifactRef> artifacts) {
        if (driver == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(4);
        }
        if (artifacts == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(5);
        }
        return ContainerUtil.and(artifacts, a2 -> DatabaseDriverValidator.isDriverFilesUpToDate(driver, a2.getId(), a2.getArtifactVersion(), a2.getChannel()));
    }

    public static boolean isDriverFilesUpToDate(@NotNull DatabaseDriver driver, @NotNull String artifact, @Nullable Version version, @Nullable String channel) {
        DatabaseArtifactList artifacts;
        DatabaseArtifactList.ArtifactVersion actualVersion;
        if (driver == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(6);
        }
        if (artifact == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(7);
        }
        if ((actualVersion = DriverClasspathPanel.resolve(artifacts = DatabaseArtifactManager.getArtifacts(), artifact, version, channel, driver)) == null) {
            return artifacts.isValid(artifact, version);
        }
        return (version == Version.INFINITY || actualVersion.version.equals((Object)version)) && artifacts.isValid(actualVersion);
    }

    @NotNull
    protected static JBIterable<String> getUrls(@Nullable Collection<SimpleClasspathElement> actual) {
        JBIterable jBIterable = JBIterable.from(actual).flatten(SimpleClasspathElement::getClassesRootUrls);
        if (jBIterable == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(8);
        }
        return jBIterable;
    }

    private static boolean isFileListExists(@NotNull JBIterable<String> urls) {
        if (urls == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(9);
        }
        return urls.filter(url -> !FileUtil.exists((String)VfsUtilCore.urlToPath((String)url))).isEmpty();
    }

    public static void findDriverLanguageProblem(@NotNull Project project, final @Nullable DatabaseDriver driver, @NotNull Consumer<? super DataSourceProblem> problems, final @Nullable DatabaseConfigEditor editor, @NotNull LocalDataSource dataSource2) {
        if (project == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(10);
        }
        if (problems == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(11);
        }
        if (dataSource2 == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(12);
        }
        if (driver == null) {
            return;
        }
        Language current = DbSqlUtil.getLanguage(dataSource2);
        final Language best = DbSqlUtil.getLanguage(dataSource2.getDbms());
        if (best instanceof SqlLanguageDialect) {
            Dbms bestDbms = ((SqlLanguageDialect)best).getDbms();
            if (bestDbms == Dbms.UNKNOWN) {
                return;
            }
            if (current instanceof SqlLanguageDialect && ((SqlLanguageDialect)current).getDbms() == bestDbms) {
                return;
            }
        }
        if (current == best) {
            return;
        }
        NamedProgressive fix = new NamedProgressive(DatabaseBundle.message((String)"progress.title.use.language", (Object[])new Object[]{best.getDisplayName()})){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (editor == null) {
                    this.fix((DatabaseDriverImpl)driver);
                } else {
                    ApplicationManager.getApplication().invokeAndWait(() -> {
                        DatabaseDriverConfigurable configurable = editor.getConfigurable(driver, true, DatabaseDriverConfigurable.class);
                        if (configurable != null) {
                            DataSourceUiUtil.modify((Consumer<? super DatabaseDriverImpl>)((Consumer)this::fix), configurable);
                        }
                    });
                }
            }

            void fix(DatabaseDriverImpl dr) {
                dr.setSqlDialect(best.getID());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/validation/DatabaseDriverValidator$1", "run"));
            }
        };
        String desc = DatabaseBundle.message((String)"notification.content.it.recommended.to.use.dialect.instead", (Object[])new Object[]{best.getDisplayName(), current.getDisplayName()});
        DataSourceProblem.HyperText text2 = new DataSourceProblem.HyperText(DatabaseBundle.message((String)"notification.title.inconsistent.language", (Object[])new Object[0]), desc + " " + HtmlChunk.link((String)"$ACTION0", (String)fix.getName()), desc, fix);
        problems.consume((Object)new DataSourceProblem(dataSource2, null, DataSourceProblem.Level.WARNING, text2, fix));
    }

    public static void findDriverFilesProblems(@Nullable DatabaseDriver driver, @NotNull Consumer<? super DataSourceProblem> problems, @Nullable DatabaseConfigEditor editor, @NotNull LocalDataSource dataSource2) {
        if (problems == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(13);
        }
        if (dataSource2 == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(14);
        }
        if (driver == null) {
            return;
        }
        List<DatabaseDriver.ArtifactRef> artifacts = driver.getArtifacts();
        for (DatabaseDriver.ArtifactRef artifact : artifacts) {
            DatabaseDriverValidator.findArtifactProblems(driver, problems, editor, dataSource2, artifact);
        }
    }

    protected static void findArtifactProblems(@NotNull DatabaseDriver driver, @NotNull Consumer<? super DataSourceProblem> problems, @Nullable DatabaseConfigEditor editor, @NotNull LocalDataSource dataSource2, DatabaseDriver.ArtifactRef artifact) {
        if (driver == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(15);
        }
        if (problems == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(16);
        }
        if (dataSource2 == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(17);
        }
        @NlsSafe String driverName = StringUtil.escapeXmlEntities((String)driver.getName());
        List<SimpleClasspathElement> curClassPath = driver.getClasspathElements();
        boolean needDownload = !DatabaseDriverValidator.isDriverFilesValid(artifact.getId(), artifact.getArtifactVersion(), curClassPath);
        DataSourceProblem.Navigate navigate = new DataSourceProblem.Navigate(driver);
        DatabaseArtifactList.ArtifactVersion actualVersion = DatabaseDriverValidator.resolve(driver, artifact);
        String actualVersionStr = actualVersion == null ? null : actualVersion.version.toString();
        boolean currentUpToDate = DatabaseDriverValidator.isDriverFilesUpToDate(driver, artifact.getId(), artifact.getArtifactVersion(), artifact.getChannel());
        if (DatabaseDriverValidator.findIncompatibilities(driver, problems, editor, dataSource2)) {
            return;
        }
        if (needDownload) {
            if (actualVersion == null) {
                String description = DatabaseBundle.message((String)"no.provided.files.for.a.href.action0.0.a", (Object[])new Object[]{driverName});
                problems.consume((Object)new DataSourceProblem(driver, null, DataSourceProblem.Level.ERROR, new DataSourceProblem.HyperText("", description, description, navigate), null));
            } else {
                boolean download = !DatabaseDriverValidator.isDriverFilesUpToDate(driver, artifact.getId(), actualVersion.version, artifact.getChannel());
                NamedProgressive downloader = DatabaseDriverValidator.createDownloadTask(actualVersion, driver, editor);
                String shortDescription = download ? DatabaseBundle.message((String)"notification.content.href.action0.download.missing.driver.files", (Object[])new Object[0]) : DatabaseBundle.message((String)"notification.content.no.driver.files.configured", (Object[])new Object[]{curClassPath.isEmpty() ? 0 : 1, actualVersionStr});
                String description = download ? DatabaseBundle.message((String)"download.missing.a.href.action1", (Object[])new Object[]{driverName}) : DatabaseBundle.message((String)"switch.to.existing.a.href.action1", (Object[])new Object[]{driverName});
                problems.consume((Object)new DataSourceProblem(driver, INVALID_FILES, DataSourceProblem.Level.ERROR, new DataSourceProblem.HyperText("", shortDescription, description, downloader, navigate), downloader));
            }
        } else if (!currentUpToDate && actualVersion != null) {
            NamedProgressive downloader = DatabaseDriverValidator.createDownloadTask(actualVersion, driver, editor);
            boolean download = !DatabaseDriverValidator.isDriverFilesUpToDate(driver, artifact.getId(), actualVersion.version, artifact.getChannel());
            String actualVersionText = "ver. " + actualVersionStr;
            String shortDescription = download ? DatabaseBundle.message((String)"notification.content.href.action0.update.to.driver", (Object[])new Object[]{actualVersionText}) : DatabaseBundle.message((String)"notification.content.href.action0.switch.to.driver", (Object[])new Object[]{actualVersionText});
            String description = download ? DatabaseBundle.message((String)"notification.content.update.href.action1", (Object[])new Object[]{driverName, actualVersionText}) : DatabaseBundle.message((String)"notification.content.switch.to.existing.href.action1", (Object[])new Object[]{driverName, actualVersionStr});
            problems.consume((Object)new DataSourceProblem(driver, INVALID_FILES, DataSourceProblem.Level.HINT, new DataSourceProblem.HyperText("", shortDescription, description, downloader, navigate), downloader));
        }
    }

    public static boolean findIncompatibilities(@NotNull DatabaseDriver driver, @NotNull Consumer<? super DataSourceProblem> problems, final @Nullable DatabaseConfigEditor editor, final @NotNull LocalDataSource dataSource2) {
        String msg;
        if (driver == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(18);
        }
        if (problems == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(19);
        }
        if (dataSource2 == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(20);
        }
        String driverName = StringUtil.escapeXmlEntities((String)driver.getName());
        boolean passed = DatabaseDriverValidator.passesConstraints(driver, dataSource2);
        if (passed || dataSource2.getVersion().eqCoarse(new int[]{0})) {
            return false;
        }
        final DatabaseDriver suitable = DatabaseDriverValidator.findSuitableDriver(dataSource2, driver);
        DatabaseDriverImpl.Constraint constraint = DatabaseDriverValidator.getConstraint(driver, dataSource2);
        if (constraint == null) {
            msg = DatabaseBundle.message((String)"notification.content.driver.does.not.support", (Object[])new Object[]{driverName, dataSource2.getDbms().getDisplayName()});
        } else {
            String range = (String)(constraint.from == null ? "up" : "from " + constraint.from) + (String)(constraint.to == null ? "" : " to " + constraint.to);
            msg = DatabaseBundle.message((String)"notification.content.driver.does.not.support.version.expected", (Object[])new Object[]{driverName, dataSource2.getVersion(), range});
        }
        NamedProgressive fix = suitable == null ? null : new NamedProgressive(DatabaseBundle.message((String)"progress.title.switch.to", (Object[])new Object[]{suitable.getName()})){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    DataSourceConfigurable configurable;
                    DataSourceConfigurable dataSourceConfigurable = configurable = editor == null ? null : editor.getConfigurable(dataSource2, true, DataSourceConfigurable.class);
                    if (configurable != null) {
                        configurable.setDriver(suitable);
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/validation/DatabaseDriverValidator$2", "run"));
            }
        };
        String extra = fix == null ? "" : " " + DatabaseBundle.message((String)"switch.to.a.href.action0", (Object[])new Object[]{suitable.getName()});
        Object[] actions = fix == null ? ArrayUtil.EMPTY_OBJECT_ARRAY : ContainerUtil.ar((Object[])new NamedProgressive[]{fix});
        problems.consume((Object)new DataSourceProblem(dataSource2, null, DataSourceProblem.Level.WARNING, new DataSourceProblem.HyperText(DatabaseBundle.message((String)"notification.title.incompatible.driver", (Object[])new Object[0]), msg + extra, msg, actions), fix));
        return true;
    }

    protected static DatabaseDriver findSuitableDriver(@NotNull LocalDataSource ds, @NotNull DatabaseDriver driver) {
        if (ds == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(21);
        }
        if (driver == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(22);
        }
        Dbms drDbms = DbImplUtil.getDbms(driver);
        int error2 = DatabaseDriverValidator.getFirstErrorPos(ds, driver);
        for (DatabaseDriver databaseDriver : DatabaseDriverManager.getInstance().getDrivers()) {
            if (databaseDriver.getId().equals(driver.getId()) || DbImplUtil.getDbms(databaseDriver) != drDbms || !DatabaseDriverValidator.passesConstraints(databaseDriver, ds) || DatabaseDriverValidator.getFirstErrorPos(ds, databaseDriver) < error2) continue;
            return databaseDriver;
        }
        return null;
    }

    private static int getFirstErrorPos(@NotNull LocalDataSource ds, @NotNull DatabaseDriver dr) {
        if (ds == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(23);
        }
        if (dr == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(24);
        }
        String url = StringUtil.notNullize((String)ds.getUrl());
        JdbcUrlParser parsed = JdbcUrlParserUtilCore.stateful(JdbcUrlParserUtilCore.select(dr.getJDBCUrlParsers(), url));
        if (parsed == null) {
            return 0;
        }
        parsed.setUrlText(url);
        List<TextRange> errors = parsed.getInvalidRanges();
        if (errors.isEmpty()) {
            return Integer.MAX_VALUE;
        }
        TextRange firstError = Collections.min(errors, Comparator.comparing(TextRange::getStartOffset));
        return firstError.getStartOffset();
    }

    private static boolean passesConstraints(@NotNull DatabaseDriver driver, @NotNull LocalDataSource dataSource2) {
        DatabaseDriverImpl.Constraint constraint;
        if (driver == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(25);
        }
        if (dataSource2 == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(26);
        }
        if ((constraint = DatabaseDriverValidator.getConstraint(driver, dataSource2)) == null) {
            return true;
        }
        return constraint.matches(dataSource2.getDbms(), dataSource2.getVersion());
    }

    private static DatabaseDriverImpl.Constraint getConstraint(@NotNull DatabaseDriver driver, @NotNull LocalDataSource dataSource2) {
        if (driver == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(27);
        }
        if (dataSource2 == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(28);
        }
        Set<DatabaseDriverImpl.Constraint> constraints = ((DatabaseDriverImpl)driver).getConstraints();
        return (DatabaseDriverImpl.Constraint)ContainerUtil.find(constraints, c2 -> c2.matches(dataSource2.getDbms(), null));
    }

    @NotNull
    public static NamedProgressive createDownloaderTask(@NotNull LocalDataSource dataSource2, final @Nullable DatabaseConfigEditor editor) {
        if (dataSource2 == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(29);
        }
        final DatabaseDriver driver = Objects.requireNonNull(dataSource2.getDatabaseDriver());
        final List versions = JBIterable.from(driver.getArtifacts()).filterMap(a2 -> DatabaseDriverValidator.resolve(driver, a2)).toList();
        return new NamedProgressive(IdeBundle.message((String)"progress.download.0.title", (Object[])new Object[]{"Driver Files"})){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                for (DatabaseArtifactList.ArtifactVersion version : versions) {
                    DatabaseDriverValidator.createDownloadTask(version, driver, editor).run(indicator);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/validation/DatabaseDriverValidator$3", "run"));
            }
        };
    }

    @Nullable
    public static DatabaseArtifactList.ArtifactVersion resolve(DatabaseDriver driver, DatabaseDriver.ArtifactRef a2) {
        return DriverClasspathPanel.resolve(DatabaseArtifactManager.getArtifacts(), a2.getId(), a2.getArtifactVersion(), a2.getChannel(), driver);
    }

    @NotNull
    public static NamedProgressive createDownloadTask(DatabaseArtifactList.ArtifactVersion version, DatabaseDriver driver, @Nullable DatabaseConfigEditor editor) {
        return new MyDriverDownloader(driver, version, editor);
    }

    public static boolean isCompatible(@NotNull DatabaseDriver driver, @NotNull DatabaseArtifactList.ArtifactVersion v) {
        Set<DatabaseDriverImpl.Constraint> constraints;
        if (driver == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(30);
        }
        if (v == null) {
            DatabaseDriverValidator.$$$reportNull$$$0(31);
        }
        if ((constraints = ((DatabaseDriverImpl)driver).getConstraints()).isEmpty()) {
            return v.matches(null, null);
        }
        return ContainerUtil.find(constraints, c2 -> c2.dbms == null || v.matches(c2.dbms, (Version)ObjectUtils.notNull((Object)c2.from, (Object)Version.ZERO), c2.to == null ? Version.INFINITY : c2.to.decStep())) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 15: 
            case 18: 
            case 22: 
            case 25: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 2: 
            case 11: 
            case 13: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problems";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifacts";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/validation/DatabaseDriverValidator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 12: 
            case 14: 
            case 17: 
            case 20: 
            case 26: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dr";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/validation/DatabaseDriverValidator";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectProblems";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isDriverFilesValid";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isDriverFilesUpToDate";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isFileListExists";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findDriverLanguageProblem";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findDriverFilesProblems";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findArtifactProblems";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findIncompatibilities";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findSuitableDriver";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getFirstErrorPos";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "passesConstraints";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getConstraint";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createDownloaderTask";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isCompatible";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyDriverDownloader
    extends NamedProgressive {
        private final DatabaseDriver myDriver;
        private final DatabaseArtifactList.ArtifactVersion myVersion;
        private final DatabaseConfigEditor myEditor;

        MyDriverDownloader(@NotNull DatabaseDriver driver, @Nullable DatabaseArtifactList.ArtifactVersion version, @Nullable DatabaseConfigEditor editor) {
            if (driver == null) {
                MyDriverDownloader.$$$reportNull$$$0(0);
            }
            super(IdeBundle.message((String)"progress.download.0.title", (Object[])new Object[]{"Driver Files"}));
            this.myDriver = driver;
            this.myVersion = version;
            this.myEditor = editor;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                MyDriverDownloader.$$$reportNull$$$0(1);
            }
            if (this.myVersion == null) {
                return;
            }
            DatabaseDriver.ArtifactRef artifact = (DatabaseDriver.ArtifactRef)ContainerUtil.find(this.myDriver.getArtifacts(), a2 -> this.myVersion.artifact.isId(a2.getId()));
            if (artifact == null) {
                return;
            }
            indicator.setText(IdeBundle.message((String)"progress.download.0.title", (Object[])new Object[]{this.myVersion.artifact.name + " files"}));
            boolean ok = DatabaseArtifactManager.getArtifacts().isValid(this.myVersion);
            ApplicationManager.getApplication().invokeLater(() -> {
                DatabaseDriverConfigurable configurable = this.myEditor == null ? null : this.myEditor.getConfigurable(this.myDriver, true, DatabaseDriverConfigurable.class);
                DatabaseDriverImpl tempDriver = configurable == null ? (DatabaseDriverImpl)this.myDriver : configurable.getTempDriver();
                ArrayList<DatabaseDriver.ArtifactRef> artifacts = new ArrayList<DatabaseDriver.ArtifactRef>(tempDriver.getArtifacts());
                int idx = ContainerUtil.indexOf(this.myDriver.getArtifacts(), a2 -> this.myVersion.artifact.isId(a2.getId()));
                if (idx != -1) {
                    artifacts.set(idx, DatabaseDriverImpl.createArtifactRef(this.myVersion.artifact.id, this.myVersion.version, ((DatabaseDriver.ArtifactRef)artifacts.get(idx)).getChannel()));
                    tempDriver.setArtifacts(artifacts);
                }
                if (configurable != null) {
                    configurable.resetFromTemp();
                }
                if (ok && this.myEditor != null) {
                    this.myEditor.onDriverDownloaded(this.myDriver);
                }
            });
            if (ok) {
                return;
            }
            while (!indicator.isCanceled()) {
                try {
                    DatabaseArtifactManager.getInstance().downloadArtifact(this.myVersion, (Consumer<? super DatabaseArtifactList.ArtifactVersion>)((Consumer)o -> {
                        if (this.myEditor != null) {
                            this.myEditor.onDriverDownloaded(this.myDriver);
                        }
                    }));
                }
                catch (IOException e) {
                    String msg = IdeBundle.message((String)"progress.download.0.title", (Object[])new Object[]{this.myVersion.artifact.name + " files"});
                    boolean retry = IOExceptionDialog.showErrorDialog((String)msg, (String)e.getMessage());
                    if (retry) continue;
                }
                break;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyDriverDownloader that = (MyDriverDownloader)o;
            if (!this.myDriver.equals(that.myDriver)) {
                return false;
            }
            if (!this.myVersion.equals(that.myVersion)) {
                return false;
            }
            return Objects.equals(this.myEditor, that.myEditor);
        }

        public int hashCode() {
            int result = this.myDriver.hashCode();
            result = 31 * result + this.myVersion.hashCode();
            result = 31 * result + (this.myEditor != null ? this.myEditor.hashCode() : 0);
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "driver";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/validation/DatabaseDriverValidator$MyDriverDownloader";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

