/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url;

import com.intellij.database.dataSource.DatabaseDriverCore;
import com.intellij.database.dataSource.DatabaseDriverManagerCore;
import com.intellij.database.dataSource.LocalDataSourceCore;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdbcUrlParserUtilCore {
    protected JdbcUrlParserUtilCore() {
    }

    @Nullable
    public static JdbcUrlParser stateful(@Nullable StatelessJdbcUrlParser parser2) {
        return parser2 == null ? null : parser2.createStateful();
    }

    @Nullable
    public static StatelessJdbcUrlParser select(@NotNull Collection<StatelessJdbcUrlParser> parsers, @NotNull String url) {
        if (parsers == null) {
            JdbcUrlParserUtilCore.$$$reportNull$$$0(0);
        }
        if (url == null) {
            JdbcUrlParserUtilCore.$$$reportNull$$$0(1);
        }
        return JdbcUrlParserUtilCore.select(parsers, url, null);
    }

    @Nullable
    public static StatelessJdbcUrlParser select(@NotNull Collection<StatelessJdbcUrlParser> parsers, @NotNull String url, @Nullable StatelessJdbcUrlParser.LocationType loc) {
        if (parsers == null) {
            JdbcUrlParserUtilCore.$$$reportNull$$$0(2);
        }
        if (url == null) {
            JdbcUrlParserUtilCore.$$$reportNull$$$0(3);
        }
        StatelessJdbcUrlParser chosen = null;
        int rank = -1;
        for (StatelessJdbcUrlParser p2 : parsers) {
            int curRank;
            if (loc != null && !p2.getPossibleLocations().contains((Object)loc) || !p2.isUrlValueValid(url) || (curRank = JdbcUrlParserUtilCore.getRank(JdbcUrlParserUtilCore.parsed(p2, url))) <= rank) continue;
            chosen = p2;
            rank = curRank;
        }
        return chosen;
    }

    @Nullable
    public static JdbcUrlParser parsed(@Nullable StatelessJdbcUrlParser parser2, @Nullable String url) {
        if (url == null) {
            return null;
        }
        JdbcUrlParser stateful = JdbcUrlParserUtilCore.stateful(parser2);
        if (stateful == null) {
            return null;
        }
        stateful.setUrlText(url);
        return stateful.isValid() ? stateful : null;
    }

    public static int getRank(@Nullable JdbcUrlParser parsed) {
        int curRank = 0;
        if (parsed != null) {
            for (String parameter : parsed.getParameters()) {
                if (!StringUtil.isNotEmpty((String)parsed.getParameter(parameter))) continue;
                ++curRank;
            }
        }
        return curRank;
    }

    @Nullable
    public static StatelessJdbcUrlParser select(@NotNull RawConnectionConfig config) {
        if (config == null) {
            JdbcUrlParserUtilCore.$$$reportNull$$$0(4);
        }
        return JdbcUrlParserUtilCore.select(config, config.getUrl());
    }

    @Nullable
    public static StatelessJdbcUrlParser select(@NotNull RawConnectionConfig config, @Nullable String url) {
        DatabaseDriverCore driver;
        if (config == null) {
            JdbcUrlParserUtilCore.$$$reportNull$$$0(5);
        }
        if (url == null) {
            return null;
        }
        if (config instanceof LocalDataSourceCore && (driver = ((LocalDataSourceCore)config).getDatabaseDriver()) != null) {
            return JdbcUrlParserUtilCore.select(driver.getJDBCUrlParsers(), url);
        }
        return JdbcUrlParserUtilCore.select(config, url, DatabaseDriverManagerCore.getInstance().getDrivers());
    }

    @Nullable
    public static StatelessJdbcUrlParser select(@NotNull RawConnectionConfig config, @NotNull String url, Collection<? extends DatabaseDriverCore> drivers) {
        if (config == null) {
            JdbcUrlParserUtilCore.$$$reportNull$$$0(6);
        }
        if (url == null) {
            JdbcUrlParserUtilCore.$$$reportNull$$$0(7);
        }
        for (DatabaseDriverCore databaseDriverCore : drivers) {
            StatelessJdbcUrlParser parser2;
            if (!Objects.equals(config.getDriverClass(), databaseDriverCore.getDriverClass()) || (parser2 = JdbcUrlParserUtilCore.select(databaseDriverCore.getJDBCUrlParsers(), url)) == null) continue;
            return parser2;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parsers";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[0] = "url";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[0] = "config";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/dataSource/url/JdbcUrlParserUtilCore";
        objectArray[2] = "select";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

