/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.ui;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.console.ExecutionEnvironmentHelper;
import com.intellij.database.console.KeepAliveActionDescriptor;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceInfo;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.statements.BarrenStatement;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.ui.DataSourceTestConnectionComponent;
import com.intellij.database.dataSource.ui.DataSourceTestConnectionComponent$$special$;
import com.intellij.database.dataSource.ui.DriverInstantiateComponent;
import com.intellij.database.dataSource.validation.DatabaseDriverValidator;
import com.intellij.database.dataSource.validation.NamedProgressive;
import com.intellij.database.dialects.DatabaseErrorHandler;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.Version;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.database.view.ui.DatabaseConfigSideTab;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.SearchWebAction;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.layout.CCFlags;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.CellBuilder;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.LayoutKt;
import com.intellij.ui.layout.Row;
import com.intellij.ui.layout.RowBuilder;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.text.StringKt;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0003<=>B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016H\u0002J,\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0002J\r\u0010\"\u001a\u00070#\u00a2\u0006\u0002\b$H\u0002J\r\u0010%\u001a\u00070\u0016\u00a2\u0006\u0002\b&H\u0002J\r\u0010'\u001a\u00070#\u00a2\u0006\u0002\b(H\u0002J\u0010\u0010)\u001a\u00020*2\u0006\u0010 \u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020*2\u0006\u0010-\u001a\u00020\u001bH\u0002J\b\u0010.\u001a\u00020\u0019H\u0002J\u001e\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001f002\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u00101\u001a\u00020\u001f2\u0006\u00102\u001a\u000203H\u0002J\"\u00104\u001a\u00020\u00192\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u00105\u001a\u00020*J\b\u00106\u001a\u00020\u0019H\u0002J\r\u00107\u001a\u000708\u00a2\u0006\u0002\b&H\u0002J\u0014\u00109\u001a\b\u0012\u0002\b\u0003\u0018\u0001002\u0006\u0010:\u001a\u00020*J\b\u0010;\u001a\u00020\u0019H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionComponent;", "", "configurable", "Lcom/intellij/database/dataSource/DataSourceConfigurable;", "(Lcom/intellij/database/dataSource/DataSourceConfigurable;)V", "balloon", "Lcom/intellij/openapi/ui/popup/Balloon;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "getConfigurable", "()Lcom/intellij/database/dataSource/DataSourceConfigurable;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "status", "Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionComponent$Status;", "statusIcon", "Ljavax/swing/JLabel;", "statusText", "Lcom/intellij/ui/components/labels/LinkLabel;", "actionsChunk", "Lcom/intellij/openapi/util/text/HtmlChunk;", "kotlin.jvm.PlatformType", "applyTestConnectionResult", "", "tempDataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "handler", "Lcom/intellij/database/util/ErrorHandler;", "r", "Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionComponent$TestConnectionResult;", "e", "", "description", "", "Lcom/intellij/openapi/util/NlsContexts$DetailedDescription;", "detailsChunk", "Lorg/jetbrains/annotations/NotNull;", "detailsHtml", "Lcom/intellij/openapi/util/NlsContexts$PopupContent;", "handleDetailsLink", "", "Ljavax/swing/event/HyperlinkEvent;", "handleIncompleteConfiguration", "source", "hideDetails", "performTestConnection", "Lcom/intellij/database/util/AsyncTask;", "pingDatabase", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "setStatus", "cancel", "showDetails", "statusChunk", "Lcom/intellij/openapi/util/text/HtmlChunk$Element;", "testConnection", "checkConfiguration", "update", "GrayLabel", "Status", "TestConnectionResult", "intellij.database.impl"})
public final class DataSourceTestConnectionComponent {
    @NotNull
    private final JComponent component;
    private final JLabel statusIcon;
    private final LinkLabel<?> statusText;
    private Status status;
    private ProgressIndicator indicator;
    private volatile Balloon balloon;
    @NotNull
    private final DataSourceConfigurable configurable;

    @NotNull
    public final JComponent getComponent() {
        return this.component;
    }

    public final void setStatus(@Nullable Status status, @Nullable ProgressIndicator indicator, boolean cancel2) {
        this.status = status;
        if (cancel2) {
            ProgressIndicator progressIndicator = this.indicator;
            if (progressIndicator != null) {
                progressIndicator.cancel();
            }
            this.indicator = null;
        }
        if (indicator != null) {
            this.indicator = indicator;
        }
        this.update();
    }

    private final void showDetails() {
        this.hideDetails();
        Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(this.detailsHtml(), null, UIUtil.getPanelBackground(), new HyperlinkListener(this){
            final /* synthetic */ DataSourceTestConnectionComponent this$0;

            public final void hyperlinkUpdate(HyperlinkEvent it2) {
                HyperlinkEvent hyperlinkEvent = it2;
                Intrinsics.checkNotNullExpressionValue((Object)hyperlinkEvent, (String)"it");
                if (DataSourceTestConnectionComponent.access$handleDetailsLink(this.this$0, hyperlinkEvent)) {
                    DataSourceTestConnectionComponent.access$hideDetails(this.this$0);
                }
            }
            {
                this.this$0 = dataSourceTestConnectionComponent;
            }
        }).createBalloon();
        Intrinsics.checkNotNullExpressionValue((Object)balloon, (String)"JBPopupFactory.getInstan\u2026s()\n    }.createBalloon()");
        Balloon tmp2 = balloon;
        tmp2.show(RelativePoint.getNorthWestOf((JComponent)((JComponent)this.statusText)), Balloon.Position.above);
        this.balloon = tmp2;
    }

    private final void hideDetails() {
        block0: {
            Balloon prev = this.balloon;
            this.balloon = null;
            Balloon balloon = prev;
            if (balloon == null) break block0;
            balloon.hide();
        }
    }

    private final String detailsHtml() {
        String string = HtmlChunk.tag((String)"table").child((HtmlChunk)HtmlChunk.tag((String)"tr").child((HtmlChunk)this.statusChunk().wrapWith("td")).child((HtmlChunk)this.actionsChunk().wrapWith("td").style("text-align: right"))).child((HtmlChunk)HtmlChunk.tag((String)"tr").child((HtmlChunk)this.detailsChunk().wrapWith("td").attr("colspan", "2"))).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"HtmlChunk.tag(\"table\")\n \u2026      )\n      .toString()");
        return string;
    }

    private final HtmlChunk detailsChunk() {
        Object object;
        block3: {
            block2: {
                object = this.status;
                if (object == null || (object = ((Status)object).asHtml()) == null) break block2;
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object it2 = object2;
                boolean bl3 = false;
                object = HtmlChunk.raw((String)it2);
                if (object != null) break block3;
            }
            object = HtmlChunk.text((String)DataSourceUiUtil.formatDataSourceInfoString((LocalDataSource)this.configurable.getDataSource()));
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"status?.asHtml()?.let { \u2026configurable.dataSource))");
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final HtmlChunk.Element statusChunk() {
        Boolean bl;
        String string;
        Status status = this.status;
        if (status != null && status.getFail()) {
            string = DatabaseBundle.message((String)"test.connection.status.failed", (Object[])new Object[0]);
        } else {
            Status status2 = this.status;
            string = status2 != null && !status2.getFail() ? DatabaseBundle.message((String)"test.connection.status.succeeded", (Object[])new Object[0]) : (this.indicator != null ? DatabaseBundle.message((String)"test.connection.status.in.progress", (Object[])new Object[0]) : DatabaseBundle.message((String)"test.connection.status.last.known", (Object[])new Object[0]));
        }
        Status status3 = this.status;
        Boolean bl2 = bl = status3 != null ? Boolean.valueOf(status3.getFail()) : null;
        HtmlChunk.Element element2 = HtmlChunk.text((String)string).bold().style("color: " + ColorUtil.toHtmlColor((Color)((Color)(Intrinsics.areEqual((Object)bl, (Object)true) ? JBColor.RED : (Intrinsics.areEqual((Object)bl, (Object)false) ? DatabaseConfigSideTab.DIM_GREEN : JBColor.GRAY)))));
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"HtmlChunk.text(\n      wh\u2026r.GRAY\n        })\n    }\")");
        return element2;
    }

    private final HtmlChunk actionsChunk() {
        HtmlBuilder htmlBuilder = new HtmlBuilder();
        boolean bl = false;
        boolean bl2 = false;
        HtmlBuilder $this$apply = htmlBuilder;
        boolean bl3 = false;
        if (this.indicator != null) {
            $this$apply.appendLink("cancel", DatabaseBundle.message((String)"test.connection.action.cancel", (Object[])new Object[0]));
            $this$apply.appendRaw("&emsp;");
        }
        $this$apply.appendLink("copy", DatabaseBundle.message((String)"test.connection.action.copy", (Object[])new Object[0]));
        Status status = this.status;
        if (status != null) {
            if (status.getFail()) {
                $this$apply.appendRaw("&emsp;");
                $this$apply.appendLink("search", DatabaseBundle.message((String)"test.connection.action.search.error", (Object[])new Object[0]));
                $this$apply.appendRaw("&emsp;");
                $this$apply.appendLink("troubleshooting", DatabaseBundle.message((String)"DataSourceTestConnectionPanel.troubleshooting", (Object[])new Object[0]));
            }
        }
        return htmlBuilder.toFragment();
    }

    /*
     * Unable to fully structure code
     */
    private final boolean handleDetailsLink(HyperlinkEvent e) {
        block13: {
            block10: {
                block12: {
                    block11: {
                        if (Intrinsics.areEqual((Object)e.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED) ^ true) {
                            return false;
                        }
                        v0 = e.getDescription();
                        if (v0 == null) break block10;
                        var2_2 = v0;
                        switch (var2_2.hashCode()) {
                            case -1367724422: {
                                if (!var2_2.equals("cancel")) ** break;
                                break block11;
                            }
                            case -906336856: {
                                if (!var2_2.equals("search")) ** break;
                                break;
                            }
                            case -1272712614: {
                                if (!var2_2.equals("troubleshooting")) ** break;
                                break block12;
                            }
                            case 3059573: {
                                if (!var2_2.equals("copy")) ** break;
                                v1 = Toolkit.getDefaultToolkit();
                                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"Toolkit.getDefaultToolkit()");
                                v1.getSystemClipboard().setContents(new StringSelection(this.description()), null);
                                break block13;
                            }
                        }
                        SearchWebAction.search((String)this.description());
                        break block13;
                    }
                    v2 = this.indicator;
                    if (v2 != null) {
                        v2.cancel();
                    }
                    break block13;
                }
                DataSourceUiUtil.showTroubleshooting();
                break block13;
            }
            v3 = this.status;
            if (v3 == null) ** GOTO lbl-1000
            v4 = e.getDescription();
            v5 = this.configurable.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"configurable.project");
            v6 = this.configurable.getController();
            Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"configurable.controller");
            if (v3.handleLink(v4, v5, v6)) {
                v7 = true;
            } else lbl-1000:
            // 2 sources

            {
                v7 = false;
            }
            return v7;
        }
        return true;
    }

    private final String description() {
        Object object = this.status;
        if (object == null || (object = ((Status)object).getDetails()) == null) {
            String string = DataSourceUiUtil.formatDataSourceInfoString((LocalDataSource)this.configurable.getDataSource());
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DataSourceUiUtil.formatD\u2026(configurable.dataSource)");
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void update() {
        Icon icon;
        ProgressIndicator progressIndicator = this.indicator;
        boolean bl = false;
        boolean bl2 = false;
        ProgressIndicator it2 = progressIndicator;
        boolean bl3 = false;
        boolean bl4 = it2 != null && !it2.isRunning();
        if (bl4) {
            this.indicator = null;
        }
        DataSourceInfo info = this.configurable.getDatabaseInfo();
        Status status = this.status;
        if (status != null && status.getFail()) {
            icon = AllIcons.General.Error;
        } else {
            Status status2 = this.status;
            icon = status2 != null && !status2.getFail() ? AllIcons.RunConfigurations.TestPassed : (this.indicator != null ? (Icon)AnimatedIcon.Default.INSTANCE : EmptyIcon.ICON_16);
        }
        this.statusIcon.setIcon(icon);
        String string = StringKt.nullize$default((String)info.databaseVersion.name, (boolean)false, (int)1, null);
        boolean bl5 = false;
        boolean bl6 = false;
        String it3 = string;
        boolean bl7 = false;
        String string2 = Intrinsics.areEqual((Object)info.dbms, (Object)Dbms.UNKNOWN) ? string : null;
        if (string2 == null) {
            Dbms dbms = info.dbms;
            Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"info.dbms");
            String string2 = dbms.getDisplayName();
            string2 = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"info.dbms.displayName");
        }
        String name = string2;
        Version version = info.exactVersion;
        bl6 = false;
        boolean bl8 = false;
        Version it4 = version;
        boolean bl9 = false;
        Version version2 = Intrinsics.areEqual((Object)it4, (Object)Version.ZERO) ^ true ? version : null;
        StringBuilder stringBuilder = new StringBuilder().append(name).append(' ');
        Object object = version2;
        if (object == null) {
            object = "";
        }
        this.statusText.setText(stringBuilder.append(object).toString());
        if (this.status != null) {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            if (!application.isUnitTestMode()) {
                this.showDetails();
            }
        }
    }

    @Nullable
    public final AsyncTask<?> testConnection(boolean checkConfiguration) {
        this.setStatus(null, null, true);
        LocalDataSource localDataSource = this.configurable.getTempDataSourceForConnection();
        Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"configurable.tempDataSourceForConnection");
        LocalDataSource tempDataSource = localDataSource;
        if (checkConfiguration && !DbImplUtil.canConnectTo(tempDataSource) && !this.handleIncompleteConfiguration(tempDataSource)) {
            return null;
        }
        if (StringUtil.isEmptyOrSpaces((String)tempDataSource.getUrl())) {
            Messages.showErrorDialog((String)DatabaseBundle.message((String)"message.text.specify.database.url", (Object[])new Object[0]), (String)DatabaseBundle.message((String)"DataSourceConfigurable.connect", (Object[])new Object[0]));
            this.configurable.getUrlEditor().requestUrlFocus();
            return null;
        }
        this.configurable.hidePasswords();
        OneTimeString prevPassword = this.configurable.getSecretService().getPassword(tempDataSource);
        LocalDataSource localDataSource2 = tempDataSource.copy(true);
        Intrinsics.checkNotNullExpressionValue((Object)localDataSource2, (String)"tempDataSource.copy(true)");
        LocalDataSource prevDs = localDataSource2;
        ErrorHandler handler = new ErrorHandler();
        AsyncTask<TestConnectionResult> testResult = this.performTestConnection(tempDataSource, handler);
        return testResult.whenComplete((Executor)EdtExecutorService.getInstance(), new BiConsumer<TestConnectionResult, Throwable>(this, handler, tempDataSource, prevDs, prevPassword){
            final /* synthetic */ DataSourceTestConnectionComponent this$0;
            final /* synthetic */ ErrorHandler $handler;
            final /* synthetic */ LocalDataSource $tempDataSource;
            final /* synthetic */ LocalDataSource $prevDs;
            final /* synthetic */ OneTimeString $prevPassword;

            public final void accept(@Nullable TestConnectionResult r, @Nullable Throwable e) {
                AsyncUtil.addUnhandledError(this.$handler, e, this.$tempDataSource);
                if (!this.$prevDs.equalConfiguration(this.$tempDataSource)) {
                    this.this$0.getConfigurable().reset(this.$tempDataSource, false);
                }
                if (Intrinsics.areEqual((Object)this.this$0.getConfigurable().getSecretService().getPassword(this.$tempDataSource), (Object)this.$prevPassword) ^ true) {
                    this.this$0.getConfigurable().reloadCredentials();
                }
                DataSourceTestConnectionComponent.access$applyTestConnectionResult(this.this$0, this.$tempDataSource, this.$handler, r, e);
            }
            {
                this.this$0 = dataSourceTestConnectionComponent;
                this.$handler = errorHandler;
                this.$tempDataSource = localDataSource;
                this.$prevDs = localDataSource2;
                this.$prevPassword = oneTimeString;
            }
        });
    }

    private final boolean handleIncompleteConfiguration(LocalDataSource source) {
        if (StringUtil.isEmptyOrSpaces((String)source.getUrl())) {
            Messages.showDialog((Project)this.configurable.getProject(), (String)DatabaseBundle.message((String)"DataSourceConfigurable.no.url", (Object[])new Object[0]), (String)DatabaseBundle.message((String)"DataSourceConfigurable.incomplete", (Object[])new Object[0]), (String[])new String[]{Messages.getOkButton()}, (int)0, (Icon)Messages.getErrorIcon());
            return false;
        }
        if (!DbImplUtil.hasDriverFiles(source)) {
            Object v1;
            Object artifacts;
            DatabaseDriver driver;
            block9: {
                driver = source.getDatabaseDriver();
                Object object = driver;
                if (object == null || (object = object.getArtifacts()) == null) {
                    object = artifacts = CollectionsKt.emptyList();
                }
                if (artifacts.isEmpty()) {
                    int res2 = Messages.showYesNoDialog((Project)this.configurable.getProject(), (String)DatabaseBundle.message((String)"DataSourceConfigurable.no.driver.files", (Object[])new Object[0]), (String)DatabaseBundle.message((String)"DataSourceConfigurable.incomplete", (Object[])new Object[0]), (String)DatabaseBundle.message((String)"DataSourceConfigurable.configure.driver", (Object[])new Object[0]), (String)Messages.getCancelButton(), (Icon)Messages.getErrorIcon());
                    if (driver != null && res2 == 0) {
                        this.configurable.getController().navigateTo(driver, true);
                    }
                    return false;
                }
                Iterable iterable = (Iterable)artifacts;
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    DatabaseDriver.ArtifactRef it2 = (DatabaseDriver.ArtifactRef)t;
                    boolean bl3 = false;
                    if (!(DatabaseDriverValidator.resolve(driver, it2) == null)) continue;
                    v1 = t;
                    break block9;
                }
                v1 = null;
            }
            DatabaseDriver.ArtifactRef invalidArtifact = v1;
            if (invalidArtifact != null) {
                int res3 = Messages.showYesNoDialog((Project)this.configurable.getProject(), (String)DatabaseBundle.message((String)"DataSourceConfigurable.invalid.provided", (Object[])new Object[0]), (String)DatabaseBundle.message((String)"DataSourceConfigurable.incomplete", (Object[])new Object[0]), (String)DatabaseBundle.message((String)"DataSourceConfigurable.configure.driver", (Object[])new Object[0]), (String)Messages.getCancelButton(), (Icon)Messages.getErrorIcon());
                if (driver != null && res3 == 0) {
                    this.configurable.getController().navigateTo(driver, true);
                }
                return false;
            }
            DatabaseDriver databaseDriver = driver;
            Intrinsics.checkNotNull((Object)databaseDriver);
            boolean downloaded = DatabaseDriverValidator.isDriverFilesUpToDate(databaseDriver, (List<DatabaseDriver.ArtifactRef>)artifacts);
            int res4 = Messages.showYesNoDialog((Project)this.configurable.getProject(), (String)DatabaseBundle.message((String)(downloaded ? "DataSourceConfigurable.drivers.not.configured" : "DataSourceConfigurable.drivers.not.downloaded"), (Object[])new Object[0]), (String)DatabaseBundle.message((String)"DataSourceConfigurable.incomplete", (Object[])new Object[0]), (String)DatabaseBundle.message((String)(downloaded ? "DataSourceConfigurable.switch.to.latest" : "DataSourceConfigurable.download.driver"), (Object[])new Object[0]), (String)Messages.getCancelButton(), (Icon)Messages.getErrorIcon());
            if (res4 == 0) {
                NamedProgressive namedProgressive = DatabaseDriverValidator.createDownloaderTask(source, this.configurable.getController());
                Intrinsics.checkNotNullExpressionValue((Object)namedProgressive, (String)"DatabaseDriverValidator.\u2026 configurable.controller)");
                NamedProgressive task = namedProgressive;
                new Task.Modal(this, task, this.configurable.getProject(), task.getName(), true){
                    final /* synthetic */ DataSourceTestConnectionComponent this$0;
                    final /* synthetic */ NamedProgressive $task;

                    public void run(@NotNull ProgressIndicator indicator) {
                        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                        this.$task.run(indicator);
                    }

                    public void onSuccess() {
                        ApplicationManager.getApplication().invokeLater(new Runnable(this){
                            final /* synthetic */ handleIncompleteConfiguration.1 this$0;

                            public final void run() {
                                this.this$0.this$0.testConnection(true);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                    {
                        this.this$0 = this$0;
                        this.$task = $captured_local_variable$1;
                        super($super_call_param$2, $super_call_param$3, $super_call_param$4);
                    }
                }.queue();
                return false;
            }
        }
        return false;
    }

    private final AsyncTask<TestConnectionResult> performTestConnection(LocalDataSource tempDataSource, ErrorHandler handler) {
        String string = DatabaseBundle.message((String)"message.text.connection.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DatabaseBundle.message(\"\u2026e.text.connection.title\")");
        AsyncTask.Frame frame = AsyncTask.Companion.frame(string);
        Project project = this.configurable.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"configurable.project");
        return AsyncTask.Companion.withBgIndicatorIfNeeded(frame, project, null).computeAsync(AppExecutorUtil.getAppExecutorService(), (ThrowableComputable)new ThrowableComputable<AsyncTask<TestConnectionResult>, Throwable>(this, tempDataSource, handler){
            final /* synthetic */ DataSourceTestConnectionComponent this$0;
            final /* synthetic */ LocalDataSource $tempDataSource;
            final /* synthetic */ ErrorHandler $handler;

            public final AsyncTask<TestConnectionResult> compute() {
                this.this$0.setStatus(null, AsyncUtil.getAsyncFriendlyIndicator(), true);
                return DatabaseConnectionManager.getInstance().build(this.this$0.getConfigurable().getProject(), this.$tempDataSource).setCredentialsStore(this.this$0.getConfigurable().getSecretService()).async(new DatabaseConnectionManager.Operation<TestConnectionResult>(this){
                    final /* synthetic */ performTestConnection.1 this$0;

                    public final TestConnectionResult perform(@NotNull DatabaseConnection it2) {
                        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                        return DataSourceTestConnectionComponent.access$pingDatabase(this.this$0.this$0, it2);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }, this.$handler);
            }
            {
                this.this$0 = dataSourceTestConnectionComponent;
                this.$tempDataSource = localDataSource;
                this.$handler = errorHandler;
            }
        });
    }

    private final void applyTestConnectionResult(LocalDataSource tempDataSource, ErrorHandler handler, TestConnectionResult r, Throwable e) {
        if (AsyncUtil.isCancellation(e) && !handler.hasErrors()) {
            this.setStatus(null, null, false);
            return;
        }
        boolean failed = handler.hasErrors();
        String summary = handler.getSummary();
        this.configurable.updateDatabaseInfo(tempDataSource);
        if (!failed && r != null) {
            summary = DataSourceUiUtil.formatDataSourceInfoString(tempDataSource);
            summary = summary + DatabaseBundle.message((String)"text.ping.choice.keep.alive.query.results.in.error.choice.ssl", (Object[])new Object[]{NlsMessages.formatDuration((long)r.getPing()), !r.getKeepAliveResult() ? 0 : 1, r.getSslState() == null ? "" : StringUtil.toLowerCase((String)String.valueOf(r.getSslState())), r.getSslState() != null && r.getSslState() != ThreeState.UNSURE ? 0 : 1});
        }
        List<DatabaseErrorHandler.Fix> list = handler.getFixes();
        Intrinsics.checkNotNullExpressionValue(list, (String)"handler.fixes");
        this.setStatus(new Status(failed, summary, list), null, false);
        this.configurable.getController().refresh();
    }

    private final TestConnectionResult pingDatabase(DatabaseConnection connection2) {
        TestConnectionResult result = new TestConnectionResult();
        Project project = this.configurable.getProject();
        DatabaseConnectionPoint databaseConnectionPoint = connection2.getConnectionPoint();
        Intrinsics.checkNotNullExpressionValue((Object)databaseConnectionPoint, (String)"connection.connectionPoint");
        String string = KeepAliveActionDescriptor.getKeepAliveQuery(project, databaseConnectionPoint.getDataSource());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"KeepAliveActionDescripto\u2026nnectionPoint.dataSource)");
        String query = string;
        BarrenStatement<String> stmt = SmartStatements.Companion.poweredBy(connection2).simple(Configuration.Companion.sourced(SmartStatements.Source.SYSTEM)).barren();
        long start2 = System.currentTimeMillis();
        try {
            stmt.execute(query);
            result.setKeepAliveResult(true);
        }
        catch (Exception e) {
            result.setKeepAliveResult(false);
        }
        result.setPing(System.currentTimeMillis() - start2);
        result.setSslState(((ExecutionEnvironmentHelper)ExecutionEnvironmentHelper.EP.forDbms(connection2.getDbms())).getSslState(connection2));
        return result;
    }

    @NotNull
    public final DataSourceConfigurable getConfigurable() {
        return this.configurable;
    }

    /*
     * WARNING - void declaration
     */
    public DataSourceTestConnectionComponent(@NotNull DataSourceConfigurable configurable) {
        void text2;
        void icon;
        void $this$panel;
        LayoutBuilder builder$iv;
        Intrinsics.checkNotNullParameter((Object)configurable, (String)"configurable");
        this.configurable = configurable;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
        objectRef2.element = null;
        LCFlags[] constraints$iv = new LCFlags[]{LCFlags.noGrid, LCFlags.fillX};
        String title$iv = null;
        boolean $i$f$panel = false;
        LayoutBuilder layoutBuilder = builder$iv = LayoutImplKt.createLayoutBuilder();
        DataSourceTestConnectionComponent dataSourceTestConnectionComponent = this;
        boolean bl = false;
        RowBuilder.DefaultImpls.row$default((RowBuilder)((RowBuilder)$this$panel), null, (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this, (Ref.ObjectRef)icon, (Ref.ObjectRef)text2){
            final /* synthetic */ DataSourceTestConnectionComponent this$0;
            final /* synthetic */ Ref.ObjectRef $icon$inlined;
            final /* synthetic */ Ref.ObjectRef $text$inlined;
            {
                this.this$0 = dataSourceTestConnectionComponent;
                this.$icon$inlined = objectRef;
                this.$text$inlined = objectRef2;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Row $this$row) {
                void $this$apply;
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                Cell cell = (Cell)$this$row;
                String string = DatabaseBundle.message((String)"DataSourceTestConnectionPanel.test.connection", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DatabaseBundle.message(\"\u2026onPanel.test.connection\")");
                CellBuilder cellBuilder = Cell.link$default((Cell)cell, (String)string, null, (Function0)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ $special$$inlined$panel$lambda$1 this$0;
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }

                    public final void invoke() {
                        this.this$0.this$0.testConnection(true);
                    }
                }), (int)2, null);
                boolean bl = false;
                boolean bl2 = false;
                CellBuilder $this$apply2 = cellBuilder;
                boolean bl3 = false;
                $this$apply2.getComponent().setFocusable(true);
                cellBuilder = Cell.label$default((Cell)((Cell)$this$row), (String)"", null, null, (boolean)false, (int)14, null);
                bl = false;
                bl2 = false;
                $this$apply2 = cellBuilder;
                boolean bl4 = false;
                ((JLabel)$this$apply2.getComponent()).setIcon(AllIcons.RunConfigurations.TestPassed);
                this.$icon$inlined.element = (JLabel)$this$apply2.getComponent();
                cellBuilder = Cell.invoke$default((Cell)((Cell)$this$row), (JComponent)((JComponent)((Object)new GrayLabel("", null, (LinkListener<Object>)((LinkListener)new LinkListener<Object>(this){
                    final /* synthetic */ $special$$inlined$panel$lambda$1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final void linkSelected(LinkLabel<Object> $noName_0, Object $noName_1) {
                        DataSourceTestConnectionComponent.access$showDetails(this.this$0.this$0);
                    }
                })))), (CCFlags[])new CCFlags[0], null, null, (int)6, null);
                bl = false;
                bl2 = false;
                $this$apply2 = cellBuilder;
                boolean bl5 = false;
                this.$text$inlined.element = (LinkLabel)$this$apply2.getComponent();
                Cell.invoke$default((Cell)((Cell)$this$row), (JComponent)new JPanel(), (CCFlags[])new CCFlags[]{$this$row.getGrowX(), $this$row.getPushX()}, null, null, (int)6, null);
                DefaultActionGroup group = new DefaultActionGroup();
                AnAction anAction = this.this$0.getConfigurable().getController().createResetAction(this.this$0.getConfigurable());
                if (anAction != null) {
                    AnAction anAction2 = anAction;
                    bl2 = false;
                    boolean bl6 = false;
                    AnAction it2 = anAction2;
                    boolean bl7 = false;
                    group.add(it2);
                }
                ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("toolbar", (ActionGroup)group, true);
                bl2 = false;
                boolean bl8 = false;
                ActionToolbar it2 = actionToolbar;
                Cell cell2 = (Cell)$this$row;
                boolean bl9 = false;
                $this$apply.setMiniMode(true);
                Unit unit = Unit.INSTANCE;
                ActionToolbar actionToolbar2 = actionToolbar;
                Intrinsics.checkNotNullExpressionValue((Object)actionToolbar2, (String)"ActionManager.getInstanc\u2026ply { setMiniMode(true) }");
                Cell.invoke$default((Cell)cell2, (JComponent)actionToolbar2.getComponent(), (CCFlags[])new CCFlags[0], null, null, (int)6, null);
            }
        }), (int)3, null);
        Unit unit = Unit.INSTANCE;
        DialogPanel panel$iv = ComponentsKt.DialogPanel((String)title$iv, null);
        builder$iv.getBuilder().build((Container)panel$iv, constraints$iv);
        LayoutKt.initPanel((LayoutBuilder)builder$iv, (DialogPanel)panel$iv);
        dataSourceTestConnectionComponent.component = (JComponent)panel$iv;
        JLabel jLabel = (JLabel)icon.element;
        Intrinsics.checkNotNull((Object)jLabel);
        this.statusIcon = jLabel;
        LinkLabel linkLabel = (LinkLabel)text2.element;
        Intrinsics.checkNotNull((Object)linkLabel);
        this.statusText = linkLabel;
        ((DialogPanel)this.component).setBorder(DriverInstantiateComponent.Companion.getTopPanelBorder());
        this.update();
    }

    public static final /* synthetic */ boolean access$handleDetailsLink(DataSourceTestConnectionComponent $this, HyperlinkEvent e) {
        return $this.handleDetailsLink(e);
    }

    public static final /* synthetic */ void access$hideDetails(DataSourceTestConnectionComponent $this) {
        $this.hideDetails();
    }

    public static final /* synthetic */ void access$applyTestConnectionResult(DataSourceTestConnectionComponent $this, LocalDataSource tempDataSource, ErrorHandler handler, TestConnectionResult r, Throwable e) {
        $this.applyTestConnectionResult(tempDataSource, handler, r, e);
    }

    public static final /* synthetic */ TestConnectionResult access$pingDatabase(DataSourceTestConnectionComponent $this, DatabaseConnection connection2) {
        return $this.pingDatabase(connection2);
    }

    public static final /* synthetic */ void access$showDetails(DataSourceTestConnectionComponent $this) {
        $this.showDetails();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB*\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\r\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\r\u0010\u0015\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0016J \u0010\u0017\u001a\u00020\u00032\b\u0010\u0018\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cR\u0018\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionComponent$Status;", "", "fail", "", "details", "", "Lcom/intellij/openapi/util/NlsContexts$DetailedDescription;", "fixes", "", "Lcom/intellij/database/dialects/DatabaseErrorHandler$Fix;", "(ZLjava/lang/String;Ljava/util/List;)V", "getDetails", "()Ljava/lang/String;", "getFail", "()Z", "getFixes", "()Ljava/util/List;", "appendFixes", "", "sb", "Lcom/intellij/openapi/util/text/HtmlBuilder;", "asHtml", "Lorg/jetbrains/annotations/Nls;", "handleLink", "desc", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/database/view/ui/DatabaseConfigEditor;", "Companion", "intellij.database.impl"})
    public static final class Status {
        private final boolean fail;
        @Nullable
        private final String details;
        @NotNull
        private final List<DatabaseErrorHandler.Fix> fixes;
        @NotNull
        private static final JBColor FAIL_COLOR;
        @NotNull
        private static final JBColor OK_COLOR;
        @NotNull
        public static final Companion Companion;

        @Nullable
        public final String asHtml() {
            if (this.details == null && this.fixes.isEmpty()) {
                return null;
            }
            HtmlBuilder builder = new HtmlBuilder();
            builder.append(StringUtil.notNullize((String)this.details));
            this.appendFixes(builder);
            return builder.toString();
        }

        /*
         * WARNING - void declaration
         */
        private final void appendFixes(HtmlBuilder sb) {
            if (this.fixes.isEmpty()) {
                return;
            }
            sb.append((HtmlChunk)HtmlChunk.br());
            int n = 0;
            int n2 = ((Collection)this.fixes).size();
            while (n < n2) {
                void i2;
                sb.appendRaw("&emsp;");
                sb.append((HtmlChunk)HtmlChunk.link((String)("fix" + (int)i2), (String)this.fixes.get((int)i2).getName()));
                ++i2;
            }
        }

        public final boolean handleLink(@Nullable String desc, @NotNull Project project, @NotNull DatabaseConfigEditor editor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            if (desc == null || !StringsKt.startsWith$default((String)desc, (String)"fix", (boolean)false, (int)2, null)) {
                return false;
            }
            int idx = StringUtil.parseInt((String)StringUtil.trimStart((String)desc, (String)"fix"), (int)-1);
            if (idx < 0 || idx >= this.fixes.size()) {
                return false;
            }
            DataSourceUiUtil.applyFix(project, this.fixes.get(0), editor);
            return true;
        }

        public final boolean getFail() {
            return this.fail;
        }

        @Nullable
        public final String getDetails() {
            return this.details;
        }

        @NotNull
        public final List<DatabaseErrorHandler.Fix> getFixes() {
            return this.fixes;
        }

        public Status(boolean fail, @Nullable String details, @NotNull List<? extends DatabaseErrorHandler.Fix> fixes) {
            Intrinsics.checkNotNullParameter(fixes, (String)"fixes");
            this.fail = fail;
            this.details = details;
            this.fixes = fixes;
        }

        static {
            Companion = new Companion(null);
            FAIL_COLOR = new JBColor(10944523, 12864337);
            JBColor jBColor = JBColor.GRAY;
            Intrinsics.checkNotNull((Object)jBColor);
            OK_COLOR = jBColor;
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionComponent$Status$Companion;", "", "()V", "FAIL_COLOR", "Lcom/intellij/ui/JBColor;", "getFAIL_COLOR", "()Lcom/intellij/ui/JBColor;", "OK_COLOR", "getOK_COLOR", "intellij.database.impl"})
        public static final class Companion {
            @NotNull
            public final JBColor getFAIL_COLOR() {
                return FAIL_COLOR;
            }

            @NotNull
            public final JBColor getOK_COLOR() {
                return OK_COLOR;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B.\u0012\r\u0010\u0003\u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\fH\u0014J\b\u0010\u000e\u001a\u00020\fH\u0014J\b\u0010\u000f\u001a\u00020\fH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionComponent$GrayLabel;", "Lcom/intellij/ui/components/labels/LinkLabel;", "", "text", "", "Lcom/intellij/openapi/util/NlsContexts$LinkLabel;", "icon", "Ljavax/swing/Icon;", "aListener", "Lcom/intellij/ui/components/labels/LinkListener;", "(Ljava/lang/String;Ljavax/swing/Icon;Lcom/intellij/ui/components/labels/LinkListener;)V", "getActive", "Ljava/awt/Color;", "getHover", "getNormal", "getVisited", "intellij.database.impl"})
    public static final class GrayLabel
    extends LinkLabel<Object> {
        @NotNull
        protected Color getActive() {
            return this.getNormal();
        }

        @NotNull
        protected Color getNormal() {
            Color color = JBUI.CurrentTheme.Label.disabledForeground((boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"JBUI.CurrentTheme.Label.disabledForeground(false)");
            return color;
        }

        @NotNull
        protected Color getHover() {
            Color color = JBUI.CurrentTheme.Label.foreground();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"JBUI.CurrentTheme.Label.foreground()");
            return color;
        }

        @NotNull
        protected Color getVisited() {
            return this.getNormal();
        }

        public GrayLabel(@Nullable String text2, @Nullable Icon icon, @Nullable LinkListener<Object> aListener) {
            super(text2, icon, aListener);
            this.setFocusable(true);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionComponent$TestConnectionResult;", "", "()V", "keepAliveResult", "", "getKeepAliveResult", "()Z", "setKeepAliveResult", "(Z)V", "ping", "", "getPing", "()J", "setPing", "(J)V", "sslState", "Lcom/intellij/util/ThreeState;", "getSslState", "()Lcom/intellij/util/ThreeState;", "setSslState", "(Lcom/intellij/util/ThreeState;)V", "intellij.database.impl"})
    private static final class TestConnectionResult {
        private long ping;
        private boolean keepAliveResult;
        @Nullable
        private ThreeState sslState = ThreeState.UNSURE;

        public final long getPing() {
            return this.ping;
        }

        public final void setPing(long l) {
            this.ping = l;
        }

        public final boolean getKeepAliveResult() {
            return this.keepAliveResult;
        }

        public final void setKeepAliveResult(boolean bl) {
            this.keepAliveResult = bl;
        }

        @Nullable
        public final ThreeState getSslState() {
            return this.sslState;
        }

        public final void setSslState(@Nullable ThreeState threeState) {
            this.sslState = threeState;
        }
    }
}

