/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.ui;

import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BeforeConnectionStepsPanel
extends JPanel {
    @NotNull
    private final Project myProject;
    private final JBList<BeforeRunTask<?>> myList;
    private final CollectionListModel<BeforeRunTask<?>> myModel;
    private final List<BeforeRunTask<?>> originalTasks;
    private final JPanel myPanel;
    private final Set<BeforeRunTask<?>> clonedTasks;
    private final RunConfiguration myFake;

    public BeforeConnectionStepsPanel(@NotNull Project project) {
        if (project == null) {
            BeforeConnectionStepsPanel.$$$reportNull$$$0(0);
        }
        this.originalTasks = new SmartList();
        this.clonedTasks = CollectionFactory.createSmallMemoryFootprintSet();
        this.myProject = project;
        this.myFake = ConsoleRunConfiguration.newConfiguration(this.myProject);
        this.myModel = new CollectionListModel((Object[])new BeforeRunTask[0]);
        this.myList = new JBList(this.myModel);
        this.myList.getEmptyText().setText(ExecutionBundle.message((String)"before.launch.panel.empty", (Object[])new Object[0]));
        this.myList.setSelectionMode(0);
        this.myList.setCellRenderer((ListCellRenderer)((Object)new MyListCellRenderer()));
        this.myList.setVisibleRowCount(4);
        ToolbarDecorator myDecorator = ToolbarDecorator.createDecorator(this.myList);
        myDecorator.setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                BeforeRunTaskProvider<BeforeRunTask<?>> provider;
                int index2 = BeforeConnectionStepsPanel.this.myList.getSelectedIndex();
                if (index2 == -1) {
                    return;
                }
                BeforeRunTask task = (BeforeRunTask)BeforeConnectionStepsPanel.this.myModel.getElementAt(index2);
                if (!BeforeConnectionStepsPanel.this.clonedTasks.contains(task)) {
                    task = task.clone();
                    BeforeConnectionStepsPanel.this.clonedTasks.add(task);
                    BeforeConnectionStepsPanel.this.myModel.setElementAt((Object)task, index2);
                }
                if ((provider = BeforeConnectionStepsPanel.getProvider(BeforeConnectionStepsPanel.this.myProject, task.getProviderId())) != null) {
                    provider.configureTask(button.getDataContext(), BeforeConnectionStepsPanel.this.myFake, task);
                }
            }
        });
        myDecorator.setEditActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(@NotNull AnActionEvent e) {
                BeforeRunTask task;
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                BeforeRunTaskProvider<BeforeRunTask<?>> provider = (task = (BeforeRunTask)BeforeConnectionStepsPanel.this.myList.getSelectedValue()) == null ? null : BeforeConnectionStepsPanel.getProvider(BeforeConnectionStepsPanel.this.myProject, task.getProviderId());
                return provider != null && provider.isConfigurable();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/ui/BeforeConnectionStepsPanel$2", "isEnabled"));
            }
        });
        myDecorator.setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                BeforeConnectionStepsPanel.this.doAddAction(button);
            }
        });
        myDecorator.setAddActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                return BeforeConnectionStepsPanel.this.checkBeforeRunTasksAbility(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/ui/BeforeConnectionStepsPanel$4", "isEnabled"));
            }
        });
        this.myPanel = myDecorator.createPanel();
        myDecorator.getActionsPanel().setCustomShortcuts(CommonActionsPanel.Buttons.EDIT, new ShortcutSet[]{CommonActionsPanel.getCommonShortcut((CommonActionsPanel.Buttons)CommonActionsPanel.Buttons.EDIT), CommonShortcuts.DOUBLE_CLICK_1});
        this.setLayout(new BorderLayout());
        this.add((Component)this.myPanel, "Center");
    }

    public void doReset(@NotNull List<BeforeRunTask<?>> tasks) {
        if (tasks == null) {
            BeforeConnectionStepsPanel.$$$reportNull$$$0(1);
        }
        this.clonedTasks.clear();
        this.originalTasks.clear();
        this.originalTasks.addAll(tasks);
        this.myModel.replaceAll(this.originalTasks);
        this.myPanel.setVisible(this.checkBeforeRunTasksAbility(false));
    }

    @NotNull
    public List<BeforeRunTask<?>> getTasks() {
        List items2 = this.myModel.getItems();
        List<Object> list = items2.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(items2);
        if (list == null) {
            BeforeConnectionStepsPanel.$$$reportNull$$$0(2);
        }
        return list;
    }

    private boolean checkBeforeRunTasksAbility(boolean checkOnlyAddAction) {
        Set<Key<?>> activeProviderKeys = this.getActiveProviderKeys();
        for (BeforeRunTaskProvider<BeforeRunTask<?>> provider : this.getBeforeRunTaskProviders()) {
            if (provider.createTask(this.myFake) == null) continue;
            if (!checkOnlyAddAction) {
                return true;
            }
            if (provider.isSingleton() && activeProviderKeys.contains(provider.getId())) continue;
            return true;
        }
        return false;
    }

    private void doAddAction(final @NotNull AnActionButton button) {
        if (button == null) {
            BeforeConnectionStepsPanel.$$$reportNull$$$0(3);
        }
        Set<Key<?>> activeProviderKeys = this.getActiveProviderKeys();
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        for (final BeforeRunTaskProvider<BeforeRunTask<?>> provider : this.getBeforeRunTaskProviders()) {
            if (provider.createTask(this.myFake) == null || activeProviderKeys.contains(provider.getId()) && provider.isSingleton()) continue;
            actionGroup.add(new AnAction(provider.getName(), null, provider.getIcon()){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    BeforeRunTask task;
                    if (e == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    if ((task = provider.createTask(BeforeConnectionStepsPanel.this.myFake)) == null) {
                        return;
                    }
                    provider.configureTask(button.getDataContext(), BeforeConnectionStepsPanel.this.myFake, task).onSuccess(changed -> {
                        if (!provider.canExecuteTask(BeforeConnectionStepsPanel.this.myFake, task)) {
                            return;
                        }
                        task.setEnabled(true);
                        BeforeConnectionStepsPanel.this.addTask(task);
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/ui/BeforeConnectionStepsPanel$5", "actionPerformed"));
                }
            });
        }
        DataContext context = button.getDataContext();
        ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(ExecutionBundle.message((String)"add.new.run.configuration.action2.name", (Object[])new Object[0]), (ActionGroup)actionGroup, context, false, false, false, null, -1, Conditions.alwaysTrue());
        popup2.show(Objects.requireNonNull(button.getPreferredPopupPoint()));
    }

    @NotNull
    private List<BeforeRunTaskProvider<BeforeRunTask<?>>> getBeforeRunTaskProviders() {
        List list = BeforeRunTaskProvider.EP_NAME.getExtensions((AreaInstance)this.myProject);
        if (list == null) {
            BeforeConnectionStepsPanel.$$$reportNull$$$0(4);
        }
        return list;
    }

    public void addTask(@NotNull BeforeRunTask<?> task) {
        if (task == null) {
            BeforeConnectionStepsPanel.$$$reportNull$$$0(5);
        }
        this.myModel.add(task);
    }

    @NotNull
    private Set<Key<?>> getActiveProviderKeys() {
        List items2 = this.myModel.getItems();
        Set result = CollectionFactory.createSmallMemoryFootprintSet((int)items2.size());
        for (BeforeRunTask task : items2) {
            result.add(task.getProviderId());
        }
        Set set = result;
        if (set == null) {
            BeforeConnectionStepsPanel.$$$reportNull$$$0(6);
        }
        return set;
    }

    @Nullable
    private static BeforeRunTaskProvider<BeforeRunTask<?>> getProvider(@NotNull Project project, Key<?> key) {
        if (project == null) {
            BeforeConnectionStepsPanel.$$$reportNull$$$0(7);
        }
        for (BeforeRunTaskProvider provider : BeforeRunTaskProvider.EP_NAME.getIterable((AreaInstance)project)) {
            if (provider.getId() != key) continue;
            return provider;
        }
        return null;
    }

    @Nullable
    public static BeforeRunTaskProvider<BeforeRunTask<?>> getProvider(@NotNull Project project, String key) {
        if (project == null) {
            BeforeConnectionStepsPanel.$$$reportNull$$$0(8);
        }
        for (BeforeRunTaskProvider provider : BeforeRunTaskProvider.EP_NAME.getIterable((AreaInstance)project)) {
            if (!provider.getId().toString().equals(key)) continue;
            return provider;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/ui/BeforeConnectionStepsPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/ui/BeforeConnectionStepsPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTasks";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeforeRunTaskProviders";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveProviderKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doReset";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doAddAction";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addTask";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getProvider";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyListCellRenderer
    extends JBList.StripedListCellRenderer {
        private MyListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value2, int index2, boolean isSelected, boolean cellHasFocus) {
            BeforeRunTask task;
            BeforeRunTaskProvider<BeforeRunTask<?>> provider;
            super.getListCellRendererComponent(list, value2, index2, isSelected, cellHasFocus);
            if (value2 instanceof BeforeRunTask && (provider = BeforeConnectionStepsPanel.getProvider(BeforeConnectionStepsPanel.this.myProject, (task = (BeforeRunTask)value2).getProviderId())) != null) {
                Icon icon = provider.getTaskIcon(task);
                this.setIcon(icon != null ? icon : provider.getIcon());
                this.setText(provider.getDescription(task));
            }
            return this;
        }
    }

    public static interface StepsBeforeRunListener {
        public void fireStepsBeforeRunChanged();

        public void titleChanged(@NotNull String var1);
    }
}

