/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.DataSourceStorageUtil;
import com.intellij.database.dataSource.LocalDataSourceCore;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystemCore;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.ObjectPath;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcUtilsCore {
    protected static final String EMPTY = "&empty;";
    protected static final List<List<String>> ESCAPES = Arrays.asList(Arrays.asList("/", "\\", "&", "@"), Arrays.asList("&eslash;", "&slash;", "&amp;", "&at;"));

    protected DbSrcUtilsCore() {
    }

    public static boolean isDbSrcFile(@Nullable VirtualFile file) {
        return file != null && file.getFileSystem() instanceof DbSrcFileSystemCore;
    }

    @Nullable
    public static String getDataSource(@NotNull VirtualFile file) {
        if (file == null) {
            DbSrcUtilsCore.$$$reportNull$$$0(0);
        }
        return DbSrcFileSystemCore.processPath(file, new DbSrcFileSystemCore.ItemProcessor<String>(){

            @Override
            public String processDataSource(@Nullable Project project, @NotNull String dataSourceId) {
                if (dataSourceId == null) {
                    1.$$$reportNull$$$0(0);
                }
                return dataSourceId;
            }

            @Override
            public String processFolder(@Nullable Project project, @NotNull String dataSourceId, @Nullable ObjectPath path, @Nullable ObjectKind group) {
                if (dataSourceId == null) {
                    1.$$$reportNull$$$0(1);
                }
                return dataSourceId;
            }

            @Override
            public String processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull ObjectPath path, @NotNull DbSrcFileSystemCore.ItemType type) {
                if (dataSourceId == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (path == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (type == null) {
                    1.$$$reportNull$$$0(4);
                }
                return dataSourceId;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataSourceId";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcUtilsCore$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processDataSource";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFolder";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFile";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Nullable
    public static ObjectPath getFullPath(@NotNull String path) {
        if (path == null) {
            DbSrcUtilsCore.$$$reportNull$$$0(1);
        }
        return DbSrcFileSystemCore.processPath(path, new DbSrcFileSystemCore.ItemProcessor<ObjectPath>(){

            @Override
            public ObjectPath processFolder(@Nullable Project project, @NotNull String dataSourceId, @Nullable ObjectPath path, ObjectKind group) {
                if (dataSourceId == null) {
                    2.$$$reportNull$$$0(0);
                }
                return group == null ? path : null;
            }

            @Override
            public ObjectPath processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull ObjectPath path, @NotNull DbSrcFileSystemCore.ItemType type) {
                if (dataSourceId == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (path == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (type == null) {
                    2.$$$reportNull$$$0(3);
                }
                return path;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataSourceId";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcUtilsCore$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFolder";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFile";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static Iterable<String> splitPath(@NotNull String path) {
        if (path == null) {
            DbSrcUtilsCore.$$$reportNull$$$0(2);
        }
        return StringUtil.tokenize((String)path, (String)"/");
    }

    public static String unescapeChars(String s2) {
        if (s2 == null) {
            return null;
        }
        if (s2.equals(EMPTY)) {
            return "";
        }
        return StringUtil.replace((String)s2, ESCAPES.get(1), ESCAPES.get(0));
    }

    @Nullable
    public static ObjectKind findKind(@Nullable String code) {
        return code == null ? null : (ObjectKind)ObjectKind.ourKinds.get(code);
    }

    @Nullable
    public static LocalDataSourceCore findDataSource(@Nullable Project project, @NotNull String id) {
        if (id == null) {
            DbSrcUtilsCore.$$$reportNull$$$0(3);
        }
        List<? extends LocalDataSourceCore> sources = DbSrcUtilsCore.getDataSources(project);
        for (LocalDataSourceCore localDataSourceCore : sources) {
            if (localDataSourceCore.isGlobal() != (project == null) || !id.equals(localDataSourceCore.getUniqueId())) continue;
            return localDataSourceCore;
        }
        return null;
    }

    @Nullable
    public static LocalDataSourceCore findDataSource(@Nullable VirtualFile file) {
        if (file == null) {
            return null;
        }
        return DbSrcFileSystemCore.processPath(file, new DbSrcFileSystemCore.ItemProcessor<LocalDataSourceCore>(){

            @Override
            public LocalDataSourceCore processDataSource(@Nullable Project project, @NotNull String dataSourceId) {
                if (dataSourceId == null) {
                    3.$$$reportNull$$$0(0);
                }
                return DbSrcUtilsCore.findDataSource(project, dataSourceId);
            }

            @Override
            public LocalDataSourceCore processFolder(@Nullable Project project, @NotNull String dataSourceId, @Nullable ObjectPath path, @Nullable ObjectKind group) {
                if (dataSourceId == null) {
                    3.$$$reportNull$$$0(1);
                }
                return DbSrcUtilsCore.findDataSource(project, dataSourceId);
            }

            @Override
            public LocalDataSourceCore processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull ObjectPath path, @NotNull DbSrcFileSystemCore.ItemType type) {
                if (dataSourceId == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (path == null) {
                    3.$$$reportNull$$$0(3);
                }
                if (type == null) {
                    3.$$$reportNull$$$0(4);
                }
                return DbSrcUtilsCore.findDataSource(project, dataSourceId);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataSourceId";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcUtilsCore$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processDataSource";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFolder";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFile";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    public static List<? extends LocalDataSourceCore> getDataSources(@Nullable Project project) {
        List<? extends LocalDataSourceCore> list = project == null ? DataSourceStorageUtil.getStorage().getDataSources() : DataSourceStorageUtil.getProjectStorage(project).getDataSources();
        if (list == null) {
            DbSrcUtilsCore.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcUtilsCore";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcUtilsCore";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSources";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDataSource";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFullPath";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "splitPath";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findDataSource";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

