/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystemCore;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBTreeTraverser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcMapping {
    private static final DbSrcMapping INSTANCE = new DbSrcMapping();

    @NotNull
    public static DbSrcMapping getInstance() {
        DbSrcMapping dbSrcMapping = INSTANCE;
        if (dbSrcMapping == null) {
            DbSrcMapping.$$$reportNull$$$0(0);
        }
        return dbSrcMapping;
    }

    @Nullable
    public DbElement getDbElement(@NotNull PsiObject object) {
        DbElement element2;
        if (object == null) {
            DbSrcMapping.$$$reportNull$$$0(1);
        }
        if (object instanceof DbElement) {
            return (DbElement)object;
        }
        PsiFile file = object.getContainingFile();
        file = file == null ? null : file.getOriginalFile();
        VirtualFile vfile = file == null ? null : file.getVirtualFile();
        DbElement dbElement = element2 = vfile == null ? null : DbImplUtil.findElement(file.getProject(), vfile);
        if (element2 == null) {
            return null;
        }
        DbDataSource dataSource2 = element2.getDataSource();
        Condition<DasObject> condition = DbNavigationUtils.matchObject(object.getName(), DbSqlUtilCore.isQuoted((DasObject)object), object.getKind(), (CasingProvider)dataSource2.getModel());
        DasObject first2 = (DasObject)((JBTreeTraverser)dataSource2.getModel().traverser().withRoot((Object)((DasObject)element2.getDelegate()))).bfsTraversal().filter(condition).first();
        return first2 == null ? element2 : DbImplUtil.findElement(dataSource2, first2);
    }

    public boolean processSources(@NotNull DbElement el, @NotNull Consumer<PsiElement> consumer2) {
        PsiObject psiSrc;
        DbDataSource ds;
        LocalDataSource local;
        if (el == null) {
            DbSrcMapping.$$$reportNull$$$0(2);
        }
        if (consumer2 == null) {
            DbSrcMapping.$$$reportNull$$$0(3);
        }
        boolean result = false;
        PsiElement delegate = (PsiElement)ObjectUtils.tryCast((Object)el.getDelegate(), PsiElement.class);
        if (delegate != null) {
            consumer2.consume((Object)delegate);
            result = true;
        }
        if ((local = (LocalDataSource)ObjectUtils.tryCast((Object)(ds = el.getDataSource()).getDelegate(), LocalDataSource.class)) == null || el == ds) {
            return false;
        }
        Project project = local.isGlobal() ? null : ds.getProject();
        VirtualFile file = DbSrcFileSystem.getInstance().findFileByPath(DbSrcFileSystem.getPath(project, ds.getUniqueId(), (DasObject)el, (CasingProvider)local.getModel(), DbSrcFileSystemCore.ItemType.SRC));
        PsiFile psiFile = file == null ? null : el.getManager().findFile(file);
        PsiObject psiObject = psiSrc = psiFile == null ? null : (PsiObject)((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)psiFile).expand(psi -> !(psi instanceof SqlStatement))).filter(PsiObject.class).filter(DasUtil.byKind((ObjectKind)el.getKind())).first();
        if (psiSrc != null) {
            consumer2.consume(psiSrc);
            result = true;
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcMapping";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcMapping";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDbElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processSources";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

