/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.connection.statements;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.Either;
import com.intellij.database.dataSource.connection.EitherKt;
import com.intellij.database.dataSource.connection.audit.ListenerAuditService;
import com.intellij.database.dataSource.connection.statements.BatchesContainer;
import com.intellij.database.dataSource.connection.statements.ClosableResultsProducer;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.JdbcBasedSmartStatement;
import com.intellij.database.dataSource.connection.statements.ParameterizedStatementBasis;
import com.intellij.database.dataSource.connection.statements.ParameterizedStatementData;
import com.intellij.database.dataSource.connection.statements.ParameterizedStatementDecoration;
import com.intellij.database.dataSource.connection.statements.ReusableNoisyStatement;
import com.intellij.database.dataSource.connection.statements.ReusableParameterizedStatement$sam$com_intellij_util_ThrowableRunnable$0;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatementsUtil;
import com.intellij.database.dataSource.connection.statements.StagedException;
import com.intellij.database.dataSource.connection.statements.StatementHolder;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.RemoteStatement;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.util.ThrowableRunnable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J$\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00150\u00182\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0011H\u0014J\b\u0010\u001b\u001a\u00020\u0015H\u0016J\u0010\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\u0014\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020 0\u0018H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0016\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006#"}, d2={"Lcom/intellij/database/dataSource/connection/statements/ReusableParameterizedStatement;", "Lcom/intellij/database/dataSource/connection/statements/JdbcBasedSmartStatement$Parameterized;", "Lcom/intellij/database/dataSource/connection/statements/ParameterizedStatementDecoration;", "Lcom/intellij/database/dataSource/connection/statements/ReusableSmartStatement;", "basis", "Lcom/intellij/database/dataSource/connection/statements/ParameterizedStatementBasis;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "auditService", "Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;", "configuration", "Lcom/intellij/database/dataSource/connection/statements/Configuration;", "(Lcom/intellij/database/dataSource/connection/statements/ParameterizedStatementBasis;Lcom/intellij/database/dataSource/DatabaseConnection;Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;Lcom/intellij/database/dataSource/connection/statements/Configuration;)V", "batches", "Lcom/intellij/database/dataSource/connection/statements/BatchesContainer;", "statementHolder", "Lcom/intellij/database/dataSource/connection/statements/StatementHolder$Reusable;", "Lcom/intellij/database/remote/jdbc/RemotePreparedStatement;", "getStatementHolder", "()Lcom/intellij/database/dataSource/connection/statements/StatementHolder$Reusable;", "addBatch", "", "input", "before", "Lcom/intellij/database/dataSource/connection/Either;", "Lcom/intellij/database/dataSource/connection/statements/StagedException;", "statement", "close", "decoration", "escapeIndex", "", "executeBatch", "Lcom/intellij/database/dataSource/connection/statements/ClosableResultsProducer;", "extract", "", "intellij.database.impl"})
public final class ReusableParameterizedStatement
extends JdbcBasedSmartStatement.Parameterized<ParameterizedStatementDecoration>
implements ReusableSmartStatement<ParameterizedStatementDecoration> {
    @NotNull
    private final StatementHolder.Reusable<RemotePreparedStatement> statementHolder;
    private final BatchesContainer batches;
    private final ParameterizedStatementBasis basis;

    @Override
    @NotNull
    protected StatementHolder.Reusable<RemotePreparedStatement> getStatementHolder() {
        return this.statementHolder;
    }

    @Override
    public void addBatch(@NotNull ParameterizedStatementDecoration input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        RemotePreparedStatement statement = (RemotePreparedStatement)EitherKt.tryGet(this.getCurrentStatement(input)).getValue();
        this.completeStatement(statement, input);
        statement.addBatch();
        this.batches.add(this.basis.getSql());
    }

    @Override
    @NotNull
    protected Either<StagedException, Unit> before(@NotNull ParameterizedStatementDecoration input, @NotNull RemotePreparedStatement statement) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        this.getAuditService().beforeParameterizedStatement(new ParameterizedStatementData(this.basis, input), this);
        return super.before(input, statement);
    }

    @Override
    @NotNull
    public Either<StagedException, ClosableResultsProducer> executeBatch() {
        Object s2 = ((StatementHolder.Reusable)this.getStatementHolder()).getStatement();
        Intrinsics.checkNotNull(s2);
        return SmartStatementsUtil.executeBatch(s2, this.getConnection(), this, this.batches);
    }

    @Override
    public void close() {
        RemotePreparedStatement statement = (RemotePreparedStatement)((StatementHolder.Reusable)this.getStatementHolder()).getStatement();
        if (statement != null) {
            this.getAuditService().beforeStatementClosing((RemoteStatement)statement, this);
            Function0 function0 = (Function0)new Function0<Unit>(statement){

                public final void invoke() {
                    ((RemotePreparedStatement)this.receiver).close();
                }
            };
            JdbcNativeUtil.performSafe((ThrowableRunnable)new ReusableParameterizedStatement$sam$com_intellij_util_ThrowableRunnable$0(function0));
        }
        this.batches.clear();
    }

    @Override
    @NotNull
    public String extract(@NotNull ParameterizedStatementDecoration input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return this.basis.getSql();
    }

    @Override
    public int escapeIndex(@NotNull ParameterizedStatementDecoration input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return this.basis.getEscapeIdx();
    }

    @Override
    @NotNull
    public ParameterizedStatementDecoration decoration(@NotNull ParameterizedStatementDecoration input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return input;
    }

    public ReusableParameterizedStatement(@NotNull ParameterizedStatementBasis basis, @NotNull DatabaseConnection connection2, @NotNull ListenerAuditService auditService, @NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)basis, (String)"basis");
        Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)auditService, (String)"auditService");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        super(connection2, auditService, configuration);
        this.basis = basis;
        this.statementHolder = new StatementHolder.Reusable();
        this.batches = new BatchesContainer();
    }

    @Override
    @NotNull
    public ReusableNoisyStatement<ParameterizedStatementDecoration> noisy() {
        return ReusableSmartStatement.DefaultImpls.noisy(this);
    }
}

