/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.components.JBPasswordField;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DatabasePasswordField {
    private final JBPasswordField myComponent;
    private final DatabaseCredentials myLocalCredentials;
    private boolean myModified;
    private boolean myMatchesGlobal;

    public DatabasePasswordField(@NotNull DatabaseCredentials local, @NotNull DasDataSource dataSource2) {
        if (local == null) {
            DatabasePasswordField.$$$reportNull$$$0(0);
        }
        if (dataSource2 == null) {
            DatabasePasswordField.$$$reportNull$$$0(1);
        }
        this.myComponent = new JBPasswordField();
        this.myLocalCredentials = local;
        this.myComponent.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                DatabasePasswordField.this.setModified(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/DatabasePasswordField$1", "textChanged"));
            }
        });
        this.myMatchesGlobal = this.extractPassword(this.myLocalCredentials, dataSource2) == null;
        this.setModified(false);
        PopupHandler.installPopupHandler((JComponent)this.myComponent, (ActionGroup)new DefaultActionGroup(new AnAction[]{new AnAction(DatabaseBundle.message((String)"action.DatabasePasswordField.set.empty.text", (Object[])new Object[0]), null, null){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                DatabasePasswordField.this.setPassword("");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/DatabasePasswordField$2", "actionPerformed"));
            }
        }}), (String)"unknown", (ActionManager)ActionManager.getInstance());
    }

    public JBPasswordField getComponent() {
        return this.myComponent;
    }

    protected abstract LocalDataSource getActualTarget();

    private void setModified(boolean modified) {
        this.myModified = modified;
        this.myComponent.setPasswordIsStored(!modified);
    }

    public char @Nullable [] getPassword() {
        char[] opt = this.getPasswordOpt();
        if (opt != null) {
            return opt;
        }
        OneTimeString pass = this.getFromCredentials();
        return pass == null ? null : pass.toCharArray(true);
    }

    @Nullable
    private OneTimeString getPasswordOneTime() {
        char[] opt = this.getPasswordOpt();
        return opt != null ? new OneTimeString(opt) : this.getFromCredentials();
    }

    public char @Nullable [] getPasswordOpt() {
        return this.myModified ? this.myComponent.getPassword() : null;
    }

    private void reset() {
        this.myComponent.setText("");
        this.setModified(false);
    }

    public void save(@NotNull DasDataSource dataSource2) {
        if (dataSource2 == null) {
            DatabasePasswordField.$$$reportNull$$$0(2);
        }
        this.setPassword(this.myLocalCredentials, dataSource2, this.getPasswordOneTime());
    }

    public void moveToStorage() {
        char[] pass = this.getPasswordOpt();
        if (pass != null) {
            this.setPassword(this.myLocalCredentials, this.getActualTarget(), new OneTimeString(pass));
            this.myMatchesGlobal = false;
            this.reset();
        }
    }

    public void changedInStorage() {
        this.myMatchesGlobal = false;
        this.reset();
    }

    public void copy(@NotNull DasDataSource from) {
        if (from == null) {
            DatabasePasswordField.$$$reportNull$$$0(3);
        }
        this.myComponent.setText("");
        this.setModified(false);
        this.setPassword(this.myLocalCredentials, this.getActualTarget(), this.extractPassword(from));
        this.myMatchesGlobal = false;
    }

    public boolean isModified() {
        return this.myModified || !this.myMatchesGlobal;
    }

    public void setPassword(@Nullable String text2) {
        if (Comparing.equal((Object)this.getPasswordOpt(), (Object)text2)) {
            this.myMatchesGlobal = true;
            return;
        }
        if (text2 == null) {
            this.setPassword(this.myLocalCredentials, this.getActualTarget(), null);
            this.myMatchesGlobal = true;
        }
        if (text2 == null) {
            this.reset();
        } else {
            char[] prev = this.myComponent.getPassword();
            if (text2.isEmpty() && (prev == null || prev.length == 0)) {
                this.myComponent.setText("temp");
            }
            this.myComponent.setText(text2);
        }
    }

    @Nullable
    private OneTimeString getFromCredentials() {
        return this.extractPassword(this.getActualTarget());
    }

    @Nullable
    protected OneTimeString extractPassword(@NotNull DasDataSource dataSource2) {
        OneTimeString password;
        if (dataSource2 == null) {
            DatabasePasswordField.$$$reportNull$$$0(4);
        }
        if ((password = this.extractPassword(this.myLocalCredentials, dataSource2)) == null) {
            password = this.extractPassword(DatabaseCredentials.getInstance(), dataSource2);
        }
        return password;
    }

    @Nullable
    protected abstract OneTimeString extractPassword(@NotNull DatabaseCredentials var1, @NotNull DasDataSource var2);

    protected abstract void setPassword(@NotNull DatabaseCredentials var1, @NotNull DasDataSource var2, @Nullable OneTimeString var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "local";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dataSource/DatabasePasswordField";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "save";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "copy";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "extractPassword";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

