/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcModelStorage;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModMateNamespace;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.GuardedRef;
import com.intellij.database.util.IntrospectionScopeUpdater;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseModelLoader {
    private static final Logger LOG = Logger.getInstance(DatabaseModelLoader.class);
    private static final BasicNamespace[] NO_NAMESPACES = new BasicNamespace[0];

    public static boolean matches(@NotNull DasObject o, @NotNull TreePattern scope) {
        if (o == null) {
            DatabaseModelLoader.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            DatabaseModelLoader.$$$reportNull$$$0(1);
        }
        return DataSourceSchemaMapping.matches(scope, o);
    }

    private static BasicNamespace @NotNull [] getNamespacesToIntrospect(@NotNull LoaderContext context, @NotNull BasicModModel model, @NotNull TreePattern selectedScope) {
        List namespaces;
        if (context == null) {
            DatabaseModelLoader.$$$reportNull$$$0(2);
        }
        if (model == null) {
            DatabaseModelLoader.$$$reportNull$$$0(3);
        }
        if (selectedScope == null) {
            DatabaseModelLoader.$$$reportNull$$$0(4);
        }
        if (context.isSchemaListOnly()) {
            if (NO_NAMESPACES == null) {
                DatabaseModelLoader.$$$reportNull$$$0(5);
            }
            return NO_NAMESPACES;
        }
        if (context.isEverythingSelected()) {
            if (NO_NAMESPACES == null) {
                DatabaseModelLoader.$$$reportNull$$$0(6);
            }
            return NO_NAMESPACES;
        }
        boolean dbRoot = DbImplUtilCore.getMetaModel(context.getDbms()).getRootNamespaceKinds().contains((Object)ObjectKind.DATABASE);
        boolean allSchemas = DatabaseModelLoader.isAllSchemas(dbRoot, selectedScope);
        if (allSchemas) {
            if (NO_NAMESPACES == null) {
                DatabaseModelLoader.$$$reportNull$$$0(7);
            }
            return NO_NAMESPACES;
        }
        JBIterable visibleNamespaces = ((JBTreeTraverser)((JBTreeTraverser)model.traverser().expandAndFilter(o -> DataSourceSchemaMapping.isIntrospected(context.getDataSource().getIntrospectionScope(), o))).expand(object -> !DbImplUtil.isSchema(object))).filter(BasicNamespace.class);
        int nonLimitedCount = visibleNamespaces.filter(n -> DbImplUtil.isSchema(n) || n.getKind() == ObjectKind.DATABASE && !n.hasChildren()).size();
        if (nonLimitedCount == (namespaces = visibleNamespaces.filter(object -> {
            if (DbImplUtil.isSchema(object)) {
                if (DatabaseModelLoader.matches(object, selectedScope)) {
                    return true;
                }
                BasicElement parent2 = object.getParent();
                if (parent2 != null && DataSourceSchemaMapping.matchesExact(selectedScope, ObjectPaths.of(parent2))) {
                    return true;
                }
            }
            return object.getKind() == ObjectKind.DATABASE && !object.hasChildren() && DatabaseModelLoader.matches(object, selectedScope);
        }).toList()).size()) {
            if (NO_NAMESPACES == null) {
                DatabaseModelLoader.$$$reportNull$$$0(8);
            }
            return NO_NAMESPACES;
        }
        BasicNamespace[] basicNamespaceArray = namespaces.toArray(new BasicNamespace[0]);
        if (basicNamespaceArray == null) {
            DatabaseModelLoader.$$$reportNull$$$0(9);
        }
        return basicNamespaceArray;
    }

    @NotNull
    private static TreePattern getSelectedScope(@NotNull LoaderContext context) {
        if (context == null) {
            DatabaseModelLoader.$$$reportNull$$$0(10);
        }
        JBIterable fromDasObjects = JBIterable.from(context.getSelection()).filter(BasicElement.class).filterMap(o -> {
            BasicNamespace nsp = o.getSchema();
            if (nsp == null) {
                nsp = o.getDatabase();
            }
            return nsp == null ? null : TreePatternUtils.create(ObjectPaths.of(nsp));
        });
        JBIterable fromStringPatterns = JBIterable.from(context.getSelection()).filter(String.class).transform(s2 -> TreePatternUtils.importPattern(context.getDbms(), s2));
        TreePattern treePattern = TreePatternUtils.union((Iterable<TreePattern>)fromStringPatterns.append((Iterable)fromDasObjects));
        if (treePattern == null) {
            DatabaseModelLoader.$$$reportNull$$$0(11);
        }
        return treePattern;
    }

    private static boolean isAllSchemas(boolean dbRoot, @NotNull TreePattern s2) {
        TreePatternNode.Group rg;
        if (s2 == null) {
            DatabaseModelLoader.$$$reportNull$$$0(12);
        }
        if ((rg = s2.root.getGroup(dbRoot ? ObjectKind.DATABASE : ObjectKind.SCHEMA)) == null || rg.negativeChild == null) {
            return false;
        }
        if (!dbRoot) {
            return true;
        }
        TreePatternNode.Group scG = rg.negativeChild.getGroup(ObjectKind.SCHEMA);
        return scG != null && scG.negativeChild != null;
    }

    private static Set<BasicDatabase> getDatabases(LoaderContext context, TreePattern selectionScope) {
        if (context.isEverythingSelected()) {
            return Collections.emptySet();
        }
        DasModel model = context.getDataSource().getModel();
        JBIterable newDbs = JBIterable.from(context.getScopeUpdater().getSchemasToAdd()).transform(p2 -> p2.findParent(ObjectKind.DATABASE, false)).unique().flatten(p2 -> QNameUtil.findByPath(model, p2).filter(BasicDatabase.class));
        return DatabaseModelLoader.scopeToDatabases(model, selectionScope).append((Iterable)newDbs).toSet();
    }

    private static Set<BasicDatabase> getDatabasesFromScope(LoaderContext context) {
        LocalDataSource source = context.getDataSource();
        TreePattern scope = source.getIntrospectionScope();
        if (scope.isEmpty()) {
            return Collections.emptySet();
        }
        DasModel model = source.getModel();
        JBIterable<BasicDatabase> dbs = DatabaseModelLoader.scopeToDatabases(model, scope);
        return dbs.toSet();
    }

    @NotNull
    private static JBIterable<BasicDatabase> scopeToDatabases(DasModel model, TreePattern scope) {
        JBIterable dbs = model.getModelRoots().filter(BasicDatabase.class);
        TreePatternNode.Group dbGroup = scope.root.getGroup(ObjectKind.DATABASE);
        if (dbGroup == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DatabaseModelLoader.$$$reportNull$$$0(13);
            }
            return jBIterable;
        }
        JBIterable jBIterable = dbs.filter(db -> {
            Casing casing = db.getCasing(ObjectKind.DATABASE, db);
            return db.isCurrent() && dbGroup.matchedChildren(ObjectName.quoted((String)"@"), casing, null) || dbGroup.matchedChildren(ObjectName.create((String)db.getName(), (boolean)DbSqlUtilCore.isQuoted(db)), casing, null);
        });
        if (jBIterable == null) {
            DatabaseModelLoader.$$$reportNull$$$0(14);
        }
        return jBIterable;
    }

    @NotNull
    private static DBIntrospectionOptions getIntrospectionOptions(LocalDataSource dataSource2) {
        DBIntrospectionOptions.SourceLoading withSources = dataSource2.getSourceLoading();
        return new DBIntrospectionOptions(withSources, dataSource2.getIntrospectionScope());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedScope";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DatabaseModelLoader";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DatabaseModelLoader";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespacesToIntrospect";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedScope";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "scopeToDatabases";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNamespacesToIntrospect";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedScope";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAllSchemas";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class IntrospectionSession {
        public static final String SINGLE_DB_WARNING = "ignore.single.db.warning";
        private final LoaderContext myContext;
        private final ProgressIndicator myIndicator;
        private final ModalityState myModality;
        private final DatabaseProcessor myProcessor;
        private final TreePattern mySelectedScope;
        private DBIntrospector myIntrospector;
        private GuardedRef<?> mySrcSession;
        private boolean myFirstTime;
        private boolean myUpdateScopeFromIntrospector;
        private boolean mySingleModeReported;

        public IntrospectionSession(@NotNull LoaderContext context, @NotNull ProgressIndicator indicator, @NotNull ModalityState modality) {
            if (context == null) {
                IntrospectionSession.$$$reportNull$$$0(0);
            }
            if (indicator == null) {
                IntrospectionSession.$$$reportNull$$$0(1);
            }
            if (modality == null) {
                IntrospectionSession.$$$reportNull$$$0(2);
            }
            this.myContext = context;
            this.myIndicator = indicator;
            this.myModality = modality;
            this.mySingleModeReported = "true".equals(this.myContext.getDataSource().getAdditionalProperties().get(SINGLE_DB_WARNING));
            this.myProcessor = context.isOutdatedCheck() ? new OutdatedProcessor() : new IntrospectionProcessor();
            this.mySelectedScope = DatabaseModelLoader.getSelectedScope(this.myContext);
        }

        public abstract void perform(@Nullable ObjectPath var1, boolean var2, @NotNull @NotNull ThrowableConsumer<@NotNull DatabaseConnection, Exception> var3) throws SQLException;

        public void run() throws SQLException {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                throw new AssertionError((Object)"Introspection should not be run in EDT");
            }
            if (!this.myContext.loadNothing()) {
                this.myContext.getDataSource().performBatch(() -> {
                    try {
                        this.introspect();
                    }
                    catch (ProcessCanceledException pce) {
                        LOG.debug("Introspection was canceled");
                    }
                    catch (SQLException e) {
                        LOG.debug(e.getMessage(), (Throwable)e);
                        ExceptionUtil.rethrow((Throwable)e);
                    }
                });
            }
        }

        protected void setScope(TreePattern introspectionScope) {
            this.myContext.getDataSource().setIntrospectionScope(introspectionScope);
            DBIntrospectionOptions options = this.myIntrospector.getOptions();
            this.myIntrospector.setOptions(options.copy(options.getSources(), introspectionScope, options.getSkipModelContentValidation()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void introspect() throws SQLException, ProcessCanceledException {
            this.myIndicator.checkCanceled();
            try {
                MultiMap tasks = MultiMap.createLinkedSet();
                LocalDataSource dataSource2 = this.myContext.getDataSource();
                boolean noReconnect = JdbcUrlParserUtil.isDatabaseBounded(dataSource2) && !JdbcUrlParserUtil.isReboundable(dataSource2);
                ObjectPath initial = this.getInitialConnectionPath();
                this.perform(initial, false, (ThrowableConsumer<DatabaseConnection, Exception>)((ThrowableConsumer)connection2 -> this.withFacade((DatabaseConnection)connection2, (ThrowableConsumer<DatabaseConnection, Exception>)((ThrowableConsumer)facade -> {
                    try {
                        this.prepareIntrospection((DatabaseConnection)facade);
                        this.checkSingleDbModeNecessity(initial, connection2.getConnectionPoint(), this.myIntrospector.getCurrentDatabase());
                        this.myFirstTime = this.myIntrospector.getModel().getModelRoots().isEmpty();
                        this.myProcessor.processFirstDatabase();
                        this.distributeDatabaseTasks(this.myIntrospector.getCurrentDatabase(), (MultiMap<ObjectPath, BasicDatabase>)tasks);
                        if (tasks.isEmpty()) {
                            this.myProcessor.processDatabases(Collections.emptyList());
                        } else {
                            Collection databases = tasks.remove(null);
                            if (!ContainerUtil.isEmpty((Collection)databases)) {
                                this.myProcessor.processDatabases(databases);
                            }
                        }
                    }
                    finally {
                        if (this.myIntrospector != null) {
                            this.myIntrospector.detachFromDB();
                        }
                    }
                }))));
                for (Map.Entry task : tasks.entrySet()) {
                    if (task.getKey() == null || ((Collection)task.getValue()).isEmpty()) continue;
                    if (noReconnect) {
                        this.reportSingleDbModeInconsistent(tasks.keySet());
                        break;
                    }
                    try {
                        this.reconnectAndIntrospectDatabases((ObjectPath)task.getKey(), (Collection)task.getValue());
                    }
                    catch (ProcessCanceledException ignored) {
                        this.myIndicator.checkCanceled();
                    }
                }
                String extra = this.myContext.isSchemaListOnly() ? DatabaseBundle.message((String)"progress.text.schemas.only", (Object[])new Object[0]) : "";
                this.myIndicator.setText(DatabaseBundle.message((String)"progress.text.finishing.introspection", (Object[])new Object[]{this.myContext.getDbms().getName(), extra}));
            }
            finally {
                if (this.mySrcSession != null) {
                    this.mySrcSession.close();
                }
            }
        }

        private void checkSingleDbModeNecessity(ObjectPath initialPath, DatabaseConnectionPoint point, String currentDb) {
            String db;
            if (this.mySingleModeReported || currentDb == null) {
                return;
            }
            if (!JdbcUrlParserUtil.isDatabaseBounded(point) || !JdbcUrlParserUtil.isReboundable(point)) {
                return;
            }
            String string = db = initialPath == null ? JdbcUrlParserUtil.getBoundParameter(point) : initialPath.name;
            if (db == null || db.equalsIgnoreCase(currentDb)) {
                return;
            }
            DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(this.myContext.getDataSource().getName(), DatabaseBundle.message((String)"notification.content.connection.to.expected.but.connected.to", (Object[])new Object[]{db, currentDb}), NotificationType.WARNING, (notification, event) -> {
                if (event.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                if (event.getDescription().equals("ignore")) {
                    this.myContext.getDataSource().getAdditionalProperties().put(SINGLE_DB_WARNING, "true");
                } else if (event.getDescription().equals("enable")) {
                    this.setSingleDbMode(true);
                }
            }).notify(this.myContext.getProject());
            this.mySingleModeReported = true;
        }

        private void reportSingleDbModeInconsistent(Set<ObjectPath> set) {
            String ignored = StringUtil.join((Iterable)JBIterable.from(set).filter(Conditions.notNull()), ObjectPath::getDisplayName, (String)", ");
            DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(DatabaseBundle.message((String)"notification.title.in.single.database.mode", (Object[])new Object[]{this.myContext.getDataSource().getName()}), DatabaseBundle.message((String)"notification.content.databases.ignored", (Object[])new Object[]{ignored}), NotificationType.WARNING, (notification, event) -> {
                if (event.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                if (event.getDescription().equals("hide")) {
                    this.hideNamespaces(set);
                } else if (event.getDescription().equals("disable")) {
                    this.setSingleDbMode(false);
                }
            }).notify(this.myContext.getProject());
        }

        private void setSingleDbMode(boolean enable) {
            this.myContext.getDataSource().setRewriteBounds(!enable);
            DataSourceUiUtil.performAutoSyncTask(this.myContext);
        }

        private void hideNamespaces(Set<ObjectPath> set) {
            NamingFamily dbs;
            BasicModel model = (BasicModel)ObjectUtils.tryCast((Object)this.myContext.getDataSource().getModel(), BasicModel.class);
            NamingFamily namingFamily = dbs = model == null ? null : (NamingFamily)ObjectUtils.tryCast((Object)model.getRoot().familyOf(ObjectKind.DATABASE), NamingFamily.class);
            if (dbs == null) {
                return;
            }
            JBIterable namespaces = JBIterable.from(set).filterMap(o -> o == null ? null : (BasicNamespace)dbs.get(o.name));
            DataSourceUiUtil.setNamespacesVisible(this.myContext.getProject(), this.myContext.getDataSource(), (Iterable<? extends BasicNamespace>)namespaces, false);
        }

        @Nullable
        private ObjectPath getInitialConnectionPath() {
            Family databases;
            LocalDataSource dataSource2 = this.myContext.getDataSource();
            if (!JdbcUrlParserUtil.isDatabaseBounded(dataSource2) || !JdbcUrlParserUtil.isReboundable(dataSource2)) {
                return null;
            }
            BasicModel model = (BasicModel)ObjectUtils.tryCast((Object)this.myContext.getDataSource().getModel(), BasicModel.class);
            Family family = databases = model == null ? null : (NamingFamily)ObjectUtils.tryCast((Object)model.getRoot().familyOf(ObjectKind.DATABASE), NamingFamily.class);
            if (databases == null || databases.isEmpty()) {
                return null;
            }
            TreePattern scope = dataSource2.getIntrospectionScope();
            TreePattern intersection = TreePatternUtils.intersect(scope, this.mySelectedScope);
            if (!JdbcUrlParserUtil.outOfBounds((DatabaseConnectionPoint)this.myContext.getDataSource(), intersection)) {
                return null;
            }
            String any = IntrospectionSession.getAnyFromIntersection(intersection, databases, this.myContext.getScopeUpdater());
            return any == null ? null : ObjectPath.create((String)any, (ObjectKind)ObjectKind.DATABASE);
        }

        @Nullable
        private static String getAnyFromIntersection(@NotNull TreePattern intersection, @NotNull NamingFamily<?> databases, @NotNull IntrospectionScopeUpdater updater) {
            if (intersection == null) {
                IntrospectionSession.$$$reportNull$$$0(3);
            }
            if (databases == null) {
                IntrospectionSession.$$$reportNull$$$0(4);
            }
            if (updater == null) {
                IntrospectionSession.$$$reportNull$$$0(5);
            }
            Condition existingDb = x -> {
                if ("*".equals(x)) {
                    return false;
                }
                BasicMateNamespace db = (BasicMateNamespace)databases.get((String)x);
                return db != null && !updater.isRemoved(db);
            };
            TreePatternNode.Group group = intersection.root.getGroup(ObjectKind.DATABASE);
            if (group == null || group.positiveChildren == null) {
                return null;
            }
            return (String)JBIterable.of((Object[])group.positiveChildren).flatten(g -> JBIterable.of((Object[])((TreePatternNode.PositiveNaming)g.naming).names)).transform(ObjectName::name).filter(existingDb).first();
        }

        private void reconnectAndIntrospectDatabases(@NotNull ObjectPath destination, @NotNull Collection<BasicDatabase> databases) throws SQLException {
            if (destination == null) {
                IntrospectionSession.$$$reportNull$$$0(6);
            }
            if (databases == null) {
                IntrospectionSession.$$$reportNull$$$0(7);
            }
            this.perform(destination, true, (ThrowableConsumer<DatabaseConnection, Exception>)((ThrowableConsumer)connection2 -> this.withFacade((DatabaseConnection)connection2, (ThrowableConsumer<DatabaseConnection, Exception>)((ThrowableConsumer)facade -> {
                this.myIndicator.setText(DatabaseBundle.message((String)"progress.text.performing.introspection", (Object[])new Object[]{this.myFirstTime ? 0 : 1, facade.getDbms().getDisplayName(), destination.kind.getPresentableName(), destination.getName()}));
                try {
                    this.myIntrospector.attachToDB((DatabaseConnection)facade);
                    this.checkSingleDbModeNecessity(destination, connection2.getConnectionPoint(), this.myIntrospector.getCurrentDatabase());
                    this.myProcessor.processDatabases(databases);
                }
                finally {
                    this.myIntrospector.detachFromDB();
                }
            }))));
        }

        private void distributeDatabaseTasks(@Nullable String currentDb, @NotNull MultiMap<ObjectPath, BasicDatabase> tasks) {
            DatabaseDriver driver;
            if (tasks == null) {
                IntrospectionSession.$$$reportNull$$$0(8);
            }
            DatabaseDriver.Bounds bounds = (driver = this.myContext.getDataSource().getDatabaseDriver()) == null ? null : driver.getConnectionBounds();
            Set<BasicDatabase> databases = this.getDatabasesForIntrospection();
            if (bounds == null || bounds.boundTo != ObjectKind.DATABASE) {
                tasks.put(null, databases);
                return;
            }
            for (BasicDatabase database : databases) {
                if (database.getName().equals(currentDb)) {
                    tasks.putValue(null, (Object)database);
                    continue;
                }
                tasks.putValue((Object)ObjectPaths.of(database), (Object)database);
            }
        }

        private Set<BasicDatabase> getDatabasesForIntrospection() {
            Set<BasicDatabase> dbs = DatabaseModelLoader.getDatabases(this.myContext, this.mySelectedScope);
            return dbs.isEmpty() ? DatabaseModelLoader.getDatabasesFromScope(this.myContext) : dbs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void introspectDatabaseList() {
            TreePattern firstScope;
            TreePattern introspectionScope = firstScope = this.myContext.getDataSource().getIntrospectionScope();
            BasicModModel model = this.myIntrospector.getModel();
            try {
                this.myIntrospector.introspectNamespaces();
                this.updateCurrentDb(model);
                introspectionScope = this.myContext.getScopeUpdater().updateVisibleNamespaces(introspectionScope, model);
                boolean bl = this.myUpdateScopeFromIntrospector = this.myFirstTime && introspectionScope.isEmpty();
            }
            catch (Throwable throwable) {
                boolean bl = this.myUpdateScopeFromIntrospector = this.myFirstTime && introspectionScope.isEmpty();
                if (this.myUpdateScopeFromIntrospector) {
                    introspectionScope = this.myIntrospector.getDefaultScope();
                    this.setScope(introspectionScope);
                } else if (!introspectionScope.equals(firstScope)) {
                    this.setScope(introspectionScope);
                }
                throw throwable;
            }
            if (this.myUpdateScopeFromIntrospector) {
                introspectionScope = this.myIntrospector.getDefaultScope();
                this.setScope(introspectionScope);
            } else if (!introspectionScope.equals(firstScope)) {
                this.setScope(introspectionScope);
            }
        }

        private void updateCurrentDb(BasicModModel model) {
            Couple<String> fakeCurrent = this.getFakeCurrentSchema();
            if (fakeCurrent == null) {
                this.updateBoundedDb(model);
                return;
            }
            NamingFamily namespaces = model.getRoot().getNamespaces();
            if (namespaces.isEmpty()) {
                return;
            }
            if (!namespaces.jbi().filter(BasicNamespace::isCurrent).isEmpty()) {
                return;
            }
            if (model.getRoot().familyOf(ObjectKind.DATABASE) != null) {
                if (fakeCurrent.first != null) {
                    model.modify(BasicModRoot.class, r -> IntrospectionSession.setCurrent(r, (String)fakeCurrent.first, ObjectKind.DATABASE));
                }
            } else if (fakeCurrent.second != null) {
                model.modify(BasicModRoot.class, r -> IntrospectionSession.setCurrent(r, (String)fakeCurrent.second, ObjectKind.SCHEMA));
            }
        }

        private void updateBoundedDb(BasicModModel model) {
            if (!JdbcUrlParserUtil.isDatabaseBounded(this.myContext.getDataSource()) || !JdbcUrlParserUtil.isReboundable(this.myContext.getDataSource())) {
                return;
            }
            String db = JdbcUrlParserUtil.getBoundParameter(this.myContext.getDataSource());
            if (db == null) {
                return;
            }
            model.modify(BasicModRoot.class, r -> IntrospectionSession.setCurrent(r, db, ObjectKind.DATABASE));
        }

        private void setFakeCurrentSc(BasicModModel model) {
            Couple<String> fakeCurrent = this.getFakeCurrentSchema();
            if (fakeCurrent == null || fakeCurrent.second == null) {
                return;
            }
            BasicDatabase database = model.getRoot().getCurrentDatabase();
            if (database == null) {
                return;
            }
            model.modify(BasicModRoot.class, r -> IntrospectionSession.setCurrent(r.mod(database), (String)fakeCurrent.second, ObjectKind.SCHEMA));
        }

        private static void setCurrent(BasicModElement parent2, String name, ObjectKind kind) {
            ModNamingFamily dbs = (ModNamingFamily)ObjectUtils.tryCast((Object)parent2.familyOf(kind), ModNamingFamily.class);
            if (dbs == null) {
                return;
            }
            for (BasicModNamedElement db : dbs) {
                BasicModMateNamespace nsp = (BasicModMateNamespace)ObjectUtils.tryCast((Object)db, BasicModMateNamespace.class);
                if (nsp == null) continue;
                nsp.setCurrent(nsp.getName().equals(name));
            }
        }

        @Nullable
        private Couple<String> getFakeCurrentSchema() {
            return "GenericIntrospector".equals(this.myIntrospector.getClass().getSimpleName()) ? this.myContext.getDataSource().getFakeCurrentSchema() : null;
        }

        private void prepareIntrospection(@NotNull DatabaseConnection facade) {
            LocalDataSource dataSource2;
            if (facade == null) {
                IntrospectionSession.$$$reportNull$$$0(9);
            }
            ModelFactory modelFactory = DbSrcModelStorage.createFactory((dataSource2 = this.myContext.getDataSource()).isGlobal() ? null : this.myContext.getProject(), dataSource2.getUniqueId());
            DBIntrospectionOptions options = DatabaseModelLoader.getIntrospectionOptions(dataSource2);
            if (this.myContext.isOutdatedCheck()) {
                options = options.copy(options.getSources(), options.getScope(), true);
            }
            this.initIntrospector(facade, dataSource2, modelFactory, options);
        }

        private void initIntrospector(DatabaseConnection facade, LocalDataSource dataSource2, ModelFactory modelFactory, DBIntrospectionOptions options) {
            DbSrcModelStorage storage;
            if (this.myIntrospector != null || this.mySrcSession != null) {
                throw new AssertionError((Object)"Already have introspector");
            }
            this.myIntrospector = DBIntrospectorFactory.createIntrospector(this.myContext.getProject(), modelFactory, facade, dataSource2);
            this.myIntrospector.setOptions(options);
            this.myIntrospector.setErrorSink((PairConsumer<String, Throwable>)((PairConsumer)this.myContext.getErrorHandler()::addError));
            BasicModModel dataSourceModel = (BasicModModel)ObjectUtils.tryCast((Object)dataSource2.getModel(), BasicModModel.class);
            BasicModModel model = this.myIntrospector.init(dataSourceModel);
            this.myIntrospector.attachToDB(facade);
            this.myIntrospector.setProgressIndicator(this.myIndicator);
            if (model != dataSourceModel) {
                this.myProcessor.before(dataSource2, model);
            }
            if ((storage = (DbSrcModelStorage)ObjectUtils.tryCast((Object)model.getTextStorage(), DbSrcModelStorage.class)) != null) {
                this.mySrcSession = storage.startWriteSession(this.myContext.getProject(), model, this.myModality, false);
            }
        }

        private void withFacade(@NotNull DatabaseConnection connection2, @NotNull @NotNull ThrowableConsumer<@NotNull DatabaseConnection, Exception> consumer2) {
            if (connection2 == null) {
                IntrospectionSession.$$$reportNull$$$0(10);
            }
            if (consumer2 == null) {
                IntrospectionSession.$$$reportNull$$$0(11);
            }
            try {
                consumer2.consume((Object)connection2);
            }
            catch (Throwable e) {
                AsyncUtil.addUnhandledError(this.myContext.getErrorHandler(), e, this.myContext.getDataSource());
                throw new ProcessCanceledException();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modality";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "intersection";
                    break;
                }
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "databases";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "destination";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tasks";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "facade";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/DatabaseModelLoader$IntrospectionSession";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getAnyFromIntersection";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reconnectAndIntrospectDatabases";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "distributeDatabaseTasks";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "prepareIntrospection";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "withFacade";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class OutdatedProcessor
        implements DatabaseProcessor {
            private OutdatedProcessor() {
            }

            @Override
            public void before(@NotNull LocalDataSource dataSource2, @NotNull BasicModModel model) {
                if (dataSource2 == null) {
                    OutdatedProcessor.$$$reportNull$$$0(0);
                }
                if (model == null) {
                    OutdatedProcessor.$$$reportNull$$$0(1);
                }
            }

            @Override
            public void processFirstDatabase() {
                IntrospectionSession.this.myIndicator.setText(DatabaseBundle.message((String)"progress.text.preparing.to.validity.check.introspection", (Object[])new Object[]{IntrospectionSession.this.myContext.getDbms().getDisplayName()}));
            }

            private JBIterable<BasicElement> extract() {
                return JBIterable.from(IntrospectionSession.this.myContext.getSelection()).filterMap(o -> DbImplUtilCore.getMaybeBasicElement((DasObject)ObjectUtils.tryCast((Object)o, DasObject.class)));
            }

            @Override
            public void processDatabases(@NotNull Collection<BasicDatabase> dbs) {
                if (dbs == null) {
                    OutdatedProcessor.$$$reportNull$$$0(2);
                }
                JBIterable elements = this.extract();
                if (!dbs.isEmpty()) {
                    elements = elements.filter(e -> dbs.contains(e.getDatabase()));
                }
                IntrospectionSession.this.myIntrospector.retrieveInvalid((Iterable<? extends BasicElement>)elements);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataSource";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "model";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dbs";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/dataSource/DatabaseModelLoader$IntrospectionSession$OutdatedProcessor";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "before";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processDatabases";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private class IntrospectionProcessor
        implements DatabaseProcessor {
            private IntrospectionProcessor() {
            }

            @Override
            public void before(@NotNull LocalDataSource dataSource2, @NotNull BasicModModel model) {
                BasicModel dsModel;
                if (dataSource2 == null) {
                    IntrospectionProcessor.$$$reportNull$$$0(0);
                }
                if (model == null) {
                    IntrospectionProcessor.$$$reportNull$$$0(1);
                }
                if (model == (dsModel = (BasicModel)ObjectUtils.tryCast((Object)dataSource2.getModel(), BasicModModel.class))) {
                    return;
                }
                if (dsModel != null) {
                    IntrospectionSession.this.myIndicator.setText(DatabaseBundle.message((String)"progress.text.clearing.cached.schemas", (Object[])new Object[0]));
                    dataSource2.clearModel();
                }
                dataSource2.setModel(model);
            }

            @Override
            public void processFirstDatabase() {
                IntrospectionSession.this.myIntrospector.introspectSessionState();
                IntrospectionSession.this.myIndicator.setText(DatabaseBundle.message((String)"progress.text.preparing.to.introspection", (Object[])new Object[]{IntrospectionSession.this.myFirstTime ? 0 : 1, IntrospectionSession.this.myContext.getDbms().getDisplayName()}));
                IntrospectionSession.this.introspectDatabaseList();
                if (!IntrospectionSession.this.myContext.isSchemaListOnly()) {
                    IntrospectionSession.this.myIndicator.setText(DatabaseBundle.message((String)"progress.text.introspecting.server.objects", (Object[])new Object[0]));
                    IntrospectionSession.this.myIntrospector.introspectServerObjects();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void processDatabases(@NotNull Collection<BasicDatabase> dbs) {
                TreePattern firstScope;
                if (dbs == null) {
                    IntrospectionProcessor.$$$reportNull$$$0(2);
                }
                TreePattern introspectionScope = firstScope = IntrospectionSession.this.myContext.getDataSource().getIntrospectionScope();
                BasicModModel model = IntrospectionSession.this.myIntrospector.getModel();
                BasicDatabase[] databases = (BasicDatabase[])ContainerUtil.toArray(dbs, BasicDatabase[]::new);
                try {
                    if (model.getRoot().familyOf(ObjectKind.DATABASE) != null) {
                        IntrospectionSession.this.myIntrospector.introspectDatabaseSchemas(databases);
                        IntrospectionSession.this.setFakeCurrentSc(model);
                        introspectionScope = IntrospectionSession.this.myContext.getScopeUpdater().updateVisibleNamespaces(introspectionScope, model);
                    }
                }
                finally {
                    if (IntrospectionSession.this.myUpdateScopeFromIntrospector) {
                        introspectionScope = IntrospectionSession.this.myIntrospector.getDefaultScope();
                        IntrospectionSession.this.setScope(introspectionScope);
                    } else if (!introspectionScope.equals(firstScope)) {
                        IntrospectionSession.this.setScope(introspectionScope);
                    }
                }
                if (IntrospectionSession.this.myContext.isSchemaListOnly()) {
                    return;
                }
                Object[] namespaces = DatabaseModelLoader.getNamespacesToIntrospect(IntrospectionSession.this.myContext, model, IntrospectionSession.this.mySelectedScope);
                if (!dbs.isEmpty()) {
                    Collection<Object> current = JBIterable.of((Object[])namespaces).filter(n -> dbs.contains(n) || dbs.contains(n.getParent())).toList();
                    if (current.isEmpty()) {
                        current = dbs;
                    }
                    namespaces = current.toArray(new BasicNamespace[0]);
                }
                IntrospectionSession.this.myIntrospector.introspectAuto((BasicNamespace[])namespaces);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataSource";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "model";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dbs";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/dataSource/DatabaseModelLoader$IntrospectionSession$IntrospectionProcessor";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "before";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processDatabases";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static interface DatabaseProcessor {
            public void before(@NotNull LocalDataSource var1, @NotNull BasicModModel var2);

            public void processFirstDatabase();

            public void processDatabases(@NotNull Collection<BasicDatabase> var1);
        }
    }
}

