/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.openapi.project.Project;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public interface DatabaseConnectionPoint
extends RawConnectionConfig {
    @NotNull
    public Properties getConnectionProperties();

    public boolean isReadOnly();

    @NotNull
    public LocalDataSource getDataSource();

    @NotNull
    public Map<String, String> getAdditionalProperties();

    @Deprecated
    @NotNull
    default public Map<String, String> getAdditionalJdbcProperties() {
        Map<String, String> map2 = this.getAdditionalProperties();
        if (map2 == null) {
            DatabaseConnectionPoint.$$$reportNull$$$0(0);
        }
        return map2;
    }

    public DatabaseDriver getDatabaseDriver();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseConnectionPoint", "getAdditionalJdbcProperties"));
    }

    public static class Adapter
    implements DatabaseConnectionPoint {
        private final DatabaseConnectionPoint myDelegate;

        public Adapter(DatabaseConnectionPoint delegate) {
            this.myDelegate = delegate;
        }

        @Override
        @NotNull
        public Properties getConnectionProperties() {
            Properties properties = this.myDelegate.getConnectionProperties();
            if (properties == null) {
                Adapter.$$$reportNull$$$0(0);
            }
            return properties;
        }

        @Override
        public boolean isReadOnly() {
            return this.myDelegate.isReadOnly();
        }

        @Override
        @NotNull
        public LocalDataSource getDataSource() {
            LocalDataSource localDataSource = this.myDelegate.getDataSource();
            if (localDataSource == null) {
                Adapter.$$$reportNull$$$0(1);
            }
            return localDataSource;
        }

        @Override
        @NotNull
        public Map<String, String> getAdditionalProperties() {
            Map<String, String> map2 = this.myDelegate.getAdditionalProperties();
            if (map2 == null) {
                Adapter.$$$reportNull$$$0(2);
            }
            return map2;
        }

        @Override
        public DatabaseDriver getDatabaseDriver() {
            return this.myDelegate.getDatabaseDriver();
        }

        public String getName() {
            return this.myDelegate.getName();
        }

        public String getDriverClass() {
            return this.myDelegate.getDriverClass();
        }

        public String getUrl() {
            return this.myDelegate.getUrl();
        }

        public String getEffectiveUrl(@NotNull Project project) {
            if (project == null) {
                Adapter.$$$reportNull$$$0(3);
            }
            return this.myDelegate.getEffectiveUrl(project);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DatabaseConnectionPoint$Adapter";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConnectionProperties";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataSource";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAdditionalProperties";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DatabaseConnectionPoint$Adapter";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getEffectiveUrl";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

