/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.DatabaseArtifactList;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DatabaseDriverManagerImpl;
import com.intellij.database.util.Version;
import com.intellij.facet.frameworks.LibrariesDownloadConnectionService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import com.intellij.util.ui.classpath.SimpleClasspathElementFactory;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class DatabaseArtifactManager {
    private static final Logger LOG = Logger.getInstance(DatabaseArtifactManager.class);
    private static final String ARTIFACTS_XML = "jdbc-drivers.xml";
    public static final Topic<ArtifactListener> TOPIC = new Topic("ARTIFACTS_TOPIC", ArtifactListener.class);
    private static final DatabaseArtifactManager INSTANCE = new DatabaseArtifactManager();
    private static final int UPDATE_LIST_TIMEOUT_MS = 86400000;
    private volatile DatabaseArtifactList myArtifactList = DatabaseArtifactList.EMPTY;
    private boolean myLoaded = true;
    private Long myLastUpdate = null;
    private final Object myFileLock = new Object();
    private final Object myLock = new Object();

    public static DatabaseArtifactManager getInstance() {
        return INSTANCE;
    }

    public static DatabaseArtifactList getArtifacts() {
        return DatabaseArtifactManager.getInstance().getArtifactList();
    }

    @TestOnly
    public static void setArtifactsList(@Nullable DatabaseArtifactList list) {
        DatabaseArtifactManager instance = DatabaseArtifactManager.getInstance();
        if (list != null) {
            instance.myArtifactList = list;
        } else {
            instance.loadArtifacts(false);
        }
    }

    private DatabaseArtifactManager() {
        Application app = ApplicationManager.getApplication();
        if (app.isUnitTestMode()) {
            this.loadArtifacts(false);
            return;
        }
        File file = DatabaseArtifactManager.getLocalArtifactListPath();
        app.executeOnPooledThread(() -> this.loadArtifacts(file.exists()));
    }

    private void loadArtifacts(boolean localOnly) {
        if (!localOnly) {
            this.loadArtifactsList();
        }
        this.loadLocalArtifactsList();
    }

    @NotNull
    public DatabaseArtifactList getArtifactList() {
        this.checkForUpdates();
        DatabaseArtifactList databaseArtifactList = this.myArtifactList;
        if (databaseArtifactList == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(0);
        }
        return databaseArtifactList;
    }

    public void forceUpdate(Project project) {
        this.updateLists(project, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForUpdates() {
        boolean notLoaded;
        boolean outdated;
        Application app = ApplicationManager.getApplication();
        if (app == null || app.isUnitTestMode()) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            outdated = this.isOutdated();
            if (outdated) {
                this.setLastUpdate(System.currentTimeMillis());
            }
            notLoaded = !outdated && !this.myLoaded;
            this.myLoaded = true;
        }
        if (outdated) {
            this.updateLists(null, true);
        } else if (notLoaded) {
            this.initLocal();
            DatabaseArtifactManager.listLoaded();
        }
    }

    private void initLocal() {
        try {
            ApplicationManager.getApplication().executeOnPooledThread(() -> this.loadLocalArtifactsList()).get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
        }
    }

    private void updateLists(Project project, boolean background) {
        this.setLastUpdate(System.currentTimeMillis());
        new Task.ConditionalModal(project, DatabaseBundle.message((String)"progress.title.update.database.drivers.list", (Object[])new Object[0]), false, () -> background){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setText(DatabaseBundle.message((String)"progress.text.loading.database.drivers.list", (Object[])new Object[0]));
                DatabaseArtifactManager.this.loadRemoteArtifactList();
                DatabaseArtifactManager.this.initLocal();
                DatabaseArtifactManager.listLoaded();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/DatabaseArtifactManager$1", "run"));
            }
        }.queue();
    }

    private static void listLoaded() {
        ApplicationManager.getApplication().invokeLater(() -> DatabaseArtifactManager.fireChanged(null));
    }

    private boolean isOutdated() {
        if (this.myLastUpdate == null) {
            File path = DatabaseArtifactManager.getLocalArtifactListPath();
            if (path.exists()) {
                this.myLastUpdate = path.lastModified();
            } else {
                return true;
            }
        }
        return System.currentTimeMillis() - this.myLastUpdate > 86400000L;
    }

    private void loadRemoteArtifactList() {
        this.loadArtifactsList();
        this.loadLocalArtifactsList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLocalArtifactsList() {
        File listFile = DatabaseArtifactManager.getLocalArtifactListPath();
        DatabaseArtifactList list = new DatabaseArtifactList(false, new URL[0]);
        Exception wentWrong = null;
        boolean remoteLoadFailed = false;
        Object object = this.myFileLock;
        synchronized (object) {
            if (listFile.exists()) {
                try {
                    list.loadList(listFile.toURI().toURL(), false);
                }
                catch (Exception e) {
                    wentWrong = e;
                }
                remoteLoadFailed = list.getArtifacts().isEmpty();
            }
            for (URL builtin : DatabaseArtifactManager.getBuiltinArtifactLists()) {
                try {
                    list.loadList(builtin, false);
                }
                catch (Exception e) {
                    LOG.warn("Unable to load " + builtin.toString(), (Throwable)e);
                }
            }
        }
        if (remoteLoadFailed) {
            LOG.warn("Unable to load " + listFile.getName() + ". Will delete", (Throwable)wentWrong);
            FileUtil.delete((File)listFile);
            object = this.myLock;
            synchronized (object) {
                this.myLoaded = false;
                this.setLastUpdate(System.currentTimeMillis() - 86400000L + 300000L);
            }
        }
        this.myArtifactList = list;
        TransactionGuard.submitTransaction((Disposable)ApplicationManager.getApplication(), () -> DatabaseArtifactManager.fireChanged(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLastUpdate(Long lastUpdate) {
        Object object = this.myLock;
        synchronized (object) {
            this.myLastUpdate = lastUpdate;
        }
    }

    private void loadArtifactsList() {
        File file = DatabaseArtifactManager.getLocalArtifactListPath();
        boolean tests = ApplicationManager.getApplication().isUnitTestMode();
        if (!tests) {
            this.loadProvidedArtifactList(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProvidedArtifactList(File file) {
        String remoteUrl = DatabaseArtifactManager.createVersionsUrl();
        if (remoteUrl != null) {
            try {
                byte[] text2 = HttpRequests.request((String)remoteUrl).readBytes(ProgressIndicatorProvider.getGlobalProgressIndicator());
                Object object = this.myFileLock;
                synchronized (object) {
                    FileUtil.writeToFile((File)file, (byte[])text2);
                }
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }
    }

    public static List<URL> getBuiltinArtifactLists() {
        List<URL> extensionUrls = DatabaseDriverManagerImpl.ConfigUrlBean.getUrls(DatabaseArtifactList.CONFIG_EP.getExtensionsIfPointIsRegistered());
        File testArtifacts = DatabaseDriverManagerImpl.existentTestPath("test-database-artifacts.xml");
        if (testArtifacts != null) {
            try {
                return ContainerUtil.append(extensionUrls, (Object[])new URL[]{testArtifacts.toURI().toURL()});
            }
            catch (MalformedURLException e) {
                LOG.warn((Throwable)e);
                return extensionUrls;
            }
        }
        return extensionUrls;
    }

    @Nullable
    public static String createVersionsUrl() {
        String serviceUrl = LibrariesDownloadConnectionService.getInstance().getServiceUrl();
        return StringUtil.isNotEmpty((String)serviceUrl) ? serviceUrl + "/jdbc-drivers/jdbc-drivers.xml" : null;
    }

    @NotNull
    private static File getLocalArtifactListPath() {
        return new File(DatabaseDriverImpl.getDownloadPath(), ARTIFACTS_XML);
    }

    private static void fireChanged(@Nullable DatabaseArtifactList.ArtifactVersion version) {
        ((ArtifactListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC)).artifactChanged(version);
    }

    public void downloadArtifact(@NotNull DatabaseArtifactList.ArtifactVersion version, @Nullable Consumer<? super DatabaseArtifactList.ArtifactVersion> onFinish) throws IOException {
        if (version == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(1);
        }
        this.myArtifactList.downloadArtifact(version);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (onFinish != null) {
                onFinish.consume((Object)version);
            }
            DatabaseArtifactManager.fireChanged(version);
        });
    }

    @NotNull
    public static List<SimpleClasspathElement> getClasspathElements(@NotNull String id, @NotNull Version version) {
        if (id == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(2);
        }
        if (version == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(3);
        }
        if (Version.INFINITY.equals((Object)version)) {
            throw new AssertionError((Object)"Should be concrete version");
        }
        DatabaseArtifactList.ArtifactVersion resolved = DatabaseArtifactManager.getArtifacts().resolve(id, version);
        ArrayList<String> urls = new ArrayList<String>();
        if (resolved != null) {
            List<File> files = DatabaseArtifactList.getClasspathElements(resolved);
            for (File file2 : files) {
                urls.add(VfsUtilCore.pathToUrl((String)file2.getPath()));
            }
        } else {
            File dir = DatabaseArtifactList.getArtifactDir(id, version);
            FileUtil.visitFiles((File)dir, file -> {
                if (file.isFile()) {
                    urls.add(VfsUtilCore.pathToUrl((String)file.getPath()));
                }
                return true;
            });
        }
        List list = SimpleClasspathElementFactory.createElements((String[])ArrayUtil.toStringArray(urls));
        if (list == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DatabaseArtifactManager";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactList";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DatabaseArtifactManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasspathElements";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "downloadArtifact";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getClasspathElements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ArtifactListener
    extends EventListener {
        public void artifactChanged(@Nullable DatabaseArtifactList.ArtifactVersion var1);
    }
}

