/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.CommonBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DataSourceScopeEditor;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DataSourceSyncManager;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dialects.DatabaseErrorHandler;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.NameVersion;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.settings.DatabaseSettingsConfigurable;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.database.util.Version;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.database.view.ui.DataSourceManagerDialog;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.database.view.ui.DatabaseDriverConfigurable;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDEventImpl;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.SyncDateFormat;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.InputEvent;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class DataSourceUiUtil {
    private static final SyncDateFormat ourTimestampFormat = new SyncDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));

    private DataSourceUiUtil() {
    }

    @NotNull
    public static <T extends EventListener, U extends T> EventDispatcher<U> eventDispatcher(@NotNull Class<T> listenerClass) {
        if (listenerClass == null) {
            DataSourceUiUtil.$$$reportNull$$$0(0);
        }
        EventDispatcher eventDispatcher = EventDispatcher.create(listenerClass);
        if (eventDispatcher == null) {
            DataSourceUiUtil.$$$reportNull$$$0(1);
        }
        return eventDispatcher;
    }

    public static void applyFix(@NotNull Project project, @NotNull DatabaseErrorHandler.Fix fix, @Nullable DatabaseConfigEditor editor) {
        if (project == null) {
            DataSourceUiUtil.$$$reportNull$$$0(2);
        }
        if (fix == null) {
            DataSourceUiUtil.$$$reportNull$$$0(3);
        }
        if (!fix.isSilent() && editor == null) {
            DataSourceManagerDialog.showDialog(DbPsiFacade.getInstance((Project)project), null, null, (Consumer<? super DatabaseConfigEditor>)((Consumer)fix::apply));
        } else {
            fix.apply(editor);
        }
    }

    public static DatabaseErrorHandler.Fix settingsFix(final @Nls @NotNull String name, final @NotNull LocalDataSource ds, final @NotNull Consumer<? super DataSourceConfigurable> consumer2) {
        if (name == null) {
            DataSourceUiUtil.$$$reportNull$$$0(4);
        }
        if (ds == null) {
            DataSourceUiUtil.$$$reportNull$$$0(5);
        }
        if (consumer2 == null) {
            DataSourceUiUtil.$$$reportNull$$$0(6);
        }
        return new DatabaseErrorHandler.Fix(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public boolean isSilent() {
                return false;
            }

            @Override
            public void apply(@Nullable DatabaseConfigEditor editor) {
                if (editor == null) {
                    return;
                }
                DataSourceUiUtil.navigate(editor, ds, (Consumer<? super DataSourceConfigurable>)consumer2);
            }
        };
    }

    public static DatabaseErrorHandler.Fix settingsFix(@Nls @NotNull String name, @NotNull DatabaseDriver dr, @NotNull Consumer<? super DatabaseDriverConfigurable> consumer2) {
        if (name == null) {
            DataSourceUiUtil.$$$reportNull$$$0(7);
        }
        if (dr == null) {
            DataSourceUiUtil.$$$reportNull$$$0(8);
        }
        if (consumer2 == null) {
            DataSourceUiUtil.$$$reportNull$$$0(9);
        }
        return DataSourceUiUtil.settingsFix(name, dr, true, consumer2);
    }

    public static DatabaseErrorHandler.Fix settingsFix(final @Nls @NotNull String name, final @NotNull DatabaseDriver dr, final boolean navigate, final @NotNull Consumer<? super DatabaseDriverConfigurable> consumer2) {
        if (name == null) {
            DataSourceUiUtil.$$$reportNull$$$0(10);
        }
        if (dr == null) {
            DataSourceUiUtil.$$$reportNull$$$0(11);
        }
        if (consumer2 == null) {
            DataSourceUiUtil.$$$reportNull$$$0(12);
        }
        return new DatabaseErrorHandler.Fix(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public boolean isSilent() {
                return false;
            }

            @Override
            public void apply(@Nullable DatabaseConfigEditor editor) {
                if (editor == null) {
                    return;
                }
                if (navigate) {
                    DataSourceUiUtil.navigate(editor, dr, (Consumer<? super DatabaseDriverConfigurable>)consumer2);
                } else {
                    DatabaseDriverConfigurable configurable = editor.getConfigurable(dr, true, DatabaseDriverConfigurable.class);
                    if (configurable != null) {
                        consumer2.consume((Object)configurable);
                    }
                }
            }
        };
    }

    public static ActionCallback navigate(@NotNull DatabaseConfigEditor editor, @NotNull LocalDataSource dataSource2, @NotNull Consumer<? super DataSourceConfigurable> modifier) {
        if (editor == null) {
            DataSourceUiUtil.$$$reportNull$$$0(13);
        }
        if (dataSource2 == null) {
            DataSourceUiUtil.$$$reportNull$$$0(14);
        }
        if (modifier == null) {
            DataSourceUiUtil.$$$reportNull$$$0(15);
        }
        return editor.navigateTo(dataSource2, false).doWhenDone(() -> {
            DataSourceConfigurable configurable = editor.getConfigurable(dataSource2, false, DataSourceConfigurable.class);
            if (configurable == null) {
                return;
            }
            modifier.consume((Object)configurable);
        });
    }

    public static ActionCallback modify(@NotNull DatabaseConfigEditor editor, @NotNull LocalDataSource dataSource2, @NotNull Consumer<? super LocalDataSource> modifier) {
        if (editor == null) {
            DataSourceUiUtil.$$$reportNull$$$0(16);
        }
        if (dataSource2 == null) {
            DataSourceUiUtil.$$$reportNull$$$0(17);
        }
        if (modifier == null) {
            DataSourceUiUtil.$$$reportNull$$$0(18);
        }
        return DataSourceUiUtil.navigate(editor, dataSource2, (Consumer<? super DataSourceConfigurable>)((Consumer)configurable -> DataSourceUiUtil.modify(configurable, modifier)));
    }

    public static void modify(DataSourceConfigurable configurable, @NotNull Consumer<? super LocalDataSource> modifier) {
        if (modifier == null) {
            DataSourceUiUtil.$$$reportNull$$$0(19);
        }
        LocalDataSource ds = configurable.getTempDataSource().copy(true);
        modifier.consume((Object)ds);
        configurable.reset(ds, false);
    }

    public static ActionCallback navigate(@NotNull DatabaseConfigEditor editor, @NotNull DatabaseDriver driver, @NotNull Consumer<? super DatabaseDriverConfigurable> modifier) {
        if (editor == null) {
            DataSourceUiUtil.$$$reportNull$$$0(20);
        }
        if (driver == null) {
            DataSourceUiUtil.$$$reportNull$$$0(21);
        }
        if (modifier == null) {
            DataSourceUiUtil.$$$reportNull$$$0(22);
        }
        return editor.navigateTo(driver, false).doWhenDone(() -> {
            DatabaseDriverConfigurable configurable = editor.getConfigurable(driver, false, DatabaseDriverConfigurable.class);
            if (configurable == null) {
                return;
            }
            modifier.consume((Object)configurable);
        });
    }

    public static void modify(@NotNull Consumer<? super DatabaseDriverImpl> modifier, DatabaseDriverConfigurable configurable) {
        if (modifier == null) {
            DataSourceUiUtil.$$$reportNull$$$0(23);
        }
        DatabaseDriverImpl dr = configurable.getTempDriver().copy(null, true);
        modifier.consume((Object)dr);
        configurable.reset(dr);
    }

    @NotNull
    public static AsyncTask<DataSourceSyncManager.SyncResult> performAutoSyncTask(@NotNull LoaderContext context) {
        if (context == null) {
            DataSourceUiUtil.$$$reportNull$$$0(24);
        }
        return DataSourceUiUtil.performAutoSyncTask(context, false);
    }

    @NotNull
    public static AsyncTask<DataSourceSyncManager.SyncResult> performAutoSyncTask(@NotNull LoaderContext context, boolean stopRunning) {
        LocalDataSource dataSource2;
        if (context == null) {
            DataSourceUiUtil.$$$reportNull$$$0(25);
        }
        if (!DbImplUtil.canConnectTo(dataSource2 = context.getDataSource()) || !dataSource2.isAutoSynchronize()) {
            AsyncTask<Object> asyncTask = AsyncTask.completed(null);
            if (asyncTask == null) {
                DataSourceUiUtil.$$$reportNull$$$0(26);
            }
            return asyncTask;
        }
        AsyncTask<DataSourceSyncManager.SyncResult> asyncTask = AsyncTask.frame(DatabaseBundle.message((String)"progress.title.automatic.synchronisation", (Object[])new Object[]{context.getDataSource().getName()})).computeAsync(AsyncUtil.getEdtExecutor(), () -> {
            AsyncTask.withBgIndicatorIfNeeded(AsyncTask.currentFrame(), context.getProject(), null);
            AsyncTask<DataSourceSyncManager.SyncResult> result = DataSourceSyncManager.getInstance().tryPerform(context, stopRunning, true);
            if (result == null) {
                return AsyncTask.completed(null);
            }
            result.whenComplete(null, (r, e) -> {
                if (!context.getErrorHandler().hasErrors() && AsyncUtil.isCancellation(e)) {
                    DataSourceUiUtil.showNotification(context.getProject(), dataSource2.getName(), DatabaseBundle.message((String)"notification.content.cancelled", (Object[])new Object[0]), false);
                } else if (context.getErrorHandler().hasErrors()) {
                    if (context.isOutdatedCheck()) {
                        DataSourceUiUtil.showOutdatedCheckErrorNotification(context, r == null ? 0L : r.elapsedTime);
                    } else {
                        DataSourceUiUtil.showNotification(context, r == null ? 0L : r.elapsedTime);
                    }
                }
            });
            return result;
        });
        if (asyncTask == null) {
            DataSourceUiUtil.$$$reportNull$$$0(27);
        }
        return asyncTask;
    }

    public static void performAutoSyncTask(@NotNull Project project, @NotNull LocalDataSource dataSource2) {
        if (project == null) {
            DataSourceUiUtil.$$$reportNull$$$0(28);
        }
        if (dataSource2 == null) {
            DataSourceUiUtil.$$$reportNull$$$0(29);
        }
        DataSourceUiUtil.performAutoSyncTask(LoaderContext.loadAll(project, dataSource2));
    }

    @NotNull
    public static LoaderContext getConnectionContext(@NotNull Project project, @NotNull LocalDataSource dataSource2, @Nullable ObjectPath path) {
        if (project == null) {
            DataSourceUiUtil.$$$reportNull$$$0(30);
        }
        if (dataSource2 == null) {
            DataSourceUiUtil.$$$reportNull$$$0(31);
        }
        LoaderContext context = new LoaderContext(project, dataSource2);
        if (JdbcUrlParserUtil.isDatabaseBounded(dataSource2)) {
            if ((path = JdbcUrlParserUtil.toBound(dataSource2, path)) == null) {
                context.include(ObjectPath.create((String)"@", (ObjectKind)ObjectKind.DATABASE));
            } else {
                context.include(path);
            }
        } else {
            context.includeAllSchemas();
        }
        LoaderContext loaderContext = context;
        if (loaderContext == null) {
            DataSourceUiUtil.$$$reportNull$$$0(32);
        }
        return loaderContext;
    }

    @NotNull
    public static AsyncTask<DataSourceSyncManager.SyncResult> performManualSyncTask(@NotNull LoaderContext context) {
        AsyncTask<DataSourceSyncManager.SyncResult> result;
        if (context == null) {
            DataSourceUiUtil.$$$reportNull$$$0(33);
        }
        if ((result = DataSourceSyncManager.getInstance().tryPerform(context, true, true)) == null) {
            AsyncTask<DataSourceSyncManager.SyncResult> asyncTask = AsyncTask.cancelled();
            if (asyncTask == null) {
                DataSourceUiUtil.$$$reportNull$$$0(34);
            }
            return asyncTask;
        }
        AsyncTask<DataSourceSyncManager.SyncResult> asyncTask = result.whenComplete(null, (r, e) -> {
            if (!context.getErrorHandler().hasErrors() && AsyncUtil.isCancellation(e)) {
                DataSourceUiUtil.showNotification(context.getProject(), context.getDataSource().getName(), DatabaseBundle.message((String)"notification.content.cancelled", (Object[])new Object[0]), false);
            } else {
                DataSourceUiUtil.showNotification(context, r == null ? 0L : r.elapsedTime);
            }
        });
        if (asyncTask == null) {
            DataSourceUiUtil.$$$reportNull$$$0(35);
        }
        return asyncTask;
    }

    @Nls
    @NotNull
    public static String formatDataSourceInfoString(LocalDataSource o) {
        Casing modes = o.getCaseModes();
        NameVersion databaseVersion = o.getDatabaseVersion();
        Dbms effectiveDbms = o.getDbms();
        Dbms actualDbms = Dbms.fromString((String)databaseVersion.name);
        Version effectiveVersion = o.getVersion();
        Version actualVersion = Version.parse((String)databaseVersion.version);
        boolean matches = effectiveDbms == actualDbms && (actualVersion != null && actualVersion.eqCoarse(effectiveVersion) || actualVersion == null && databaseVersion.version.contains(effectiveVersion.toString()));
        NameVersion driverVersion = o.getDriverVersion();
        String s1 = DatabaseBundle.message((String)"dataSource.quickInfo.dbmsPhrase", (Object[])new Object[]{databaseVersion.name, databaseVersion.version});
        String s2 = DatabaseBundle.message((String)"dataSource.quickInfo.caseSensitivity2Phrase", (Object[])new Object[]{Case.LOWER.apply(modes.plain.name()), Case.LOWER.apply(modes.quoted.name())});
        String s3 = DatabaseBundle.message((String)"dataSource.quickInfo.driverPhrase", (Object[])new Object[]{driverVersion.name, driverVersion.version, o.getJDBCVersion()});
        String s4 = s1 + "\n" + s2 + "\n" + s3;
        if (!matches) {
            String s42 = DatabaseBundle.message((String)"dataSource.quickInfo.effectiveVersion", (Object[])new Object[]{effectiveDbms.getDisplayName(), effectiveVersion});
            s4 = s4 + "\n" + s42;
        }
        String string = s4;
        if (string == null) {
            DataSourceUiUtil.$$$reportNull$$$0(36);
        }
        return string;
    }

    public static void showNotification(@Nullable Project project, @NlsContexts.NotificationTitle String title, @NlsContexts.NotificationContent String message2, boolean error2) {
        Pair<@NlsContexts.NotificationContent String, HyperlinkListener> pair = DataSourceUiUtil.truncatePopupMessageIfNeeded(message2, error2 ? DatabaseBundle.message((String)"message.title.connection.error", (Object[])new Object[0]) : title, error2 ? Messages.getErrorIcon() : Messages.getInformationIcon());
        NotificationGroup group = error2 ? DatabaseNotifications.DATABASE_VIEW_GROUP : DatabaseNotifications.DATABASE_VIEW_LOG_GROUP;
        group.createNotification(title, (String)pair.first, error2 ? NotificationType.WARNING : NotificationType.INFORMATION, (notification, event) -> ((HyperlinkListener)pair.second).hyperlinkUpdate(event)).notify(project);
    }

    public static Pair<@NlsContexts.NotificationContent String, @Nullable HyperlinkListener> truncatePopupMessageIfNeeded(@NlsContexts.NotificationContent String text2, @NlsContexts.DialogTitle String dialogTitle, Icon icon) {
        boolean truncate;
        boolean bl = truncate = text2.length() > 120;
        if (!truncate) {
            return Pair.create((Object)text2, null);
        }
        String balloonMessage = text2.substring(0, 120) + " ... " + HtmlChunk.link((String)"more", (String)DatabaseBundle.message((String)"message.hyperlink.click.for.more", (Object[])new Object[0]));
        @NlsSafe String message2 = text2.replace("\t", "  ");
        return Pair.create((Object)balloonMessage, e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && "more".equals(e.getDescription())) {
                Messages.showIdeaMessageDialog(null, (String)message2, (String)dialogTitle, (String[])new String[]{CommonBundle.getOkButtonText()}, (int)0, (Icon)icon, null);
            }
        });
    }

    public static void showErrorBalloon(Throwable error2, Component component, Point point, boolean showArrow, boolean showConfig) {
        if (!component.isVisible() || !component.isShowing()) {
            return;
        }
        String errorText = StringUtil.notNullize((String)error2.getMessage(), (String)error2.getClass().getSimpleName());
        errorText = DataSourceUiUtil.wrap(errorText, 50, "\n", true);
        errorText = StringUtil.trimLog((String)errorText, (int)200);
        errorText = StringUtil.trimTrailing((String)errorText);
        @NlsSafe String errorFullText = ExceptionUtil.getThrowableText((Throwable)error2, (String)"com.intellij.");
        String imgURL = DataSourceUiUtil.getIconUrl("/general/settings.png");
        String detailsLinkMessage = " <a href=\"more\">" + DatabaseBundle.message((String)"message.hyperlink.click.for.more", (Object[])new Object[0]) + "</a>";
        @NlsSafe String balloonContent = showConfig ? "<table border=0 cellspacing=0 cellpadding=0><tr valign=top><td>" + errorText + detailsLinkMessage + "</td><td align=right>&nbsp;&nbsp;<a href=\"config\"><img alt=\"Disable error balloons\" hspace=0 vspace=0 border=0 width=16 height=16 src=\"" + imgURL + "\"></a></td></tr></table>" : errorText + detailsLinkMessage;
        HyperlinkListener hyperlinkListener = e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                if ("more".equals(e.getDescription())) {
                    Messages.showIdeaMessageDialog(null, (String)errorFullText, (String)DatabaseBundle.message((String)"dialog.title.query.error", (Object[])new Object[0]), (String[])new String[]{CommonBundle.getOkButtonText()}, (int)0, (Icon)Messages.getErrorIcon(), null);
                } else if ("config".equals(e.getDescription())) {
                    ShowSettingsUtilImpl.showSettingsDialog(null, (String)DatabaseSettingsConfigurable.CONFIGURABLE_ID, (String)"");
                }
            }
        };
        BalloonBuilder builder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(balloonContent, MessageType.ERROR, hyperlinkListener).setClickHandler(e -> {}, true).setShowCallout(showArrow).setHideOnAction(true).setHideOnClickOutside(true);
        Balloon balloon = builder.createBalloon();
        balloon.show(new RelativePoint(component, point), Balloon.Position.below);
    }

    @Nullable
    public static String getIconUrl(@NotNull String icon) {
        if (icon == null) {
            DataSourceUiUtil.$$$reportNull$$$0(37);
        }
        String imgURL = null;
        URL resource = AllIcons.class.getClassLoader().getResource(StringUtil.trimStart((String)icon, (String)"/"));
        try {
            imgURL = resource != null ? resource.toURI().toURL().toExternalForm() : null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return imgURL;
    }

    public static String wrap(@NotNull String str, int wrapLength, String newLineStr, boolean wrapLongWords) {
        if (str == null) {
            DataSourceUiUtil.$$$reportNull$$$0(38);
        }
        if (newLineStr == null) {
            newLineStr = "\n";
        }
        if (wrapLength < 1) {
            wrapLength = 1;
        }
        int inputLineLength = str.length();
        int offset = 0;
        StringBuilder wrappedLine = new StringBuilder(inputLineLength + 32);
        while (inputLineLength - offset > wrapLength) {
            if (str.charAt(offset) == ' ') {
                ++offset;
                continue;
            }
            int spaceToWrapAt = str.lastIndexOf(32, wrapLength + offset);
            if (spaceToWrapAt >= offset) {
                wrappedLine.append(str, offset, spaceToWrapAt);
                wrappedLine.append(newLineStr);
                offset = spaceToWrapAt + 1;
                continue;
            }
            if (wrapLongWords) {
                wrappedLine.append(str, offset, wrapLength + offset);
                wrappedLine.append(newLineStr);
                offset += wrapLength;
                continue;
            }
            spaceToWrapAt = str.indexOf(32, wrapLength + offset);
            if (spaceToWrapAt >= 0) {
                wrappedLine.append(str, offset, spaceToWrapAt);
                wrappedLine.append(newLineStr);
                offset = spaceToWrapAt + 1;
                continue;
            }
            wrappedLine.append(str.substring(offset));
            offset = inputLineLength;
        }
        wrappedLine.append(str.substring(offset));
        return wrappedLine.toString();
    }

    @NlsSafe
    @NotNull
    public static String currentTime() {
        String string = "[" + ourTimestampFormat.format(new Date()) + "] ";
        if (string == null) {
            DataSourceUiUtil.$$$reportNull$$$0(39);
        }
        return string;
    }

    public static void runAsyncWithCorrectModality(@NotNull Task.Backgroundable task) {
        if (task == null) {
            DataSourceUiUtil.$$$reportNull$$$0(40);
        }
        ((CoreProgressManager)ProgressManager.getInstance()).runProcessWithProgressAsynchronously(task, (ProgressIndicator)new BackgroundableProcessIndicator(task), null, ModalityState.current());
    }

    public static void runSynchronously(@NotNull Task task) {
        ProgressIndicator indicator;
        if (task == null) {
            DataSourceUiUtil.$$$reportNull$$$0(41);
        }
        if ((indicator = ProgressManager.getInstance().getProgressIndicator()) == null) {
            indicator = new EmptyProgressIndicator();
        }
        try {
            task.run(indicator);
        }
        catch (ProcessCanceledException processCanceledException) {
        }
        finally {
            if (indicator.isCanceled()) {
                task.onCancel();
            } else {
                task.onSuccess();
            }
        }
    }

    @NotNull
    public static JBPopup buildHiddenNamespacesPopup(@NotNull Project project, final @NotNull LocalDataSource dataSource2, @Nullable BasicElement selection) {
        if (project == null) {
            DataSourceUiUtil.$$$reportNull$$$0(42);
        }
        if (dataSource2 == null) {
            DataSourceUiUtil.$$$reportNull$$$0(43);
        }
        final DataSourceScopeEditor editor = new DataSourceScopeEditor(project){

            @Override
            protected LocalDataSource getDataSource(boolean withCredentials) {
                return dataSource2;
            }

            @Override
            @NotNull
            protected Dbms getDbms() {
                Dbms dbms = dataSource2.getDbms();
                if (dbms == null) {
                    3.$$$reportNull$$$0(0);
                }
                return dbms;
            }

            @Override
            @NotNull
            public DataSourceSchemaMapping getSchemaMapping() {
                TreePattern scope = this.getEditorState();
                this.mySchemaMapping.setIntrospectionScope(scope);
                DataSourceSchemaMapping dataSourceSchemaMapping = this.mySchemaMapping;
                if (dataSourceSchemaMapping == null) {
                    3.$$$reportNull$$$0(1);
                }
                return dataSourceSchemaMapping;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/database/dataSource/DataSourceUiUtil$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDbms";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSchemaMapping";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        editor.setInitialModel(dataSource2, (BasicModel)ObjectUtils.tryCast((Object)dataSource2.getModel(), BasicModel.class));
        TreePattern pattern = dataSource2.getIntrospectionScope();
        editor.setScopes(pattern, pattern);
        editor.setFakeCurrentSchema(dataSource2.getFakeCurrentSchema());
        editor.setSchemaMapping(dataSource2.getSchemaMapping());
        editor.select(selection);
        Ref notApply = Ref.create();
        final Ref popupRef = Ref.create();
        JBPopup popup2 = JBPopupFactory.getInstance().createComponentPopupBuilder(editor.getComponent(), (JComponent)editor.getTree()).setMovable(true).setResizable(true).setRequestFocus(true).setDimensionServiceKey(project, "HiddenNamespacesPopup", false).setAdText(DatabaseBundle.message((String)"manage.data.sources.ad", (Object[])new Object[0])).setKeyEventHandler(event -> {
            if (event.getID() == 401) {
                if (event.getKeyCode() == 10) {
                    ((JBPopup)popupRef.get()).closeOk((InputEvent)event);
                    return true;
                }
                if (event.getKeyCode() == 27 && !editor.hasSpeedSearchActive()) {
                    notApply.set((Object)Boolean.TRUE);
                    ((JBPopup)popupRef.get()).cancel();
                    return true;
                }
            }
            return false;
        }).addListener(new JBPopupListener(){

            public void beforeShown(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                ((AbstractPopup)popupRef.get()).setShowHints(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/dataSource/DataSourceUiUtil$4", "beforeShown"));
            }
        }).createPopup();
        popupRef.set((Object)popup2);
        popup2.setFinalRunnable(() -> {
            if (notApply.get() == Boolean.TRUE) {
                return;
            }
            Couple<String> fcs = editor.getFakeCurrentSchema();
            DataSourceSchemaMapping mapping = editor.getSchemaMapping();
            if (Comparing.equal(fcs, dataSource2.getFakeCurrentSchema()) && Comparing.equal((Object)mapping, (Object)dataSource2.getSchemaMapping())) {
                return;
            }
            @NotNull TreePattern oldScope = dataSource2.getIntrospectionScope();
            dataSource2.setFakeCurrentSchema(fcs);
            dataSource2.setSchemaMapping(mapping);
            DataSourceStorage.getProjectStorage(project).updateDataSource(dataSource2);
            DataSourceUiUtil.applyMappings(project, dataSource2);
            DataSourceUiUtil.performAutoSyncTask(DataSourceUiUtil.scopeChange(new LoaderContext(project, dataSource2), oldScope, dataSource2.getIntrospectionScope()));
        });
        new UiNotifyConnector.Once((Component)editor.getComponent(), new Activatable(){

            public void showNotify() {
                editor.introspectIfEmpty();
            }
        });
        JBPopup jBPopup = popup2;
        if (jBPopup == null) {
            DataSourceUiUtil.$$$reportNull$$$0(44);
        }
        return jBPopup;
    }

    @Nullable
    public static AsyncTask<DataSourceSyncManager.SyncResult> applyMappings(@NotNull Project project, @NotNull LocalDataSource dataSource2) {
        if (project == null) {
            DataSourceUiUtil.$$$reportNull$$$0(45);
        }
        if (dataSource2 == null) {
            DataSourceUiUtil.$$$reportNull$$$0(46);
        }
        return DataSourceSyncManager.getInstance().tryPerform(new LoaderContext(project, dataSource2), false, true);
    }

    public static LoaderContext scopeChange(@NotNull LoaderContext context, @NotNull TreePattern oldScope, @NotNull TreePattern newScope) {
        TreePattern diff;
        if (context == null) {
            DataSourceUiUtil.$$$reportNull$$$0(47);
        }
        if (oldScope == null) {
            DataSourceUiUtil.$$$reportNull$$$0(48);
        }
        if (newScope == null) {
            DataSourceUiUtil.$$$reportNull$$$0(49);
        }
        if (!(diff = TreePatternUtils.minus(newScope, oldScope)).isEmpty()) {
            context.include(diff);
        }
        return context;
    }

    public static boolean setNamespacesVisible(Project project, LocalDataSource dataSource2, Iterable<? extends BasicNamespace> selectedValues, boolean visible) {
        return DataSourceUiUtil.setPathsVisible(project, dataSource2, (Iterable<ObjectPath>)JBIterable.from(selectedValues).map(ObjectPaths::of), visible);
    }

    public static boolean setPathsVisible(Project project, LocalDataSource dataSource2, Iterable<ObjectPath> paths, boolean visible) {
        TreePattern newScope;
        TreePattern objects2 = TreePatternUtils.union((Iterable<TreePattern>)JBIterable.from(paths).map(TreePatternUtils::create));
        TreePattern scope = dataSource2.getIntrospectionScope();
        TreePattern treePattern = newScope = visible ? TreePatternUtils.union(scope, objects2) : TreePatternUtils.minus(scope, objects2);
        if (scope.equals(newScope)) {
            return false;
        }
        dataSource2.setIntrospectionScope(newScope);
        if (dataSource2.isGlobal()) {
            DataSourceStorage.getStorage().updateDataSource(dataSource2);
        } else {
            DataSourceStorage.getProjectStorage(project).updateDataSource(dataSource2);
        }
        DataSourceUiUtil.applyMappings(project, dataSource2);
        return true;
    }

    public static void showNotification(LoaderContext context, long elapsedTime) {
        boolean isError = context.getErrorHandler().hasErrors();
        String message2 = StringUtil.notNullize((String)StringUtil.nullize((String)DataSourceUiUtil.computeMessage(context)), (String)DatabaseBundle.message((String)"notification.content.connection.successful", (Object[])new Object[0]));
        DataSourceUiUtil.showNotification(context.getProject(), context.getDataSource().getName(), message2 + DataSourceUiUtil.getElapsedString(elapsedTime), isError);
    }

    private static void showOutdatedCheckErrorNotification(LoaderContext context, long elapsedTime) {
        String message2 = DataSourceUiUtil.computeMessage(context);
        String title = context.getDataSource().getName();
        Pair<String, @Nullable HyperlinkListener> pair = DataSourceUiUtil.truncatePopupMessageIfNeeded(message2 + DataSourceUiUtil.getElapsedString(elapsedTime), DatabaseBundle.message((String)"message.title.connection.error", (Object[])new Object[0]), Messages.getErrorIcon());
        DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(title, DatabaseBundle.message((String)"notification.content.br.you.can.href.disable.disable.outdated.object.notification", (Object[])new Object[]{pair.first}), NotificationType.WARNING, (notification, event) -> {
            if (pair.second != null) {
                ((HyperlinkListener)pair.second).hyperlinkUpdate(event);
            }
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && "disable".equals(event.getDescription())) {
                context.getDataSource().setCheckOutdated(false);
                DataSourceStorage.getProjectStorage(context.getProject()).updateDataSource(context.getDataSource());
                notification.expire();
            }
        }).notify(context.getProject());
    }

    @NlsContexts.NotificationContent
    @NotNull
    protected static String computeMessage(LoaderContext context) {
        boolean isError = context.getErrorHandler().hasErrors();
        String summary = context.getErrorHandler().getSummary();
        if (isError) {
            String string = DataSourceUiUtil.escapeAngleBrackets(summary);
            if (string == null) {
                DataSourceUiUtil.$$$reportNull$$$0(50);
            }
            return string;
        }
        if (context.hasSelection()) {
            List objects2 = JBIterable.from(context.getSelection()).filter(Conditions.notInstanceOf(Class.class)).toList();
            int size = objects2.size();
            Object item = ContainerUtil.getFirstItem((Collection)objects2);
            String itemName = item instanceof String ? (String)item : (item instanceof DasObject ? ((DasObject)item).getName() : null);
            String string = size == 1 && !StringUtil.isEmptyOrSpaces((String)itemName) ? DatabaseBundle.message((String)"notification.content.synchronized", (Object[])new Object[]{itemName}) : DatabaseBundle.message((String)"notification.content.synchronization.successful", (Object[])new Object[0]);
            if (string == null) {
                DataSourceUiUtil.$$$reportNull$$$0(51);
            }
            return string;
        }
        String string = DataSourceUiUtil.formatDataSourceInfoString(context.getDataSource()) + "\n\n" + DatabaseBundle.message((String)"notification.content.connection.successful", (Object[])new Object[0]);
        if (string == null) {
            DataSourceUiUtil.$$$reportNull$$$0(52);
        }
        return string;
    }

    private static String escapeAngleBrackets(String message2) {
        return message2.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    protected static String getElapsedString(long elapsedTime) {
        return elapsedTime > 1L ? " (" + NlsMessages.formatDuration((long)elapsedTime) + ")" : "";
    }

    @NotNull
    public static Promise<?> promiseFacadeUpdate(@NotNull DbPsiFacade facade, @Nullable Disposable parent2) {
        if (facade == null) {
            DataSourceUiUtil.$$$reportNull$$$0(53);
        }
        AsyncPromise p2 = new AsyncPromise();
        Disposable listenerDisposable = Disposer.newDisposable();
        Disposer.register((Disposable)((Disposable)ObjectUtils.notNull((Object)parent2, (Object)facade.getProject())), (Disposable)listenerDisposable);
        facade.getProject().getMessageBus().connect(listenerDisposable).subscribe(DbPsiFacade.TOPIC, o -> {
            Disposer.dispose((Disposable)listenerDisposable);
            p2.setResult(null);
        });
        AsyncPromise asyncPromise = p2;
        if (asyncPromise == null) {
            DataSourceUiUtil.$$$reportNull$$$0(54);
        }
        return asyncPromise;
    }

    public static boolean createDataSourceFromFiles(@NotNull Project project, @NotNull List<VirtualFile> files) {
        if (project == null) {
            DataSourceUiUtil.$$$reportNull$$$0(55);
        }
        if (files == null) {
            DataSourceUiUtil.$$$reportNull$$$0(56);
        }
        ArrayList<VirtualFile> extraFiles = new ArrayList<VirtualFile>(files);
        ArrayList<DbDataSource> dataSources = new ArrayList<DbDataSource>();
        Iterator it2 = extraFiles.iterator();
        while (it2.hasNext()) {
            VirtualFile file = (VirtualFile)it2.next();
            DbDataSource dataSource2 = DbImplUtil.findDataSourceByFile(project, file);
            if (dataSource2 == null) continue;
            dataSources.add(dataSource2);
            it2.remove();
        }
        int existingSize = dataSources.size();
        DbPsiFacade facade = DbPsiFacade.getInstance((Project)project);
        if (!extraFiles.isEmpty()) {
            for (DataSourceManager manager : DataSourceManager.getManagers((Project)project)) {
                for (DasDataSource system : manager.createDataSourceByFiles(files)) {
                    ContainerUtil.addIfNotNull(dataSources, (Object)facade.findDataSource(system.getUniqueId()));
                }
            }
        }
        if (!dataSources.isEmpty()) {
            Promise<?> prepare = existingSize != dataSources.size() ? DataSourceUiUtil.promiseFacadeUpdate(facade, null) : Promises.resolvedPromise();
            prepare.thenAsync(o -> DatabaseView.select(project, dataSources, true)).onProcessed(o -> ApplicationManager.getApplication().invokeLater(() -> DbNavigationUtils.navigateToDataSourceFile((DbElement)ContainerUtil.getFirstItem((List)dataSources), true)));
            return true;
        }
        return false;
    }

    public static DatabaseDriver createDefaultDatabaseDriver(@NotNull Collection<? extends DatabaseDriver> existing) {
        if (existing == null) {
            DataSourceUiUtil.$$$reportNull$$$0(57);
        }
        Set names = (Set)JBIterable.from(existing).map(DatabaseDriver::getName).addAllTo((Collection)CollectionFactory.createCaseInsensitiveStringSet());
        return DatabaseDriverManager.getInstance().createDriver(DbUtil.generateUniqueName((String)"User Driver", (Set)names), "java.sql.Driver", null);
    }

    public static void showTroubleshooting() {
        HelpManager.getInstance().invokeHelp("Connectivity_problems");
    }

    public static <K, V> V putOrRemove(Map<K, V> m, K k, V v) {
        if (v == null) {
            return m.remove(k);
        }
        return m.put(k, v);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 26: 
            case 27: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 39: 
            case 44: 
            case 50: 
            case 51: 
            case 52: 
            case 54: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 26: 
            case 27: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 39: 
            case 44: 
            case 50: 
            case 51: 
            case 52: 
            case 54: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listenerClass";
                break;
            }
            case 1: 
            case 26: 
            case 27: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 39: 
            case 44: 
            case 50: 
            case 51: 
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DataSourceUiUtil";
                break;
            }
            case 2: 
            case 28: 
            case 30: 
            case 42: 
            case 45: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fix";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dr";
                break;
            }
            case 13: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 14: 
            case 17: 
            case 29: 
            case 31: 
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 15: 
            case 18: 
            case 19: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 24: 
            case 25: 
            case 33: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldScope";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newScope";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceUiUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "eventDispatcher";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "performAutoSyncTask";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnectionContext";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "performManualSyncTask";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDataSourceInfoString";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "currentTime";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "buildHiddenNamespacesPopup";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "computeMessage";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "promiseFacadeUpdate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "eventDispatcher";
                break;
            }
            case 1: 
            case 26: 
            case 27: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 39: 
            case 44: 
            case 50: 
            case 51: 
            case 52: 
            case 54: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "settingsFix";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "navigate";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "modify";
                break;
            }
            case 24: 
            case 25: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "performAutoSyncTask";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getConnectionContext";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "performManualSyncTask";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getIconUrl";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "runAsyncWithCorrectModality";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "runSynchronously";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "buildHiddenNamespacesPopup";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "applyMappings";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "scopeChange";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "promiseFacadeUpdate";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "createDataSourceFromFiles";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultDatabaseDriver";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 26: 
            case 27: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 39: 
            case 44: 
            case 50: 
            case 51: 
            case 52: 
            case 54: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DbGroupDropTarget
    implements DnDTarget {
        private final String myGroupName;

        public DbGroupDropTarget(@NotNull String groupName) {
            if (groupName == null) {
                DbGroupDropTarget.$$$reportNull$$$0(0);
            }
            this.myGroupName = groupName;
        }

        public void drop(DnDEvent event) {
            List dataSources = DbGroupDropTarget.getDataSources(event).toList();
            DbDataSource first2 = (DbDataSource)ContainerUtil.getFirstItem((Collection)dataSources);
            if (first2 == null) {
                return;
            }
            for (DbDataSource dataSource2 : dataSources) {
                ((AbstractDataSource)dataSource2.getDelegate()).setGroupName(this.myGroupName);
            }
            DatabaseView.refreshViewAndSelect(first2.getProject(), dataSources);
        }

        public boolean update(DnDEvent event) {
            return DbGroupDropTarget.getDataSources(event).isNotEmpty();
        }

        @NotNull
        private static JBIterable<DbDataSource> getDataSources(DnDEvent event) {
            block4: {
                JBIterable jBIterable;
                try {
                    JBIterable result;
                    Object data = event.getTransferData(DnDEventImpl.ourDataFlavor);
                    if (!(data instanceof Object[]) || !(result = JBIterable.of((Object[])((Object[])data))).filter(o -> !(o instanceof DbDataSource)).isEmpty()) break block4;
                    jBIterable = result.filter(DbDataSource.class);
                }
                catch (UnsupportedFlavorException | IOException exception) {
                    // empty catch block
                }
                if (jBIterable == null) {
                    DbGroupDropTarget.$$$reportNull$$$0(1);
                }
                return jBIterable;
            }
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DbGroupDropTarget.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groupName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DataSourceUiUtil$DbGroupDropTarget";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DataSourceUiUtil$DbGroupDropTarget";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataSources";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

