/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.IgnoredBeanFactory;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vcs.changes.IgnoredFileDescriptor;
import com.intellij.openapi.vcs.changes.IgnoredFileProvider;
import com.intellij.project.ProjectKt;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceStorageLocal {
    private static final String STATE_FILE_PATH = "dataSources.local.xml";
    public static final String COMPONENT_NAME = "dataSourceStorageLocal";
    private Element myState;

    public static DataSourceStorageLocal getGlobalInstance() {
        return (DataSourceStorageLocal)ApplicationManager.getApplication().getService(App.class);
    }

    public static DataSourceStorageLocal getProjectInstance(@NotNull Project project) {
        if (project == null) {
            DataSourceStorageLocal.$$$reportNull$$$0(0);
        }
        return (DataSourceStorageLocal)ServiceManager.getService((Project)project, Prj.class);
    }

    public static DataSourceStorageLocal getInstance(@Nullable Project project) {
        return project == null ? DataSourceStorageLocal.getGlobalInstance() : DataSourceStorageLocal.getProjectInstance(project);
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            DataSourceStorageLocal.$$$reportNull$$$0(1);
        }
        this.myState = state.clone();
    }

    public Element getState() {
        return this.myState == null ? null : this.myState.clone();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dataSource/DataSourceStorageLocal";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getProjectInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @State(name="dataSourceStorageLocal", storages={@Storage(value="dataSources.local.xml", roamingType=RoamingType.DISABLED)})
    public static class Prj
    extends DataSourceStorageLocal
    implements PersistentStateComponent<Element> {
    }

    static class IgnoredFiles
    implements IgnoredFileProvider {
        IgnoredFiles() {
        }

        public boolean isIgnoredFile(@NotNull Project project, @NotNull FilePath filePath) {
            if (project == null) {
                IgnoredFiles.$$$reportNull$$$0(0);
            }
            if (filePath == null) {
                IgnoredFiles.$$$reportNull$$$0(1);
            }
            String storageDir = DataSourceStorage.getStorageDir(project);
            return ProjectKt.isEqualToProjectFileStorePath((Project)project, (Path)Paths.get(filePath.getPath(), new String[0]), (String)DataSourceStorageLocal.STATE_FILE_PATH) || storageDir != null && FileUtil.isAncestor((String)storageDir, (String)filePath.getPath(), (boolean)false);
        }

        @NotNull
        public Set<IgnoredFileDescriptor> getIgnoredFiles(@NotNull Project project) {
            if (project == null) {
                IgnoredFiles.$$$reportNull$$$0(2);
            }
            LinkedHashSet<IgnoredFileBean> ignored = new LinkedHashSet<IgnoredFileBean>();
            String storageDir = DataSourceStorage.getStorageDir(project);
            if (storageDir != null) {
                ignored.add(IgnoredBeanFactory.ignoreUnderDirectory((String)storageDir, (Project)project));
            }
            if (ProjectKt.isDirectoryBased((Project)project)) {
                Path dataSourcesLocalIgnore = ProjectKt.getStateStore((Project)project).getStorageManager().expandMacro(DataSourceStorageLocal.STATE_FILE_PATH);
                ignored.add(IgnoredBeanFactory.ignoreFile((String)FileUtil.toSystemIndependentName((String)dataSourcesLocalIgnore.toString()), (Project)project));
            }
            Set set = ContainerUtil.unmodifiableOrEmptySet(ignored);
            if (set == null) {
                IgnoredFiles.$$$reportNull$$$0(3);
            }
            return set;
        }

        @NotNull
        public String getIgnoredGroupDescription() {
            String string = DatabaseBundle.message((String)"text.datasource.local.storage.ignored.files", (Object[])new Object[0]);
            if (string == null) {
                IgnoredFiles.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DataSourceStorageLocal$IgnoredFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DataSourceStorageLocal$IgnoredFiles";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIgnoredFiles";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIgnoredGroupDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isIgnoredFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getIgnoredFiles";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @State(name="dataSourceStorageLocal", storages={@Storage(value="dataSources.local.xml", roamingType=RoamingType.DISABLED)})
    public static class App
    extends DataSourceStorageLocal
    implements PersistentStateComponent<Element> {
    }
}

