/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DataSourceSnapshotManager;
import com.intellij.database.model.ModelFacadeCore;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.view.ui.DbCheckBoxTree;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.ThreeStateCheckBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DataSourceScopeEditorTree
extends DbCheckBoxTree<MyNode> {
    DataSourceScopeEditorTree(@NotNull CheckedTreeNode root2, @NotNull Getter<Couple<String>> fakeCurrent, @NotNull DataSourceSchemaMapping mapping) {
        if (root2 == null) {
            DataSourceScopeEditorTree.$$$reportNull$$$0(0);
        }
        if (fakeCurrent == null) {
            DataSourceScopeEditorTree.$$$reportNull$$$0(1);
        }
        if (mapping == null) {
            DataSourceScopeEditorTree.$$$reportNull$$$0(2);
        }
        super(root2, new MyTreeCellRenderer(fakeCurrent, mapping));
    }

    static CheckedTreeNode createNode(MyNode node) {
        return new CheckedTreeNode(node){

            public boolean isChecked() {
                return ((MyNode)this.getUserObject()).isChecked();
            }

            public void setChecked(boolean checked) {
                ((MyNode)this.getUserObject()).setChecked(checked);
            }

            public boolean isLeaf() {
                MyNode userNode = (MyNode)ObjectUtils.tryCast((Object)this.getUserObject(), MyNode.class);
                if (userNode == null) {
                    return super.isLeaf();
                }
                if (!userNode.getChildNodes().isEmpty()) {
                    return false;
                }
                if (userNode.getObject() == "*" || userNode instanceof CurNode) {
                    return true;
                }
                BasicMetaObject<?> meta = userNode.getMeta();
                if (meta == null) {
                    return false;
                }
                for (BasicMetaObject<BasicMateNamespace> basicMetaObject : meta.children) {
                    if (!basicMetaObject.kindOf(BasicMateNamespace.class)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    @Nullable
    static DataSourceScopeEditorTree getTree(DataContext dataContext) {
        return (DataSourceScopeEditorTree)((Object)ObjectUtils.tryCast((Object)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext), DataSourceScopeEditorTree.class));
    }

    public static boolean matches(Couple<String> fsc, MyNode node) {
        return node.getKind() == ObjectKind.DATABASE ? DataSourceScopeEditorTree.matches(fsc, node.getName(), null) : DataSourceScopeEditorTree.matches(fsc, DataSourceScopeEditorTree.getParentName(node), node.getName());
    }

    @Nullable
    public static String getParentName(MyNode node) {
        MyNode parent2 = (MyNode)node.getParent();
        return parent2 != null && parent2.getKind() == ObjectKind.DATABASE ? parent2.getName() : null;
    }

    public static boolean matches(Couple<String> fsc, String pName, String name) {
        return fsc != null && Objects.equals(fsc.first, pName) && (name == null || Objects.equals(fsc.second, name));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "root";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "fakeCurrent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "mapping";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/dataSource/DataSourceScopeEditorTree";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyTreeCellRenderer
    extends DbCheckBoxTree.CellWithUnderlinedAllRenderer<MyNode> {
        private final Getter<Couple<String>> myCurrent;
        private final DataSourceSchemaMapping myMapping;

        MyTreeCellRenderer(@NotNull Getter<Couple<String>> current, @NotNull DataSourceSchemaMapping mapping) {
            if (current == null) {
                MyTreeCellRenderer.$$$reportNull$$$0(0);
            }
            if (mapping == null) {
                MyTreeCellRenderer.$$$reportNull$$$0(1);
            }
            this.myCurrent = current;
            this.myMapping = mapping;
        }

        @Override
        protected void customizeCheckboxRenderer(MyNode node) {
            if (node.getParent() == null) {
                return;
            }
            ColoredTreeCellRenderer renderer = this.getTextRenderer();
            this.renderText(node, (ColoredTextContainer)renderer);
            if (node.getObject() instanceof DasObject && MyTreeCellRenderer.isImplicitlySelected(node) && !this.myCheckbox.isSelected()) {
                this.myCheckbox.setState(ThreeStateCheckBox.State.DONT_CARE);
            }
        }

        private static boolean isImplicitlySelected(MyNode node) {
            if (node == null) {
                return false;
            }
            CurNode cur2 = node.getCurrentSibling();
            return cur2 != null && cur2.getCurObject() == node.getObject() && (cur2.isChecked() || MyTreeCellRenderer.isImplicitlySelected((MyNode)node.getParent()));
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Override
        protected void renderText(MyNode node, ColoredTextContainer renderer) {
            this.setToolTipText(null);
            String name = node.getName();
            @NlsSafe Couple fcs = (Couple)this.myCurrent.get();
            if (node.getObject() instanceof DasObject) {
                BasicNamespace nsp;
                CurNode cur2;
                if (StringUtil.isEmpty((String)name)) {
                    renderer.append(DatabaseBundle.message((String)"data.source.scope.editor.tree.unnamed.node.name", (Object[])new Object[0]), SimpleTextAttributes.GRAY_ATTRIBUTES);
                } else {
                    renderer.append(name, node.getKind() == ObjectKind.DATABASE ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
                boolean isCurrent = fcs == null ? (cur2 = node.getCurrentSibling()) != null && cur2.getCurObject() == node.getObject() : DataSourceScopeEditorTree.matches((Couple<String>)fcs, node);
                if (isCurrent) {
                    renderer.append("  (" + MyTreeCellRenderer.getCurrentNodeText(node) + ")", fcs == null ? SimpleTextAttributes.GRAYED_ATTRIBUTES : SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES);
                }
                if ((nsp = (BasicNamespace)ObjectUtils.tryCast((Object)node.getObject(), BasicNamespace.class)) != null) {
                    boolean canSubstitute;
                    boolean substituted = DataSourceSnapshotManager.INSTANCE.map(nsp, this.myMapping) != null && !node.isChecked();
                    boolean bl = canSubstitute = substituted || DataSourceSnapshotManager.INSTANCE.canSubstitute(nsp, true);
                    if (canSubstitute) {
                        if (renderer instanceof SimpleColoredComponent) {
                            ((SimpleColoredComponent)renderer).setIconOnTheRight(true);
                        }
                        renderer.setIcon(substituted ? AllIcons.Actions.Lightning : IconLoader.getDisabledIcon((Icon)AllIcons.Actions.Lightning));
                        renderer.setToolTipText(DatabaseBundle.message((String)(substituted ? "DataSourceScopeEditor.substituted.used" : (DataSourceSnapshotManager.IGNORE_AUTO_MINI_CAT || !this.myMapping.isUseMiniCat() || !node.isChecked() ? "DataSourceScopeEditor.substituted.not.used" : "DataSourceScopeEditor.substituted.not.used.but.will")), (Object[])new Object[0]));
                    }
                }
            } else if (node instanceof CurNode) {
                renderer.append(MyTreeCellRenderer.getCurrentNodeText(node), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                if (fcs == null) {
                    DasObject curObject = ((CurNode)node).getCurObject();
                    if (curObject != null) {
                        renderer.append(" (" + curObject.getName() + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
                    }
                } else {
                    String cur3;
                    String string = cur3 = node.getKind() == ObjectKind.DATABASE ? (String)fcs.first : (String)fcs.second;
                    if (cur3 != null) {
                        renderer.append(" (" + cur3 + ")", SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
                    }
                }
            } else if (node.getObject() == "*") {
                renderer.append(MyTreeCellRenderer.getAllNodeText(node), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            } else {
                renderer.append(StringUtil.isEmpty((String)name) ? DatabaseBundle.message((String)"data.source.scope.editor.tree.unnamed.node.name", (Object[])new Object[0]) : name, SimpleTextAttributes.EXCLUDED_ATTRIBUTES);
            }
        }

        @Nls
        @NotNull
        private static String getCurrentNodeText(MyNode node) {
            String string = DatabaseBundle.message((String)"data.source.scope.editor.tree.current.node.pattern", (Object[])new Object[]{MyTreeCellRenderer.getCurrentNodeKindName(node)});
            if (string == null) {
                MyTreeCellRenderer.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nls
        @NotNull
        private static String getAllNodeText(MyNode node) {
            String string = DatabaseBundle.message((String)"data.source.scope.editor.tree.all.node.pattern", (Object[])new Object[]{MyTreeCellRenderer.getCurrentNodeKindNamePlural(node)});
            if (string == null) {
                MyTreeCellRenderer.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nls
        @NotNull
        private static String getCurrentNodeKindName(@NotNull MyNode node) {
            if (node == null) {
                MyTreeCellRenderer.$$$reportNull$$$0(4);
            }
            ObjectKind kind = (ObjectKind)ObjectUtils.notNull((Object)node.getKind(), (Object)ObjectKind.NONE);
            BasicMetaObject<?> meta = node.getMeta();
            Dbms dbms = meta == null ? Dbms.UNKNOWN : meta.getModel().dbms;
            String name = ModelFacadeCore.forDbms(dbms).getModelHelper().getName(kind);
            String string = StringUtil.equalsIgnoreCase((CharSequence)name, (CharSequence)ObjectKind.DATABASE.name()) ? DatabaseBundle.message((String)"data.source.scope.editor.tree.current.node.database", (Object[])new Object[0]) : (StringUtil.equalsIgnoreCase((CharSequence)name, (CharSequence)ObjectKind.SCHEMA.name()) ? DatabaseBundle.message((String)"data.source.scope.editor.tree.current.node.schema", (Object[])new Object[0]) : StringUtil.toLowerCase((String)name));
            if (string == null) {
                MyTreeCellRenderer.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Nls
        @NotNull
        private static String getCurrentNodeKindNamePlural(@NotNull MyNode node) {
            if (node == null) {
                MyTreeCellRenderer.$$$reportNull$$$0(6);
            }
            ObjectKind kind = (ObjectKind)ObjectUtils.notNull((Object)node.getKind(), (Object)ObjectKind.NONE);
            BasicMetaObject<?> meta = node.getMeta();
            Dbms dbms = meta == null ? Dbms.UNKNOWN : meta.getModel().dbms;
            String name = ModelFacadeCore.forDbms(dbms).getModelHelper().getName(kind);
            String string = StringUtil.equalsIgnoreCase((CharSequence)name, (CharSequence)ObjectKind.DATABASE.name()) ? DatabaseBundle.message((String)"data.source.scope.editor.tree.current.node.database.plural", (Object[])new Object[0]) : (StringUtil.equalsIgnoreCase((CharSequence)name, (CharSequence)ObjectKind.SCHEMA.name()) ? DatabaseBundle.message((String)"data.source.scope.editor.tree.current.node.schema.plural", (Object[])new Object[0]) : StringUtil.pluralize((String)StringUtil.toLowerCase((String)name)));
            if (string == null) {
                MyTreeCellRenderer.$$$reportNull$$$0(7);
            }
            return string;
        }

        public String getToolTipText(MouseEvent event) {
            ColoredTreeCellRenderer renderer = this.getTextRenderer();
            if (renderer.getIcon() != null) {
                boolean onIcon;
                Point rp = SwingUtilities.convertPoint(event.getComponent(), event.getPoint(), (Component)renderer);
                Dimension size = renderer.getPreferredSize();
                boolean bl = onIcon = rp.x >= 0 && rp.y >= 0 && rp.x < size.width && rp.y < size.height && rp.x >= size.width - size.height;
                if (onIcon) {
                    return renderer.getToolTipText();
                }
            }
            return super.getToolTipText(event);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "current";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapping";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DataSourceScopeEditorTree$MyTreeCellRenderer";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DataSourceScopeEditorTree$MyTreeCellRenderer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCurrentNodeText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllNodeText";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCurrentNodeKindName";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCurrentNodeKindNamePlural";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 7: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getCurrentNodeKindName";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getCurrentNodeKindNamePlural";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class CurNode
    extends MyNode {
        private DasObject myCurObject;

        CurNode(BasicMetaObject<?> meta, DasObject curObject) {
            super("Current", meta, "@");
            this.myCurObject = curObject;
        }

        public DasObject getCurObject() {
            return this.myCurObject;
        }

        public void setCurObject(DasObject curObject) {
            this.myCurObject = curObject;
        }
    }

    static class MyNode
    extends DbCheckBoxTree.MyNode<MyNode> {
        private CurNode myCurNode = null;

        MyNode(String name, BasicMetaObject<?> meta, Object object) {
            super(name, meta, object);
        }

        @Nullable
        public CurNode getCurrentSibling() {
            MyNode parent2 = (MyNode)this.getParent();
            return parent2 == null ? null : parent2.getCurNode();
        }

        @Nullable
        public CurNode getCurNode() {
            return this.myCurNode;
        }

        @Override
        @NotNull
        protected MyNode createAll(@NotNull BasicMetaObject<?> meta) {
            if (meta == null) {
                MyNode.$$$reportNull$$$0(0);
            }
            return new MyNode("All", meta, "*");
        }

        @Override
        @NotNull
        public Iterable<MyNode> getSimpleChildNodes() {
            JBIterable jBIterable = this.myCurNode == null ? super.getSimpleChildNodes() : JBIterable.of((Object)this.myCurNode).append(super.getSimpleChildNodes());
            if (jBIterable == null) {
                MyNode.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }

        public void setHasAllAndCur(boolean has) {
            this.setHasAll(has);
            if (has == (this.myCurNode != null)) {
                return;
            }
            BasicMetaObject<?> child = this.findChild(ObjectKind.DATABASE);
            if (child == null) {
                child = this.findChild(ObjectKind.SCHEMA);
            }
            if (has && child != null) {
                this.myCurNode = new CurNode(child, null);
                this.reparent(Collections.singletonList(this.myCurNode));
            } else {
                this.myCurNode = null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "meta";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DataSourceScopeEditorTree$MyNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DataSourceScopeEditorTree$MyNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSimpleChildNodes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createAll";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

