/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.CommonBundle;
import com.intellij.DynamicBundle;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DataSourceScopeEditor;
import com.intellij.database.dataSource.DataSourceScopeEditorTree;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcModelStorage;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.database.view.ModelLightCopier;
import com.intellij.database.view.ui.DbCheckBoxTree;
import com.intellij.find.impl.RegExHelpPopup;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CheckboxTreeListener;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ExpandableEditorSupport;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceSchemasPanel {
    private static final String INTROSPECTION_ERROR = "INTROSPECTION_ERROR";
    private final DataSourceConfigurable myDialog;
    private JPanel myRoot;
    private JPanel mySchemasPanel;
    private final MyScopeEditor myScopeEditor;
    private ExpandableTextField myObjectFilter;
    private TextFieldWithAutoCompletion<Pair<String, ObjectKind>> mySchemaPattern;
    private TreePattern mySchemaPatternScope = TreePattern.EMPTY;
    private boolean myUpdatingField = false;
    private boolean myUpdatingTree = false;
    private boolean myTreeDirty = false;
    private boolean myScopeFromField = true;
    private static final List<List<String>> ESCAPES = Arrays.asList(Arrays.asList("\\", ":", ",", "|"), Arrays.asList("\\\\", "\\:", "\\,", "\\|"));

    public DataSourceSchemasPanel(DataSourceConfigurable dialog2) {
        this.myDialog = dialog2;
        this.$$$setupUI$$$();
        this.myScopeEditor = new MyScopeEditor(dialog2);
        this.mySchemasPanel.setBorder(JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)0, (int)0, (int)1, (int)0));
        this.mySchemasPanel.setLayout(new BorderLayout());
        this.mySchemasPanel.add((Component)this.myScopeEditor.getComponent(), "Center");
        new UiNotifyConnector((Component)this.myScopeEditor.getComponent(), new Activatable(){

            public void showNotify() {
                DataSourceSchemasPanel.this.introspectIfNeeded();
            }
        });
    }

    private void introspectIfNeeded() {
        this.myScopeEditor.introspectIfEmpty();
    }

    public JComponent getComponent() {
        return this.myRoot;
    }

    private void createUIComponents() {
        this.myObjectFilter = new ExpandableTextField(s2 -> JBIterable.of((Object[])s2.split("\\|\\|")).transform(StringUtil.TRIMMER).toList(), strings -> StringUtil.join((Iterable)JBIterable.from((Iterable)strings).transform(StringUtil.TRIMMER), (String)"||"));
        this.mySchemaPattern = new TextFieldWithAutoCompletion(this.myDialog.getProject(), (TextFieldWithAutoCompletionListProvider)new MyCompletion(), false, "");
        this.mySchemaPattern.setFont(this.myObjectFilter.getFont());
        new ExpandableEditorSupport(this.mySchemaPattern, s2 -> JBIterable.of((Object[])s2.split("\\|")).transform(StringUtil.TRIMMER).toList(), strings -> StringUtil.join((Iterable)JBIterable.from((Iterable)strings).transform(StringUtil.TRIMMER), (String)"|"));
        Shortcut[] shortcuts = KeymapUtil.getActiveKeymapShortcuts((String)"QuickJavaDoc").getShortcuts();
        String tooltipText = shortcuts.length == 0 ? "" : DatabaseBundle.message((String)"for.help", (Object[])new Object[]{KeymapUtil.getShortcutText((Shortcut)shortcuts[0])});
        this.mySchemaPattern.addSettingsProvider(e -> e.getContentComponent().setToolTipText(tooltipText));
        this.myObjectFilter.setToolTipText(tooltipText);
        AnAction action2 = new AnAction(CommonBundle.message((String)"action.help", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                Component c2;
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (UIUtil.isAncestor(DataSourceSchemasPanel.this.mySchemaPattern, (Component)(c2 = (Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT)))) {
                    DataSourceSchemasPanel.showHint(DataSourceSchemasPanel.this.mySchemaPattern, DatabaseBundle.message((String)"DataSourceSchemasPanel.schema.pattern.hint", (Object[])new Object[0]));
                }
                if (UIUtil.isAncestor((Component)DataSourceSchemasPanel.this.myObjectFilter, (Component)c2)) {
                    DataSourceSchemasPanel.showHint((JComponent)DataSourceSchemasPanel.this.myObjectFilter, DatabaseBundle.message((String)"DataSourceSchemasPanel.object.filter.hint", (Object[])new Object[]{StringUtil.join((Collection)ContainerUtil.sorted(DbImplUtilCore.FILTER_BY_NAME.keySet()), (String)"</b>, <b>")}));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/DataSourceSchemasPanel$2", "actionPerformed"));
            }
        };
        action2.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcuts), this.mySchemaPattern);
        action2.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcuts), (JComponent)this.myObjectFilter);
        this.mySchemaPattern.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!DataSourceSchemasPanel.this.myUpdatingTree && !DataSourceSchemasPanel.this.myUpdatingField) {
                    DataSourceSchemasPanel.this.myScopeFromField = true;
                }
                if (!DataSourceSchemasPanel.this.myUpdatingField) {
                    DataSourceSchemasPanel.this.myScopeEditor.setFieldScope(DataSourceSchemasPanel.parse(((LocalDataSource)DataSourceSchemasPanel.this.myDialog.getDataSource()).getDbms(), e.getDocument().getText()), false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/DataSourceSchemasPanel$3", "documentChanged"));
            }
        });
    }

    public void saveSettings(@NotNull LocalDataSource dataSource2) {
        if (dataSource2 == null) {
            DataSourceSchemasPanel.$$$reportNull$$$0(0);
        }
        dataSource2.setFakeCurrentSchema(this.myScopeEditor.getFakeCurrentSchema());
        dataSource2.setObjectPattern(StringUtil.nullize((String)this.myObjectFilter.getText()));
        dataSource2.setSchemaMapping(this.myScopeEditor.getSchemaMapping());
    }

    public void reset(@NotNull LocalDataSource dataSource2) {
        if (dataSource2 == null) {
            DataSourceSchemasPanel.$$$reportNull$$$0(1);
        }
        this.myScopeEditor.setInitialModel((LocalDataSource)this.myDialog.getDataSource(), DataSourceSchemasPanel.tryCopy((BasicModel)ObjectUtils.tryCast((Object)((LocalDataSource)this.myDialog.getDataSource()).getModel(), BasicModel.class)));
        this.myScopeEditor.resetFieldScope(dataSource2.getIntrospectionScope());
        this.myScopeEditor.setFakeCurrentSchema(dataSource2.getFakeCurrentSchema());
        this.myScopeEditor.setSchemaMapping(dataSource2.getSchemaMapping());
        this.myObjectFilter.setText(StringUtil.notNullize((String)dataSource2.getObjectPattern()));
    }

    private static void showHint(final JComponent component, @NlsContexts.HintText String text2) {
        JComponent label = HintUtil.createInformationLabel((String)text2, (HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                if ("#regex".equals(e.getDescription())) {
                    RegExHelpPopup.createRegExLinkRunnable((Component)component).run();
                }
            }
        }, null, null);
        JBPopupFactory.getInstance().createBalloonBuilder(label).setFillColor(HintUtil.getInformationColor()).createBalloon().show(RelativePoint.getNorthWestOf((JComponent)component), Balloon.Position.above);
    }

    @Nullable
    private static BasicModel tryCopy(final @Nullable BasicModel basicModel) {
        if (basicModel == null) {
            return null;
        }
        BasicModModel modModel = DbSrcModelStorage.createFactory(null, (String)null).createModel(basicModel.getDbms());
        modModel.modify(BasicModRoot.class, new ModelModifier<BasicModRoot>(){

            @Override
            public void perform(BasicModRoot element2) {
                this.copy(element2, basicModel.getRoot());
            }

            void copy(BasicModElement to, BasicElement from) {
                ModelLightCopier.copyProperties(from, to, false);
                for (BasicMetaObject<BasicNamespace> basicMetaObject : from.getMetaObject().children) {
                    if (!basicMetaObject.kindOf(BasicNamespace.class)) continue;
                    this.copy(to.familyOf(basicMetaObject.kind), from.familyOf(basicMetaObject.kind));
                }
            }

            void copy(ModFamily<?> to, Family<?> from) {
                if (to == null || from == null) {
                    return;
                }
                for (BasicElement element2 : from) {
                    this.copy((BasicModElement)to.createNewOne(), element2);
                }
            }
        });
        return modModel;
    }

    private static String escape(String s2) {
        return StringUtil.replace((String)s2, ESCAPES.get(0), ESCAPES.get(1));
    }

    private static String unescape(String s2) {
        return StringUtil.replace((String)s2, ESCAPES.get(1), ESCAPES.get(0));
    }

    public static TreePattern parse(@NotNull Dbms dbms, String s2) {
        if (dbms == null) {
            DataSourceSchemasPanel.$$$reportNull$$$0(2);
        }
        ArrayList<String> dbs = new ArrayList<String>();
        ArrayList schs = new ArrayList();
        int dbPos = s2.length();
        while (dbPos > 0) {
            int dbEnd2;
            int curDbPos = DataSourceSchemasPanel.lastIndexOf(s2, '|', dbPos - 1) + 1;
            int dbEnd = DataSourceSchemasPanel.lastIndexOf(s2, ':', dbPos - 1, curDbPos);
            int n = dbEnd2 = dbEnd == -1 ? -1 : DataSourceSchemasPanel.lastIndexOf(s2, ':', dbEnd - 1, curDbPos);
            if (dbEnd != -1 && dbEnd2 == -1) {
                dbs.add(DataSourceSchemasPanel.unescape(s2.substring(curDbPos, dbEnd)));
                LinkedHashSet<String> ss2 = new LinkedHashSet<String>();
                schs.add(ss2);
                int schPos = dbPos;
                while (schPos > 0) {
                    int curSchPos = DataSourceSchemasPanel.lastIndexOf(s2, ',', schPos - 1, dbEnd);
                    String sch = DataSourceSchemasPanel.unescape(s2.substring(Math.max(dbEnd, curSchPos) + 1, schPos));
                    if (!sch.isEmpty()) {
                        ss2.add(sch);
                    }
                    schPos = curSchPos;
                }
            }
            dbPos = curDbPos - 1;
        }
        MultiMap state = MultiMap.create();
        for (int i2 = dbs.size() - 1; i2 >= 0; --i2) {
            state.putValues((Object)((String)dbs.get(i2)), (Collection)schs.get(i2));
        }
        return TreePatternUtils.fromScopeMap(DbImplUtilCore.getMetaModel(dbms), (MultiMap<String, String>)state);
    }

    public static String serialize(TreePattern scope) {
        StringBuilder res2 = new StringBuilder();
        TreePatternNode.Group dbG = scope.root.getGroup(ObjectKind.DATABASE);
        if (dbG == null) {
            TreePatternNode.Group scG = scope.root.getGroup(ObjectKind.SCHEMA);
            if (scG != null) {
                DataSourceSchemasPanel.serializeSchemas(res2, "*", scG);
            }
        } else {
            Object scG;
            if (dbG.positiveChildren != null) {
                scG = dbG.positiveChildren;
                int n = ((TreePatternNode<TreePatternNode.PositiveNaming>[])scG).length;
                for (int j = 0; j < n; ++j) {
                    TreePatternNode<TreePatternNode.PositiveNaming> child = scG[j];
                    TreePatternNode.Group scG2 = child.getGroup(ObjectKind.SCHEMA);
                    if (scG2 == null) continue;
                    for (ObjectName name : ((TreePatternNode.BaseNaming)child.naming).names) {
                        DataSourceSchemasPanel.serializeSchemas(res2, name.name, scG2);
                    }
                }
            }
            if (dbG.negativeChild != null && (scG = dbG.negativeChild.getGroup(ObjectKind.SCHEMA)) != null) {
                DataSourceSchemasPanel.serializeSchemas(res2, "*", scG);
            }
        }
        return res2.toString();
    }

    private static void serializeSchemas(StringBuilder res2, @NotNull String db, @NotNull TreePatternNode.Group scG) {
        if (db == null) {
            DataSourceSchemasPanel.$$$reportNull$$$0(3);
        }
        if (scG == null) {
            DataSourceSchemasPanel.$$$reportNull$$$0(4);
        }
        if (res2.length() != 0) {
            res2.append('|');
        }
        res2.append(DataSourceSchemasPanel.escape(db)).append(':');
        int l = res2.length();
        for (String sch : JBIterable.of((Object[])scG.positiveChildren).flatten(n -> JBIterable.of((Object[])((TreePatternNode.PositiveNaming)n.naming).names).map(ObjectName::name)).append((Object)(scG.negativeChild == null ? null : "*"))) {
            if (res2.length() != l) {
                res2.append(',');
            }
            res2.append(DataSourceSchemasPanel.escape(sch));
        }
    }

    private static int lastIndexOf(String s2, char c2, int from) {
        return DataSourceSchemasPanel.lastIndexOf(s2, c2, from, 0);
    }

    private static int lastIndexOf(String s2, char c2, int from, int to) {
        while (from >= to) {
            char cur2 = s2.charAt(from);
            --from;
            if (cur2 != c2) continue;
            int pos = from + 1;
            int slashes = 0;
            while (from >= to && (cur2 = s2.charAt(from)) == '\\') {
                ++slashes;
                --from;
            }
            if (slashes % 2 != 0) continue;
            return pos;
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "db";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scG";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dataSource/DataSourceSchemasPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "saveSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "reset";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "parse";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "serializeSchemas";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myRoot = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.mySchemasPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(8, 12, 8, 12), null, 0, 0, null, null));
        ExpandableTextField expandableTextField = this.myObjectFilter;
        jPanel3.add((Component)expandableTextField, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceSchemasPanel.class).getString("data.source.object.filter.label"));
        jPanel3.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        TextFieldWithAutoCompletion<Pair<String, ObjectKind>> textFieldWithAutoCompletion = this.mySchemaPattern;
        jPanel3.add((Component)textFieldWithAutoCompletion, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceSchemasPanel.class).getString("data.source.editor.schema.pattern.label"));
        jPanel3.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c2 = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private class MyCompletion
    extends TextFieldWithAutoCompletionListProvider<Pair<String, ObjectKind>> {
        protected MyCompletion() {
            super(null);
        }

        @Nullable
        public String getPrefix(@NotNull String text2, int offset) {
            if (text2 == null) {
                MyCompletion.$$$reportNull$$$0(0);
            }
            int last = Math.max(DataSourceSchemasPanel.lastIndexOf(text2, '|', offset - 1), Math.max(DataSourceSchemasPanel.lastIndexOf(text2, ':', offset - 1), DataSourceSchemasPanel.lastIndexOf(text2, ',', offset - 1)));
            return text2.substring(Math.max(0, last + 1), offset);
        }

        @Nullable
        protected String getTailText(@NotNull Pair<String, ObjectKind> item) {
            if (item == null) {
                MyCompletion.$$$reportNull$$$0(1);
            }
            return "*".equals(item.first) ? "  All " + StringUtil.pluralize((String)((ObjectKind)item.second).code()) : ("@".equals(item.first) ? "  Current " + ((ObjectKind)item.second).code() : null);
        }

        @Nullable
        protected Icon getIcon(@NotNull Pair<String, ObjectKind> item) {
            if (item == null) {
                MyCompletion.$$$reportNull$$$0(2);
            }
            return DbPresentationCore.getIcon((ObjectKind)item.second);
        }

        @NotNull
        protected String getLookupString(@NotNull Pair<String, ObjectKind> item) {
            if (item == null) {
                MyCompletion.$$$reportNull$$$0(3);
            }
            String string = (String)item.first;
            if (string == null) {
                MyCompletion.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public Collection<Pair<String, ObjectKind>> getItems(String prefix, boolean cached, CompletionParameters parameters) {
            JBIterable schs;
            int offset = parameters.getOffset();
            String text2 = parameters.getEditor().getDocument().getText();
            int dbPos = DataSourceSchemasPanel.lastIndexOf(text2, '|', offset - 1);
            int scPos = Math.max(DataSourceSchemasPanel.lastIndexOf(text2, ':', offset - 1), DataSourceSchemasPanel.lastIndexOf(text2, ',', offset - 1));
            boolean isDb = scPos == -1 || scPos < dbPos;
            DataSourceScopeEditorTree.MyNode root2 = DataSourceSchemasPanel.this.myScopeEditor.getRoot();
            if (isDb) {
                JBIterable dbs = root2.findChild(ObjectKind.DATABASE) == null ? JBIterable.empty() : JBIterable.from(root2.getChildNodes()).transform(DataSourceScopeEditor::getNodeName).filter(Conditions.notNull());
                Set set = JBIterable.of((Object[])new String[]{"*", "@"}).append((Iterable)dbs).transform(n -> Pair.create((Object)n, (Object)ObjectKind.DATABASE)).toSet();
                if (set == null) {
                    MyCompletion.$$$reportNull$$$0(5);
                }
                return set;
            }
            String dbName = text2.substring(0, scPos);
            if (root2.findChild(ObjectKind.DATABASE) == null) {
                schs = JBIterable.from(root2.getChildNodes()).transform(DataSourceScopeEditor::getNodeName);
            } else {
                DbCheckBoxTree.MyNode db = "*".equals(dbName) || "@".equals(dbName) ? null : (DataSourceScopeEditorTree.MyNode)JBIterable.from(root2.getChildNodes()).find(n -> dbName.equals(DataSourceScopeEditor.getNodeName(n)));
                schs = (db == null ? JBIterable.from(root2.getChildNodes()).flatten(DbCheckBoxTree.MyNode::getChildNodes) : JBIterable.from(db.getChildNodes())).transform(DataSourceScopeEditor::getNodeName);
            }
            Set set = JBIterable.of((Object[])new String[]{"*", "@"}).append((Iterable)schs).transform(n -> Pair.create((Object)n, (Object)ObjectKind.SCHEMA)).toSet();
            if (set == null) {
                MyCompletion.$$$reportNull$$$0(6);
            }
            return set;
        }

        @NotNull
        public LookupElementBuilder createLookupBuilder(@NotNull Pair<String, ObjectKind> item) {
            if (item == null) {
                MyCompletion.$$$reportNull$$$0(7);
            }
            String text2 = this.getLookupString(item);
            LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create(item, (String)DataSourceSchemasPanel.escape(text2)).withLookupString(text2).withPresentableText(text2).withIcon(this.getIcon(item)).withTailText(this.getTailText(item), true);
            if (lookupElementBuilder == null) {
                MyCompletion.$$$reportNull$$$0(8);
            }
            return lookupElementBuilder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DataSourceSchemasPanel$MyCompletion";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DataSourceSchemasPanel$MyCompletion";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLookupString";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getItems";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createLookupBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPrefix";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getTailText";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getIcon";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getLookupString";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createLookupBuilder";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyScopeEditor
    extends DataSourceScopeEditor {
        MyScopeEditor(DataSourceConfigurable dialog2) {
            super(dialog2.getProject());
            ((DataSourceScopeEditorTree)this.getTree()).addCheckboxTreeListener(new CheckboxTreeListener(){

                public void beforeNodeStateChanged(@NotNull CheckedTreeNode node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    MyScopeEditor.this.beforeStateChanged();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/DataSourceSchemasPanel$MyScopeEditor$1", "beforeNodeStateChanged"));
                }
            });
        }

        @Override
        @NotNull
        public DataSourceSchemaMapping getSchemaMapping() {
            this.mySchemaMapping.setIntrospectionScope(this.getScope());
            DataSourceSchemaMapping dataSourceSchemaMapping = this.mySchemaMapping;
            if (dataSourceSchemaMapping == null) {
                MyScopeEditor.$$$reportNull$$$0(0);
            }
            return dataSourceSchemaMapping;
        }

        @Override
        protected void handleIntrospectionError(@Nullable String msg) {
            if (msg == null) {
                DataSourceSchemasPanel.this.myDialog.getController().showErrorNotification(DataSourceSchemasPanel.this.myDialog, DataSourceSchemasPanel.INTROSPECTION_ERROR, null);
            } else {
                DataSourceSchemasPanel.this.myDialog.getController().showErrorNotification(DataSourceSchemasPanel.this.myDialog, DataSourceSchemasPanel.INTROSPECTION_ERROR, "Error", msg, new Object[0]);
            }
        }

        @Override
        @Nullable
        protected LocalDataSource getDataSource(boolean withCredentials) {
            if (!withCredentials) {
                return DataSourceSchemasPanel.this.myDialog.getTempDataSource();
            }
            LocalDataSource dataSource2 = DataSourceSchemasPanel.this.myDialog.getTempDataSourceForConnection();
            if (this.myModel != ((LocalDataSource)DataSourceSchemasPanel.this.myDialog.getDataSource()).getModel() && this.myModel != null) {
                dataSource2.setModel(this.myModel);
            }
            return dataSource2;
        }

        @Override
        protected void onIntrospectionFinished(LocalDataSource dataSource2) {
            if (!DataSourceSchemasPanel.this.myTreeDirty && DataSourceSchemasPanel.this.mySchemaPatternScope.isEmpty() && !dataSource2.getIntrospectionScope().isEmpty()) {
                this.setScopes(dataSource2.getIntrospectionScope(), dataSource2.getIntrospectionScope());
            }
            super.onIntrospectionFinished(dataSource2);
        }

        @Override
        @NotNull
        protected DatabaseCredentials getCredentials() {
            DatabaseCredentials databaseCredentials = DataSourceSchemasPanel.this.myDialog.getSecretService();
            if (databaseCredentials == null) {
                MyScopeEditor.$$$reportNull$$$0(1);
            }
            return databaseCredentials;
        }

        @Override
        protected void onStateChanged() {
            if (DataSourceSchemasPanel.this.myTreeDirty) {
                this.updateTreeScope();
            }
        }

        @Override
        @NotNull
        protected Dbms getDbms() {
            Dbms dbms = ((LocalDataSource)DataSourceSchemasPanel.this.myDialog.getDataSource()).getDbms();
            if (dbms == null) {
                MyScopeEditor.$$$reportNull$$$0(2);
            }
            return dbms;
        }

        @Override
        @NotNull
        protected JComponent createNorthPanel() {
            JPanel northPanel = new JPanel(new BorderLayout());
            ActionToolbar toolbar2 = ActionManager.getInstance().createActionToolbar("DbSourceSchemas", (ActionGroup)this.createTreeActions(), true);
            toolbar2.setTargetComponent((JComponent)this.getTree());
            northPanel.add((Component)toolbar2.getComponent(), "West");
            northPanel.add((Component)this.getFilteringTree().installSearchField(), "East");
            JPanel jPanel = northPanel;
            if (jPanel == null) {
                MyScopeEditor.$$$reportNull$$$0(3);
            }
            return jPanel;
        }

        @Override
        protected void beforeStateChanged() {
            if (!DataSourceSchemasPanel.this.myUpdatingTree && !DataSourceSchemasPanel.this.myUpdatingField) {
                DataSourceSchemasPanel.this.myScopeFromField = false;
            }
            DataSourceSchemasPanel.this.myTreeDirty = true;
        }

        @Override
        protected void onSetScopeReady() {
            this.updateTreeScope();
        }

        private TreePattern getScope() {
            if (DataSourceSchemasPanel.this.myScopeFromField) {
                return DataSourceSchemasPanel.this.mySchemaPatternScope;
            }
            if (DataSourceSchemasPanel.this.myTreeDirty) {
                this.updateTreeScope();
            }
            return this.mySelectedScope;
        }

        private void updateTreeScope() {
            DataSourceSchemasPanel.this.myTreeDirty = false;
            TreePattern scope = this.getEditorState();
            if (scope.equals(this.mySelectedScope)) {
                return;
            }
            this.mySelectedScope = scope;
            if (!DataSourceSchemasPanel.this.myScopeFromField) {
                this.setFieldScope(scope, true);
            }
        }

        private void resetFieldScope(TreePattern scope) {
            DataSourceSchemasPanel.this.myScopeFromField = true;
            this.setFieldScope(scope, true);
        }

        private void setFieldScope(TreePattern scope, boolean updateText) {
            if (DataSourceSchemasPanel.this.myUpdatingField) {
                return;
            }
            DataSourceSchemasPanel.this.myUpdatingField = true;
            try {
                DataSourceSchemasPanel.this.mySchemaPatternScope = scope;
                if (updateText) {
                    DataSourceSchemasPanel.this.mySchemaPattern.setText(DataSourceSchemasPanel.serialize(scope));
                }
                if (DataSourceSchemasPanel.this.myScopeFromField) {
                    this.setTreeScope(scope);
                }
            }
            finally {
                DataSourceSchemasPanel.this.myUpdatingField = false;
            }
        }

        private void setTreeScope(TreePattern scope) {
            if (DataSourceSchemasPanel.this.myUpdatingTree) {
                return;
            }
            DataSourceSchemasPanel.this.myUpdatingTree = true;
            try {
                this.setScopes(scope, DataSourceSchemasPanel.this.myUpdatingField ? scope : null);
            }
            finally {
                DataSourceSchemasPanel.this.myUpdatingTree = false;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/dataSource/DataSourceSchemasPanel$MyScopeEditor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSchemaMapping";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCredentials";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDbms";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNorthPanel";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

