/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.NameVersion;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.RemoteDatabaseMetaData;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class DataSourceInfo {
    @NotNull
    public NameVersion databaseVersion = NameVersion.UNKNOWN;
    @NotNull
    public NameVersion driverVersion = NameVersion.UNKNOWN;
    @NotNull
    public String jdbcVersion = DasUtil.NO_NAME;
    @Nullable
    public String identifierQuoteString;
    @Nullable
    public String extraNameCharacters;
    @NotNull
    public Casing casing = DasUtil.CASING_MIXED;
    public Dbms dbms;
    public Version exactVersion;
    public Version exactDriverVersion;

    DataSourceInfo() {
    }

    void copyFrom(@NotNull DataSourceInfo info) {
        if (info == null) {
            DataSourceInfo.$$$reportNull$$$0(0);
        }
        this.databaseVersion = info.databaseVersion;
        this.driverVersion = info.driverVersion;
        this.jdbcVersion = info.jdbcVersion;
        this.identifierQuoteString = info.identifierQuoteString;
        this.extraNameCharacters = info.extraNameCharacters;
        this.casing = info.casing;
        this.dbms = info.dbms;
        this.exactVersion = info.exactVersion;
        this.exactDriverVersion = info.exactDriverVersion;
    }

    public static void refreshDatabaseInfo(@NotNull LocalDataSource dataSource2, @Nullable DatabaseConnection connection2) {
        if (dataSource2 == null) {
            DataSourceInfo.$$$reportNull$$$0(1);
        }
        if (connection2 == null) {
            return;
        }
        DataSourceInfo.resetDatabaseInfo(dataSource2.getInfo(), connection2);
    }

    private static void resetDatabaseInfo(@NotNull DataSourceInfo info, @NotNull DatabaseConnection connection2) {
        if (info == null) {
            DataSourceInfo.$$$reportNull$$$0(2);
        }
        if (connection2 == null) {
            DataSourceInfo.$$$reportNull$$$0(3);
        }
        RemoteDatabaseMetaData metaData = (RemoteDatabaseMetaData)JdbcNativeUtil.computeSafe(connection2::getRemoteMetaData);
        info.dbms = connection2.getDbms();
        info.exactVersion = connection2.getVersion();
        info.exactDriverVersion = connection2.getDriverVersion();
        if (metaData == null) {
            info.copyFrom(new DataSourceInfo());
            return;
        }
        info.databaseVersion = new NameVersion((String)JdbcNativeUtil.computeSafe(() -> ((RemoteDatabaseMetaData)metaData).getDatabaseProductName()), (String)JdbcNativeUtil.computeSafe(() -> ((RemoteDatabaseMetaData)metaData).getDatabaseProductVersion()));
        info.driverVersion = new NameVersion((String)JdbcNativeUtil.computeSafe(() -> ((RemoteDatabaseMetaData)metaData).getDriverName()), (String)JdbcNativeUtil.computeSafe(() -> ((RemoteDatabaseMetaData)metaData).getDriverVersion()));
        try {
            info.jdbcVersion = metaData.getJDBCMajorVersion() + "." + metaData.getJDBCMinorVersion();
        }
        catch (Throwable e) {
            try {
                metaData.getConnection();
                info.jdbcVersion = "2.1";
            }
            catch (Throwable e1) {
                info.jdbcVersion = "1.2";
            }
        }
        info.identifierQuoteString = (String)JdbcNativeUtil.computeSafe(() -> ((RemoteDatabaseMetaData)metaData).getIdentifierQuoteString());
        info.extraNameCharacters = (String)JdbcNativeUtil.computeSafe(() -> ((RemoteDatabaseMetaData)metaData).getExtraNameCharacters());
        if (StringUtil.isEmptyOrSpaces((String)info.identifierQuoteString)) {
            info.identifierQuoteString = null;
        }
        if (StringUtil.isEmptyOrSpaces((String)info.extraNameCharacters)) {
            info.extraNameCharacters = null;
        }
        try {
            info.casing = DataSourceInfo.getCasing(info.dbms, metaData);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NotNull
    public static DetectedDbms getDetected(@NotNull RemoteConnection connection2) {
        if (connection2 == null) {
            DataSourceInfo.$$$reportNull$$$0(4);
        }
        String dbms = (String)JdbcNativeUtil.computeSafe(() -> ((RemoteConnection)connection2).getDetectedDbmsName());
        String ver = (String)JdbcNativeUtil.computeSafe(() -> ((RemoteConnection)connection2).getDetectedDbmsVersion());
        String driverVersion = (String)JdbcNativeUtil.computeSafe(() -> ((RemoteConnection)connection2).getDriverVersion());
        return new DetectedDbms(Dbms.fromString((String)dbms), (Version)ObjectUtils.notNull((Object)Version.parse((String)ver), (Object)Version.ZERO), (Version)ObjectUtils.notNull((Object)Version.parse((String)driverVersion), (Object)Version.ZERO));
    }

    static void initDbmsFromJdbc(@NotNull LocalDataSource dataSource2, @NotNull DataSourceInfo info) {
        if (dataSource2 == null) {
            DataSourceInfo.$$$reportNull$$$0(5);
        }
        if (info == null) {
            DataSourceInfo.$$$reportNull$$$0(6);
        }
        info.dbms = DataSourceInfo.forDataSource(dataSource2);
        JdbcHelper helper = DbImplUtilCore.getJdbcHelper(info.dbms);
        Version v = Version.parse((String)helper.parseVersion(info.databaseVersion.version));
        info.exactVersion = v == null ? Version.ZERO : v;
        info.exactDriverVersion = Version.ZERO;
    }

    @TestOnly
    public static void reset(@NotNull LocalDataSource dataSource2) {
        if (dataSource2 == null) {
            DataSourceInfo.$$$reportNull$$$0(7);
        }
        dataSource2.getInfo().copyFrom(new DataSourceInfo());
    }

    @NotNull
    public static Dbms forDataSource(@NotNull DasDataSource o) {
        Dbms result;
        if (o == null) {
            DataSourceInfo.$$$reportNull$$$0(8);
        }
        if ((result = DataSourceInfo.fromJdbcData(o)) == Dbms.UNKNOWN) {
            DatabaseDriver driver;
            DatabaseDriver databaseDriver = driver = o instanceof DatabaseConnectionPoint ? ((DatabaseConnectionPoint)o).getDatabaseDriver() : null;
            if (driver != null) {
                result = DbImplUtil.getDbms(driver);
            }
        }
        if (result == Dbms.UNKNOWN && o instanceof RawConnectionConfig) {
            result = Dbms.forConnection((RawConnectionConfig)((RawConnectionConfig)o));
        }
        Dbms dbms = result;
        if (dbms == null) {
            DataSourceInfo.$$$reportNull$$$0(9);
        }
        return dbms;
    }

    private static Dbms fromJdbcData(@NotNull DasDataSource o) {
        if (o == null) {
            DataSourceInfo.$$$reportNull$$$0(10);
        }
        NameVersion p2 = o.getDatabaseVersion();
        Dbms result = Dbms.fromString((String)p2.version);
        if (result == Dbms.UNKNOWN) {
            result = Dbms.fromString((String)p2.name);
        }
        if (result == Dbms.POSTGRES) {
            String driverId;
            DatabaseDriver driver = o instanceof DatabaseConnectionPoint ? ((DatabaseConnectionPoint)o).getDatabaseDriver() : null;
            String string = driverId = driver == null ? null : driver.getId();
            if (driverId != null && StringUtil.containsIgnoreCase((String)driverId, (String)Dbms.GREENPLUM.getName())) {
                result = Dbms.GREENPLUM;
            } else {
                com.intellij.openapi.util.Version version;
                com.intellij.openapi.util.Version version2 = version = p2.version != null && p2.version.contains("8") ? com.intellij.openapi.util.Version.parseVersion((String)p2.version) : null;
                if (version != null && version.major == 8 && version.bugfix == 2) {
                    result = Dbms.REDSHIFT;
                }
            }
        }
        return result;
    }

    @NotNull
    public static Casing getCasing(@NotNull Dbms dbms, @NotNull RemoteDatabaseMetaData metaData) {
        if (dbms == null) {
            DataSourceInfo.$$$reportNull$$$0(11);
        }
        if (metaData == null) {
            DataSourceInfo.$$$reportNull$$$0(12);
        }
        boolean supportsMixedCase = JdbcNativeUtil.getBooleanSafe(() -> ((RemoteDatabaseMetaData)metaData).supportsMixedCaseIdentifiers());
        boolean storesUpperCase = JdbcNativeUtil.getBooleanSafe(() -> ((RemoteDatabaseMetaData)metaData).storesUpperCaseIdentifiers());
        boolean storesLowerCase = JdbcNativeUtil.getBooleanSafe(() -> ((RemoteDatabaseMetaData)metaData).storesLowerCaseIdentifiers());
        boolean storesMixedCase = JdbcNativeUtil.getBooleanSafe(() -> ((RemoteDatabaseMetaData)metaData).storesMixedCaseIdentifiers());
        boolean supportsMixedCaseQuoted = JdbcNativeUtil.getBooleanSafe(() -> ((RemoteDatabaseMetaData)metaData).supportsMixedCaseQuotedIdentifiers());
        boolean storesUpperCaseQuoted = JdbcNativeUtil.getBooleanSafe(() -> ((RemoteDatabaseMetaData)metaData).storesUpperCaseQuotedIdentifiers());
        boolean storesLowerCaseQuoted = JdbcNativeUtil.getBooleanSafe(() -> ((RemoteDatabaseMetaData)metaData).storesLowerCaseQuotedIdentifiers());
        boolean storesMixedCaseQuoted = JdbcNativeUtil.getBooleanSafe(() -> ((RemoteDatabaseMetaData)metaData).storesMixedCaseQuotedIdentifiers());
        Case plain = DataSourceInfo.getCaseMode(dbms, supportsMixedCase, storesLowerCase, storesUpperCase, storesMixedCase);
        Case quoted = DataSourceInfo.getCaseMode(dbms, supportsMixedCaseQuoted, storesLowerCaseQuoted, storesUpperCaseQuoted, storesMixedCaseQuoted);
        Casing casing = Casing.create((Case)plain, (Case)quoted);
        if (casing == null) {
            DataSourceInfo.$$$reportNull$$$0(13);
        }
        return casing;
    }

    @NotNull
    public static Case getCaseMode(@NotNull Dbms dbms, boolean sensitive, boolean forceLower, boolean forceUpper, boolean asIs) {
        if (dbms == null) {
            DataSourceInfo.$$$reportNull$$$0(14);
        }
        if (sensitive && asIs) {
            Case case_ = dbms.isSqlite() || dbms.isMicrosoft() ? Case.MIXED : Case.EXACT;
            if (case_ == null) {
                DataSourceInfo.$$$reportNull$$$0(15);
            }
            return case_;
        }
        Case case_ = asIs && (dbms.isSybase() || dbms == Dbms.IGNITE) || sensitive ? Case.EXACT : (forceLower ? Case.LOWER : (forceUpper && !dbms.isMysql() ? Case.UPPER : Case.MIXED));
        if (case_ == null) {
            DataSourceInfo.$$$reportNull$$$0(16);
        }
        return case_;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 13: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 13: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 9: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DataSourceInfo";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceInfo";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "forDataSource";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasing";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaseMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "refreshDatabaseInfo";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resetDatabaseInfo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDetected";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "initDbmsFromJdbc";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "forDataSource";
                break;
            }
            case 9: 
            case 13: 
            case 15: 
            case 16: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fromJdbcData";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCasing";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getCaseMode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 13: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class DetectedDbms {
        public final Dbms dbms;
        public final Version version;
        public final Version driverVersion;

        private DetectedDbms(@NotNull Dbms dbms, @NotNull Version version, @NotNull Version driverVersion) {
            if (dbms == null) {
                DetectedDbms.$$$reportNull$$$0(0);
            }
            if (version == null) {
                DetectedDbms.$$$reportNull$$$0(1);
            }
            if (driverVersion == null) {
                DetectedDbms.$$$reportNull$$$0(2);
            }
            this.dbms = dbms;
            this.version = version;
            this.driverVersion = driverVersion;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dbms";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "version";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "driverVersion";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dataSource/DataSourceInfo$DetectedDbms";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

