/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types;

import com.intellij.database.data.types.LogicalType;
import com.intellij.database.extractors.tz.TimeZonedTime;
import com.intellij.database.extractors.tz.TimeZonedTimestamp;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import org.jetbrains.annotations.NotNull;

public final class ConversionPoint<T> {
    public static final ConversionPoint<TimeZonedTimestamp> TIMESTAMP_WITH_TIMEZONE = new ConversionPoint<TimeZonedTimestamp>("TIMESTAMP WITH TIMEZONE", LogicalType.TIMESTAMP_WITH_TIMEZONE, TimeZonedTimestamp.class);
    public static final ConversionPoint<TimeZonedTime> TIME_WITH_TIMEZONE = new ConversionPoint<TimeZonedTime>("TIME WITH TIMEZONE", LogicalType.TIME_WITH_TIMEZONE, TimeZonedTime.class);
    public static final ConversionPoint<Number> BIG_DECIMAL = new ConversionPoint<Number>("BIG_DECIMAL", LogicalType.FIXED_POINT_NUMBER, Number.class);
    public static final ConversionPoint<Number> MONEY = new ConversionPoint<Number>("MONEY", LogicalType.MONEY, Number.class);
    public static final ConversionPoint<Timestamp> TIMESTAMP = new ConversionPoint<Timestamp>("TIMESTAMP", LogicalType.TIMESTAMP, Timestamp.class);
    public static final ConversionPoint<TemporalAccessor> TEMPORAL_TIMESTAMP = new ConversionPoint<TemporalAccessor>("TEMPORAL_TIMESTAMP", LogicalType.TIMESTAMP, TemporalAccessor.class);
    public static final ConversionPoint<TemporalAccessor> TEMPORAL_TIME = new ConversionPoint<TemporalAccessor>("TEMPORAL_TIME", LogicalType.TIME, TemporalAccessor.class);
    public static final ConversionPoint<String> BINARY_STRING = new ConversionPoint<String>("BINARY STRING", LogicalType.BINARY_STRING, String.class);
    public static final ConversionPoint<Number> DOUBLE_PRECISION = new ConversionPoint<Number>("DOUBLE_PRECISION", LogicalType.DOUBLE_PRECISION, Number.class);
    public static final ConversionPoint<Number> SINGLE_PRECISION = new ConversionPoint<Number>("SINGLE_PRECISION", LogicalType.SINGLE_PRECISION, Number.class);
    public static final ConversionPoint<String> TEXT = new ConversionPoint<String>("TEXT", LogicalType.TEXT, String.class);
    public static final ConversionPoint<String> TEXT_DATE = new ConversionPoint<String>("TEXT_DATE", LogicalType.DATE, String.class);
    public static final ConversionPoint<String> TEXT_TIMESTAMP = new ConversionPoint<String>("TEXT_TIMESTAMP", LogicalType.TIMESTAMP, String.class);
    public static final ConversionPoint<String> NTEXT = new ConversionPoint<String>("NTEXT", LogicalType.NTEXT, String.class);
    public static final ConversionPoint<String> BLOB_TEXT = new ConversionPoint<String>("BLOB_TEXT", LogicalType.BLOB, String.class);
    public static final ConversionPoint<String> TEXT_ID = new ConversionPoint<String>("TEXT_ID", LogicalType.TEXT_ID, String.class);
    public static final ConversionPoint<String> CLOB = new ConversionPoint<String>("CLOB", LogicalType.CLOB, String.class);
    public static final ConversionPoint<String> CHAR = new ConversionPoint<String>("CHAR", LogicalType.CHAR, String.class);
    public static final ConversionPoint<String> NCHAR = new ConversionPoint<String>("NCHAR", LogicalType.NCHAR, String.class);
    public static final ConversionPoint<String> VARCHAR = new ConversionPoint<String>("VARCHAR", LogicalType.VARCHAR, String.class);
    public static final ConversionPoint<String> NVARCHAR = new ConversionPoint<String>("NVARCHAR", LogicalType.NVARCHAR, String.class);
    public static final ConversionPoint<byte[]> BINARY = new ConversionPoint<byte[]>("BINARY", LogicalType.BINARY, byte[].class);
    public static final ConversionPoint<byte[]> BINARY_ID = new ConversionPoint<byte[]>("BINARY_ID", LogicalType.BINARY_ID, byte[].class);
    public static final ConversionPoint<byte[]> VARBINARY = new ConversionPoint<byte[]>("VARBINARY", LogicalType.VARBINARY, byte[].class);
    public static final ConversionPoint<byte[]> BLOB = new ConversionPoint<byte[]>("BLOB", LogicalType.BLOB, byte[].class);
    public static final ConversionPoint<byte[]> GRAPHIC = new ConversionPoint<byte[]>("GRAPHIC", LogicalType.GRAPHIC, byte[].class);
    public static final ConversionPoint<String> TEXT_GRAPHIC = new ConversionPoint<String>("TEXT_GRAPHIC", LogicalType.GRAPHIC, String.class);
    public static final ConversionPoint<Boolean> BOOLEAN = new ConversionPoint<Boolean>("BOOLEAN", LogicalType.BOOLEAN, Boolean.class);
    public static final ConversionPoint<Number> BOOLEAN_NUMBER = new ConversionPoint<Number>("BOOLEAN_NUMBER", LogicalType.BOOLEAN, Number.class);
    public static final ConversionPoint<Date> DATE = new ConversionPoint<Date>("DATE", LogicalType.DATE, Date.class);
    public static final ConversionPoint<Number> YEAR = new ConversionPoint<Number>("YEAR", LogicalType.YEAR, Number.class);
    public static final ConversionPoint<Time> TIME = new ConversionPoint<Time>("TIME", LogicalType.TIME, Time.class);
    public static final ConversionPoint<Number> NUMBER = new ConversionPoint<Number>("NUMBER", LogicalType.NUMBER, Number.class);
    public static final ConversionPoint<Number> UNSIGNED_NUMBER = new ConversionPoint<Number>("UNSIGNED_NUMBER", LogicalType.UNSIGNED_NUMBER, Number.class);
    public static final ConversionPoint<Number> SERIAL_NUMBER = new ConversionPoint<Number>("SERIAL_NUMBER", LogicalType.SERIAL, Number.class);
    public static final ConversionPoint<String> XML = new ConversionPoint<String>("XML", LogicalType.XML, String.class);
    public static final ConversionPoint<String> UUID = new ConversionPoint<String>("UUID", LogicalType.UUID, String.class);
    public static final ConversionPoint<String> TSVECTOR = new ConversionPoint<String>("TSVECTOR", LogicalType.TSVECTOR, String.class);
    public static final ConversionPoint<String> NUMBER_RANGE = new ConversionPoint<String>("NUMBER_RANGE", LogicalType.NUMBER_RANGE, String.class);
    public static final ConversionPoint<String> DATE_RANGE = new ConversionPoint<String>("DATE_RANGE", LogicalType.DATE_RANGE, String.class);
    public static final ConversionPoint<String> TIMESTAMP_RANGE = new ConversionPoint<String>("TIMESTAMP_RANGE", LogicalType.TIMESTAMP_RANGE, String.class);
    public static final ConversionPoint<String> TIMESTAMP_TZ_RANGE = new ConversionPoint<String>("TIMESTAMP_TZ_RANGE", LogicalType.TIMESTAMP_TZ_RANGE, String.class);
    public static final ConversionPoint<String> POINT = new ConversionPoint<String>("POINT", LogicalType.POINT, String.class);
    public static final ConversionPoint<String> INTERVAL = new ConversionPoint<String>("INTERVAL", LogicalType.INTERVAL, String.class);
    public static final ConversionPoint<String> JSON = new ConversionPoint<String>("JSON", LogicalType.JSON, String.class);
    public static final ConversionPoint<String> GEOMETRY = new ConversionPoint<String>("GEOMETRY", LogicalType.GEOMETRY, String.class);
    public static final ConversionPoint<String> GEOGRAPHY = new ConversionPoint<String>("GEOGRAPHY", LogicalType.GEOGRAPHY, String.class);
    public static final ConversionPoint<String> INET = new ConversionPoint<String>("INET", LogicalType.INET, String.class);
    public static final ConversionPoint<Object> UNKNOWN = new ConversionPoint<Object>("UNKNOWN", LogicalType.UNKNOWN, Object.class);
    private final String myName;
    private final LogicalType myLogicalType;
    private final Class<T> myClass;

    private ConversionPoint(@NotNull String name, LogicalType logicalType, Class<T> aClass) {
        if (name == null) {
            ConversionPoint.$$$reportNull$$$0(0);
        }
        this.myName = name;
        this.myLogicalType = logicalType;
        this.myClass = aClass;
    }

    @NotNull
    public LogicalType getLogicalType() {
        LogicalType logicalType = this.myLogicalType;
        if (logicalType == null) {
            ConversionPoint.$$$reportNull$$$0(1);
        }
        return logicalType;
    }

    public String toString() {
        return this.myName;
    }

    @NotNull
    public ConversionPoint<?> withClass(@NotNull Class<?> clazz) {
        if (clazz == null) {
            ConversionPoint.$$$reportNull$$$0(2);
        }
        return new ConversionPoint(this.myName, this.myLogicalType, clazz);
    }

    public boolean equals(Object obj) {
        return obj instanceof ConversionPoint && StringUtil.equals((CharSequence)this.myName, (CharSequence)((ConversionPoint)obj).myName) && Comparing.equal((Object)((Object)this.myLogicalType), (Object)((Object)((ConversionPoint)obj).myLogicalType)) && Comparing.equal(this.myClass, ((ConversionPoint)obj).myClass);
    }

    @NotNull
    public Class<T> getObjectClass() {
        Class<T> clazz = this.myClass;
        if (clazz == null) {
            ConversionPoint.$$$reportNull$$$0(3);
        }
        return clazz;
    }

    public int hashCode() {
        return this.myName.hashCode() + this.myLogicalType.hashCode() + this.myClass.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/data/types/ConversionPoint";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/data/types/ConversionPoint";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogicalType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "withClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

