/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.csv.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.ui.CsvFormatUISettings;
import com.intellij.database.csv.ui.CsvFormatsListComponent;
import com.intellij.database.csv.ui.CsvFormatsSettingsUI;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvFormatsSelectionUI
extends CsvFormatsSettingsUI {
    private final SaveActionSupport mySaveActionSupport;

    public CsvFormatsSelectionUI(@NotNull Disposable parent2, @Nullable SaveActionSupport support, @NotNull CsvFormatUISettings settings) {
        if (parent2 == null) {
            CsvFormatsSelectionUI.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            CsvFormatsSelectionUI.$$$reportNull$$$0(1);
        }
        super(false, parent2, settings);
        this.mySaveActionSupport = support;
    }

    public void notifySaved(@NotNull CsvFormat format) {
        if (format == null) {
            CsvFormatsSelectionUI.$$$reportNull$$$0(2);
        }
        this.getFormatsListComponent().markUnmodified(format);
    }

    @Override
    @NotNull
    protected ToolbarDecorator createFormatListDecorator() {
        AnActionButton action2 = new AnActionButton(() -> "", AllIcons.Actions.MenuSaveall){
            ActionGroup group;
            {
                this.group = CsvFormatsSelectionUI.this.getSaveActionsGroup();
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Component component;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((component = e.getInputEvent().getComponent()) == null) {
                    return;
                }
                ActionManager.getInstance().createActionPopupMenu("ProjectViewToolbar", this.group).getComponent().show(component, 0, component.getHeight());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/csv/ui/CsvFormatsSelectionUI$1", "actionPerformed"));
            }
        };
        action2.addCustomUpdater(e -> this.hasChanges());
        ToolbarDecorator toolbarDecorator = super.createFormatListDecorator().disableUpDownActions().addExtraAction(action2);
        if (toolbarDecorator == null) {
            CsvFormatsSelectionUI.$$$reportNull$$$0(3);
        }
        return toolbarDecorator;
    }

    @NotNull
    private ActionGroup getSaveActionsGroup() {
        abstract class SaveAction
        extends AnAction {
            SaveAction(String text2) {
                super(text2);
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    SaveAction.$$$reportNull$$$0(0);
                }
                CsvFormat selectedFormat = CsvFormatsSelectionUI.this.getSelectedFormat();
                e.getPresentation().setEnabled(CsvFormatsSelectionUI.this.mySaveActionSupport != null && selectedFormat != null && CsvFormatsSelectionUI.this.getFormatsListComponent().isModified(selectedFormat));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/csv/ui/CsvFormatsSelectionUI$1SaveAction", "update"));
            }
        }
        DefaultActionGroup saveActionsGroup = new DefaultActionGroup(new AnAction[]{new SaveAction(DatabaseBundle.message((String)"action.save.text", (Object[])new Object[0])){
            {
                super(text2);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                CsvFormatsSelectionUI.this.mySaveActionSupport.save(CsvFormatsSelectionUI.this, Objects.requireNonNull(CsvFormatsSelectionUI.this.getSelectedFormat()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/csv/ui/CsvFormatsSelectionUI$2", "actionPerformed"));
            }
        }, new SaveAction(DatabaseBundle.message((String)"action.save.as.text", (Object[])new Object[0])){
            {
                super(text2);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                CsvFormat toSaveAs = Objects.requireNonNull(CsvFormatsSelectionUI.this.getSelectedFormat());
                CsvFormatsListComponent formatsList = CsvFormatsSelectionUI.this.getFormatsListComponent();
                formatsList.resetFormat(toSaveAs.name);
                CsvFormat newFormat = formatsList.newFormat(toSaveAs);
                formatsList.editFormatName(newFormat, (Consumer<CsvFormat>)((Consumer)format -> CsvFormatsSelectionUI.this.mySaveActionSupport.save(CsvFormatsSelectionUI.this, (CsvFormat)format)));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/csv/ui/CsvFormatsSelectionUI$3", "actionPerformed"));
            }
        }, new SaveAction(DatabaseBundle.message((String)"action.save.all.text", (Object[])new Object[0])){
            {
                super(text2);
            }

            @Override
            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                e.getPresentation().setEnabled(CsvFormatsSelectionUI.this.mySaveActionSupport != null && CsvFormatsSelectionUI.this.hasChanges());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(1);
                }
                List<CsvFormat> formats = CsvFormatsSelectionUI.this.getFormats();
                DatabaseSettings.getSettings().setCsvFormats(formats);
                for (CsvFormat format : formats) {
                    CsvFormatsSelectionUI.this.getFormatsListComponent().markUnmodified(format);
                }
                DatabaseSettings.fireSettingsChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/database/csv/ui/CsvFormatsSelectionUI$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }});
        saveActionsGroup.setPopup(true);
        DefaultActionGroup defaultActionGroup = saveActionsGroup;
        if (defaultActionGroup == null) {
            CsvFormatsSelectionUI.$$$reportNull$$$0(4);
        }
        return defaultActionGroup;
    }

    private boolean hasChanges() {
        return !this.getFormats().equals(DatabaseSettings.getSettings().getCsvFormats());
    }

    @NotNull
    public static CsvFormatsSelectionUI createDatabaseSettingsBackedForm(@NotNull Disposable parent2) {
        if (parent2 == null) {
            CsvFormatsSelectionUI.$$$reportNull$$$0(5);
        }
        return CsvFormatsSelectionUI.createDatabaseSettingsBackedForm(parent2, CsvFormatUISettings.DEFAULT);
    }

    @NotNull
    public static CsvFormatsSelectionUI createDatabaseSettingsBackedForm(@NotNull Disposable parent2, @NotNull CsvFormatUISettings settings) {
        if (parent2 == null) {
            CsvFormatsSelectionUI.$$$reportNull$$$0(6);
        }
        if (settings == null) {
            CsvFormatsSelectionUI.$$$reportNull$$$0(7);
        }
        CsvFormatsSelectionUI form = new CsvFormatsSelectionUI(parent2, new DatabaseSettingsSaveActionSupport(), settings);
        form.reset(DatabaseSettings.getSettings().getCsvFormats(), null);
        CsvFormatsSelectionUI csvFormatsSelectionUI = form;
        if (csvFormatsSelectionUI == null) {
            CsvFormatsSelectionUI.$$$reportNull$$$0(8);
        }
        return csvFormatsSelectionUI;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/csv/ui/CsvFormatsSelectionUI";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/csv/ui/CsvFormatsSelectionUI";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createFormatListDecorator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSaveActionsGroup";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createDatabaseSettingsBackedForm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "notifySaved";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createDatabaseSettingsBackedForm";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DatabaseSettingsSaveActionSupport
    implements SaveActionSupport {
        private DatabaseSettingsSaveActionSupport() {
        }

        @Override
        public void save(@NotNull CsvFormatsSelectionUI form, @NotNull CsvFormat format) {
            DatabaseSettings settings;
            ArrayList<CsvFormat> formats;
            int idx;
            if (form == null) {
                DatabaseSettingsSaveActionSupport.$$$reportNull$$$0(0);
            }
            if (format == null) {
                DatabaseSettingsSaveActionSupport.$$$reportNull$$$0(1);
            }
            if ((idx = CsvFormat.indexOfFormatNamed(formats = new ArrayList<CsvFormat>((settings = DatabaseSettings.getSettings()).getCsvFormats()), format.name)) != -1) {
                formats.set(idx, format);
            } else {
                formats.add(format);
            }
            settings.setCsvFormats(formats);
            DatabaseSettings.fireSettingsChanged();
            form.notifySaved(format);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "form";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "format";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/csv/ui/CsvFormatsSelectionUI$DatabaseSettingsSaveActionSupport";
            objectArray[2] = "save";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface SaveActionSupport {
        public void save(@NotNull CsvFormatsSelectionUI var1, @NotNull CsvFormat var2);
    }
}

