/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.session;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.client.DatabaseSessionClientWithFile;
import com.intellij.database.console.client.VisibleDatabaseSessionClient;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionStateListener;
import com.intellij.database.console.session.PerProjectFileAttributes;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.session.BaseLogView;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00132\u00020\u0001:\u0004\u0013\u0014\u0015\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\nH\u0016J\"\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/console/session/GlobalSessionStateListener;", "Lcom/intellij/database/console/session/DatabaseSessionStateListener$Adapter;", "()V", "clientAttached", "", "client", "Lcom/intellij/database/console/client/VisibleDatabaseSessionClient;", "clientDetached", "clientReattached", "from", "Lcom/intellij/database/console/session/DatabaseSession;", "to", "renamed", "session", "saveSessionName", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "Companion", "SavedSession", "SavedText", "SessionSearchStrategy", "intellij.database.impl"})
public final class GlobalSessionStateListener
extends DatabaseSessionStateListener.Adapter {
    private static final FileAttribute ourLegacyAttributes;
    private static final PerProjectFileAttributes ourFileAttributes;
    @NotNull
    public static final Companion Companion;

    @Override
    public void clientAttached(@NotNull VisibleDatabaseSessionClient client) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            VisibleDatabaseSessionClient visibleDatabaseSessionClient = client;
            if (!(visibleDatabaseSessionClient instanceof DatabaseSessionClientWithFile)) {
                visibleDatabaseSessionClient = null;
            }
            DatabaseSessionClientWithFile databaseSessionClientWithFile = (DatabaseSessionClientWithFile)visibleDatabaseSessionClient;
            if (databaseSessionClientWithFile == null) break block1;
            DatabaseSessionClientWithFile databaseSessionClientWithFile2 = databaseSessionClientWithFile;
            boolean bl = false;
            boolean bl2 = false;
            DatabaseSessionClientWithFile it2 = databaseSessionClientWithFile2;
            boolean bl3 = false;
            this.saveSessionName(((DatabaseSession)it2.getSession()).getProject(), (DatabaseSession)it2.getSession(), it2.getVirtualFile());
        }
    }

    @Override
    public void clientDetached(@NotNull VisibleDatabaseSessionClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
    }

    @Override
    public void clientReattached(@NotNull VisibleDatabaseSessionClient client, @NotNull DatabaseSession from, @NotNull DatabaseSession to) {
        block1: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            VisibleDatabaseSessionClient visibleDatabaseSessionClient = client;
            if (!(visibleDatabaseSessionClient instanceof DatabaseSessionClientWithFile)) {
                visibleDatabaseSessionClient = null;
            }
            if ((object = (DatabaseSessionClientWithFile)visibleDatabaseSessionClient) == null || (object = object.getView()) == null || (object = ((BaseLogView)object).getHistoryLogger()) == null) break block1;
            ((DataAuditor.PrintingAdapter)object).print(DatabaseBundle.message((String)"notification.content.session.changed.from.to", (Object[])new Object[]{from.getTitle(), to.getTitle()}));
        }
    }

    @Override
    public void renamed(@NotNull DatabaseSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        for (DatabaseSessionClientWithFile cwf : session2.getClientsWithFile()) {
            this.saveSessionName(((DatabaseSession)cwf.getSession()).getProject(), (DatabaseSession)cwf.getSession(), cwf.getVirtualFile());
        }
    }

    private final void saveSessionName(Project project, DatabaseSession session2, VirtualFile file) {
        String string;
        if (DbImplUtil.isDatabaseVirtualFile(file)) {
            return;
        }
        if (session2 != null && SessionsUtil.needToSaveSessionName(session2, file)) {
            StringBuilder stringBuilder = new StringBuilder();
            LocalDataSource localDataSource = (LocalDataSource)session2.getTarget();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"session.target");
            string = stringBuilder.append(localDataSource.getUniqueId()).append(":").append(session2.getTitle()).toString();
        } else {
            string = null;
        }
        String sessionId = string;
        FileAttribute fileAttribute = ourFileAttributes.get(project);
        Intrinsics.checkNotNull((Object)fileAttribute);
        DbImplUtil.writeVFSAttributeSafe(file, fileAttribute, sessionId);
    }

    static {
        Companion = new Companion(null);
        ourLegacyAttributes = new FileAttribute("datasource_uuid", 2, true);
        ourFileAttributes = new PerProjectFileAttributes("database.attached.session", 1);
    }

    @JvmStatic
    @Nullable
    public static final SavedSession getSessionInfo(@NotNull Project project, @NotNull VirtualFile file) {
        return Companion.getSessionInfo(project, file);
    }

    @JvmStatic
    private static final SavedText getSavedInfo(Project project, VirtualFile file) {
        return GlobalSessionStateListener.Companion.getSavedInfo(project, file);
    }

    @JvmStatic
    private static final String getSessionNameFromFileId(Project project, String fileId) {
        return GlobalSessionStateListener.Companion.getSessionNameFromFileId(project, fileId);
    }

    @JvmStatic
    private static final VirtualFile findFile(String fileId) {
        return GlobalSessionStateListener.Companion.findFile(fileId);
    }

    @JvmStatic
    private static final SavedText parseText(String text2, boolean legacy) {
        return GlobalSessionStateListener.Companion.parseText(text2, legacy);
    }

    @JvmStatic
    private static final SessionSearchStrategy strategyFor(VirtualFile file) {
        return GlobalSessionStateListener.Companion.strategyFor(file);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u00020\u00058\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/console/session/GlobalSessionStateListener$SavedSession;", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "sessionName", "", "strict", "", "(Lcom/intellij/database/dataSource/LocalDataSource;Ljava/lang/String;Z)V", "getDataSource", "()Lcom/intellij/database/dataSource/LocalDataSource;", "getSessionName", "()Ljava/lang/String;", "getStrict", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "intellij.database.impl"})
    public static final class SavedSession {
        @NotNull
        private final LocalDataSource dataSource;
        @NotNull
        private final String sessionName;
        private final boolean strict;

        @NotNull
        public final LocalDataSource getDataSource() {
            return this.dataSource;
        }

        @Nls
        @NotNull
        public final String getSessionName() {
            return this.sessionName;
        }

        public final boolean getStrict() {
            return this.strict;
        }

        public SavedSession(@NotNull LocalDataSource dataSource2, @NotNull String sessionName, boolean strict) {
            Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
            Intrinsics.checkNotNullParameter((Object)sessionName, (String)"sessionName");
            this.dataSource = dataSource2;
            this.sessionName = sessionName;
            this.strict = strict;
        }

        @NotNull
        public final LocalDataSource component1() {
            return this.dataSource;
        }

        @NotNull
        public final String component2() {
            return this.sessionName;
        }

        public final boolean component3() {
            return this.strict;
        }

        @NotNull
        public final SavedSession copy(@NotNull LocalDataSource dataSource2, @NotNull String sessionName, boolean strict) {
            Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
            Intrinsics.checkNotNullParameter((Object)sessionName, (String)"sessionName");
            return new SavedSession(dataSource2, sessionName, strict);
        }

        public static /* synthetic */ SavedSession copy$default(SavedSession savedSession, LocalDataSource localDataSource, String string, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                localDataSource = savedSession.dataSource;
            }
            if ((n & 2) != 0) {
                string = savedSession.sessionName;
            }
            if ((n & 4) != 0) {
                bl = savedSession.strict;
            }
            return savedSession.copy(localDataSource, string, bl);
        }

        @NotNull
        public String toString() {
            return "SavedSession(dataSource=" + this.dataSource + ", sessionName=" + this.sessionName + ", strict=" + this.strict + ")";
        }

        public int hashCode() {
            LocalDataSource localDataSource = this.dataSource;
            String string = this.sessionName;
            int n = ((localDataSource != null ? ((Object)localDataSource).hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31;
            int n2 = this.strict ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SavedSession)) break block3;
                    SavedSession savedSession = (SavedSession)object;
                    if (!Intrinsics.areEqual((Object)this.dataSource, (Object)savedSession.dataSource) || !Intrinsics.areEqual((Object)this.sessionName, (Object)savedSession.sessionName) || this.strict != savedSession.strict) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J)\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/console/session/GlobalSessionStateListener$SavedText;", "", "dataSource", "", "sessionName", "legacy", "", "(Ljava/lang/String;Ljava/lang/String;Z)V", "getDataSource", "()Ljava/lang/String;", "getLegacy", "()Z", "getSessionName", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "intellij.database.impl"})
    private static final class SavedText {
        @NotNull
        private final String dataSource;
        @Nullable
        private final String sessionName;
        private final boolean legacy;

        @NotNull
        public final String getDataSource() {
            return this.dataSource;
        }

        @Nullable
        public final String getSessionName() {
            return this.sessionName;
        }

        public final boolean getLegacy() {
            return this.legacy;
        }

        public SavedText(@NotNull String dataSource2, @Nullable String sessionName, boolean legacy) {
            Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
            this.dataSource = dataSource2;
            this.sessionName = sessionName;
            this.legacy = legacy;
        }

        @NotNull
        public final String component1() {
            return this.dataSource;
        }

        @Nullable
        public final String component2() {
            return this.sessionName;
        }

        public final boolean component3() {
            return this.legacy;
        }

        @NotNull
        public final SavedText copy(@NotNull String dataSource2, @Nullable String sessionName, boolean legacy) {
            Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
            return new SavedText(dataSource2, sessionName, legacy);
        }

        public static /* synthetic */ SavedText copy$default(SavedText savedText, String string, String string2, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = savedText.dataSource;
            }
            if ((n & 2) != 0) {
                string2 = savedText.sessionName;
            }
            if ((n & 4) != 0) {
                bl = savedText.legacy;
            }
            return savedText.copy(string, string2, bl);
        }

        @NotNull
        public String toString() {
            return "SavedText(dataSource=" + this.dataSource + ", sessionName=" + this.sessionName + ", legacy=" + this.legacy + ")";
        }

        public int hashCode() {
            String string = this.dataSource;
            String string2 = this.sessionName;
            int n = ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31;
            int n2 = this.legacy ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SavedText)) break block3;
                    SavedText savedText = (SavedText)object;
                    if (!Intrinsics.areEqual((Object)this.dataSource, (Object)savedText.dataSource) || !Intrinsics.areEqual((Object)this.sessionName, (Object)savedText.sessionName) || this.legacy != savedText.legacy) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH&j\u0002\b\u000fj\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/console/session/GlobalSessionStateListener$SessionSearchStrategy;", "", "(Ljava/lang/String;I)V", "canLookForSession", "", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "savedText", "Lcom/intellij/database/console/session/GlobalSessionStateListener$SavedText;", "lookForNewSession", "Lcom/intellij/database/console/session/GlobalSessionStateListener$SavedSession;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "CONSOLE", "REGULAR", "intellij.database.impl"})
    private static final abstract class SessionSearchStrategy
    extends Enum<SessionSearchStrategy> {
        public static final /* enum */ SessionSearchStrategy CONSOLE;
        public static final /* enum */ SessionSearchStrategy REGULAR;
        private static final /* synthetic */ SessionSearchStrategy[] $VALUES;

        static {
            SessionSearchStrategy[] sessionSearchStrategyArray = new SessionSearchStrategy[2];
            SessionSearchStrategy[] sessionSearchStrategyArray2 = sessionSearchStrategyArray;
            sessionSearchStrategyArray[0] = CONSOLE = new CONSOLE("CONSOLE", 0);
            sessionSearchStrategyArray[1] = REGULAR = new REGULAR("REGULAR", 1);
            $VALUES = sessionSearchStrategyArray;
        }

        @Nullable
        public abstract SavedSession lookForNewSession(@NotNull Project var1, @NotNull VirtualFile var2);

        public abstract boolean canLookForSession(@NotNull Project var1, @NotNull LocalDataSource var2, @NotNull SavedText var3);

        private SessionSearchStrategy() {
        }

        public /* synthetic */ SessionSearchStrategy(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static SessionSearchStrategy[] values() {
            return (SessionSearchStrategy[])$VALUES.clone();
        }

        public static SessionSearchStrategy valueOf(String string) {
            return Enum.valueOf(SessionSearchStrategy.class, string);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/console/session/GlobalSessionStateListener$SessionSearchStrategy$CONSOLE;", "Lcom/intellij/database/console/session/GlobalSessionStateListener$SessionSearchStrategy;", "canLookForSession", "", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "savedText", "Lcom/intellij/database/console/session/GlobalSessionStateListener$SavedText;", "lookForNewSession", "Lcom/intellij/database/console/session/GlobalSessionStateListener$SavedSession;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.database.impl"})
        static final class CONSOLE
        extends SessionSearchStrategy {
            @Override
            @Nullable
            public SavedSession lookForNewSession(@NotNull Project project, @NotNull VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                LocalDataSource localDataSource = DbImplUtil.getMaybeLocalDataSource((DasDataSource)DbVFSUtils.getDataSource(project, file));
                if (localDataSource == null) {
                    return null;
                }
                Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"DbImplUtil.getMaybeLocal\u2026ct, file)) ?: return null");
                LocalDataSource dataSource2 = localDataSource;
                return new SavedSession(dataSource2, DatabaseSession.Companion.getTitle(project, file), false);
            }

            @Override
            public boolean canLookForSession(@NotNull Project project, @NotNull LocalDataSource dataSource2, @NotNull SavedText savedText) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
                Intrinsics.checkNotNullParameter((Object)savedText, (String)"savedText");
                return true;
            }

            /*
             * WARNING - void declaration
             */
            CONSOLE() {
                void var1_1;
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/console/session/GlobalSessionStateListener$SessionSearchStrategy$REGULAR;", "Lcom/intellij/database/console/session/GlobalSessionStateListener$SessionSearchStrategy;", "canLookForSession", "", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "savedText", "Lcom/intellij/database/console/session/GlobalSessionStateListener$SavedText;", "lookForNewSession", "Lcom/intellij/database/console/session/GlobalSessionStateListener$SavedSession;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.database.impl"})
        static final class REGULAR
        extends SessionSearchStrategy {
            @Override
            @Nullable
            public SavedSession lookForNewSession(@NotNull Project project, @NotNull VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                return null;
            }

            @Override
            public boolean canLookForSession(@NotNull Project project, @NotNull LocalDataSource dataSource2, @NotNull SavedText savedText) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
                Intrinsics.checkNotNullParameter((Object)savedText, (String)"savedText");
                if (!DbImplUtil.canConnectTo(dataSource2)) {
                    return false;
                }
                if (!savedText.getLegacy()) {
                    return true;
                }
                VirtualFile virtualFile = Companion.findFile(savedText.getSessionName());
                if (virtualFile == null) {
                    return true;
                }
                VirtualFile file = virtualFile;
                LocalDataSource consoleDataSource = DbImplUtil.getMaybeLocalDataSource((DasDataSource)DbVFSUtils.getDataSource(project, file));
                return consoleDataSource == dataSource2;
            }

            /*
             * WARNING - void declaration
             */
            REGULAR() {
                void var1_1;
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0003J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0003J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0007J\u001c\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0003J\u001c\u0010\u0013\u001a\u0004\u0018\u00010\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0003J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\bH\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/console/session/GlobalSessionStateListener$Companion;", "", "()V", "ourFileAttributes", "Lcom/intellij/database/console/session/PerProjectFileAttributes;", "ourLegacyAttributes", "Lcom/intellij/openapi/vfs/newvfs/FileAttribute;", "findFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileId", "", "getSavedInfo", "Lcom/intellij/database/console/session/GlobalSessionStateListener$SavedText;", "project", "Lcom/intellij/openapi/project/Project;", "file", "getSessionInfo", "Lcom/intellij/database/console/session/GlobalSessionStateListener$SavedSession;", "getSessionNameFromFileId", "parseText", "text", "legacy", "", "strategyFor", "Lcom/intellij/database/console/session/GlobalSessionStateListener$SessionSearchStrategy;", "intellij.database.impl"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final SavedSession getSessionInfo(@NotNull Project project, @NotNull VirtualFile file) {
            LocalDataSource dataSource2;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            SavedText savedText = this.getSavedInfo(project, file);
            SessionSearchStrategy strategy = this.strategyFor(file);
            LocalDataSource localDataSource = dataSource2 = savedText == null ? null : DbImplUtil.getMaybeLocalDataSource((DasDataSource)DbPsiFacade.getInstance((Project)project).findDataSource(savedText.getDataSource()));
            if (dataSource2 == null) {
                return strategy.lookForNewSession(project, file);
            }
            if (savedText == null) {
                return null;
            }
            if (!strategy.canLookForSession(project, dataSource2, savedText)) {
                return null;
            }
            String sessionName = savedText.getLegacy() ? this.getSessionNameFromFileId(project, savedText.getSessionName()) : savedText.getSessionName();
            String string = sessionName;
            if (string == null) {
                string = DatabaseSession.Companion.getTitle(project, file);
            }
            return new SavedSession(dataSource2, string, sessionName != null);
        }

        @JvmStatic
        private final SavedText getSavedInfo(Project project, VirtualFile file) {
            String string;
            String legacy = DbImplUtil.readVFSAttributeSafe(file, ourLegacyAttributes);
            if (legacy != null) {
                DbImplUtil.writeVFSAttributeSafe(file, ourLegacyAttributes, null);
            }
            if ((string = legacy) == null) {
                FileAttribute fileAttribute = ourFileAttributes.get(project);
                Intrinsics.checkNotNull((Object)fileAttribute);
                string = DbImplUtil.readVFSAttributeSafe(file, fileAttribute);
            }
            return this.parseText(string, legacy != null);
        }

        @JvmStatic
        private final String getSessionNameFromFileId(Project project, String fileId) {
            VirtualFile file = this.findFile(fileId);
            return file == null ? null : DatabaseSession.Companion.getTitle(project, file);
        }

        @JvmStatic
        private final VirtualFile findFile(String fileId) {
            int parsedFileId = StringUtil.parseInt((String)fileId, (int)0);
            return parsedFileId == 0 ? null : PersistentFS.getInstance().findFileById(parsedFileId);
        }

        @JvmStatic
        private final SavedText parseText(String text2, boolean legacy) {
            String string;
            String dataSourceId;
            String string2;
            int n;
            if (text2 == null) {
                return null;
            }
            int index2 = StringsKt.indexOf$default((CharSequence)text2, (char)':', (int)0, (boolean)false, (int)6, null);
            if (index2 > 0) {
                String string3 = text2;
                int n2 = 0;
                n = 0;
                String string4 = string3.substring(n2, index2);
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            } else {
                string2 = dataSourceId = text2;
            }
            if (index2 >= 0) {
                String string5 = text2;
                n = index2 + 1;
                boolean bl = false;
                String string6 = string5.substring(n);
                string = string6;
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
            } else {
                string = null;
            }
            String sessionName = string;
            return new SavedText(dataSourceId, sessionName, legacy);
        }

        @JvmStatic
        private final SessionSearchStrategy strategyFor(VirtualFile file) {
            return DbVFSUtils.isConsoleFile(file) ? SessionSearchStrategy.CONSOLE : SessionSearchStrategy.REGULAR;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

