/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.session;

import com.intellij.database.DataBus;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.run.audit.DatabaseSessionLogger;
import com.intellij.database.run.audit.SessionLogger;
import com.intellij.database.run.session.BaseLogView;
import com.intellij.database.run.session.LogViewOwner;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.SearchPath;
import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.execution.ui.layout.impl.RunnerLayoutUiImpl;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.content.Content;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.StatusText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

public abstract class DatabaseLogView<T extends LogViewOwner & DataRequest.OwnerEx>
extends BaseLogView<T>
implements Disposable {
    private static final String PROMPT = "> ";

    public DatabaseLogView(@NotNull LanguageConsoleView languageConsole, @NotNull T owner, @NotNull DatabaseServiceViewController<T> controller, @NlsContexts.StatusText @NotNull String placeholder) {
        if (languageConsole == null) {
            DatabaseLogView.$$$reportNull$$$0(0);
        }
        if (owner == null) {
            DatabaseLogView.$$$reportNull$$$0(1);
        }
        if (controller == null) {
            DatabaseLogView.$$$reportNull$$$0(2);
        }
        if (placeholder == null) {
            DatabaseLogView.$$$reportNull$$$0(3);
        }
        super(languageConsole.getProject(), languageConsole, controller, owner, ((DataRequest.OwnerEx)owner).getMessageBus());
        languageConsole.setPrompt(PROMPT);
        if (owner instanceof DataProvider) {
            this.getUi().getContentManager().addDataProvider((DataProvider)owner);
        }
        this.getUi().getOptions().setTabPopupActions((ActionGroup)ActionManager.getInstance().getAction("Console.TabPopupGroup"));
        this.ensureContentInitialized();
        ConsoleViewImpl console = (ConsoleViewImpl)languageConsole;
        console.addLayerToPane((JComponent)new PlaceholderComponent(this, console, placeholder));
    }

    public boolean shouldActivateFor(@NotNull DataRequest.Owner owner) {
        if (owner == null) {
            DatabaseLogView.$$$reportNull$$$0(4);
        }
        return owner == this.getTarget() || SessionsUtil.isInternalOwner(owner);
    }

    @Override
    protected void updatePrompt(@NotNull DataRequest.Context context) {
        SearchPath searchPath;
        if (context == null) {
            DatabaseLogView.$$$reportNull$$$0(5);
        }
        if ((searchPath = context.getSearchPath()) == null || searchPath.elements.isEmpty()) {
            this.getConsoleView().setPrompt(PROMPT);
            return;
        }
        String prompt = DbImplUtil.searchPathPresentation(searchPath.elements) + PROMPT;
        this.getConsoleView().setPrompt(StringUtil.shortenTextWithEllipsis((String)prompt, (int)35, (int)10));
    }

    @Override
    @NotNull
    protected SessionLogger createAuditor() {
        return new DatabaseSessionLogger(this);
    }

    @Override
    public void setTarget(@NotNull T target, @NotNull DataBus.Consuming bus) {
        if (target == null) {
            DatabaseLogView.$$$reportNull$$$0(6);
        }
        if (bus == null) {
            DatabaseLogView.$$$reportNull$$$0(7);
        }
        try {
            ((DatabaseServiceViewController)this.getController()).setOwner(target);
        }
        finally {
            super.setTarget(target, bus);
        }
    }

    @Override
    public void addRequestToHistory(@NotNull DataRequest.Context context) {
        boolean isRequestedQuery;
        String query;
        if (context == null) {
            DatabaseLogView.$$$reportNull$$$0(8);
        }
        boolean isNotEmpty = !StringUtil.isEmpty((String)(query = context.getQuery()));
        boolean isConsoleRequest = isNotEmpty && context.request instanceof ConsoleDataRequest;
        boolean bl = isRequestedQuery = isConsoleRequest && StringUtil.equalsIgnoreWhitespaces((CharSequence)query, (CharSequence)((ConsoleDataRequest)context.request).query);
        if (isRequestedQuery) {
            Object text2 = this.getDataSource().getDbms().isTransactSql() ? query : query + ";";
            ConsoleHistoryController.addToHistory((LanguageConsoleView)this.getConsoleView(), (String)text2);
        }
        super.addRequestToHistory(context);
    }

    @NotNull
    protected abstract LocalDataSource getDataSource();

    @Override
    protected void buildConsoleUi() {
        RunnerLayoutUi ui = this.getUi();
        ui.getDefaults().initTabDefaults(0, this.getController().id(), null);
        ui.getOptions().setMoveToGridActionEnabled(true).setMinimizeActionEnabled(false);
        if (ui instanceof RunnerLayoutUiImpl) {
            RunnerLayoutUiImpl impl = (RunnerLayoutUiImpl)ui;
            impl.setLeftToolbarVisible(false);
            impl.setContentToolbarBefore(false);
        }
        JBLoadingPanel loadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this);
        loadingPanel.setLoadingText("");
        loadingPanel.add((Component)this.getConsoleView().getComponent(), (Object)"Center");
        String title = DatabaseBundle.message((String)"jdbc.console.tab.title.console", (Object[])new Object[0]);
        JComponent toFocus = this.getConsoleView().getHistoryViewer().getContentComponent();
        Content output = ui.createContent("Input", (JComponent)loadingPanel, title, AllIcons.Debugger.Console, toFocus);
        DefaultActionGroup outputActions = new DefaultActionGroup();
        DbUIUtil.addLeftToolbarConsoleActions(outputActions, (ConsoleView)this.getConsoleView());
        output.setActions((ActionGroup)outputActions, "RunnerToolbar", this.getConsoleView().getComponent());
        this.getConsoleView().setConsoleEditorEnabled(false);
        output.setCloseable(false);
        ui.addContent(output, 0, PlaceInGrid.center, false);
    }

    @NotNull
    public List<AnAction> getActions() {
        if (!this.isValid()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                DatabaseLogView.$$$reportNull$$$0(9);
            }
            return list;
        }
        ArrayList<AnAction> consoleActions = new ArrayList<AnAction>();
        ActionManager actionManager = ActionManager.getInstance();
        AnAction specificActionGroup = actionManager.getAction("Console.Dialect.SpecificGroup");
        if (specificActionGroup != null) {
            consoleActions.add(specificActionGroup);
        }
        consoleActions.add((AnAction)Separator.create());
        consoleActions.add(ActionManager.getInstance().getAction("Console.Jdbc.Terminate"));
        consoleActions.add((AnAction)Separator.create());
        consoleActions.add(this.getUi().getOptions().getLayoutActions());
        for (AnAction action2 : consoleActions) {
            action2.registerCustomShortcutSet(action2.getShortcutSet(), this.getUi().getComponent());
        }
        ArrayList<AnAction> arrayList = consoleActions;
        if (arrayList == null) {
            DatabaseLogView.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @Override
    protected void onLineBreak(@NotNull LanguageConsoleView console) {
        String prompt;
        if (console == null) {
            DatabaseLogView.$$$reportNull$$$0(11);
        }
        String indent = StringUtil.repeat((String)" ", (int)((prompt = console.getPrompt()) == null ? 0 : prompt.length()));
        console.print(indent, ConsoleViewContentType.USER_INPUT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageConsole";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeholder";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/session/DatabaseLogView";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/session/DatabaseLogView";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "shouldActivateFor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updatePrompt";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setTarget";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addRequestToHistory";
                break;
            }
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "onLineBreak";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PlaceholderComponent
    extends JPanel {
        private final ConsoleViewImpl myConsole;
        private final StatusText myStatusText;

        PlaceholderComponent(@NotNull Disposable parent2, @NotNull ConsoleViewImpl console, @NlsContexts.StatusText @NotNull String text2) {
            if (parent2 == null) {
                PlaceholderComponent.$$$reportNull$$$0(0);
            }
            if (console == null) {
                PlaceholderComponent.$$$reportNull$$$0(1);
            }
            if (text2 == null) {
                PlaceholderComponent.$$$reportNull$$$0(2);
            }
            final Disposable disposable2 = Disposer.newDisposable();
            Disposer.register((Disposable)parent2, (Disposable)disposable2);
            this.myConsole = console;
            this.myStatusText = new StatusText(this){

                protected boolean isStatusVisible() {
                    Editor editor = myConsole.getEditor();
                    return editor != null && editor.getDocument().getTextLength() == 0;
                }
            };
            this.myStatusText.setText(text2);
            Editor editor = this.myConsole.getEditor();
            if (editor != null) {
                editor.getDocument().addDocumentListener(new DocumentListener(){

                    public void documentChanged(@NotNull DocumentEvent event) {
                        if (event == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        DbUIUtil.invokeLaterIfNeeded(() -> {
                            Container parent2 = this.getParent();
                            if (parent2 != null) {
                                parent2.remove(this);
                            }
                        });
                        Disposer.dispose((Disposable)disposable2);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/console/session/DatabaseLogView$PlaceholderComponent$2", "documentChanged"));
                    }
                }, disposable2);
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.myStatusText.paint((Component)this, g);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "console";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/console/session/DatabaseLogView$PlaceholderComponent";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static abstract class DatabaseServiceViewController<T extends LogViewOwner>
    implements BaseLogView.LogViewController {
        private T myOwner;

        DatabaseServiceViewController(@NotNull T owner) {
            if (owner == null) {
                DatabaseServiceViewController.$$$reportNull$$$0(0);
            }
            this.myOwner = owner;
        }

        protected void setOwner(@NotNull T owner) {
            if (owner == null) {
                DatabaseServiceViewController.$$$reportNull$$$0(1);
            }
            this.myOwner = owner;
        }

        @Override
        @NotNull
        public Promise<Void> show(@NotNull BaseLogView<?> view2, boolean activate, boolean requestFocus) {
            if (view2 == null) {
                DatabaseServiceViewController.$$$reportNull$$$0(2);
            }
            view2.ensureContentInitialized();
            EditorColorsUtil.updateNotInHierarchyComponentUIAndColors((Component)view2.getContent().getComponent());
            Promise<Void> promise = this.selectNode(view2.getProject(), this.myOwner, activate, requestFocus);
            if (promise == null) {
                DatabaseServiceViewController.$$$reportNull$$$0(3);
            }
            return promise;
        }

        @NotNull
        protected abstract Promise<Void> selectNode(@NotNull Project var1, @NotNull T var2, boolean var3, boolean var4);

        @Override
        @NotNull
        public String id() {
            return "not_persistent_id";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/session/DatabaseLogView$DatabaseServiceViewController";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/session/DatabaseLogView$DatabaseServiceViewController";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "show";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setOwner";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "show";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

