/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.session;

import com.intellij.database.DataBus;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.DatabaseServiceViewContributor;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.client.DatabaseSessionClientWithFile;
import com.intellij.database.console.session.DatabaseInEditorResults;
import com.intellij.database.console.session.DatabaseLogView;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.ConsoleGridDataHookUp;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.ui.PlanView;
import com.intellij.database.run.ScriptingClientDataConsumer;
import com.intellij.database.run.SqlNotebookModel;
import com.intellij.database.run.session.LogView;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.content.Content;
import com.intellij.util.ObjectUtils;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class DatabaseClientLogView
extends DatabaseLogView<DatabaseSessionClientWithFile> {
    private static final Key<PlanView> PLAN_VIEW_KEY = Key.create((String)"PlanView");
    private final List<ConsoleGridDataHookUp> myHookUps;
    private final DatabaseChooser myChooser;
    private Content myPlanContent;

    public DatabaseClientLogView(@NotNull LanguageConsoleView languageConsole, @NotNull DatabaseSessionClientWithFile owner) {
        if (languageConsole == null) {
            DatabaseClientLogView.$$$reportNull$$$0(0);
        }
        if (owner == null) {
            DatabaseClientLogView.$$$reportNull$$$0(1);
        }
        super(languageConsole, owner, new ClientLogViewController(owner), DatabaseClientLogView.getPlaceholder(owner));
        this.myHookUps = new ArrayList<ConsoleGridDataHookUp>();
        this.myChooser = new DatabaseChooser(this);
    }

    @NotNull
    public ScriptingClientDataConsumer.ResultsPlaceChooser getResultsPlaceChooser() {
        DatabaseChooser databaseChooser = this.myChooser;
        if (databaseChooser == null) {
            DatabaseClientLogView.$$$reportNull$$$0(2);
        }
        return databaseChooser;
    }

    public boolean isEmpty() {
        return this.myHookUps.isEmpty() && this.myPlanContent == null && this.getConsoleView().getHistoryViewer().getDocument().getTextLength() == 0;
    }

    @Override
    @NotNull
    protected LocalDataSource getDataSource() {
        LocalDataSource localDataSource = (LocalDataSource)((DatabaseSession)((DatabaseSessionClientWithFile)this.getTarget()).getSession()).getTarget();
        if (localDataSource == null) {
            DatabaseClientLogView.$$$reportNull$$$0(3);
        }
        return localDataSource;
    }

    public void registerHookUp(@NotNull Disposable disposable2, @NotNull ConsoleGridDataHookUp hookUp) {
        if (disposable2 == null) {
            DatabaseClientLogView.$$$reportNull$$$0(4);
        }
        if (hookUp == null) {
            DatabaseClientLogView.$$$reportNull$$$0(5);
        }
        this.myHookUps.add(hookUp);
        Disposer.register((Disposable)disposable2, () -> this.myHookUps.remove(hookUp));
    }

    public void showPlan(@Nullable PlanModel plan) {
        if (plan != null) {
            this.ensureContentInitialized();
            if (this.myPlanContent == null) {
                this.myPlanContent = this.createPlanContent();
                this.getUi().addContent(this.myPlanContent, -1, PlaceInGrid.bottom, false);
                this.getUi().setBouncing(this.myPlanContent, true);
            }
            ((PlanView)PLAN_VIEW_KEY.get((UserDataHolder)this.myPlanContent)).setModel(plan);
            this.getUi().selectAndFocus(this.myPlanContent, true, false);
        } else if (this.myPlanContent != null) {
            this.getUi().removeContent(this.myPlanContent, true);
            this.myPlanContent = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTarget(@NotNull DatabaseSessionClientWithFile target, @NotNull DataBus.Consuming bus) {
        if (target == null) {
            DatabaseClientLogView.$$$reportNull$$$0(6);
        }
        if (bus == null) {
            DatabaseClientLogView.$$$reportNull$$$0(7);
        }
        try {
            if (this.myHookUps != null) {
                for (ConsoleGridDataHookUp hookUp : this.myHookUps) {
                    hookUp.setParent(target);
                    hookUp.setSession((DatabaseSession)target.getSession());
                }
            }
        }
        finally {
            super.setTarget(target, bus);
        }
    }

    @Override
    public boolean isValid() {
        return super.isValid() && ((DatabaseSessionClientWithFile)this.getTarget()).getVirtualFile().isValid();
    }

    @NotNull
    private Content createPlanContent() {
        PlanView view2 = PlanView.createView(this.getProject());
        Content content = this.getUi().createContent("Input", view2.getComponent(), DatabaseBundle.message((String)"DatabaseClientViewLog.plan", (Object[])new Object[0]), DatabaseIcons.Table, view2.getPreferredFocusedComponent());
        content.setCloseable(true);
        PLAN_VIEW_KEY.set((UserDataHolder)content, (Object)view2);
        Disposer.register((Disposable)content, (Disposable)view2);
        Disposer.register((Disposable)content, (Disposable)new Disposable(){

            public void dispose() {
                DatabaseClientLogView.this.myPlanContent = null;
            }
        });
        Content content2 = content;
        if (content2 == null) {
            DatabaseClientLogView.$$$reportNull$$$0(8);
        }
        return content2;
    }

    @NlsContexts.StatusText
    @NotNull
    private static String getPlaceholder(@NotNull DatabaseSessionClientWithFile owner) {
        if (owner == null) {
            DatabaseClientLogView.$$$reportNull$$$0(9);
        }
        String string = DatabaseBundle.message((String)"jdbc.console.tab.title.output", (Object[])new Object[]{StringUtil.capitalize((String)owner.getDepartment().getCommonName())});
        if (string == null) {
            DatabaseClientLogView.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageConsole";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/session/DatabaseClientLogView";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hookUp";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/session/DatabaseClientLogView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultsPlaceChooser";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSource";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createPlanContent";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceholder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerHookUp";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setTarget";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DatabaseChooser
    implements ScriptingClientDataConsumer.ResultsPlaceChooser {
        private final ScriptingClientDataConsumer.ResultsPlace myDefaultPlace;
        private final LogView<?> myView;
        private final DatabaseInEditorResults myResults;

        DatabaseChooser(@NotNull LogView<?> view2) {
            if (view2 == null) {
                DatabaseChooser.$$$reportNull$$$0(0);
            }
            this.myDefaultPlace = new ScriptingClientDataConsumer.LogViewResultsPlace(view2);
            this.myView = view2;
            this.myResults = new DatabaseInEditorResults();
        }

        @Override
        @NotNull
        public ScriptingClientDataConsumer.ResultsPlace getDefaultPlace() {
            ScriptingClientDataConsumer.ResultsPlace resultsPlace = this.myDefaultPlace;
            if (resultsPlace == null) {
                DatabaseChooser.$$$reportNull$$$0(1);
            }
            return resultsPlace;
        }

        @Override
        @NotNull
        public ScriptingClientDataConsumer.ResultsPlace getResultsPlace(@NotNull DataRequest.Context context) {
            DatabaseInEditorResults.Arguments arguments;
            if (context == null) {
                DatabaseChooser.$$$reportNull$$$0(2);
            }
            ScriptingClientDataConsumer.ResultsPlace resultsPlace = (arguments = DatabaseChooser.getArguments(context)) != null && arguments.console.isNotebookMode() ? new InEditorPlaceWrapper(this.myDefaultPlace, arguments, this.myResults) : this.myDefaultPlace;
            if (resultsPlace == null) {
                DatabaseChooser.$$$reportNull$$$0(3);
            }
            return resultsPlace;
        }

        @Override
        @NotNull
        public Collection<RunnerLayoutUi> getAllUis() {
            ArrayList<RunnerLayoutUi> uis = new ArrayList<RunnerLayoutUi>();
            uis.add(this.myView.getUi());
            uis.addAll(this.myResults.getUis());
            ArrayList<RunnerLayoutUi> arrayList = uis;
            if (arrayList == null) {
                DatabaseChooser.$$$reportNull$$$0(4);
            }
            return arrayList;
        }

        @Override
        @NotNull
        public Collection<? extends DatabaseInEditorResults.Result> getEmbeddedResults(@NotNull Editor editor) {
            if (editor == null) {
                DatabaseChooser.$$$reportNull$$$0(5);
            }
            Collection<? extends DatabaseInEditorResults.Result> collection = this.myResults.getResults(editor);
            if (collection == null) {
                DatabaseChooser.$$$reportNull$$$0(6);
            }
            return collection;
        }

        @Nullable
        private static DatabaseInEditorResults.Arguments getArguments(@NotNull DataRequest.Context context) {
            DataRequest.CoupledWithEditor request;
            if (context == null) {
                DatabaseChooser.$$$reportNull$$$0(7);
            }
            EditorEx editor = (request = (DataRequest.CoupledWithEditor)ObjectUtils.tryCast((Object)((Object)context.request), DataRequest.CoupledWithEditor.class)) == null ? null : (EditorEx)ObjectUtils.tryCast((Object)request.getEditor(), EditorEx.class);
            JdbcConsole console = editor == null ? null : (JdbcConsole)ObjectUtils.tryCast((Object)context.request.owner, JdbcConsole.class);
            return console == null ? null : new DatabaseInEditorResults.Arguments(editor, request, console);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/session/DatabaseClientLogView$DatabaseChooser";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/session/DatabaseClientLogView$DatabaseChooser";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultPlace";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResultsPlace";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllUis";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEmbeddedResults";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 6: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getResultsPlace";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getEmbeddedResults";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getArguments";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class InEditorPlaceWrapper
        implements ScriptingClientDataConsumer.ResultsPlace {
            private final DatabaseInEditorResults myHelper;
            private final ScriptingClientDataConsumer.ResultsPlace myServicesPlace;
            private final DatabaseInEditorResults.Arguments myArguments;
            private Ref<DatabaseInEditorResults.ResultConstructor> myResult;

            InEditorPlaceWrapper(@NotNull ScriptingClientDataConsumer.ResultsPlace servicesPlace, @NotNull DatabaseInEditorResults.Arguments arguments, @NotNull DatabaseInEditorResults helper) {
                if (servicesPlace == null) {
                    InEditorPlaceWrapper.$$$reportNull$$$0(0);
                }
                if (arguments == null) {
                    InEditorPlaceWrapper.$$$reportNull$$$0(1);
                }
                if (helper == null) {
                    InEditorPlaceWrapper.$$$reportNull$$$0(2);
                }
                this.myServicesPlace = servicesPlace;
                this.myArguments = arguments;
                this.myHelper = helper;
                PsiFile file = arguments.console.getFile();
                SqlNotebookModel.getCellAccessor(file, arguments.console.getScriptModel(), (Condition<? super TextRange>)Conditions.alwaysTrue());
            }

            @Override
            @NotNull
            public RunnerLayoutUi getOrCreateUi() {
                DatabaseInEditorResults.Result result;
                if (this.myResult == null) {
                    result = this.myHelper.getOrCreateResult(this.myArguments);
                    this.myResult = Ref.create((Object)result);
                    if (result != null) {
                        result.setInProgress(true);
                    }
                }
                RunnerLayoutUi runnerLayoutUi = (result = (DatabaseInEditorResults.Result)this.myResult.get()) == null ? this.myServicesPlace.getOrCreateUi() : result.getUi();
                if (runnerLayoutUi == null) {
                    InEditorPlaceWrapper.$$$reportNull$$$0(3);
                }
                return runnerLayoutUi;
            }

            @Override
            @NotNull
            public Promise<Void> show(boolean activate, boolean focus) {
                DatabaseInEditorResults.Result result = (DatabaseInEditorResults.Result)this.myResult.get();
                if (result == null) {
                    Promise<Void> promise = this.myServicesPlace.show(activate, focus);
                    if (promise == null) {
                        InEditorPlaceWrapper.$$$reportNull$$$0(4);
                    }
                    return promise;
                }
                if (activate) {
                    this.myHelper.scrollTo(result, (Editor)this.myArguments.editor);
                }
                Promise promise = Promises.resolvedPromise();
                if (promise == null) {
                    InEditorPlaceWrapper.$$$reportNull$$$0(5);
                }
                return promise;
            }

            @Override
            public void requestFinished() {
                Ref<DatabaseInEditorResults.ResultConstructor> result = this.myResult;
                if (result == null) {
                    return;
                }
                DatabaseInEditorResults.ResultConstructor constructor = (DatabaseInEditorResults.ResultConstructor)result.get();
                if (constructor != null) {
                    constructor.setInProgress(false);
                }
            }

            @Override
            public void readyToShow(@NotNull Content content) {
                DatabaseInEditorResults.Result result;
                if (content == null) {
                    InEditorPlaceWrapper.$$$reportNull$$$0(6);
                }
                if ((result = (DatabaseInEditorResults.Result)this.myResult.get()) != null) {
                    this.myHelper.show(result, content, (Editor)this.myArguments.editor);
                    return;
                }
                this.myServicesPlace.readyToShow(content);
            }

            @Override
            public boolean showImmediate() {
                return false;
            }

            @Override
            @NotNull
            public String getActionGroupName() {
                return this.myResult.get() == null ? this.myServicesPlace.getActionGroupName() : "Console.TableResult.Group.Common";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "servicesPlace";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "arguments";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "helper";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/console/session/DatabaseClientLogView$DatabaseChooser$InEditorPlaceWrapper";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "content";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/console/session/DatabaseClientLogView$DatabaseChooser$InEditorPlaceWrapper";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getOrCreateUi";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "show";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "readyToShow";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }

    private static class ClientLogViewController
    extends DatabaseLogView.DatabaseServiceViewController<DatabaseSessionClientWithFile> {
        ClientLogViewController(@NotNull DatabaseSessionClientWithFile owner) {
            if (owner == null) {
                ClientLogViewController.$$$reportNull$$$0(0);
            }
            super(owner);
        }

        @Override
        @NotNull
        protected Promise<Void> selectNode(@NotNull Project project, @NotNull DatabaseSessionClientWithFile owner, boolean activate, boolean requestFocus) {
            if (project == null) {
                ClientLogViewController.$$$reportNull$$$0(1);
            }
            if (owner == null) {
                ClientLogViewController.$$$reportNull$$$0(2);
            }
            if (DatabaseSettings.getSettings().showOutputInTab) {
                DatabaseServiceViewContributor.extractNode(project, owner);
            }
            Promise<Void> promise = DatabaseServiceViewContributor.selectNode(project, owner, activate, requestFocus);
            if (promise == null) {
                ClientLogViewController.$$$reportNull$$$0(3);
            }
            return promise;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/session/DatabaseClientLogView$ClientLogViewController";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/session/DatabaseClientLogView$ClientLogViewController";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "selectNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "selectNode";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

