/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.runConfiguration;

import com.intellij.database.console.runConfiguration.DatabaseScriptRunConfiguration;
import com.intellij.database.console.runConfiguration.DatabaseScriptRunConfigurationOptions;
import com.intellij.database.console.runConfiguration.DatabaseScriptRunConfigurationType;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J,\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0013H\u0002J\u0018\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005H\u0016J&\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\u001eH\u0014\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationProducer;", "Lcom/intellij/execution/actions/LazyRunConfigurationProducer;", "Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfiguration;", "()V", "createConfigurationFromContext", "Lcom/intellij/execution/actions/ConfigurationFromContext;", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "findExistingConfiguration", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "getConfigurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "getSelectedFiles", "", "", "source", "Lcom/intellij/psi/PsiElement;", "sourceFile", "isConfigurationFromContext", "", "configuration", "isIgnoredConsoleScriptFile", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isConsoleOrEmptySource", "isPreferredConfiguration", "self", "other", "setupConfigurationFromContext", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "intellij.database.impl"})
public final class DatabaseScriptRunConfigurationProducer
extends LazyRunConfigurationProducer<DatabaseScriptRunConfiguration> {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        return DatabaseScriptRunConfigurationType.Companion.getInstance().getConfigurationFactories()[0];
    }

    @Nullable
    public ConfigurationFromContext createConfigurationFromContext(@NotNull ConfigurationContext context) {
        ConfigurationFromContext configurationFromContext;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ConfigurationFromContext configurationFromContext2 = super.createConfigurationFromContext(context);
        if (configurationFromContext2 != null) {
            ConfigurationFromContext configurationFromContext3 = configurationFromContext2;
            boolean bl = false;
            boolean bl2 = false;
            ConfigurationFromContext $this$apply = configurationFromContext3;
            boolean bl3 = false;
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = $this$apply.getConfigurationSettings();
            Intrinsics.checkNotNullExpressionValue((Object)runnerAndConfigurationSettings, (String)"configurationSettings");
            runnerAndConfigurationSettings.setEditBeforeRun(true);
            configurationFromContext = configurationFromContext3;
        } else {
            configurationFromContext = null;
        }
        return configurationFromContext;
    }

    protected boolean setupConfigurationFromContext(@NotNull DatabaseScriptRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        block1: {
            PsiElement source;
            Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(sourceElement, (String)"sourceElement");
            PsiElement psiElement = source = (PsiElement)sourceElement.get();
            PsiFile sourceFile = psiElement != null ? psiElement.getContainingFile() : null;
            List<String> list = this.getSelectedFiles(context, source, (PsiElement)sourceFile);
            if (list == null) {
                return false;
            }
            List<String> selectedFiles = list;
            DatabaseScriptRunConfigurationOptions databaseScriptRunConfigurationOptions = configuration.getOptions();
            boolean bl = false;
            boolean bl2 = false;
            DatabaseScriptRunConfigurationOptions $this$apply = databaseScriptRunConfigurationOptions;
            boolean bl3 = false;
            $this$apply.setMode(DatabaseScriptRunConfigurationOptions.Mode.FILE);
            $this$apply.setFiles(CollectionsKt.toMutableList((Collection)selectedFiles));
            configuration.setGeneratedName();
            PsiFile psiFile = sourceFile;
            if (psiFile == null) break block1;
            databaseScriptRunConfigurationOptions = psiFile;
            bl = false;
            bl2 = false;
            DatabaseScriptRunConfigurationOptions it2 = databaseScriptRunConfigurationOptions;
            boolean bl4 = false;
            sourceElement.set((Object)it2);
        }
        return true;
    }

    private final List<String> getSelectedFiles(ConfigurationContext context) {
        return this.getSelectedFiles(context, null, null);
    }

    /*
     * Unable to fully structure code
     */
    private final List<String> getSelectedFiles(ConfigurationContext context, PsiElement source, PsiElement sourceFile) {
        v0 = (VirtualFile[])LangDataKeys.VIRTUAL_FILE_ARRAY.getData(context.getDataContext());
        if (v0 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"LangDataKeys.VIRTUAL_FIL\u2026taContext) ?: return null");
        data = v0;
        isConsoleOrEmptySource = source != null && sourceFile != null && ((Intrinsics.areEqual((Object)source, (Object)sourceFile) ^ true) != false || source.getTextLength() == 0);
        $this$mapNotNull$iv = data;
        $i$f$mapNotNull = false;
        var9_8 = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        var14_14 = $this$forEach$iv$iv$iv;
        var15_15 = ((void)var14_14).length;
        for (var16_16 = 0; var16_16 < var15_15; ++var16_16) {
            element$iv$iv = element$iv$iv$iv = var14_14[var16_16];
            $i$a$-forEach-ArraysKt___ArraysKt$mapNotNullTo$1$iv$iv = false;
            file = element$iv$iv;
            $i$a$-mapNotNull-DatabaseScriptRunConfigurationProducer$getSelectedFiles$files$1 = false;
            var22_22 = file;
            var23_23 = false;
            var24_24 = false;
            it = var22_22;
            $i$a$-takeIf-DatabaseScriptRunConfigurationProducer$getSelectedFiles$files$1$1 = false;
            if (!DbImplUtil.isScriptFile(context.getProject(), (VirtualFile)it)) ** GOTO lbl-1000
            v1 = file;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"file");
            if (!this.isIgnoredConsoleScriptFile((VirtualFile)v1, isConsoleOrEmptySource)) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            v3 = v2 != false ? var22_22 : null;
            if ((v3 != null ? v3.getPath() : null) == null) continue;
            var27_27 = var27_27;
            var28_28 = false;
            var29_29 = false;
            it$iv$iv = var27_27;
            $i$a$-let-ArraysKt___ArraysKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        var7_6 = files = (List<E>)destination$iv$iv;
        var8_7 = false;
        var9_9 = false;
        it = var7_6;
        $i$a$-takeIf-DatabaseScriptRunConfigurationProducer$getSelectedFiles$1 = false;
        var12_12 = it;
        var13_13 = false;
        return var12_12.isEmpty() == false != false ? var7_6 : null;
    }

    private final boolean isIgnoredConsoleScriptFile(VirtualFile file, boolean isConsoleOrEmptySource) {
        return DbVFSUtils.isConsoleFile(file) && isConsoleOrEmptySource;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isPreferredConfiguration(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        String path;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        RunConfiguration runConfiguration = self.getConfiguration();
        if (!(runConfiguration instanceof DatabaseScriptRunConfiguration)) {
            runConfiguration = null;
        }
        DatabaseScriptRunConfiguration databaseScriptRunConfiguration = (DatabaseScriptRunConfiguration)runConfiguration;
        Object object = databaseScriptRunConfiguration;
        if (databaseScriptRunConfiguration == null) return true;
        DatabaseScriptRunConfigurationOptions databaseScriptRunConfigurationOptions = ((DatabaseScriptRunConfiguration)((Object)object)).getOptions();
        object = databaseScriptRunConfigurationOptions;
        if (databaseScriptRunConfigurationOptions == null) return true;
        List<String> list = ((DatabaseScriptRunConfigurationOptions)((Object)object)).getFiles();
        object = list;
        if (list == null) return true;
        String string = (String)CollectionsKt.firstOrNull((List)object);
        String string2 = path = string;
        if (string2 == null) return true;
        String string3 = string2;
        boolean bl = false;
        boolean bl2 = false;
        String it2 = string3;
        boolean bl3 = false;
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(it2);
        VirtualFile file = virtualFile;
        if (file == null) return true;
        RunConfiguration runConfiguration2 = self.getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)runConfiguration2, (String)"self.configuration");
        if (DbImplUtil.isScriptFile(runConfiguration2.getProject(), file)) return false;
        return true;
    }

    public boolean isConfigurationFromContext(@NotNull DatabaseScriptRunConfiguration configuration, @NotNull ConfigurationContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DatabaseScriptRunConfigurationOptions options = configuration.getOptions();
        List<String> list = this.getSelectedFiles(context);
        if (list == null) {
            return false;
        }
        List<String> selectedFiles = list;
        return options.getMode() == DatabaseScriptRunConfigurationOptions.Mode.FILE && selectedFiles.size() == options.getFiles().size() && selectedFiles.containsAll((Collection)options.getFiles());
    }

    @Nullable
    public RunnerAndConfigurationSettings findExistingConfiguration(@NotNull ConfigurationContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"context.project");
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = RunManager.Companion.getInstance(project).getSelectedConfiguration();
        if (runnerAndConfigurationSettings != null) {
            DatabaseScriptRunConfiguration rc;
            RunnerAndConfigurationSettings runnerAndConfigurationSettings2 = runnerAndConfigurationSettings;
            boolean bl = false;
            boolean bl2 = false;
            RunnerAndConfigurationSettings cur2 = runnerAndConfigurationSettings2;
            boolean bl3 = false;
            RunConfiguration runConfiguration = cur2.getConfiguration();
            if (!(runConfiguration instanceof DatabaseScriptRunConfiguration)) {
                runConfiguration = null;
            }
            if ((rc = (DatabaseScriptRunConfiguration)runConfiguration) != null && this.isConfigurationFromContext(rc, context)) {
                return cur2;
            }
        }
        return super.findExistingConfiguration(context);
    }
}

