/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.runConfiguration;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.RemoteConsoleProcessSupport;
import com.intellij.database.console.runConfiguration.DatabaseScriptFilesRunProfileState;
import com.intellij.database.console.runConfiguration.DatabaseScriptRunConfiguration;
import com.intellij.database.console.runConfiguration.DatabaseScriptRunConfigurationOptions;
import com.intellij.database.console.runConfiguration.DatabaseScriptRunConfigurationSettingsEditor;
import com.intellij.database.console.runConfiguration.DatabaseScriptRunConfigurationType;
import com.intellij.database.console.runConfiguration.DatabaseScriptRunProfileState;
import com.intellij.database.console.runConfiguration.DatabaseScriptTextRunProfileState;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.LocalDataSourceCore;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.LocatableRunConfigurationOptions;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.lang.Language;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B!\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0000H\u0016J\u0010\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u0002H\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001e\u0010\u0018\u001a\u0018\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001a\u0018\u00010\u0019H\u0002J\u0010\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001eH\u0002J\b\u0010 \u001a\u00020!H\u0016J\n\u0010\"\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006#"}, d2={"Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfiguration;", "Lcom/intellij/execution/configurations/LocatableConfigurationBase;", "Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationOptions;", "Lcom/intellij/execution/runners/RunConfigurationWithSuppressedDefaultRunAction;", "type", "Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationType;", "project", "Lcom/intellij/openapi/project/Project;", "name", "", "(Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationType;Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "checkConfiguration", "", "clone", "getConfigurationEditor", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/intellij/execution/configurations/RunConfiguration;", "getOptions", "getState", "Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunProfileState;", "executor", "Lcom/intellij/execution/Executor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "getTargetPairs", "", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/database/dataSource/LocalDataSource;", "Lcom/intellij/database/util/ObjectPath;", "getVirtualFiles", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/openapi/vfs/VirtualFile;", "isGeneratedName", "", "suggestedName", "intellij.database.impl"})
public final class DatabaseScriptRunConfiguration
extends LocatableConfigurationBase<DatabaseScriptRunConfigurationOptions>
implements RunConfigurationWithSuppressedDefaultRunAction {
    @NotNull
    public DatabaseScriptRunConfigurationOptions getOptions() {
        LocatableRunConfigurationOptions locatableRunConfigurationOptions = super.getOptions();
        if (locatableRunConfigurationOptions == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.console.runConfiguration.DatabaseScriptRunConfigurationOptions");
        }
        return (DatabaseScriptRunConfigurationOptions)locatableRunConfigurationOptions;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        return new DatabaseScriptRunConfigurationSettingsEditor(project, (Function0<DatabaseScriptRunConfiguration>)((Function0)new Function0<DatabaseScriptRunConfiguration>(this){
            final /* synthetic */ DatabaseScriptRunConfiguration this$0;

            @NotNull
            public final DatabaseScriptRunConfiguration invoke() {
                ConfigurationFactory configurationFactory = this.this$0.getFactory();
                if (configurationFactory == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.console.runConfiguration.DatabaseScriptRunConfigurationType");
                }
                DatabaseScriptRunConfigurationType databaseScriptRunConfigurationType = (DatabaseScriptRunConfigurationType)configurationFactory;
                Project project = this.this$0.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                return new DatabaseScriptRunConfiguration(databaseScriptRunConfigurationType, project, null, 4, null);
            }
            {
                this.this$0 = databaseScriptRunConfiguration;
                super(0);
            }
        }));
    }

    public void checkConfiguration() {
        boolean bl;
        boolean bl2;
        Object object;
        super.checkConfiguration();
        DatabaseScriptRunConfigurationOptions options = this.getOptions();
        if (options.getMode() == DatabaseScriptRunConfigurationOptions.Mode.TEXT) {
            object = options.getText();
            bl2 = false;
            bl = false;
            if (object == null || StringsKt.isBlank((CharSequence)object)) {
                throw (Throwable)new RuntimeConfigurationError(DatabaseBundle.message((String)"dialog.message.missing.code.to.execute", (Object[])new Object[0]));
            }
        } else if (this.getVirtualFiles() == null) {
            throw (Throwable)new RuntimeConfigurationError(DatabaseBundle.message((String)"dialog.message.missing.files.to.execute", (Object[])new Object[0]));
        }
        List<Pair<LocalDataSource, ObjectPath>> list = this.getTargetPairs();
        if (list != null) {
            object = list;
            bl2 = false;
            bl = false;
            Object it2 = object;
            boolean bl3 = false;
            if (it2.isEmpty()) {
                throw (Throwable)new RuntimeConfigurationError(DatabaseBundle.message((String)"dialog.message.no.configured.target.data.sources", (Object[])new Object[0]));
            }
        } else {
            throw (Throwable)new RuntimeConfigurationError(DatabaseBundle.message((String)"dialog.message.missing.target.data.sources", (Object[])new Object[0]));
        }
    }

    @Nullable
    public DatabaseScriptRunProfileState getState(@NotNull Executor executor2, @NotNull ExecutionEnvironment environment) {
        DatabaseScriptRunProfileState databaseScriptRunProfileState;
        block7: {
            DatabaseScriptRunProfileState databaseScriptRunProfileState2;
            Intrinsics.checkNotNullParameter((Object)executor2, (String)"executor");
            Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
            DatabaseScriptRunConfigurationOptions options = this.getOptions();
            List<Pair<LocalDataSource, ObjectPath>> list = this.getTargetPairs();
            if (list == null) {
                return null;
            }
            List<Pair<LocalDataSource, ObjectPath>> targets2 = list;
            if (targets2.isEmpty()) {
                return null;
            }
            Pair singleTarget = (Pair)CollectionsKt.singleOrNull(targets2);
            if (options.getMode() == DatabaseScriptRunConfigurationOptions.Mode.TEXT && singleTarget != null) {
                String string = options.getText();
                if (string == null) {
                    return null;
                }
                String scriptText = string;
                if (!StringsKt.endsWith$default((CharSequence)scriptText, (char)'\n', (boolean)false, (int)2, null)) {
                    scriptText = scriptText + '\n';
                }
                String string2 = this.getName();
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                Object object = singleTarget.first;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"singleTarget.first");
                databaseScriptRunProfileState2 = new DatabaseScriptTextRunProfileState(string2, project, (LocalDataSource)object, SearchPath.of((ObjectPath)((ObjectPath)singleTarget.second)), scriptText);
            } else {
                JBIterable<VirtualFile> jBIterable = this.getVirtualFiles();
                if (jBIterable == null) {
                    return null;
                }
                JBIterable<VirtualFile> virtualFiles = jBIterable;
                String string = this.getName();
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                List list2 = virtualFiles.toList();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"virtualFiles.toList()");
                databaseScriptRunProfileState2 = new DatabaseScriptFilesRunProfileState(string, project, list2, targets2, environment);
            }
            databaseScriptRunProfileState = databaseScriptRunProfileState2;
            boolean bl = false;
            boolean bl2 = false;
            DatabaseScriptRunProfileState $this$apply = databaseScriptRunProfileState;
            boolean bl3 = false;
            AsyncTask.Frame frame = (AsyncTask.Frame)((Object)RemoteConsoleProcessSupport.BEFORE_RUN_CONTEXT.get((UserDataHolder)environment));
            if (frame == null) break block7;
            AsyncTask.Frame frame2 = frame;
            boolean bl4 = false;
            boolean bl5 = false;
            AsyncTask.Frame it2 = frame2;
            boolean bl6 = false;
            RemoteConsoleProcessSupport.BEFORE_RUN_CONTEXT.set((UserDataHolder)$this$apply, (Object)it2);
        }
        return databaseScriptRunProfileState;
    }

    @NotNull
    public DatabaseScriptRunConfiguration clone() {
        RunConfiguration runConfiguration = super.clone();
        if (runConfiguration == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.console.runConfiguration.DatabaseScriptRunConfiguration");
        }
        return (DatabaseScriptRunConfiguration)runConfiguration;
    }

    private final List<Pair<LocalDataSource, ObjectPath>> getTargetPairs() {
        DataSourceStorage storage = DataSourceStorage.getProjectStorage(this.getProject());
        List list = JBIterable.from((Iterable)this.getOptions().getTargets()).map((Function)new Function<DatabaseScriptRunConfigurationOptions.Target, Pair<LocalDataSourceCore, ObjectPath>>(storage){
            final /* synthetic */ DataSourceStorage $storage;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Pair<LocalDataSourceCore, ObjectPath> fun(DatabaseScriptRunConfigurationOptions.Target it2) {
                Pair pair;
                LocalDataSourceCore localDataSourceCore = this.$storage.getDataSourceById(it2.getDataSourceId());
                if (localDataSourceCore != null) {
                    ObjectPath objectPath;
                    LocalDataSourceCore localDataSourceCore2 = localDataSourceCore;
                    boolean bl = false;
                    boolean bl2 = false;
                    LocalDataSourceCore ds = localDataSourceCore2;
                    boolean bl3 = false;
                    LocalDataSourceCore localDataSourceCore3 = ds;
                    String string = it2.getNamespace();
                    if (string != null) {
                        void n;
                        String string2 = string;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        String string3 = string2;
                        LocalDataSourceCore localDataSourceCore4 = localDataSourceCore3;
                        boolean bl6 = false;
                        ObjectPath objectPath2 = ObjectPath.deserialize((String)n);
                        localDataSourceCore3 = localDataSourceCore4;
                        objectPath = objectPath2;
                    } else {
                        objectPath = null;
                    }
                    pair = Pair.create((Object)((Object)localDataSourceCore3), objectPath);
                } else {
                    pair = null;
                }
                return pair;
            }
            {
                this.$storage = dataSourceStorage;
            }
        }).toList();
        boolean bl = false;
        boolean bl2 = false;
        List it2 = list;
        boolean bl3 = false;
        return !it2.contains(null) ? list : null;
    }

    private final JBIterable<VirtualFile> getVirtualFiles() {
        DatabaseScriptRunConfigurationOptions options = this.getOptions();
        if (options.getMode() == DatabaseScriptRunConfigurationOptions.Mode.TEXT) {
            String string = options.getText();
            if (string == null) {
                return JBIterable.empty();
            }
            String statementText = string;
            DataSourceStorage projectStorage = DataSourceStorage.getProjectStorage(this.getProject());
            Object object = SequencesKt.first((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)options.getTargets()), (Function1)((Function1)new Function1<DatabaseScriptRunConfigurationOptions.Target, LocalDataSourceCore>(projectStorage){
                final /* synthetic */ DataSourceStorage $projectStorage;

                @Nullable
                public final LocalDataSourceCore invoke(@NotNull DatabaseScriptRunConfigurationOptions.Target it2) {
                    Intrinsics.checkNotNullParameter((Object)((Object)it2), (String)"it");
                    return this.$projectStorage.getDataSourceById(it2.getDataSourceId());
                }
                {
                    this.$projectStorage = dataSourceStorage;
                    super(1);
                }
            })));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"options.targets.asSequen\u2026t.dataSourceId) }.first()");
            LocalDataSourceCore dataSource2 = (LocalDataSourceCore)((Object)object);
            LightVirtualFile virtualFile = new LightVirtualFile(this.getName(), (Language)DbSqlUtil.getSqlDialect(dataSource2), (CharSequence)statementText);
            return JBIterable.of((Object)virtualFile);
        }
        JBIterable jBIterable = JBIterable.from((Iterable)options.getFiles()).map((Function)getVirtualFiles.1.INSTANCE).collect();
        boolean bl = false;
        boolean bl2 = false;
        JBIterable it2 = jBIterable;
        boolean bl3 = false;
        return !it2.contains(null) ? jBIterable : null;
    }

    public boolean isGeneratedName() {
        return Intrinsics.areEqual((Object)this.getName(), (Object)this.suggestedName());
    }

    @Nullable
    public String suggestedName() {
        String string;
        if (this.getOptions().getMode() != DatabaseScriptRunConfigurationOptions.Mode.FILE) {
            return null;
        }
        List<String> files = this.getOptions().getFiles();
        Object object = this.getState();
        boolean bl = false;
        boolean bl2 = false;
        DatabaseScriptRunConfigurationOptions $this$run = (DatabaseScriptRunConfigurationOptions)((Object)object);
        boolean bl3 = false;
        switch (files.size()) {
            case 0: {
                string = null;
                break;
            }
            case 1: {
                string = PathUtil.getFileName((String)files.get(0));
                break;
            }
            default: {
                string = DatabaseBundle.message((String)"sql.run.configuration.few.files.to.run.default.name", (Object[])new Object[]{PathUtil.getFileName((String)files.get(0)), files.size() - 1});
            }
        }
        return string;
    }

    public DatabaseScriptRunConfiguration(@NotNull DatabaseScriptRunConfigurationType type, @NotNull Project project, @Nullable String name) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, (ConfigurationFactory)type, name);
    }

    public /* synthetic */ DatabaseScriptRunConfiguration(DatabaseScriptRunConfigurationType databaseScriptRunConfigurationType, Project project, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = null;
        }
        this(databaseScriptRunConfigurationType, project, string);
    }
}

