/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.evaluation;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.run.actions.TransactionAction;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.WrapInSelectResult;
import com.intellij.database.script.generator.dml.WrapInSelectTask;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EvaluationResultFetcher {
    private static final int FETCH_SIZE = 2;
    public static final int BATCH_SIZE = 10;
    protected final DbDataSource mySource;
    protected final Project myProject;
    private final List<DataConsumer.Row> myRows;
    private final List<DataConsumer.Column> myColumns;
    private final DataRequest.OwnerEx myOwnerEx;
    private final String myQuery;
    private final AtomicReference<DataRequest> myCurrentRequest;
    private boolean myLoaded;
    private int myFetched;
    private long myCount;

    EvaluationResultFetcher(@NotNull List<DataConsumer.Row> rows, @NotNull List<DataConsumer.Column> columns, @NotNull Project project, @NotNull DataRequest.OwnerEx ex, @NotNull DbDataSource source, @NotNull String query, boolean loaded) {
        if (rows == null) {
            EvaluationResultFetcher.$$$reportNull$$$0(0);
        }
        if (columns == null) {
            EvaluationResultFetcher.$$$reportNull$$$0(1);
        }
        if (project == null) {
            EvaluationResultFetcher.$$$reportNull$$$0(2);
        }
        if (ex == null) {
            EvaluationResultFetcher.$$$reportNull$$$0(3);
        }
        if (source == null) {
            EvaluationResultFetcher.$$$reportNull$$$0(4);
        }
        if (query == null) {
            EvaluationResultFetcher.$$$reportNull$$$0(5);
        }
        this.myRows = rows;
        this.myColumns = columns;
        this.myProject = project;
        this.myOwnerEx = ex;
        this.mySource = source;
        this.myQuery = query;
        this.myLoaded = loaded;
        this.myCurrentRequest = new AtomicReference();
        this.myCount = -1L;
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = this.mySource.getDbms();
        if (dbms == null) {
            EvaluationResultFetcher.$$$reportNull$$$0(6);
        }
        return dbms;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            EvaluationResultFetcher.$$$reportNull$$$0(7);
        }
        return project;
    }

    @NotNull
    public List<DataConsumer.Row> getRows() {
        List list = ContainerUtil.getFirstItems(this.myRows, (int)this.myFetched);
        if (list == null) {
            EvaluationResultFetcher.$$$reportNull$$$0(8);
        }
        return list;
    }

    public long getRowCount() {
        return this.myLoaded || this.myCount == -1L ? (long)this.myRows.size() : this.myCount;
    }

    public boolean isRowCountPrecise() {
        return this.myCount != -1L || this.myLoaded;
    }

    public int getFetchSize() {
        return 2;
    }

    @NotNull
    public List<DataConsumer.Column> getColumns() {
        List<DataConsumer.Column> list = this.myColumns;
        if (list == null) {
            EvaluationResultFetcher.$$$reportNull$$$0(9);
        }
        return list;
    }

    public void fetchCached() {
        this.fetchCached(null);
    }

    public void fetch(@NotNull Runnable callback) {
        if (callback == null) {
            EvaluationResultFetcher.$$$reportNull$$$0(10);
        }
        if (this.isBusy(callback) || this.fetchCached(callback)) {
            return;
        }
        RowsLoadRequest request = this.resetStateOnProcessed(new RowsLoadRequest(this.myOwnerEx, this.getQuery(this.myFetched, 10), this.myFetched, 10));
        this.myCurrentRequest.set(request);
        request.getPromise().onProcessed(v -> DbUIUtil.invokeLaterIfNeeded(() -> {
            this.myFetched = Math.min(this.myFetched + 2, this.myRows.size());
            callback.run();
        }));
        this.myOwnerEx.getMessageBus().getDataProducer().processRequest(request);
    }

    public void count(final @NotNull Runnable callback) {
        if (callback == null) {
            EvaluationResultFetcher.$$$reportNull$$$0(11);
        }
        if (this.isBusy(callback)) {
            return;
        }
        this.myCurrentRequest.set(this.resetStateOnProcessed(new DataRequest.RawRequest(this.myOwnerEx){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void processRaw(DataRequest.Context context, DatabaseConnection connection2) throws Exception {
                try {
                    String t = DbImplUtil.findFreeAlias(EvaluationResultFetcher.this.myProject, EvaluationResultFetcher.this.mySource.getDbms(), EvaluationResultFetcher.this.myQuery, "t");
                    String query = EvaluationResultFetcher.this.getCountQuery(t);
                    if (query != null) {
                        EvaluationResultFetcher.this.myCount = DbImplUtil.getCount(connection2, query);
                    }
                }
                finally {
                    DbUIUtil.invokeLaterIfNeeded(callback);
                }
            }
        }));
        this.myOwnerEx.getMessageBus().getDataProducer().processRequest(this.myCurrentRequest.get());
    }

    @NotNull
    protected String getQuery(int start2, int load) {
        String string = this.myQuery;
        if (string == null) {
            EvaluationResultFetcher.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Nullable
    protected String getCountQuery(@NotNull String alias) {
        if (alias == null) {
            EvaluationResultFetcher.$$$reportNull$$$0(13);
        }
        WrapInSelectTask task = DmlTaskKt.wrapInSelect(this.myQuery, this.myProject).countAll().version(this.mySource.getVersion()).alias(alias).build(DbImplUtil.createBuilderForUIExec(this.mySource.getDbms(), (DasObject)this.mySource));
        WrapInSelectResult result = DmlUtilKt.dmlGenerator(this.mySource.getDbms()).generate(task);
        return result == null ? null : result.getStatement();
    }

    public boolean canFetch() {
        return this.myRows.size() > this.myFetched || !this.myLoaded;
    }

    public boolean isBusy() {
        return this.myCurrentRequest.get() != null;
    }

    private boolean fetchCached(@Nullable Runnable callback) {
        if (this.myFetched < this.myRows.size() || this.myLoaded) {
            this.myFetched = Math.min(this.myFetched + 2, this.myRows.size());
            if (callback != null) {
                callback.run();
            }
            return true;
        }
        return false;
    }

    private boolean isBusy(@NotNull Runnable callback) {
        if (callback == null) {
            EvaluationResultFetcher.$$$reportNull$$$0(14);
        }
        if (this.isBusy()) {
            callback.run();
            return true;
        }
        return false;
    }

    @NotNull
    private <T extends DataRequest> T resetStateOnProcessed(@NotNull T request) {
        if (request == null) {
            EvaluationResultFetcher.$$$reportNull$$$0(15);
        }
        request.getPromise().onProcessed(v -> this.myCurrentRequest.set(null));
        T t = request;
        if (t == null) {
            EvaluationResultFetcher.$$$reportNull$$$0(16);
        }
        return t;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ex";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/evaluation/EvaluationResultFetcher";
                break;
            }
            case 10: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/evaluation/EvaluationResultFetcher";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRows";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumns";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuery";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "resetStateOnProcessed";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 16: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fetch";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "count";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCountQuery";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isBusy";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "resetStateOnProcessed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class RowsLoadRequest
    extends DataRequest.IsolatedQueryRequest {
        private int myCount;

        protected RowsLoadRequest(@NotNull DataRequest.OwnerEx owner, String query, int loaded, int toLoad) {
            if (owner == null) {
                RowsLoadRequest.$$$reportNull$$$0(0);
            }
            if (query == null) {
                RowsLoadRequest.$$$reportNull$$$0(1);
            }
            super(owner, query, DataRequest.newConstraints(loaded, toLoad, 0, 0), null);
        }

        @Override
        public void setColumns(@NotNull DataRequest.Context context, int resultSetIndex, DataConsumer.Column @NotNull [] columns, int firstRowNum) {
            if (context == null) {
                RowsLoadRequest.$$$reportNull$$$0(2);
            }
            if (columns == null) {
                RowsLoadRequest.$$$reportNull$$$0(3);
            }
        }

        @Override
        public void addRows(@NotNull DataRequest.Context context, List<DataConsumer.Row> rows) {
            if (context == null) {
                RowsLoadRequest.$$$reportNull$$$0(4);
            }
            Dbms dbms = (Dbms)ObjectUtils.chooseNotNull((Object)TransactionAction.getDbms(context.request.owner), (Object)Dbms.UNKNOWN);
            ObjectFormatter.convertRows(rows, EvaluationResultFetcher.this.myColumns, dbms);
            EvaluationResultFetcher.this.myRows.addAll(rows);
            this.myCount += rows.size();
        }

        @Override
        public void afterLastRowAdded(@NotNull DataRequest.Context context, int total) {
            if (context == null) {
                RowsLoadRequest.$$$reportNull$$$0(5);
            }
            EvaluationResultFetcher.this.myLoaded = total <= EvaluationResultFetcher.this.myRows.size();
        }

        public int getCount() {
            return this.myCount;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "query";
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/evaluation/EvaluationResultFetcher$RowsLoadRequest";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setColumns";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addRows";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterLastRowAdded";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

