/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dataSource.DatabaseArtifactList;
import com.intellij.database.dataSource.DatabaseArtifactManager;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.diagnostic.VMOptions;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.MacroManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.util.Bitness;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JdkVersionDetector;

public class JdbcConsoleRunContext
implements ConsoleRunConfiguration.RunContext {
    private static final Logger LOG = Logger.getInstance(JdbcConsoleRunContext.class);
    private static final Collection<String> IGNORED_SUFFIXES = Arrays.asList(".txt", ".me", ".info", ".pom", ".xml");
    public static final String MAIN_CLASS = "com.intellij.database.remote.RemoteJdbcServer";
    private static final String ZONE_PROPERTY = "user.timezone";
    private static final String LIBRARY_PATH = "java.library.path";
    private final LocalDataSource myDataSource;

    JdbcConsoleRunContext(LocalDataSource dataSource2) {
        this.myDataSource = dataSource2;
    }

    public static void addUtilJars(@NotNull PathsList cp, boolean addGroovy) {
        if (cp == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(0);
        }
        cp.add(PathUtil.getJarPathForClass(StringUtilRt.class));
        cp.add(PathUtil.getJarPathForClass(TObjectHashingStrategy.class));
        if (addGroovy) {
            JdbcConsoleRunContext.addClassJar(cp, JdbcConsole.class, "groovy.lang.GroovyShell");
        }
    }

    public static void addJdbcConsoleJars(PathsList cp) {
        JdbcConsoleRunContext.addClassJar(cp, JdbcEngine.class, MAIN_CLASS);
        JdbcConsoleRunContext.addClassJar(cp, JdbcNativeUtil.class, "com.intellij.database.remote.jdba.jdbc.JdbcIntermediateFederatedProvider");
    }

    public static void addClassJar(@NotNull PathsList cp, @NotNull Class<?> context, @NotNull String className) {
        String s2;
        if (cp == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(1);
        }
        if (context == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(2);
        }
        if (className == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(3);
        }
        if ((s2 = PathManager.getResourceRoot(context, (String)("/" + className.replace('.', '/') + ".class"))) == null) {
            return;
        }
        cp.add(new File(s2).getAbsoluteFile().getAbsolutePath());
    }

    public LocalDataSource getDataSource() {
        return this.myDataSource;
    }

    @Override
    public String getMainClassName() {
        return MAIN_CLASS;
    }

    @Override
    public void collectClassPath(PathsList cp) {
        JdbcConsoleRunContext.addUtilJars(cp, true);
        JdbcConsoleRunContext.addJdbcConsoleJars(cp);
        boolean sensitive = LocalFileSystem.getInstance().isCaseSensitive();
        block0: for (SimpleClasspathElement classpathElement : this.myDataSource.getClasspathElements()) {
            for (String url : classpathElement.getClassesRootUrls()) {
                String path = PathUtil.toPresentableUrl((String)url);
                for (String suffix : IGNORED_SUFFIXES) {
                    if (!(sensitive ? path.endsWith(suffix) : StringUtil.endsWithIgnoreCase((String)path, (String)suffix))) continue;
                    continue block0;
                }
                cp.add(path);
            }
        }
    }

    @Override
    @Nullable
    public Sdk getSdk() {
        DatabaseDriver driver = this.myDataSource.getDatabaseDriver();
        String path = driver == null ? null : ((DatabaseDriverImpl)driver).getJrePath();
        return path == null ? null : new SimpleJavaSdkType().createJdk("tmp-custom", path);
    }

    @Override
    public void tuneParams(@NotNull Project project, @NotNull SimpleJavaParameters params) throws ExecutionException {
        String driverClass;
        if (project == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(4);
        }
        if (params == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(5);
        }
        if (StringUtil.isEmpty((String)(driverClass = this.myDataSource.getDriverClass()))) {
            throw new ExecutionException(DatabaseBundle.message((String)"dialog.message.no.driver.class.for", (Object[])new Object[]{this.myDataSource.getName()}));
        }
        ParametersList vmParams = params.getVMParametersList();
        if (!vmParams.hasProperty(ZONE_PROPERTY)) {
            vmParams.addProperty(ZONE_PROPERTY, "UTC");
        }
        Bitness bitness = this.detectBitness(params);
        List<File> nativePaths = this.getNativeLibrariesPaths(bitness);
        this.setNativePaths(params, nativePaths);
        this.setDefaultMemoryOption(vmParams, VMOptions.MemoryKind.HEAP);
        this.setDefaultMemoryOption(vmParams, VMOptions.MemoryKind.MIN_HEAP);
        params.getProgramParametersList().add(driverClass);
        String dir = this.myDataSource.getWorkingDir();
        if ("".equals(dir)) {
            String string = dir = this.myDataSource.isGlobal() ? null : project.getBasePath();
        }
        if (dir != null) {
            params.setWorkingDirectory(JdbcConsoleRunContext.expand(project, dir));
        }
    }

    public static String expand(@NotNull Project project, String dir) {
        String expanded;
        if (project == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(6);
        }
        if (dir == null) {
            return null;
        }
        DataContext context = SimpleDataContext.getProjectContext((Project)project);
        try {
            expanded = MacroManager.getInstance().expandSilentMacros(dir, true, context);
        }
        catch (Macro.ExecutionCancelledException e) {
            expanded = dir;
        }
        return (String)ObjectUtils.notNull((Object)expanded, (Object)dir);
    }

    public void setDefaultMemoryOption(ParametersList vmParams, VMOptions.MemoryKind memoryKind) {
        String value2 = this.findMemSet(vmParams.getParameters(), memoryKind);
        if (value2 != null) {
            return;
        }
        String current = this.findMemSet(ManagementFactory.getRuntimeMXBean().getInputArguments(), memoryKind);
        if (current == null) {
            return;
        }
        vmParams.add(current);
    }

    @Nullable
    public String findMemSet(@NotNull List<String> parameters, VMOptions.MemoryKind memoryKind) {
        if (parameters == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(7);
        }
        for (String parameter : parameters) {
            if (!parameter.startsWith(memoryKind.option)) continue;
            return parameter;
        }
        return null;
    }

    public void setNativePaths(@NotNull SimpleJavaParameters params, List<File> nativePaths) {
        String ldPath;
        if (params == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(8);
        }
        if (nativePaths.isEmpty()) {
            return;
        }
        ParametersList vmParams = params.getVMParametersList();
        String existing = StringUtil.nullize((String)vmParams.getPropertyValue(LIBRARY_PATH));
        String path = StringUtil.join((Iterable)JBIterable.from(nativePaths).map(File::getAbsolutePath), (String)File.pathSeparator);
        vmParams.addProperty(LIBRARY_PATH, (String)(existing == null ? path : existing + File.pathSeparator + path));
        String string = SystemInfo.isMac ? "DYLD_FALLBACK_LIBRARY_PATH" : (SystemInfo.isUnix ? "LD_LIBRARY_PATH" : (ldPath = SystemInfo.isWindows ? "PATH" : null));
        if (ldPath != null) {
            String prev = StringUtil.nullize((String)((String)params.getEnv().get(path)));
            if (prev == null) {
                prev = StringUtil.nullize((String)((String)EnvironmentUtil.getEnvironmentMap().get(ldPath)));
            }
            String newPath = prev == null ? path : prev + File.pathSeparator + path;
            LOG.info("Extending " + ldPath + " " + prev + "\nto " + newPath);
            params.addEnv(ldPath, newPath);
        }
    }

    @NotNull
    private List<File> getNativeLibrariesPaths(Bitness bitness) {
        DatabaseDriver driver = this.myDataSource.getDatabaseDriver();
        if (driver == null) {
            List<File> list = Collections.emptyList();
            if (list == null) {
                JdbcConsoleRunContext.$$$reportNull$$$0(9);
            }
            return list;
        }
        List<SimpleClasspathElement> libPaths = driver.getNativeLibraryPaths();
        ArrayList<File> result = new ArrayList<File>();
        for (SimpleClasspathElement element2 : libPaths) {
            for (String url : element2.getClassesRootUrls()) {
                File file = new File(StringUtil.trimStart((String)url, (String)"file://"));
                if (StringUtil.endsWithIgnoreCase((String)url, (String)".jar") || StringUtil.endsWithIgnoreCase((String)url, (String)".zip")) {
                    ContainerUtil.addIfNotNull(result, (Object)DatabaseArtifactList.getNativeLibrary(file, null, bitness));
                    continue;
                }
                result.add(file.isFile() ? file.getParentFile() : file);
            }
        }
        DatabaseArtifactList artifacts = DatabaseArtifactManager.getArtifacts();
        for (DatabaseDriver.ArtifactRef artifact : driver.getArtifacts()) {
            DatabaseArtifactList.ArtifactVersion version;
            if (artifact.getArtifactVersion() == null || (version = artifacts.resolve(artifact.getId(), artifact.getArtifactVersion())) == null) continue;
            List<File> fromArtifacts = DatabaseArtifactList.getNativeLibraries(version, bitness);
            result.addAll(fromArtifacts);
        }
        ArrayList<File> arrayList = result;
        if (arrayList == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    protected Bitness detectBitness(@NotNull SimpleJavaParameters params) {
        Sdk jdk;
        if (params == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(11);
        }
        String homePath = (jdk = params.getJdk()) == null ? null : jdk.getHomePath();
        JdkVersionDetector.JdkVersionInfo info = homePath == null ? null : JdkVersionDetector.getInstance().detectJdkVersionInfo(homePath);
        Bitness bitness = info == null ? Bitness.x64 : info.bitness;
        if (bitness == null) {
            JdbcConsoleRunContext.$$$reportNull$$$0(12);
        }
        return bitness;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cp";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/JdbcConsoleRunContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/JdbcConsoleRunContext";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNativeLibrariesPaths";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "detectBitness";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addUtilJars";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addClassJar";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "tuneParams";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findMemSet";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setNativePaths";
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "detectBitness";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

