/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.cli.CliConfiguration;
import com.intellij.database.cli.CliConfigurationPack;
import com.intellij.database.cli.CliDialogValidator;
import com.intellij.database.cli.CliModel;
import com.intellij.database.cli.CliProperties;
import com.intellij.database.cli.CliRunner;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CliDialog
extends DialogWrapper {
    private static final String DIMENSION_KEY = "DUMP_DIALOG_DIMENSION_KEY";
    private static final Dimension MIN_SIZE = JBUI.size((int)300, (int)100);
    private static final Dimension PREFERRED_SIZE = JBUI.size((int)600, (int)400);
    private final LocalDataSource myDataSource;
    private final Project myProject;
    private final CliConfigurationPack myPack;
    private final MyPanel myPanel;

    public CliDialog(@NotNull Project project, @NotNull LocalDataSource dataSource2, @NotNull Collection<DbElement> elements, @NotNull CliConfigurationPack configurations, @NotNull @NlsContexts.DialogTitle String title) {
        if (project == null) {
            CliDialog.$$$reportNull$$$0(0);
        }
        if (dataSource2 == null) {
            CliDialog.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            CliDialog.$$$reportNull$$$0(2);
        }
        if (configurations == null) {
            CliDialog.$$$reportNull$$$0(3);
        }
        if (title == null) {
            CliDialog.$$$reportNull$$$0(4);
        }
        super(project);
        this.myDataSource = dataSource2;
        this.myProject = project;
        this.myPack = configurations;
        this.myPanel = configurations.isSingleConfiguration() ? new MySingleConfigurationPanel(project, elements, configurations) : new MyMultiConfigurationPanel(project, elements, configurations);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myPanel);
        this.setTitle(title);
        this.initValidation();
        this.init();
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.myOKAction.putValue("Name", DatabaseBundle.message((String)"database.cli.integration.run.action", (Object[])new Object[0]));
    }

    protected void doOKAction() {
        if (!this.getOKAction().isEnabled()) {
            return;
        }
        CliProperties.storeLastUsedConfiguration(this.myPack, this.myPanel.configuration());
        CliModel model = this.myPanel.model();
        String executable = model.getExecutableCommand();
        List<String> parameterizable = model.getParameterizable();
        model.store();
        super.doOKAction();
        new CliRunner(this.myProject, this.myDataSource, this.myPanel.configuration(), parameterizable, executable).run();
    }

    protected boolean shouldAddErrorNearButtons() {
        return !CliDialog.isMoveHelpButtonLeft();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myPanel.model().getPreferredFocusableComponent();
    }

    @Nullable
    protected ValidationInfo doValidate() {
        return this.myPanel.validator().createInfo(this.myPanel.model());
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return DIMENSION_KEY;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JComponent component = this.myPanel.component();
        component.setMinimumSize(MIN_SIZE);
        component.setPreferredSize(PREFERRED_SIZE);
        return component;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "configurations";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "title";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/cli/CliDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MySingleConfigurationPanel
    extends JPanel
    implements MyPanel {
        private final CliModel myModel;
        private final CliConfiguration myConfiguration;
        private final CliDialogValidator myValidator;

        MySingleConfigurationPanel(@NotNull Project project, @NotNull Collection<DbElement> elements, @NotNull CliConfigurationPack configurations) {
            if (project == null) {
                MySingleConfigurationPanel.$$$reportNull$$$0(0);
            }
            if (elements == null) {
                MySingleConfigurationPanel.$$$reportNull$$$0(1);
            }
            if (configurations == null) {
                MySingleConfigurationPanel.$$$reportNull$$$0(2);
            }
            super(new BorderLayout());
            CliConfiguration first2 = configurations.first();
            this.myConfiguration = Objects.requireNonNull(first2);
            this.myModel = new CliModel(project, this.myConfiguration.getObjectsPreparer().prepare(elements).get(), this.myConfiguration);
            this.myValidator = this.myConfiguration.getValidator();
            Disposer.register((Disposable)this, (Disposable)this.myModel);
            Disposer.register((Disposable)this.myModel, (Disposable)this.myValidator);
            this.add(this.myModel.getComponent());
        }

        @Override
        @NotNull
        public CliDialogValidator validator() {
            CliDialogValidator cliDialogValidator = this.myValidator;
            if (cliDialogValidator == null) {
                MySingleConfigurationPanel.$$$reportNull$$$0(3);
            }
            return cliDialogValidator;
        }

        @Override
        @NotNull
        public CliConfiguration configuration() {
            CliConfiguration cliConfiguration = this.myConfiguration;
            if (cliConfiguration == null) {
                MySingleConfigurationPanel.$$$reportNull$$$0(4);
            }
            return cliConfiguration;
        }

        @Override
        @NotNull
        public CliModel model() {
            CliModel cliModel = this.myModel;
            if (cliModel == null) {
                MySingleConfigurationPanel.$$$reportNull$$$0(5);
            }
            return cliModel;
        }

        @Override
        @NotNull
        public JComponent component() {
            MySingleConfigurationPanel mySingleConfigurationPanel = this;
            if (mySingleConfigurationPanel == null) {
                MySingleConfigurationPanel.$$$reportNull$$$0(6);
            }
            return mySingleConfigurationPanel;
        }

        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurations";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/cli/CliDialog$MySingleConfigurationPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/cli/CliDialog$MySingleConfigurationPanel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "validator";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "configuration";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "model";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "component";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyMultiConfigurationPanel
    extends JPanel
    implements MyPanel {
        private final CardLayout myLayout;
        private final Map<CliConfiguration, Data> myMap;
        private final JPanel myCardPanel;
        private final ActionToolbar myToolbar;
        private CliConfiguration mySelectedConfiguration;

        MyMultiConfigurationPanel(@NotNull Project project, @NotNull Collection<DbElement> elements, @NotNull CliConfigurationPack configurations) {
            if (project == null) {
                MyMultiConfigurationPanel.$$$reportNull$$$0(0);
            }
            if (elements == null) {
                MyMultiConfigurationPanel.$$$reportNull$$$0(1);
            }
            if (configurations == null) {
                MyMultiConfigurationPanel.$$$reportNull$$$0(2);
            }
            super(new BorderLayout());
            this.myLayout = new CardLayout();
            this.myMap = new HashMap<CliConfiguration, Data>();
            this.myCardPanel = new JPanel(this.myLayout);
            configurations.getConfigurations().forEach(c2 -> {
                CliDialogValidator validator = c2.getValidator();
                CliModel model = new CliModel(project, c2.getObjectsPreparer().prepare(elements).get(), (CliConfiguration)c2);
                Disposer.register((Disposable)this, (Disposable)model);
                Disposer.register((Disposable)model, (Disposable)validator);
                this.myMap.put((CliConfiguration)c2, new Data(validator, model));
                this.myCardPanel.add((Component)model.getComponent(), c2.getName());
            });
            ArrayList<Object> actions = new ArrayList<Object>();
            boolean first2 = true;
            for (CliConfiguration configuration : configurations.getConfigurations()) {
                if (!first2) {
                    actions.add(new Separator());
                }
                first2 = false;
                actions.add((Object)new MyToggle(configuration));
            }
            this.myToolbar = ActionManager.getInstance().createActionToolbar("toolbar", (ActionGroup)new DefaultActionGroup(actions), true);
            this.add((Component)this.myToolbar.getComponent(), "North");
            this.add((Component)this.myCardPanel, "Center");
            this.mySelectedConfiguration = (CliConfiguration)ObjectUtils.notNull((Object)CliProperties.getLastUsedConfigurationKey(configurations), (Object)configurations.first());
            this.myLayout.show(this.myCardPanel, Objects.requireNonNull(this.mySelectedConfiguration).getName());
        }

        @Override
        @NotNull
        public CliConfiguration configuration() {
            CliConfiguration cliConfiguration = this.mySelectedConfiguration;
            if (cliConfiguration == null) {
                MyMultiConfigurationPanel.$$$reportNull$$$0(3);
            }
            return cliConfiguration;
        }

        @Override
        @NotNull
        public CliDialogValidator validator() {
            CliDialogValidator cliDialogValidator = this.myMap.get((Object)this.mySelectedConfiguration).validator;
            if (cliDialogValidator == null) {
                MyMultiConfigurationPanel.$$$reportNull$$$0(4);
            }
            return cliDialogValidator;
        }

        @Override
        @NotNull
        public CliModel model() {
            CliModel cliModel = this.myMap.get((Object)this.mySelectedConfiguration).model;
            if (cliModel == null) {
                MyMultiConfigurationPanel.$$$reportNull$$$0(5);
            }
            return cliModel;
        }

        @Override
        @NotNull
        public JComponent component() {
            MyMultiConfigurationPanel myMultiConfigurationPanel = this;
            if (myMultiConfigurationPanel == null) {
                MyMultiConfigurationPanel.$$$reportNull$$$0(6);
            }
            return myMultiConfigurationPanel;
        }

        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurations";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/cli/CliDialog$MyMultiConfigurationPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/cli/CliDialog$MyMultiConfigurationPanel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "configuration";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "validator";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "model";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "component";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private final class MyToggle
        extends ToggleAction
        implements DumbAware {
            private final CliConfiguration myConfiguration;

            private MyToggle(CliConfiguration configuration) {
                if (configuration == null) {
                    MyToggle.$$$reportNull$$$0(0);
                }
                super(StringUtil.escapeMnemonics((String)configuration.getName()));
                this.myConfiguration = configuration;
                this.getTemplatePresentation().setIcon(EmptyIcon.ICON_0);
                this.getTemplatePresentation().setDisabledIcon(EmptyIcon.ICON_0);
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    MyToggle.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabledAndVisible(true);
                super.update(e);
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    MyToggle.$$$reportNull$$$0(2);
                }
                return MyMultiConfigurationPanel.this.mySelectedConfiguration == this.myConfiguration;
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    MyToggle.$$$reportNull$$$0(3);
                }
                if (!state) {
                    return;
                }
                boolean expanded = MyMultiConfigurationPanel.this.myMap.get((Object)MyMultiConfigurationPanel.this.mySelectedConfiguration).model.isExpanded();
                MyMultiConfigurationPanel.this.mySelectedConfiguration = this.myConfiguration;
                MyMultiConfigurationPanel.this.myToolbar.updateActionsImmediately();
                MyMultiConfigurationPanel.this.myMap.get((Object)MyMultiConfigurationPanel.this.mySelectedConfiguration).model.setExpanded(expanded);
                MyMultiConfigurationPanel.this.myLayout.show(MyMultiConfigurationPanel.this.myCardPanel, MyMultiConfigurationPanel.this.mySelectedConfiguration.getName());
            }

            public boolean displayTextInToolbar() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "configuration";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/cli/CliDialog$MyMultiConfigurationPanel$MyToggle";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static final class Data {
            final CliDialogValidator validator;
            final CliModel model;

            private Data(@NotNull CliDialogValidator validator, @NotNull CliModel model) {
                if (validator == null) {
                    Data.$$$reportNull$$$0(0);
                }
                if (model == null) {
                    Data.$$$reportNull$$$0(1);
                }
                this.validator = validator;
                this.model = model;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "validator";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "model";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/cli/CliDialog$MyMultiConfigurationPanel$Data";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static interface MyPanel
    extends Disposable {
        @NotNull
        public CliDialogValidator validator();

        @NotNull
        public CliConfiguration configuration();

        @NotNull
        public CliModel model();

        @NotNull
        public JComponent component();
    }
}

