/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.credentialStore.Credentials;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.cli.CliConfiguration;
import com.intellij.database.cli.CliLexeme;
import com.intellij.database.cli.DbCliUtil;
import com.intellij.database.cli.LexemeIndicators;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.DataSourceSslConfiguration;
import com.intellij.database.dataSource.DatabaseConnectionEstablisher;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.DatabaseCredentialsAuthProvider;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.ide.passwordSafe.ui.PasswordPromptComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.io.Closeable;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CliCredentialsManager
implements Closeable {
    private static final Logger LOG = Logger.getInstance(CliCredentialsManager.class);
    private final LocalDataSource myDataSource;
    private final CliConfiguration myConfiguration;
    private final Project myProject;
    private final String myCommand;
    private final List<CliLexeme> myLexemes;

    public CliCredentialsManager(@NotNull LocalDataSource source, @NotNull CliConfiguration configuration, @NotNull Project project, @NotNull String command) {
        if (source == null) {
            CliCredentialsManager.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            CliCredentialsManager.$$$reportNull$$$0(1);
        }
        if (project == null) {
            CliCredentialsManager.$$$reportNull$$$0(2);
        }
        if (command == null) {
            CliCredentialsManager.$$$reportNull$$$0(3);
        }
        this.myDataSource = source;
        this.myConfiguration = configuration;
        this.myProject = project;
        this.myCommand = StringUtil.trim((String)command);
        this.myLexemes = DbCliUtil.rawLexemes(this.myCommand);
    }

    @NotNull
    public Pair<String, String> getCommandAndPassword() {
        Pair<String, String> pair = this.getHostPort();
        if (pair == null) {
            CliCredentialsManager.cancelDump();
        }
        ConnectionData host = this.getData(this.myConfiguration.getHostIndicators(), (String)pair.getFirst());
        ConnectionData port = this.getData(this.myConfiguration.getPortIndicators(), (String)pair.getSecond());
        DataSourceSslConfiguration cfg = this.myDataSource.getSslCfg();
        ConnectionData sslCa = cfg == null || !cfg.myEnabled ? null : this.getData(this.myConfiguration.getSslCaIndicators(), cfg.myCaCertPath);
        ConnectionData sslCert = cfg == null || !cfg.myEnabled ? null : this.getData(this.myConfiguration.getSslCertIndicators(), cfg.myClientCertPath);
        ConnectionData sslKey = cfg == null || !cfg.myEnabled ? null : this.getData(this.myConfiguration.getSslKeyIndicators(), cfg.myClientKeyPath);
        CliCredentials credentials = this.getCredentials(this.myDataSource);
        ConnectionData username = credentials.getUsername();
        ConnectionData password = credentials.getPassword();
        if (!username.isEnteredByUser() && username.isEmpty()) {
            CliCredentialsManager.cancelDump();
        }
        String sanitizedCommand = this.syncCredentials(this.myCommand, credentials);
        CliConfiguration.Parameters parameters = new CliConfiguration.Parameters(CliCredentialsManager.getValue(username), CliCredentialsManager.getValue(host), CliCredentialsManager.getValue(port), CliCredentialsManager.getValue(sslCa), CliCredentialsManager.getValue(sslCert), CliCredentialsManager.getValue(sslKey));
        String command = this.myConfiguration.getCommand(sanitizedCommand, parameters);
        Pair pair2 = Pair.create((Object)command, (Object)CliCredentialsManager.getValue(password));
        if (pair2 == null) {
            CliCredentialsManager.$$$reportNull$$$0(4);
        }
        return pair2;
    }

    @Nullable
    private Pair<String, String> getHostPort() {
        try {
            DataSourceSshTunnelConfiguration configuration = this.myDataSource.getSshConfiguration();
            if (configuration != null && configuration.isEnabled()) {
                Integer localPort;
                boolean inUnitTest = ApplicationManager.getApplication().isUnitTestMode();
                if (inUnitTest) {
                    localPort = Objects.requireNonNull(configuration.getSshConfig(null)).getLocalPort();
                } else {
                    JdbcDriverManager manager = JdbcDriverManager.getDriverManager(this.myProject);
                    manager.getDriver(this.myDataSource, manager.getDefaultRunConfiguration(this.myDataSource, DatabaseCredentials.getInstance()));
                    localPort = manager.getLocalPort(this.myDataSource);
                }
                if (localPort != null) {
                    return Pair.create((Object)"localhost", (Object)String.valueOf(localPort));
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Can't create SSH tunnel. Trying to connect with default host and port", (Throwable)e);
        }
        DatabaseDriver driver = this.myDataSource.getDatabaseDriver();
        RawConnectionConfig config = this.myDataSource.getConnectionConfig();
        if (driver == null || config == null) {
            CliCredentialsManager.cancelDump();
        }
        List<StatelessJdbcUrlParser> parsers = driver.getJDBCUrlParsers();
        String url = config.getUrl();
        return JdbcUrlParserUtil.extractHostPort(parsers, url, (Ref<JdbcUrlParser>)Ref.create());
    }

    @Override
    public void close() {
    }

    @Nullable
    private static String getValue(@Nullable ConnectionData data) {
        return data == null || data.isEnteredByUser() || data.isEmpty() ? null : data.getValue();
    }

    @NotNull
    private CliCredentials getCredentials(@NotNull LocalDataSource source) {
        if (source == null) {
            CliCredentialsManager.$$$reportNull$$$0(5);
        }
        String userName = DbCliUtil.getUserName(source);
        String pass = DbCliUtil.getPassword(source);
        ConnectionData username = this.getData(this.myConfiguration.getUsernameIndicators(), userName);
        ConnectionData password = this.getData(this.myConfiguration.getPasswordIndicators(), pass);
        boolean differentSources = password.isEnteredByUser() != username.isEnteredByUser();
        boolean canAskPassword = !password.isEnteredByUser() || !this.myConfiguration.getPasswordIndicators().isSuppress();
        boolean canAskUsername = !username.isEnteredByUser() || !this.myConfiguration.getUsernameIndicators().isSuppress();
        boolean somethingEmpty = !password.isEnteredByUser() && password.isEmpty() || !username.isEnteredByUser() && username.isEmpty();
        boolean ask = differentSources && canAskPassword && canAskUsername || somethingEmpty;
        return !ask || ApplicationManager.getApplication().isUnitTestMode() ? new CliCredentials(username, password, false, false) : this.askCredentials(this.myLexemes, source, username, password);
    }

    @NotNull
    private String syncCredentials(@NotNull String command, @NotNull CliCredentials credentials) {
        if (command == null) {
            CliCredentialsManager.$$$reportNull$$$0(6);
        }
        if (credentials == null) {
            CliCredentialsManager.$$$reportNull$$$0(7);
        }
        LexemeIndicators usernameIndicators = this.myConfiguration.getUsernameIndicators();
        LexemeIndicators passwordIndicators = this.myConfiguration.getPasswordIndicators();
        String string = DbCliUtil.getCommandWithout(command, credentials.isUsernameRemoveNeeded() ? usernameIndicators : null, credentials.isPasswordRemoveNeeded() ? passwordIndicators : null);
        if (string == null) {
            CliCredentialsManager.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private CliCredentials askCredentials(@NotNull List<CliLexeme> lexemes, @NotNull LocalDataSource source, @NotNull ConnectionData username, @NotNull ConnectionData password) {
        Pair<String, String> pair;
        if (lexemes == null) {
            CliCredentialsManager.$$$reportNull$$$0(9);
        }
        if (source == null) {
            CliCredentialsManager.$$$reportNull$$$0(10);
        }
        if (username == null) {
            CliCredentialsManager.$$$reportNull$$$0(11);
        }
        if (password == null) {
            CliCredentialsManager.$$$reportNull$$$0(12);
        }
        boolean noStore = username.isEnteredByUser() || password.isEnteredByUser();
        LexemeIndicators usernameIndicators = this.myConfiguration.getUsernameIndicators();
        LexemeIndicators passwordIndicators = this.myConfiguration.getPasswordIndicators();
        String usernameForDialog = username.isEnteredByUser() ? CliCredentialsManager.getArgumentValue(lexemes, usernameIndicators) : username.getValue();
        String passwordForDialog = password.isEnteredByUser() ? CliCredentialsManager.getArgumentValue(lexemes, passwordIndicators) : password.getValue();
        Pair<String, String> pair2 = pair = noStore ? CliCredentialsManager.getNoStored(source, usernameForDialog, passwordForDialog) : this.getStored(source, usernameForDialog);
        if (pair == null) {
            CliCredentialsManager.cancelDump();
        }
        boolean removeUsername = username.isEnteredByUser() && !StringUtil.equals((CharSequence)usernameForDialog, (CharSequence)((CharSequence)pair.getFirst()));
        boolean removePassword = password.isEnteredByUser() && !StringUtil.equals((CharSequence)passwordForDialog, (CharSequence)((CharSequence)pair.getSecond()));
        boolean notSetUsername = !removeUsername && username.isEnteredByUser();
        boolean notSetPassword = !removePassword && password.isEnteredByUser();
        return new CliCredentials(new ConnectionData((String)pair.getFirst(), notSetUsername), new ConnectionData((String)pair.getSecond(), notSetPassword), removeUsername, removePassword);
    }

    @Nullable
    private static Pair<String, String> getNoStored(@NotNull LocalDataSource source, @Nullable String username, @Nullable String password) {
        if (source == null) {
            CliCredentialsManager.$$$reportNull$$$0(13);
        }
        return (Pair)UIUtil.invokeAndWaitIfNeeded(() -> {
            PasswordPromptComponent component = new PasswordPromptComponent(true, DatabaseBundle.message((String)"dialog.message.enter.username.password", (Object[])new Object[0]), true, null);
            component.setUserName(username);
            component.setPassword(password);
            DialogBuilder builder = new DialogBuilder().centerPanel(component.getComponent()).title(DatabaseBundle.message((String)"dialog.title.dumping", (Object[])new Object[]{source.getName()})).okActionEnabled(true);
            builder.addCancelAction();
            builder.addOkAction();
            builder.setPreferredFocusComponent(component.getPreferredFocusedComponent());
            if (!builder.showAndGet()) {
                return null;
            }
            return Pair.create((Object)component.getUserName(), (Object)String.valueOf(component.getPassword()));
        });
    }

    @Nullable
    private Pair<String, String> getStored(@NotNull LocalDataSource source, @Nullable String username) {
        if (source == null) {
            CliCredentialsManager.$$$reportNull$$$0(14);
        }
        Credentials asked = null;
        try {
            DatabaseConnectionInterceptor.ProtoConnection proto = DatabaseCredentialsAuthProvider.askCredentialsWhenFailed(DatabaseConnectionEstablisher.createProtoConnection(ConsoleRunConfiguration.newConfiguration(this.myProject), source), DatabaseBundle.message((String)"dialog.message.enter.username.password", (Object[])new Object[0]), false).unwrap().toCompletableFuture().get();
            asked = DatabaseCredentialsAuthProvider.extractCredentials(proto);
        }
        catch (InterruptedException e) {
            throw new ProcessCanceledException();
        }
        catch (ExecutionException e) {
            if (AsyncUtil.isCancellation(e)) {
                throw new ProcessCanceledException();
            }
            LOG.error((Throwable)e);
        }
        return asked == null || StringUtil.isEmpty((String)asked.getUserName()) ? null : Pair.create((Object)asked.getUserName(), (Object)asked.getPasswordAsString());
    }

    @Nullable
    private static String getArgumentValue(@NotNull List<CliLexeme> lexemes, @NotNull LexemeIndicators indicators) {
        if (lexemes == null) {
            CliCredentialsManager.$$$reportNull$$$0(15);
        }
        if (indicators == null) {
            CliCredentialsManager.$$$reportNull$$$0(16);
        }
        if (indicators.isSuppress()) {
            return "";
        }
        if (!indicators.hasParameter()) {
            return null;
        }
        int index2 = DbCliUtil.getIndexFromCommand(lexemes, indicators);
        if (index2 == -1 || index2 == lexemes.size() - 1) {
            return null;
        }
        return StringUtil.trim((String)lexemes.get(index2 + 1).getText());
    }

    private static void cancelDump() {
        throw new ProcessCanceledException();
    }

    @NotNull
    private ConnectionData getData(@Nullable LexemeIndicators indicators, @NotNull String string) {
        if (string == null) {
            CliCredentialsManager.$$$reportNull$$$0(17);
        }
        return new ConnectionData(string, this.containsIndicator(indicators));
    }

    private boolean containsIndicator(@Nullable LexemeIndicators indicators) {
        if (indicators == null) {
            return false;
        }
        return ContainerUtil.find(this.myLexemes, DbCliUtil.argumentWithParameterFinder(this.myLexemes, indicators)) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/cli/CliCredentialsManager";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexemes";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "username";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "password";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicators";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/cli/CliCredentialsManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandAndPassword";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "syncCredentials";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCredentials";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "syncCredentials";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "askCredentials";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getNoStored";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getStored";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentValue";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class CliCredentials {
        private final ConnectionData myUsername;
        private final ConnectionData myPassword;
        private final boolean myUsernameRemoveNeeded;
        private final boolean myPasswordRemoveNeeded;

        private CliCredentials(@NotNull ConnectionData username, @NotNull ConnectionData password, boolean usernameRemoveNeeded, boolean passwordRemoveNeeded) {
            if (username == null) {
                CliCredentials.$$$reportNull$$$0(0);
            }
            if (password == null) {
                CliCredentials.$$$reportNull$$$0(1);
            }
            this.myUsername = username;
            this.myPassword = password;
            this.myUsernameRemoveNeeded = usernameRemoveNeeded;
            this.myPasswordRemoveNeeded = passwordRemoveNeeded;
        }

        public boolean isPasswordRemoveNeeded() {
            return this.myPasswordRemoveNeeded;
        }

        public boolean isUsernameRemoveNeeded() {
            return this.myUsernameRemoveNeeded;
        }

        @NotNull
        public ConnectionData getPassword() {
            ConnectionData connectionData = this.myPassword;
            if (connectionData == null) {
                CliCredentials.$$$reportNull$$$0(2);
            }
            return connectionData;
        }

        @NotNull
        public ConnectionData getUsername() {
            ConnectionData connectionData = this.myUsername;
            if (connectionData == null) {
                CliCredentials.$$$reportNull$$$0(3);
            }
            return connectionData;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "username";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "password";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/cli/CliCredentialsManager$CliCredentials";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/cli/CliCredentialsManager$CliCredentials";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPassword";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUsername";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ConnectionData {
        private final String myValue;
        private final boolean myEnteredByUser;

        ConnectionData(@Nullable String value2, boolean enteredByUser) {
            this.myValue = value2;
            this.myEnteredByUser = enteredByUser;
        }

        boolean isEnteredByUser() {
            return this.myEnteredByUser;
        }

        @Nullable
        String getValue() {
            return this.myValue;
        }

        boolean isEmpty() {
            return this.myValue != null && this.myValue.isEmpty();
        }
    }
}

