/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.actions.QueryActionBase;
import com.intellij.database.console.DialogVisibilityController;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.run.ParametersHolder;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowSqlParametersPanelAction
extends DumbAwareAction {
    private static final Key<ScriptModel.PStorage> PARAM_STORAGE_KEY = Key.create((String)"sql.parameters");
    private static final Key<ParametersHolder> HOLDER_KEY = Key.create((String)"sql.parameters.holder");

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowSqlParametersPanelAction.$$$reportNull$$$0(0);
        }
        boolean enabled = ShowSqlParametersPanelAction.getActionData(e) != null;
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(enabled || e.isFromActionToolbar());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowSqlParametersPanelAction.$$$reportNull$$$0(1);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        ParametersHolder holder = ShowSqlParametersPanelAction.getParametersHolder(e);
        if (holder != null) {
            holder.toggleParamContent(true);
        }
    }

    @NotNull
    public static ScriptModel.PStorage getStorage(@NotNull JdbcConsole console) {
        ScriptModel.PStorage oldStorage;
        if (console == null) {
            ShowSqlParametersPanelAction.$$$reportNull$$$0(2);
        }
        if ((oldStorage = (ScriptModel.PStorage)console.getUserData(PARAM_STORAGE_KEY)) != null) {
            ScriptModel.PStorage pStorage = oldStorage;
            if (pStorage == null) {
                ShowSqlParametersPanelAction.$$$reportNull$$$0(3);
            }
            return pStorage;
        }
        ScriptModel.PStorage newStorage = ScriptModel.PStorage.newStorage();
        console.putUserData(PARAM_STORAGE_KEY, newStorage);
        ScriptModel.PStorage pStorage = newStorage;
        if (pStorage == null) {
            ShowSqlParametersPanelAction.$$$reportNull$$$0(4);
        }
        return pStorage;
    }

    public static void migrate(@Nullable JdbcConsole from, @NotNull JdbcConsole to) {
        ScriptModel.PStorage oldStorage;
        if (to == null) {
            ShowSqlParametersPanelAction.$$$reportNull$$$0(5);
        }
        ScriptModel.PStorage pStorage = oldStorage = from == null ? null : (ScriptModel.PStorage)from.getUserData(PARAM_STORAGE_KEY);
        if (oldStorage != null) {
            to.putUserData(PARAM_STORAGE_KEY, oldStorage);
        }
    }

    @Nullable
    private static ParametersHolder getParametersHolder(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowSqlParametersPanelAction.$$$reportNull$$$0(6);
        }
        ActionData data = ShowSqlParametersPanelAction.getActionData(e);
        Project project = e.getProject();
        return data == null || project == null ? null : ShowSqlParametersPanelAction.getParametersHolder(project, data);
    }

    @NotNull
    static ParametersHolder getParametersHolder(@NotNull Project project, @NotNull ActionData data) {
        ParametersHolder existing;
        if (project == null) {
            ShowSqlParametersPanelAction.$$$reportNull$$$0(7);
        }
        if (data == null) {
            ShowSqlParametersPanelAction.$$$reportNull$$$0(8);
        }
        if ((existing = (ParametersHolder)HOLDER_KEY.get((UserDataHolder)data.console)) != null) {
            ParametersHolder parametersHolder = existing;
            if (parametersHolder == null) {
                ShowSqlParametersPanelAction.$$$reportNull$$$0(9);
            }
            return parametersHolder;
        }
        Disposable disposable2 = () -> HOLDER_KEY.set((UserDataHolder)data.console, null);
        DialogVisibilityController controller = new DialogVisibilityController(disposable2);
        ScriptModel.PStorage storage = ShowSqlParametersPanelAction.getStorage(data.console);
        MyHelper helper = new MyHelper(data.virtualFile, data.editor);
        ParametersHolder holder = new ParametersHolder(project, storage, data.info.model, helper, controller);
        Disposer.register((Disposable)disposable2, (Disposable)holder);
        HOLDER_KEY.set((UserDataHolder)data.console, (Object)holder);
        holder.attachToEditor();
        ParametersHolder parametersHolder = holder;
        if (parametersHolder == null) {
            ShowSqlParametersPanelAction.$$$reportNull$$$0(10);
        }
        return parametersHolder;
    }

    @Nullable
    static ActionData getActionData(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowSqlParametersPanelAction.$$$reportNull$$$0(11);
        }
        Project project = e.getProject();
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        JdbcConsole console = JdbcConsole.findConsole(e);
        JdbcConsoleProvider.Info info = QueryActionBase.getInfoClassic(e, DatabaseSettings.getDefaultExecOption());
        return console != null && project != null && virtualFile != null && editor != null && info != null && JdbcConsoleProvider.isSqlAtPlace(file, editor) ? new ActionData(editor, virtualFile, console, info) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/ShowSqlParametersPanelAction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/ShowSqlParametersPanelAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorage";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getParametersHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getStorage";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "migrate";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getParametersHolder";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getActionData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ActionData {
        final Editor editor;
        final VirtualFile virtualFile;
        final JdbcConsole console;
        final JdbcConsoleProvider.Info info;

        ActionData(@NotNull Editor editor, @NotNull VirtualFile virtualFile, @NotNull JdbcConsole console, @NotNull JdbcConsoleProvider.Info info) {
            if (editor == null) {
                ActionData.$$$reportNull$$$0(0);
            }
            if (virtualFile == null) {
                ActionData.$$$reportNull$$$0(1);
            }
            if (console == null) {
                ActionData.$$$reportNull$$$0(2);
            }
            if (info == null) {
                ActionData.$$$reportNull$$$0(3);
            }
            this.editor = editor;
            this.virtualFile = virtualFile;
            this.console = console;
            this.info = info;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "virtualFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "console";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "info";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/actions/ShowSqlParametersPanelAction$ActionData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyHelper
    implements ParametersHolder.Helper {
        private final VirtualFile myVirtualFile;
        private final Editor myEditor;

        MyHelper(@NotNull VirtualFile file, @NotNull Editor editor) {
            if (file == null) {
                MyHelper.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                MyHelper.$$$reportNull$$$0(1);
            }
            this.myVirtualFile = file;
            this.myEditor = editor;
        }

        @Override
        @NotNull
        public Document getDocument() {
            Document document = this.myEditor.getDocument();
            if (document == null) {
                MyHelper.$$$reportNull$$$0(2);
            }
            return document;
        }

        @Override
        @NotNull
        public Editor getEditor() {
            Editor editor = this.myEditor;
            if (editor == null) {
                MyHelper.$$$reportNull$$$0(3);
            }
            return editor;
        }

        @Override
        @NotNull
        public VirtualFile getVirtualFile() {
            VirtualFile virtualFile = this.myVirtualFile;
            if (virtualFile == null) {
                MyHelper.$$$reportNull$$$0(4);
            }
            return virtualFile;
        }

        @Override
        public boolean shouldOpenFileOnEditParameters() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/ShowSqlParametersPanelAction$MyHelper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/ShowSqlParametersPanelAction$MyHelper";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDocument";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVirtualFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

