/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbGridGotoRelatedProvider;
import com.intellij.database.run.actions.AlignedIconWithTextAction;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.ObjectUtils;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.awt.event.MouseEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OpenEditorAction
extends DumbAwareAction {
    public OpenEditorAction() {
        this.setInjectedContext(true);
    }

    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            OpenEditorAction.$$$reportNull$$$0(0);
        }
        boolean enabled = (project = e.getProject()) != null && this.isEnabled(e) && this.getNavigatables(project, e, false).filter(Navigatable::canNavigate).isNotEmpty();
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(enabled || e.isFromActionToolbar());
    }

    protected boolean isEnabled(@NotNull AnActionEvent e) {
        boolean mouseSelection;
        if (e == null) {
            OpenEditorAction.$$$reportNull$$$0(1);
        }
        return !(mouseSelection = this.isMouseSelection(e)) && e.getData(CommonDataKeys.EDITOR) == null;
    }

    protected boolean isMouseSelection(@NotNull AnActionEvent e) {
        if (e == null) {
            OpenEditorAction.$$$reportNull$$$0(2);
        }
        return e.getInputEvent() instanceof MouseEvent && UIUtil.isToggleListSelectionEvent((MouseEvent)((MouseEvent)e.getInputEvent()));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            OpenEditorAction.$$$reportNull$$$0(3);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        OpenSourceUtil.navigate((boolean)true, (boolean)true, this.getNavigatables(project, e, true));
    }

    @NotNull
    protected JBIterable<Navigatable> getNavigatables(@NotNull Project project, @NotNull AnActionEvent e, boolean forInvoke) {
        if (project == null) {
            OpenEditorAction.$$$reportNull$$$0(4);
        }
        if (e == null) {
            OpenEditorAction.$$$reportNull$$$0(5);
        }
        JBIterable jBIterable = JBIterable.of((Object[])((Navigatable[])e.getData(CommonDataKeys.NAVIGATABLE_ARRAY)));
        if (jBIterable == null) {
            OpenEditorAction.$$$reportNull$$$0(6);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/OpenEditorAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/OpenEditorAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigatables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isMouseSelection";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNavigatables";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class OpenDDLGridAction
    extends AlignedIconWithTextAction
    implements DumbAware {
        OpenDDLGridAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                OpenDDLGridAction.$$$reportNull$$$0(0);
            }
            PsiElement element2 = (PsiElement)e.getData(CommonDataKeys.PSI_ELEMENT);
            boolean enabled = e.getData(DatabaseDataKeys.DATA_GRID_KEY) != null && DbGridGotoRelatedProvider.getTargetElement(element2) != null;
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DbElement target;
            if (e == null) {
                OpenDDLGridAction.$$$reportNull$$$0(1);
            }
            if ((target = DbGridGotoRelatedProvider.getTargetElement((PsiElement)e.getData(CommonDataKeys.PSI_ELEMENT))) == null) {
                return;
            }
            EditorWindow editorWindow = (EditorWindow)e.getData(EditorWindow.DATA_KEY);
            if (editorWindow != null) {
                FileEditorManagerEx.getInstanceEx((Project)target.getProject()).setCurrentWindow(editorWindow);
            }
            DbNavigationUtils.navigateToSource(target, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/actions/OpenEditorAction$OpenDDLGridAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class OpenDDLAction
    extends OpenEditorAction {
        OpenDDLAction() {
        }

        @Override
        @NotNull
        protected JBIterable<Navigatable> getNavigatables(@NotNull Project project, @NotNull AnActionEvent e, boolean forInvoke) {
            if (project == null) {
                OpenDDLAction.$$$reportNull$$$0(0);
            }
            if (e == null) {
                OpenDDLAction.$$$reportNull$$$0(1);
            }
            JBIterable jBIterable = super.getNavigatables(project, e, forInvoke).filterMap(n -> {
                DbElement o = DbNavigationUtils.extractDbElement(n);
                if (o == null) {
                    return null;
                }
                if (DbSqlUtil.isSqlElement(o)) {
                    return o;
                }
                VirtualFile file = DbNavigationUtils.getContainingFile(o, forInvoke);
                if (file == null) {
                    return null;
                }
                if (!forInvoke) {
                    return new OpenFileDescriptor(project, file);
                }
                return DbNavigationUtils.createToSourceNavigatable(o);
            });
            if (jBIterable == null) {
                OpenDDLAction.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/OpenEditorAction$OpenDDLAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/OpenEditorAction$OpenDDLAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigatables";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getNavigatables";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class OpenConsoleAction
    extends OpenEditorAction {
        OpenConsoleAction() {
        }

        @Override
        protected boolean isEnabled(@NotNull AnActionEvent e) {
            if (e == null) {
                OpenConsoleAction.$$$reportNull$$$0(0);
            }
            return !this.isMouseSelection(e);
        }

        @Override
        @NotNull
        protected JBIterable<Navigatable> getNavigatables(@NotNull Project project, @NotNull AnActionEvent e, boolean forInvoke) {
            if (project == null) {
                OpenConsoleAction.$$$reportNull$$$0(1);
            }
            if (e == null) {
                OpenConsoleAction.$$$reportNull$$$0(2);
            }
            JBIterable jBIterable = super.getNavigatables(project, e, forInvoke).filterMap(o -> {
                if (e.getData(CommonDataKeys.EDITOR) != null) {
                    return null;
                }
                DbElement element2 = DbNavigationUtils.extractDbElement(o);
                if (element2 != null && DbNavigationUtils.canNavigateToDataSourceFile(element2)) {
                    return DbNavigationUtils.createToDataSourceFileNavigatable(element2);
                }
                return null;
            });
            if (jBIterable == null) {
                OpenConsoleAction.$$$reportNull$$$0(3);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/OpenEditorAction$OpenConsoleAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/OpenEditorAction$OpenConsoleAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigatables";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isEnabled";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getNavigatables";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class OpenDataAction
    extends OpenEditorAction {
        OpenDataAction() {
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                OpenDataAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            boolean goTo = "EditorPopup".equals(e.getPlace());
            String text2 = DatabaseBundle.message((String)(goTo ? "action.Jdbc.OpenEditor.Data.GoTo.text" : "action.Jdbc.OpenEditor.Data.text"), (Object[])new Object[0]);
            e.getPresentation().setText(text2);
        }

        @Override
        protected boolean isEnabled(@NotNull AnActionEvent e) {
            if (e == null) {
                OpenDataAction.$$$reportNull$$$0(1);
            }
            return !this.isMouseSelection(e);
        }

        @Override
        @NotNull
        protected JBIterable<Navigatable> getNavigatables(@NotNull Project project, @NotNull AnActionEvent e, boolean forInvoke) {
            if (project == null) {
                OpenDataAction.$$$reportNull$$$0(2);
            }
            if (e == null) {
                OpenDataAction.$$$reportNull$$$0(3);
            }
            JBIterable jBIterable = super.getNavigatables(project, e, forInvoke).filterMap(o -> {
                DbElement element2 = OpenDataAction.getDbElement(o);
                if (element2 == null || !DbNavigationUtils.canNavigateToData(element2)) {
                    return null;
                }
                return DbNavigationUtils.createToDataNavigatable(element2);
            });
            if (jBIterable == null) {
                OpenDataAction.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }

        @Nullable
        private static DbElement getDbElement(Navigatable o) {
            DbElement element2 = DbNavigationUtils.extractDbElement(o);
            if (element2 != null) {
                return element2;
            }
            SqlDefinition def = (SqlDefinition)ObjectUtils.tryCast((Object)o, SqlDefinition.class);
            if (def != null) {
                return (DbElement)SqlPsiFacade.getInstance((Project)def.getProject()).findRelatedDbElements((PsiElement)def, false).first();
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/OpenEditorAction$OpenDataAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/OpenEditorAction$OpenDataAction";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigatables";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isEnabled";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getNavigatables";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

