/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.Dbms;
import com.intellij.database.actions.BasicElementAction;
import com.intellij.database.dataSource.DataSourceStorageCore;
import com.intellij.database.dataSource.DataSourceStorageUtil;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.LocalDataSourceCore;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.MultiMap;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\b\u001a\u0004\u0018\u00010\u00022\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0014J,\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00020\u0012H\u0014J\u001c\u0010\u0014\u001a\u00020\u00052\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00020\u0012H\u0014R\u0014\u0010\u0004\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/actions/HideSchemasAction;", "Lcom/intellij/database/actions/BasicElementAction;", "Lcom/intellij/database/model/basic/BasicNamespace;", "()V", "expandGroupItems", "", "getExpandGroupItems", "()Z", "cast", "node", "Lcom/intellij/database/model/basic/BasicNode;", "doIt", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "selection", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/database/model/basic/BasicModel;", "enabled", "intellij.database.impl"})
public final class HideSchemasAction
extends BasicElementAction<BasicNamespace> {
    @Override
    protected boolean getExpandGroupItems() {
        return false;
    }

    @Override
    @Nullable
    protected BasicNamespace cast(@Nullable BasicNode node) {
        BasicNode basicNode = node;
        if (!(basicNode instanceof BasicNamespace)) {
            basicNode = null;
        }
        return (BasicNamespace)basicNode;
    }

    @Override
    protected boolean enabled(@NotNull MultiMap<BasicModel, BasicNamespace> selection) {
        Intrinsics.checkNotNullParameter(selection, (String)"selection");
        Iterator iterator = selection.values().iterator();
        while (iterator.hasNext()) {
            BasicNamespace element2;
            BasicNamespace basicNamespace = element2 = (BasicNamespace)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)basicNamespace, (String)"element");
            if (!Intrinsics.areEqual((Object)basicNamespace.getKind(), (Object)ObjectKind.DATABASE) || !element2.isCurrent()) continue;
            BasicModel basicModel = element2.getModel();
            if (!Intrinsics.areEqual((Object)(basicModel != null ? basicModel.getDbms() : null), (Object)Dbms.POSTGRES)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void doIt(@NotNull AnActionEvent e, @NotNull Project project, @NotNull MultiMap<BasicModel, BasicNamespace> selection) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(selection, (String)"selection");
        DataSourceStorageCore dataSourceStorageCore = DataSourceStorageUtil.getProjectStorage(project);
        Intrinsics.checkNotNullExpressionValue((Object)dataSourceStorageCore, (String)"DataSourceStorageUtil.getProjectStorage(project)");
        for (LocalDataSourceCore localDataSourceCore : dataSourceStorageCore.getDataSources()) {
            DasModel model;
            if (!(localDataSourceCore instanceof LocalDataSource)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)((LocalDataSource)localDataSourceCore).getModel(), (String)"dataSource.model");
            if (!(model instanceof BasicModel) || !selection.containsKey((Object)model)) continue;
            DataSourceUiUtil.setNamespacesVisible(project, (LocalDataSource)localDataSourceCore, selection.get((Object)model), false);
        }
    }
}

