/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.google.common.collect.ImmutableMap;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.actions.ActionStatus;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dialects.AbstractDefinitionProvider;
import com.intellij.database.dialects.DefinitionProvider;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasSchemaChild;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicMultiDatabaseRoot;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.script.generator.CustomScriptingOptions;
import com.intellij.database.script.generator.DefaultScriptingOptions;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingOption;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.script.generator.UtilKt;
import com.intellij.database.script.generator.ui.ScriptGeneratorTool;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.TreePattern;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.DatabaseView;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateSqlActions {
    private static final ScriptingOptions SCRIPTING_OPTIONS_FOR_CLIPBOARD = DefaultScriptingOptions.INSTANCE;
    private static final ScriptingOptions SCRIPTING_OPTIONS_FOR_CONSOLE = new CustomScriptingOptions((Map<ScriptingOption<?>, ? extends Object>)ImmutableMap.of(ScriptingOptionStatic.CREATE_OR_REPLACE, (Object)true, ScriptingOptionStatic.CREATE_IF_NOT_EXISTS, (Object)true));

    @NotNull
    private static JBIterable<DbElement> getElements(AnActionEvent e, boolean scriptableOnly) {
        JBIterable result = DatabaseView.getSelectedElements(e.getDataContext(), (Condition<? super DatabaseStructure.Group>)((Condition)o -> o instanceof DatabaseStructure.FamilyGroup));
        JBIterable jBIterable = scriptableOnly ? result.filter(GenerateSqlActions::isDbElementScriptable) : result;
        if (jBIterable == null) {
            GenerateSqlActions.$$$reportNull$$$0(0);
        }
        return jBIterable;
    }

    public static CompletionStage<Void> generateDbDdl(@NotNull DefinitionProvider provider, @NotNull List<DbElement> objects2, @NotNull ErrorHandler handler, @NotNull StringBuilder builder, boolean markDb) {
        List<DbElement> current;
        DbElement first2;
        LocalDataSource dataSource2;
        if (provider == null) {
            GenerateSqlActions.$$$reportNull$$$0(1);
        }
        if (objects2 == null) {
            GenerateSqlActions.$$$reportNull$$$0(2);
        }
        if (handler == null) {
            GenerateSqlActions.$$$reportNull$$$0(3);
        }
        if (builder == null) {
            GenerateSqlActions.$$$reportNull$$$0(4);
        }
        LocalDataSource localDataSource = dataSource2 = (first2 = (DbElement)ContainerUtil.getFirstItem(objects2)) == null ? null : DbImplUtil.getMaybeLocalDataSource((DasDataSource)first2.getDataSource());
        if (dataSource2 == null) {
            return CompletableFuture.completedFuture(null);
        }
        ObjectPath path = ObjectPaths.of((DasObject)DasUtil.getNamespace((DasObject)first2));
        ArrayList rest = new ArrayList();
        if (JdbcUrlParserUtil.isDatabaseBounded(dataSource2)) {
            current = new ArrayList<DbElement>();
            for (DbElement object : objects2) {
                (JdbcUrlParserUtil.outOfBounds(dataSource2, path, ObjectPaths.of((DasObject)object)) ? rest : current).add(object);
            }
        } else {
            current = objects2;
        }
        Project project = first2.getProject();
        SearchPath searchPath = SearchPath.of((ObjectPath)path);
        return DatabaseSessionManager.facade(project, dataSource2, null, searchPath, false, handler, DGDepartment.CODE_GENERATION).runAsync(SessionsUtil.function(connection2 -> {
            if (!rest.isEmpty() || markDb) {
                builder.append("-- Database ").append(DasUtil.getCatalog((DasObject)first2)).append("\n");
            }
            provider.load((Iterable<? extends DasObject>)current, (DatabaseConnection)connection2, builder);
            return null;
        })).thenComposeAsync(r -> rest.isEmpty() ? CompletableFuture.completedFuture(null) : GenerateSqlActions.generateDbDdl(provider, rest, handler, builder, true));
    }

    public static ActionStatus checkActionScriptableStatus(@NotNull JBIterable<DbElement> dbElements, @Nullable Predicate<BasicElement> applicabilityPredicate) {
        if (dbElements == null) {
            GenerateSqlActions.$$$reportNull$$$0(5);
        }
        JBIterable unwantedElements = dbElements.filter(x -> x instanceof DbDataSource || x.getDelegate() instanceof BasicDatabase);
        JBIterable basicElements = dbElements.filterMap(GenerateSqlActions::toBasicElement);
        if (applicabilityPredicate != null) {
            basicElements = basicElements.filter(applicabilityPredicate::test);
        }
        if (basicElements.isEmpty()) {
            return ActionStatus.HIDDEN;
        }
        if (unwantedElements.isNotEmpty()) {
            return ActionStatus.DISABLED;
        }
        BasicModel model = (BasicModel)basicElements.map(BasicNode::getModel).unique().single();
        if (model == null) {
            return ActionStatus.DISABLED;
        }
        JBIterable scriptableElements = basicElements.filter(GenerateSqlActions::isBasicElementScriptable);
        return scriptableElements.isNotEmpty() ? ActionStatus.ENABLED : ActionStatus.DISABLED;
    }

    @Nullable
    private static BasicElement toBasicElement(@Nullable DbElement element2) {
        if (element2 == null) {
            return null;
        }
        Object delegate = element2.getDelegate();
        if (delegate instanceof BasicElement) {
            return (BasicElement)delegate;
        }
        if (element2 instanceof BasicElement) {
            return (BasicElement)element2;
        }
        return null;
    }

    private static boolean isDbElementScriptable(@Nullable DbElement element2) {
        if (element2 == null) {
            return false;
        }
        if (element2 instanceof DasSchemaChild) {
            return true;
        }
        return element2.getDelegate() instanceof BasicElement;
    }

    private static boolean isBasicElementScriptable(@Nullable BasicElement element2) {
        return element2 != null;
    }

    @NotNull
    private static String doGenerateDDL(@NotNull Collection<DbElement> selectedElements, boolean forConsole) {
        if (selectedElements == null) {
            GenerateSqlActions.$$$reportNull$$$0(6);
        }
        ArrayList<BasicElement> list1 = new ArrayList<BasicElement>(selectedElements.size());
        ArrayList<DbElement> list2 = new ArrayList<DbElement>(selectedElements.size());
        Project project = null;
        TreePattern scope = null;
        for (DbElement e : selectedElements) {
            Object d2;
            if (project == null) {
                project = e.getProject();
            }
            if ((d2 = e.getDelegate()) instanceof BasicElement) {
                list1.add((BasicElement)d2);
                continue;
            }
            if (d2 instanceof LocalDataSource) {
                LocalDataSource lds = (LocalDataSource)d2;
                DasModel m = lds.getModel();
                if (!(m instanceof BasicModel)) continue;
                scope = lds.getIntrospectionScope();
                list1.add(((BasicModel)m).getRoot());
                continue;
            }
            list2.add(e);
        }
        return GenerateSqlActions.doGenerateDDLUsingScriptingService(project, scope, list1, list2, forConsole);
    }

    @NotNull
    private static String doGenerateDDLUsingScriptingService(Project project, @Nullable TreePattern scope, @NotNull Collection<BasicElement> selectedElements, Collection<DbElement> unknown, boolean forConsole) {
        if (selectedElements == null) {
            GenerateSqlActions.$$$reportNull$$$0(7);
        }
        Map<BasicModel, List<BasicElement>> groupedByModels = ModelFun.groupByModel(selectedElements);
        StringBuilder b2 = new StringBuilder();
        for (Map.Entry<BasicModel, List<BasicElement>> entry : groupedByModels.entrySet()) {
            ArrayList elements;
            BasicModel m = entry.getKey();
            String text2 = GenerateSqlActions.doGenerateDDLUsingScriptingService(project, scope, m, elements = new ArrayList(entry.getValue()), forConsole);
            if (text2.length() <= 0) continue;
            if (b2.length() > 0) {
                b2.append("\n\n");
            }
            b2.append(text2);
        }
        for (DbElement element2 : unknown) {
            if (b2.length() > 0) {
                b2.append("\n\n");
            }
            b2.append("Unexpected: ").append(element2.getDelegate().getClass().getSimpleName());
        }
        String string = b2.toString();
        if (string == null) {
            GenerateSqlActions.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private static String doGenerateDDLUsingScriptingService(@NotNull Project project, @Nullable TreePattern scope, @NotNull BasicModel model, @NotNull Iterable<? extends BasicElement> selectedElements, boolean forConsole) {
        JBIterable explicitSchemata;
        JBIterable selection;
        JBIterable visibleDatabasesOfRoot;
        JBIterable databasesSchemata;
        List schemata;
        if (project == null) {
            GenerateSqlActions.$$$reportNull$$$0(9);
        }
        if (model == null) {
            GenerateSqlActions.$$$reportNull$$$0(10);
        }
        if (selectedElements == null) {
            GenerateSqlActions.$$$reportNull$$$0(11);
        }
        BasicSchema schema = (schemata = (databasesSchemata = (visibleDatabasesOfRoot = (selection = JBIterable.from(selectedElements)).filter(BasicMultiDatabaseRoot.class).flatten(BasicMultiDatabaseRoot::getDatabases).filter(BasicDatabase.class).filter(d2 -> scope == null || DataSourceSchemaMapping.matches(scope, d2))).append((Iterable)selection.filter(BasicDatabase.class).filter(db -> !visibleDatabasesOfRoot.contains(db))).flatten(BasicDatabase::getSchemas).filter(BasicSchema.class).filter(s2 -> !s2.isNameSurrogate()).filter(s2 -> scope == null || DataSourceSchemaMapping.matches(scope, s2))).append((Iterable)(explicitSchemata = selection.filter(BasicSchema.class).filter(s2 -> !databasesSchemata.contains(s2)))).toList()).size() == 1 ? (BasicSchema)schemata.get(0) : null;
        ScriptingSingleModelTaskBuilder taskBuilder = new ScriptingSingleModelTaskBuilder(model, ScriptCategory.CREATE_COMPLETE);
        JBIterable.from((Iterable)schemata).flatten(UtilKt::getScriptableMajorObjects).append((Iterable)selection.filter(o -> !schemata.contains(o.getSchema()))).addAllTo(taskBuilder.getElements());
        taskBuilder.setCurrentSchema(schema);
        taskBuilder.setOptions(forConsole ? SCRIPTING_OPTIONS_FOR_CONSOLE : SCRIPTING_OPTIONS_FOR_CLIPBOARD);
        ScriptingResult result = ScriptGenerators.INSTANCE.makeScript(project, taskBuilder.build());
        String string = result.getScriptText();
        if (string == null) {
            GenerateSqlActions.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/GenerateSqlActions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbElements";
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedElements";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/GenerateSqlActions";
                break;
            }
            case 8: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "doGenerateDDLUsingScriptingService";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generateDbDdl";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkActionScriptableStatus";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doGenerateDDL";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doGenerateDDLUsingScriptingService";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ShowSqlGeneratorAction
    extends DumbAwareAction {
        ShowSqlGeneratorAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowSqlGeneratorAction.$$$reportNull$$$0(0);
            }
            ActionStatus status = GenerateSqlActions.checkActionScriptableStatus(GenerateSqlActions.getElements(e, false), null);
            e.getPresentation().setVisible(status.visible || e.isFromActionToolbar());
            e.getPresentation().setEnabled(status.enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowSqlGeneratorAction.$$$reportNull$$$0(1);
            }
            JBIterable<DbElement> dbElements = GenerateSqlActions.getElements(e, false);
            JBIterable basicElements = dbElements.filterMap(x$0 -> GenerateSqlActions.toBasicElement(x$0));
            JBIterable scriptableElements = basicElements.filter(x$0 -> GenerateSqlActions.isBasicElementScriptable(x$0));
            Project project = (Project)dbElements.map(PsiElement::getProject).unique().single();
            BasicModel model = (BasicModel)basicElements.map(BasicNode::getModel).unique().single();
            if (project == null || model == null || scriptableElements.isEmpty()) {
                return;
            }
            ScriptGeneratorTool.INSTANCE.show(project, model, (Iterable<? extends BasicNode>)scriptableElements);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/actions/GenerateSqlActions$ShowSqlGeneratorAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class SqlActionsGroup
    extends DefaultActionGroup {
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SqlActionsGroup.$$$reportNull$$$0(0);
            }
            ActionStatus status = "EditorPopup".equals(e.getPlace()) ? GenerateSqlActions.checkActionScriptableStatus(GenerateSqlActions.getElements(e, false), null) : ActionStatus.ENABLED;
            e.getPresentation().setEnabledAndVisible(status.enabled);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/GenerateSqlActions$SqlActionsGroup", "update"));
        }
    }

    static class OpenDdlInConsoleAction
    extends DumbAwareAction {
        OpenDdlInConsoleAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                OpenDdlInConsoleAction.$$$reportNull$$$0(0);
            }
            boolean enabled = GenerateSqlActions.getElements(e, true).find(el -> !el.getDataSource().getDbms().isMongo()) != null;
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            List elements;
            String ddl;
            if (e == null) {
                OpenDdlInConsoleAction.$$$reportNull$$$0(1);
            }
            if (StringUtil.isEmpty((String)(ddl = GenerateSqlActions.doGenerateDDL(elements = GenerateSqlActions.getElements(e, true).unique().toList(), true)))) {
                return;
            }
            DbUIUtil.openInConsole((DbElement)elements.get(0), ddl);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/actions/GenerateSqlActions$OpenDdlInConsoleAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class CopyDdlAction
    extends DumbAwareAction {
        CopyDdlAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CopyDdlAction.$$$reportNull$$$0(0);
            }
            boolean enabled = GenerateSqlActions.getElements(e, false).find(el -> !el.getDataSource().getDbms().isMongo()) != null;
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setVisible(enabled || e.isFromActionToolbar());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            List objects2;
            if (e == null) {
                CopyDdlAction.$$$reportNull$$$0(1);
            }
            if ((objects2 = GenerateSqlActions.getElements(e, false).unique().toList()).isEmpty()) {
                return;
            }
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(GenerateSqlActions.doGenerateDDL(objects2, false)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/actions/GenerateSqlActions$CopyDdlAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class CopyDdlFromDbAction
    extends DumbAwareAction {
        CopyDdlFromDbAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CopyDdlFromDbAction.$$$reportNull$$$0(0);
            }
            JBIterable<DbElement> objects2 = this.getObjects(e.getDataContext());
            JBIterable<DbElement> supported = this.filterSupported(objects2);
            boolean visible = !objects2.isEmpty();
            boolean enabled = visible && !supported.isEmpty();
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setVisible(visible);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            JBIterable<DbElement> objects2;
            DbElement first2;
            DefinitionProvider provider;
            if (e == null) {
                CopyDdlFromDbAction.$$$reportNull$$$0(1);
            }
            if ((provider = this.getProvider(first2 = (DbElement)(objects2 = this.getObjects(e.getDataContext())).first())) == null || first2 == null) {
                return;
            }
            ErrorHandler handler = new ErrorHandler();
            StringBuilder builder = new StringBuilder();
            ProgressIndicatorEx indicator = AsyncUtil.createBackgroundIndicator(first2.getProject(), DatabaseBundle.message((String)"action.DatabaseView.CopyDdlFromDbAction.loading.sources", (Object[])new Object[0]));
            AsyncUtil.runTask(() -> GenerateSqlActions.generateDbDdl(provider, objects2.filter(provider::isSupported).toList(), handler, builder, false).whenCompleteAsync((s2, throwable) -> {
                if (throwable != null) {
                    AsyncUtil.addUnhandledError(handler, throwable, DbImplUtil.getMaybeLocalDataSource((DasDataSource)first2.getDataSource()));
                    if (handler.hasErrors()) {
                        DatabaseNotifications.DATABASE_EXECUTION_GROUP.createNotification(handler.getSummary(), MessageType.ERROR).notify(e.getProject());
                    }
                } else {
                    CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(builder.toString()));
                }
            }, AsyncUtil.getEdtExecutor()), indicator);
        }

        @NotNull
        JBIterable<DbElement> getObjects(DataContext context) {
            JBIterable<DbElement> objects2 = DatabaseView.getSelectedElementsNoGroups(context, false);
            DbElement first2 = (DbElement)objects2.first();
            if (first2 == null) {
                JBIterable jBIterable = JBIterable.empty();
                if (jBIterable == null) {
                    CopyDdlFromDbAction.$$$reportNull$$$0(2);
                }
                return jBIterable;
            }
            DbDataSource dataSource2 = first2.getDataSource();
            JBIterable jBIterable = objects2.filter(o -> o != dataSource2 && o.getDataSource() == dataSource2);
            if (jBIterable == null) {
                CopyDdlFromDbAction.$$$reportNull$$$0(3);
            }
            return jBIterable;
        }

        @NotNull
        JBIterable<DbElement> filterSupported(@NotNull JBIterable<DbElement> objects2) {
            DefinitionProvider provider;
            if (objects2 == null) {
                CopyDdlFromDbAction.$$$reportNull$$$0(4);
            }
            JBIterable jBIterable = (provider = this.getProvider((DbElement)objects2.first())) == null ? JBIterable.empty() : objects2.filter(provider::isSupported);
            if (jBIterable == null) {
                CopyDdlFromDbAction.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }

        @Nullable
        DefinitionProvider getProvider(@Nullable DbElement first2) {
            if (first2 == null) {
                return null;
            }
            LocalDataSource localDataSource = DbImplUtil.getMaybeLocalDataSource((DasDataSource)first2.getDataSource());
            if (localDataSource == null) {
                return null;
            }
            return AbstractDefinitionProvider.find(localDataSource);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/GenerateSqlActions$CopyDdlFromDbAction";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "objects";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/GenerateSqlActions$CopyDdlFromDbAction";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getObjects";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filterSupported";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "filterSupported";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

