/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.actions.DatabaseObjectRefactoring;
import com.intellij.database.editor.DatabaseEditorHelperCore;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicTableColumn;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeForeignKey;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DatabaseTableEditor;
import com.intellij.database.view.models.builder.ForeignKeyModelBuilder;
import com.intellij.database.view.models.builder.IndexModelBuilder;
import com.intellij.database.view.models.builder.TableModelBuilder;
import com.intellij.database.view.ui.AbstractDbRefactoringDialog;
import com.intellij.database.view.ui.DbRefactoringDialogHelper;
import com.intellij.database.view.ui.DbRefactoringHelper;
import com.intellij.database.view.ui.DbTableDialog;
import com.intellij.database.view.ui.GenericEditingResultProcessor;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlFile;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class GenerateDbObjectGroup
extends ActionGroup
implements DumbAware {
    public static final DataKey<Consumer<AbstractDbRefactoringDialog>> INTERCEPTOR = DataKey.create((String)"GenerateDbObjectGroup.INTERCEPTOR");
    public static final DataKey<DbRefactoringHelper.ObjectLocation> FORCED_LOCATION = DataKey.create((String)"DatabaseObjectRefactoring.FORCED_LOCATION");
    private final AnAction[] myChildren = new AnAction[]{new BaseGenerateDbObjectAction(ObjectKind.TABLE, DasNamespace.class, true){

        @Override
        @NotNull
        protected DeObject getEditedObject(@NotNull DbTableDialog dialog2, @Nullable BasicElement parent2, @NotNull DataContext dataContext) {
            if (dialog2 == null) {
                1.$$$reportNull$$$0(0);
            }
            if (dataContext == null) {
                1.$$$reportNull$$$0(1);
            }
            DeObject deObject = dialog2.createEmptyTemplate(parent2);
            if (deObject == null) {
                1.$$$reportNull$$$0(2);
            }
            return deObject;
        }

        @Override
        protected DeObject getObjectToSelect(@NotNull DbTableDialog dialog2, @Nullable BasicElement parent2, @NotNull DataContext dataContext) {
            if (dialog2 == null) {
                1.$$$reportNull$$$0(3);
            }
            if (dataContext == null) {
                1.$$$reportNull$$$0(4);
            }
            return ((DatabaseTableEditor)dialog2.getEditor()).getTable();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialog";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/GenerateDbObjectGroup$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/GenerateDbObjectGroup$1";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditedObject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getEditedObject";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getObjectToSelect";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }, new BaseGenerateDbObjectAction(ObjectKind.COLUMN, DasTable.class, false){

        @Override
        @Nullable
        protected DeColumn getObjectToSelect(@NotNull DbTableDialog dialog2, @Nullable BasicElement parent2, @NotNull DataContext dataContext) {
            if (dialog2 == null) {
                2.$$$reportNull$$$0(0);
            }
            if (dataContext == null) {
                2.$$$reportNull$$$0(1);
            }
            Ref column2 = Ref.create();
            ((TableModelBuilder)((TableModelBuilder.TableColumnModelBuilder)((TableModelBuilder.TableColumnModelBuilder)TableModelBuilder.modify(((DatabaseTableEditor)dialog2.getEditor()).getTableModel()).withColumn("new_column")).addAndGet((Ref<DeColumn>)column2)).leave()).commit();
            return (DeColumn)column2.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dialog";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dataContext";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/actions/GenerateDbObjectGroup$2";
            objectArray[2] = "getObjectToSelect";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }, new BaseGenerateDbObjectAction(ObjectKind.INDEX, DasTable.class, false){

        @Override
        @Nullable
        protected DeIndex getObjectToSelect(@NotNull DbTableDialog dialog2, @Nullable BasicElement parent2, @NotNull DataContext dataContext) {
            if (dialog2 == null) {
                3.$$$reportNull$$$0(0);
            }
            if (dataContext == null) {
                3.$$$reportNull$$$0(1);
            }
            DeTable table = ((DatabaseTableEditor)dialog2.getEditor()).getTable();
            Ref index2 = Ref.create();
            ((TableModelBuilder)((TableModelBuilder.TableIndexModelBuilder)((TableModelBuilder.TableIndexModelBuilder)((IndexModelBuilder)((Object)TableModelBuilder.modify(((DatabaseTableEditor)dialog2.getEditor()).getTableModel()).withIndex(""))).addColumns((Iterable<DeColumn>)JBIterable.from((Iterable)DatabaseObjectRefactoring.getDasObjects(dataContext).filterMap(o -> DatabaseObjectRefactoring.getBasicElement(o, dialog2.getContext())).filter(BasicTableColumn.class).filter(object -> object.getParent() == parent2)).transform(object -> {
                DeColumn column2 = (DeColumn)dialog2.exportOp((BasicElement)object, true);
                column2.table = table;
                return column2;
            }), DasIndex.Sorting.NONE)).addAndGet((Ref<DeIndex>)index2)).leave()).commit();
            return (DeIndex)index2.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dialog";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dataContext";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/actions/GenerateDbObjectGroup$3";
            objectArray[2] = "getObjectToSelect";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }, new BaseGenerateDbObjectAction(ObjectKind.FOREIGN_KEY, DasTable.class, false){

        @Override
        @Nullable
        protected DeObject getObjectToSelect(@NotNull DbTableDialog dialog2, @Nullable BasicElement parent2, @NotNull DataContext dataContext) {
            if (dialog2 == null) {
                4.$$$reportNull$$$0(0);
            }
            if (dataContext == null) {
                4.$$$reportNull$$$0(1);
            }
            DeTable table = ((DatabaseTableEditor)dialog2.getEditor()).getTable();
            Ref fk = Ref.create();
            ((TableModelBuilder)((TableModelBuilder.TableForeignKeyModelBuilder)((TableModelBuilder.TableForeignKeyModelBuilder)((ForeignKeyModelBuilder)((Object)TableModelBuilder.modify(((DatabaseTableEditor)dialog2.getEditor()).getTableModel()).withForeignKey(""))).addRefRefs((Iterable<DeColumn>)JBIterable.from((Iterable)DatabaseObjectRefactoring.getDasObjects(dataContext).filterMap(o -> DatabaseObjectRefactoring.getBasicElement(o, dialog2.getContext())).filter(BasicTableColumn.class).filter(object -> object.getParent() == parent2)).transform(object -> {
                DeColumn column2 = (DeColumn)dialog2.exportOp((BasicElement)object, true);
                column2.table = table;
                return column2;
            }))).addAndGet((Ref<DeForeignKey>)fk)).leave()).commit();
            return (DeObject)fk.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dialog";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dataContext";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/actions/GenerateDbObjectGroup$4";
            objectArray[2] = "getObjectToSelect";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }};

    private static boolean checkFile(DataContext dataContext) {
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        PsiElement element2 = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        return file != null && file.getLanguage() instanceof SqlLanguageDialect || element2 != null && element2.getLanguage() instanceof SqlLanguageDialect;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GenerateDbObjectGroup.$$$reportNull$$$0(0);
        }
        super.update(e);
        e.getPresentation().setEnabledAndVisible(GenerateDbObjectGroup.checkFile(e.getDataContext()));
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        if (this.myChildren == null) {
            GenerateDbObjectGroup.$$$reportNull$$$0(1);
        }
        return this.myChildren;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/GenerateDbObjectGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/GenerateDbObjectGroup";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class BaseGenerateDbObjectAction
    extends DumbAwareAction {
        @NotNull
        private final ObjectKind myKind;
        private final Class<? extends DasObject> myParentClass;
        private final boolean myParentNullable;

        protected BaseGenerateDbObjectAction(@NotNull ObjectKind kind, @NotNull Class<? extends DasObject> parentClass, boolean parentNullable) {
            if (kind == null) {
                BaseGenerateDbObjectAction.$$$reportNull$$$0(0);
            }
            if (parentClass == null) {
                BaseGenerateDbObjectAction.$$$reportNull$$$0(1);
            }
            super(DatabaseObjectRefactoring.getKindTitle(kind));
            this.myKind = kind;
            this.myParentClass = parentClass;
            this.myParentNullable = parentNullable;
        }

        protected boolean isEnabled(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                BaseGenerateDbObjectAction.$$$reportNull$$$0(2);
            }
            if (!GenerateDbObjectGroup.checkFile(dataContext)) {
                return false;
            }
            DasObject object = this.getObject(dataContext);
            if (object == null) {
                return this.myParentNullable;
            }
            if (this.getSupportedLocations(DbRefactoringHelper.ObjectLocation.of(object, null)).isEmpty()) {
                return false;
            }
            if (this.createContext(dataContext) == null) {
                return false;
            }
            if (this.myParentClass == DasTable.class && !DbImplUtilCore.isDataTable(object.getKind())) {
                return false;
            }
            return this.myParentClass.isAssignableFrom(object.getClass());
        }

        @NotNull
        protected JBIterable<DbRefactoringHelper.ObjectLocation> getSupportedLocations(@Nullable DbRefactoringHelper.ObjectLocation objectLocation) {
            JBIterable jBIterable = JBIterable.of((Object)((Object)((DbRefactoringHelper.ObjectLocation)((Object)ObjectUtils.chooseNotNull((Object)((Object)objectLocation), (Object)((Object)DbRefactoringHelper.ObjectLocation.CODE))))));
            if (jBIterable == null) {
                BaseGenerateDbObjectAction.$$$reportNull$$$0(3);
            }
            return jBIterable;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                BaseGenerateDbObjectAction.$$$reportNull$$$0(4);
            }
            e.getPresentation().setEnabledAndVisible(this.isEnabled(e.getDataContext()));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DasObject object;
            Pair<BasicElement, DatabaseEditorContext> info;
            if (e == null) {
                BaseGenerateDbObjectAction.$$$reportNull$$$0(5);
            }
            if (!this.isEnabled(e.getDataContext())) {
                return;
            }
            DbRefactoringHelper.ObjectLocation forcedLocation = (DbRefactoringHelper.ObjectLocation)((Object)e.getData(FORCED_LOCATION));
            Consumer dialogInterceptor = (Consumer)e.getData(INTERCEPTOR);
            PsiElement place = BaseGenerateDbObjectAction.getPlace(e.getDataContext());
            if (place == null) {
                place = (PsiElement)ObjectUtils.tryCast((Object)e.getData(CommonDataKeys.PSI_FILE), SqlFile.class);
            }
            if ((info = DatabaseObjectRefactoring.prepareForEditing(place, object = this.getObject(e.getDataContext()))) == null) {
                return;
            }
            DbRefactoringHelper.ObjectLocation location = DbRefactoringHelper.ObjectLocation.of(object, ((DatabaseEditorContext)info.second).getDataSource());
            if (location == null || ((DatabaseEditorContext)info.second).getVirtualFile() != null) {
                location = DbRefactoringHelper.ObjectLocation.CODE;
            }
            if (forcedLocation != null) {
                location = forcedLocation;
            }
            DbTableDialog dialog2 = this.prepare((BasicElement)info.first, (DatabaseEditorContext)info.second, e.getDataContext(), location);
            if (dialogInterceptor != null) {
                dialogInterceptor.consume((Object)dialog2);
            } else {
                dialog2.finishAndShow();
            }
        }

        @NotNull
        protected DbTableDialog prepare(@Nullable BasicElement object, @NotNull DatabaseEditorContext context, @NotNull DataContext dataContext, @NotNull DbRefactoringHelper.ObjectLocation genLocation) {
            if (context == null) {
                BaseGenerateDbObjectAction.$$$reportNull$$$0(6);
            }
            if (dataContext == null) {
                BaseGenerateDbObjectAction.$$$reportNull$$$0(7);
            }
            if (genLocation == null) {
                BaseGenerateDbObjectAction.$$$reportNull$$$0(8);
            }
            DbTableDialog dialog2 = new DbTableDialog(context);
            BaseGenerateDbObjectAction.setProcessor(dialog2, dataContext, genLocation);
            dialog2.configureForCreation(this.getEditedObject(dialog2, object, dataContext), this.isForceCreate(genLocation));
            DbRefactoringDialogHelper.bootstrap(dialog2, (Computable<? extends DeObject>)((Computable)() -> this.getObjectToSelect(dialog2, object, dataContext)));
            DbTableDialog dbTableDialog = dialog2;
            if (dbTableDialog == null) {
                BaseGenerateDbObjectAction.$$$reportNull$$$0(9);
            }
            return dbTableDialog;
        }

        protected boolean isForceCreate(@NotNull DbRefactoringHelper.ObjectLocation genLocation) {
            if (genLocation == null) {
                BaseGenerateDbObjectAction.$$$reportNull$$$0(10);
            }
            return genLocation == DbRefactoringHelper.ObjectLocation.CODE;
        }

        @Nullable
        public DatabaseEditorContext createContext(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                BaseGenerateDbObjectAction.$$$reportNull$$$0(11);
            }
            DasObject object = this.getObject(dataContext);
            PsiElement place = BaseGenerateDbObjectAction.getPlace(dataContext);
            if (object != null) {
                return DbRefactoringHelper.createContext(object, place, true);
            }
            SqlFile file = (SqlFile)ObjectUtils.tryCast((Object)CommonDataKeys.PSI_FILE.getData(dataContext), SqlFile.class);
            if (file == null) {
                return null;
            }
            return DatabaseEditorContext.forFile(file, true);
        }

        @Nullable
        private static PsiElement getPlace(@NotNull DataContext context) {
            if (context == null) {
                BaseGenerateDbObjectAction.$$$reportNull$$$0(12);
            }
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
            PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
            return editor == null || file == null ? null : file.findElementAt(editor.getCaretModel().getOffset());
        }

        private static void setProcessor(@NotNull DbTableDialog dialog2, @NotNull DataContext dataContext, @NotNull DbRefactoringHelper.ObjectLocation genLocation) {
            if (dialog2 == null) {
                BaseGenerateDbObjectAction.$$$reportNull$$$0(13);
            }
            if (dataContext == null) {
                BaseGenerateDbObjectAction.$$$reportNull$$$0(14);
            }
            if (genLocation == null) {
                BaseGenerateDbObjectAction.$$$reportNull$$$0(15);
            }
            RangeMarker place = DbRefactoringHelper.getPlace(BaseGenerateDbObjectAction.getPlace(dataContext));
            if (genLocation == DbRefactoringHelper.ObjectLocation.CODE) {
                dialog2.setResultProcessor(new GenericEditingResultProcessor(dialog2, DbRefactoringHelper.SQL_SETTINGS, place));
            } else {
                dialog2.setResultProcessor(new GenericEditingResultProcessor(dialog2, DbRefactoringHelper.DB_SETTINGS, place));
            }
        }

        @NotNull
        protected DeObject getEditedObject(@NotNull DbTableDialog dialog2, @Nullable BasicElement parent2, @NotNull DataContext dataContext) {
            if (dialog2 == null) {
                BaseGenerateDbObjectAction.$$$reportNull$$$0(16);
            }
            if (dataContext == null) {
                BaseGenerateDbObjectAction.$$$reportNull$$$0(17);
            }
            Object De = dialog2.export(Objects.requireNonNull(parent2), true);
            if (De == null) {
                BaseGenerateDbObjectAction.$$$reportNull$$$0(18);
            }
            return De;
        }

        @Nullable
        protected abstract DeObject getObjectToSelect(@NotNull DbTableDialog var1, @Nullable BasicElement var2, @NotNull DataContext var3);

        @Nullable
        protected DasObject getObject(@NotNull DataContext dataContext) {
            DasObject object;
            if (dataContext == null) {
                BaseGenerateDbObjectAction.$$$reportNull$$$0(19);
            }
            if ((object = DatabaseObjectRefactoring.getDasObject(dataContext)) == null) {
                ObjectPath currentObject;
                SqlFile file = (SqlFile)ObjectUtils.tryCast((Object)CommonDataKeys.PSI_FILE.getData(dataContext), SqlFile.class);
                ObjectPath objectPath = currentObject = file == null ? null : SearchPath.getCurrent((SearchPath)DatabaseEditorHelperCore.getSearchPath((PsiFile)file));
                if (currentObject == null) {
                    return null;
                }
                DbDataSource dataSource2 = DbImplUtil.getForcedDataSource((PsiFile)file);
                if (dataSource2 != null) {
                    object = DbSqlUtil.findElement(dataSource2, currentObject);
                }
            }
            while (object != null && !this.myParentClass.isAssignableFrom(object.getClass())) {
                object = object.getDasParent();
            }
            return object;
        }

        @TestOnly
        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = this.myKind;
            if (objectKind == null) {
                BaseGenerateDbObjectAction.$$$reportNull$$$0(20);
            }
            return objectKind;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 9: 
                case 18: 
                case 20: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 9: 
                case 18: 
                case 20: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentClass";
                    break;
                }
                case 2: 
                case 7: 
                case 11: 
                case 14: 
                case 17: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 3: 
                case 9: 
                case 18: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/GenerateDbObjectGroup$BaseGenerateDbObjectAction";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 6: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 8: 
                case 10: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "genLocation";
                    break;
                }
                case 13: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/GenerateDbObjectGroup$BaseGenerateDbObjectAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSupportedLocations";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "prepare";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditedObject";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isEnabled";
                    break;
                }
                case 3: 
                case 9: 
                case 18: 
                case 20: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "prepare";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "isForceCreate";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "createContext";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "getPlace";
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "setProcessor";
                    break;
                }
                case 16: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "getEditedObject";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "getObject";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 9: 
                case 18: 
                case 20: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

