/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.Dbms;
import com.intellij.database.actions.DatabaseStringUsageTarget;
import com.intellij.database.actions.FullTextSearchAction;
import com.intellij.database.actions.FullTextSearchAction$Companion$WhenMappings;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.ContainsInIndexedTextOperation;
import com.intellij.database.data.types.DasColumnRef;
import com.intellij.database.data.types.EqualsPredicateOperation;
import com.intellij.database.data.types.LikePredicateOperation;
import com.intellij.database.data.types.OperandType;
import com.intellij.database.data.types.PredicateOperation;
import com.intellij.database.data.types.PredicateSpec;
import com.intellij.database.data.types.PredicatesHelper;
import com.intellij.database.data.types.PredicatesHelperKt;
import com.intellij.database.data.types.StringPredicateValue;
import com.intellij.database.data.types.domain.LikeOpType;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.InterruptibleDatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.SimpleSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.fulltextsearch.FtsUtilKt;
import com.intellij.database.fulltextsearch.FullTextSearchDbElementUsage;
import com.intellij.database.fulltextsearch.FullTextSearchOptions;
import com.intellij.database.fulltextsearch.FullTextSearchOptionsStorage;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicTableOrView;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbTable;
import com.intellij.database.script.generator.dml.DmlHelper;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.PredicatesWhereClause;
import com.intellij.database.script.generator.dml.SelectTask;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.Version;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.find.FindModel;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00132\u00020\u0001:\u0004\u0012\u0013\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u000f\u001a\u00020\u0004*\u00020\t2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\u0011H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/actions/FullTextSearchAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "filterOverlaps", "", "Lcom/intellij/database/psi/DbElement;", "elements", "getSearchableTargets", "getSelectedElements", "", "update", "forEachParent", "consumer", "Lkotlin/Function1;", "CancellingDelegate", "Companion", "SearchGroup", "TableGrouper", "intellij.database.impl"})
public final class FullTextSearchAction
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Collection<DbElement> targets2 = this.getSearchableTargets((Collection<? extends DbElement>)this.getSelectedElements(e));
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        Collection<DbElement> collection = targets2;
        boolean bl = false;
        presentation.setEnabledAndVisible(!collection.isEmpty());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        Collection<DbElement> targets2 = this.filterOverlaps(this.getSearchableTargets((Collection<? extends DbElement>)this.getSelectedElements(e)));
        if (targets2.isEmpty()) {
            return;
        }
        FullTextSearchOptions options = new FullTextSearchOptions(FullTextSearchOptionsStorage.getText(), FullTextSearchOptionsStorage.getMatchCase(), FullTextSearchOptionsStorage.getSearchTarget(), FullTextSearchOptionsStorage.getLocation(), FullTextSearchOptionsStorage.getMaxNumOfFetchedRows());
        new DatabaseStringUsageTarget(project2, FullTextSearchAction.Companion.createFindModel(project2, ""), options, targets2).showSettings();
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<DbElement> getSearchableTargets(Collection<? extends DbElement> elements) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = elements;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LocalDataSource dataSource2;
            DbElement it2 = (DbElement)element$iv$iv;
            boolean bl = false;
            if (!(!(it2 instanceof DbDataSource) && !(it2 instanceof DbNamespaceImpl) && !(it2 instanceof DbTable) ? false : (dataSource2 = DbImplUtil.getMaybeLocalDataSource((DasDataSource)FullTextSearchAction.Companion.getDbDataSource(it2))) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<DbElement> getSelectedElements(AnActionEvent e) {
        void $this$flatMapTo$iv$iv;
        block5: {
            Object object;
            block7: {
                block6: {
                    DataGrid grid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext());
                    if (grid == null) break block5;
                    DasTable table = DataGridUtil.getDatabaseTable(grid);
                    DbDataSource dataSource2 = DataGridUtil.getDatabaseSystem(grid);
                    object = DbImplUtil.findElement(dataSource2, (DasObject)table);
                    if (object == null) break block6;
                    DbElement dbElement = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    DbElement it2 = dbElement;
                    boolean bl3 = false;
                    object = CollectionsKt.listOf((Object)it2);
                    if (object != null) break block7;
                }
                object = CollectionsKt.emptyList();
            }
            return object;
        }
        Object[] objectArray = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(e.getDataContext());
        if (objectArray == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"LangDataKeys.PSI_ELEMENT\u2026xt) ?: return emptyList()");
        Object[] data = objectArray;
        List groups = ArraysKt.filterIsInstance((Object[])data, DatabaseStructure.Group.class);
        Iterable $this$flatMap$iv = groups;
        boolean $i$f$flatMap = false;
        Iterable it2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            DatabaseStructure.Group it3 = (DatabaseStructure.Group)((Object)element$iv$iv);
            boolean bl = false;
            Iterable list$iv$iv = (Iterable)it3.iterateChildren();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List groupChildren = CollectionsKt.filterIsInstance((Iterable)((List)destination$iv$iv), DbElement.class);
        List children2 = ArraysKt.filterIsInstance((Object[])data, DbElement.class);
        return CollectionsKt.plus((Collection)children2, (Iterable)groupChildren);
    }

    private final Collection<DbElement> filterOverlaps(Collection<? extends DbElement> elements) {
        boolean bl = false;
        Map parentsToChildren = new LinkedHashMap();
        for (DbElement dbElement : elements) {
            this.forEachParent(dbElement, (Function1<? super DbElement, Unit>)((Function1)new Function1<DbElement, Unit>(parentsToChildren, dbElement){
                final /* synthetic */ Map $parentsToChildren;
                final /* synthetic */ DbElement $element;

                public final void invoke(@NotNull DbElement parent2) {
                    Object object;
                    Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
                    Map $this$getOrPut$iv = this.$parentsToChildren;
                    boolean $i$f$getOrPut = false;
                    V value$iv = $this$getOrPut$iv.get(parent2);
                    if (value$iv == null) {
                        boolean bl = false;
                        boolean bl2 = false;
                        Set answer$iv = new LinkedHashSet<E>();
                        $this$getOrPut$iv.put(parent2, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    ((Set)object).add(this.$element);
                }
                {
                    this.$parentsToChildren = map2;
                    this.$element = dbElement;
                    super(1);
                }
            }));
        }
        Set set = CollectionsKt.toMutableSet((Iterable)elements);
        for (DbElement dbElement : elements) {
            Set children2;
            if ((Set)parentsToChildren.get(dbElement) == null) {
                continue;
            }
            set.removeAll(children2);
        }
        return set;
    }

    private final void forEachParent(DbElement $this$forEachParent, Function1<? super DbElement, Unit> consumer2) {
        for (DbElement parent2 = $this$forEachParent.getParent(); parent2 != null; parent2 = parent2.getParent()) {
            consumer2.invoke((Object)parent2);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J$\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0002J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\rJ(\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\r2\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00160\u0014H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/actions/FullTextSearchAction$TableGrouper;", "", "myTargets", "", "Lcom/intellij/database/psi/DbElement;", "(Ljava/util/Collection;)V", "getAllSchemas", "Lcom/intellij/database/model/basic/BasicSchema;", "namespace", "Lcom/intellij/database/psi/DbNamespaceImpl;", "dbDataSource", "Lcom/intellij/database/psi/DbDataSource;", "getAllTables", "", "Lcom/intellij/database/model/basic/BasicTableOrView;", "schemas", "", "getGroups", "Lcom/intellij/database/actions/FullTextSearchAction$SearchGroup;", "groupedTables", "", "Lcom/intellij/database/dataSource/LocalDataSource;", "", "getSchema", "getTable", "table", "Lcom/intellij/database/psi/DbTable;", "mustReconnect", "", "dbms", "Lcom/intellij/database/Dbms;", "intellij.database.impl"})
    public static final class TableGrouper {
        private final Collection<DbElement> myTargets;

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<SearchGroup> getGroups() {
            boolean bl = false;
            Map groupedTables = new LinkedHashMap();
            for (DbElement target : this.myTargets) {
                Set set;
                Iterable<? extends BasicSchema> $this$filter$iv;
                BasicModel model;
                LocalDataSource dataSource2;
                Iterable<BasicSchema> value$iv;
                List schemas;
                TreePattern scope;
                BasicSchema it2;
                void $this$filterTo$iv$iv;
                boolean $i$f$filterTo;
                Iterable answer$iv;
                DbElement dbElement = target;
                if (dbElement instanceof DbTable) {
                    BasicTableOrView table;
                    Object object;
                    LocalDataSource dataSource3;
                    DbDataSource dbDataSource;
                    if (this.getTable((DbTable)target) == null) {
                        continue;
                    }
                    if (Companion.getDbDataSource(target) == null) {
                        continue;
                    }
                    if (DbImplUtil.getMaybeLocalDataSource((DasDataSource)dbDataSource) == null) {
                        continue;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)dataSource3, (String)"getMaybeLocalDataSource(\u2026aSource) ?: continue@loop");
                    Map $this$getOrPut$iv = groupedTables;
                    boolean $i$f$getOrPut = false;
                    Object value$iv2 = $this$getOrPut$iv.get(dataSource3);
                    if (value$iv2 == null) {
                        boolean bl2 = false;
                        boolean bl3 = false;
                        answer$iv = new LinkedHashSet();
                        $this$getOrPut$iv.put(dataSource3, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv2;
                    }
                    ((Set)object).add(table);
                    continue;
                }
                if (dbElement instanceof DbNamespaceImpl) {
                    Set set2;
                    LocalDataSource dataSource4;
                    DbDataSource dbDataSource;
                    if (Companion.getDbDataSource(target) == null) {
                        continue;
                    }
                    if (DbImplUtil.getMaybeLocalDataSource((DasDataSource)dbDataSource) == null) {
                        continue;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)dataSource4, (String)"getMaybeLocalDataSource(\u2026aSource) ?: continue@loop");
                    Intrinsics.checkNotNullExpressionValue((Object)dataSource4.getIntrospectionScope(), (String)"dataSource.introspectionScope");
                    Iterable $this$filter$iv2 = this.getAllSchemas((DbNamespaceImpl)target, dbDataSource);
                    boolean $i$f$filter = false;
                    answer$iv = $this$filter$iv2;
                    Collection destination$iv$iv = new ArrayList();
                    $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        it2 = (BasicSchema)element$iv$iv;
                        boolean bl4 = false;
                        if (!DataSourceSchemaMapping.matches(scope, it2)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    schemas = (List)destination$iv$iv;
                    Map $this$getOrPut$iv = groupedTables;
                    boolean $i$f$getOrPut = false;
                    value$iv = $this$getOrPut$iv.get(dataSource4);
                    if (value$iv == null) {
                        boolean bl5 = false;
                        $i$f$filterTo = false;
                        Set answer$iv2 = new LinkedHashSet();
                        $this$getOrPut$iv.put(dataSource4, answer$iv2);
                        set2 = answer$iv2;
                    } else {
                        set2 = value$iv;
                    }
                    ((Set)set2).addAll((Collection)this.getAllTables(schemas, dbDataSource));
                    continue;
                }
                if (!(dbElement instanceof DbDataSource)) continue;
                if (DbImplUtil.getMaybeLocalDataSource((DasDataSource)target) == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)dataSource2, (String)"getMaybeLocalDataSource(target) ?: continue@loop");
                DasModel dasModel = dataSource2.getModel();
                if (!(dasModel instanceof BasicModel)) {
                    dasModel = null;
                }
                if ((BasicModel)dasModel == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)dataSource2.getIntrospectionScope(), (String)"dataSource.introspectionScope");
                BasicRoot basicRoot = model.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)basicRoot, (String)"model.root");
                Intrinsics.checkNotNullExpressionValue(basicRoot.getAllSchemas(), (String)"model.root.allSchemas");
                boolean $i$f$filter = false;
                value$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it2 = (BasicSchema)element$iv$iv;
                    boolean bl6 = false;
                    if (!DataSourceSchemaMapping.matches(scope, it2)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                schemas = (List)destination$iv$iv;
                Map $this$getOrPut$iv = groupedTables;
                boolean $i$f$getOrPut = false;
                value$iv = $this$getOrPut$iv.get(dataSource2);
                if (value$iv == null) {
                    boolean bl7 = false;
                    boolean bl8 = false;
                    Set answer$iv3 = new LinkedHashSet();
                    $this$getOrPut$iv.put(dataSource2, answer$iv3);
                    set = answer$iv3;
                } else {
                    set = value$iv;
                }
                ((Set)set).addAll((Collection)this.getAllTables(schemas, (DbDataSource)target));
            }
            return this.getGroups(groupedTables);
        }

        /*
         * WARNING - void declaration
         */
        private final List<BasicTableOrView> getAllTables(Iterable<? extends BasicSchema> schemas, DbDataSource dbDataSource) {
            boolean bl = false;
            List elements = new ArrayList();
            for (ObjectKind tableKind : ModelConsts.TABLE_OR_VIEW_KINDS) {
                Iterable<? extends BasicSchema> $this$flatMapTo$iv = schemas;
                boolean $i$f$flatMapTo = false;
                Iterator<? extends BasicSchema> iterator = $this$flatMapTo$iv.iterator();
                while (iterator.hasNext()) {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    BasicSchema element$iv;
                    BasicSchema s2 = element$iv = iterator.next();
                    boolean bl2 = false;
                    JBIterable jBIterable = s2.getDasChildren(tableKind);
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"s.getDasChildren(tableKind)");
                    Iterable iterable = CollectionsKt.filterIsInstance((Iterable)((Iterable)jBIterable), BasicTableOrView.class);
                    boolean $i$f$filter = false;
                    void var14_15 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        BasicTableOrView it2 = (BasicTableOrView)element$iv$iv;
                        boolean bl3 = false;
                        if (!(DbImplUtil.findElement(dbDataSource, it2) != null)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable list$iv = (List)destination$iv$iv;
                    CollectionsKt.addAll((Collection)elements, (Iterable)list$iv);
                }
            }
            return elements;
        }

        private final Collection<BasicSchema> getAllSchemas(DbNamespaceImpl namespace, DbDataSource dbDataSource) {
            BasicSchema schema = this.getSchema(namespace);
            if (schema != null) {
                return CollectionsKt.listOf((Object)schema);
            }
            JBIterable<DbElement> jBIterable = namespace.getDasChildren(ObjectKind.SCHEMA);
            Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"namespace.getDasChildren(ObjectKind.SCHEMA)");
            JBIterable<DbElement> dbSchemas = jBIterable;
            boolean bl = false;
            List schemas = new ArrayList();
            for (DbElement dbSchema : dbSchemas) {
                if (!(dbSchema instanceof DbNamespaceImpl) || (schema = this.getSchema((DbNamespaceImpl)dbSchema)) == null || DbImplUtil.findElement(dbDataSource, schema) == null) continue;
                schemas.add(schema);
            }
            return schemas;
        }

        private final BasicSchema getSchema(DbNamespaceImpl namespace) {
            DasObject dasObject = (DasObject)namespace.getDelegate();
            if (!(dasObject instanceof BasicSchema)) {
                dasObject = null;
            }
            return (BasicSchema)dasObject;
        }

        private final BasicTableOrView getTable(DbTable table) {
            Object object = table.getDelegate();
            if (!(object instanceof BasicTableOrView)) {
                object = null;
            }
            return (BasicTableOrView)object;
        }

        /*
         * WARNING - void declaration
         */
        private final List<SearchGroup> getGroups(Map<LocalDataSource, ? extends Set<? extends BasicTableOrView>> groupedTables) {
            ArrayList<SearchGroup> groups = new ArrayList<SearchGroup>();
            Object object = groupedTables;
            boolean bl = false;
            for (Map.Entry<LocalDataSource, ? extends Set<? extends BasicTableOrView>> entry : object.entrySet()) {
                void dataSource2;
                Object object2 = entry;
                boolean bl2 = false;
                object = object2.getKey();
                object2 = entry;
                bl2 = false;
                Set<? extends BasicTableOrView> tables = object2.getValue();
                Dbms dbms = dataSource2.getDbms();
                Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"dataSource.dbms");
                if (this.mustReconnect(dbms)) {
                    void $this$mapTo$iv;
                    Map $this$getOrPut$iv$iv$iv;
                    void $this$groupByTo$iv$iv;
                    Map $this$groupBy$iv;
                    object2 = tables;
                    boolean $i$f$groupBy = false;
                    void var9_10 = $this$groupBy$iv;
                    Map destination$iv$iv = new LinkedHashMap();
                    boolean $i$f$groupByTo = false;
                    for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                        Object object3;
                        BasicTableOrView it2 = (BasicTableOrView)element$iv$iv;
                        boolean bl3 = false;
                        SearchPath key$iv$iv = DbImplUtil.getDatabaseToSwitch((LocalDataSource)dataSource2, SearchPath.of((ObjectPath)ObjectPaths.of((DasObject)DbImplUtil.getSearchPathObject(DbImplUtil.getDatabaseDialect(dataSource2.getDbms()), it2))));
                        $this$getOrPut$iv$iv$iv = destination$iv$iv;
                        boolean $i$f$getOrPut = false;
                        Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                        if (value$iv$iv$iv == null) {
                            boolean bl4 = false;
                            List answer$iv$iv$iv = new ArrayList();
                            $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                            object3 = answer$iv$iv$iv;
                        } else {
                            object3 = value$iv$iv$iv;
                        }
                        List list$iv$iv = (List)object3;
                        list$iv$iv.add(element$iv$iv);
                    }
                    $this$groupBy$iv = destination$iv$iv;
                    boolean $i$f$mapTo = false;
                    var9_10 = $this$mapTo$iv;
                    boolean bl5 = false;
                    for (Map.Entry item$iv : var9_10.entrySet()) {
                        void searchPath;
                        void $dstr$searchPath$ts;
                        Object element$iv$iv;
                        element$iv$iv = item$iv;
                        Collection collection = groups;
                        boolean bl6 = false;
                        void var15_20 = $dstr$searchPath$ts;
                        boolean bl7 = false;
                        $this$getOrPut$iv$iv$iv = (SearchPath)var15_20.getKey();
                        var15_20 = $dstr$searchPath$ts;
                        bl7 = false;
                        List ts = (List)var15_20.getValue();
                        SearchGroup searchGroup = new SearchGroup(CollectionsKt.toSet((Iterable)ts), (LocalDataSource)dataSource2, (SearchPath)searchPath);
                        collection.add(searchGroup);
                    }
                    continue;
                }
                groups.add(new SearchGroup(tables, (LocalDataSource)dataSource2, null));
            }
            return groups;
        }

        private final boolean mustReconnect(Dbms dbms) {
            return dbms.isPostgres();
        }

        public TableGrouper(@NotNull Collection<? extends DbElement> myTargets) {
            Intrinsics.checkNotNullParameter(myTargets, (String)"myTargets");
            this.myTargets = myTargets;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0086\u0002J\t\u0010\u0011\u001a\u00020\u0006H\u0086\u0002J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\bH\u0086\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/actions/FullTextSearchAction$SearchGroup;", "", "tables", "", "Lcom/intellij/database/model/basic/BasicTableOrView;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "searchPath", "Lcom/intellij/database/util/SearchPath;", "(Ljava/util/Set;Lcom/intellij/database/dataSource/LocalDataSource;Lcom/intellij/database/util/SearchPath;)V", "getDataSource", "()Lcom/intellij/database/dataSource/LocalDataSource;", "getSearchPath", "()Lcom/intellij/database/util/SearchPath;", "getTables", "()Ljava/util/Set;", "component1", "component2", "component3", "intellij.database.impl"})
    public static final class SearchGroup {
        @NotNull
        private final Set<BasicTableOrView> tables;
        @NotNull
        private final LocalDataSource dataSource;
        @Nullable
        private final SearchPath searchPath;

        @NotNull
        public final Set<BasicTableOrView> component1() {
            return this.tables;
        }

        @NotNull
        public final LocalDataSource component2() {
            return this.dataSource;
        }

        @Nullable
        public final SearchPath component3() {
            return this.searchPath;
        }

        @NotNull
        public final Set<BasicTableOrView> getTables() {
            return this.tables;
        }

        @NotNull
        public final LocalDataSource getDataSource() {
            return this.dataSource;
        }

        @Nullable
        public final SearchPath getSearchPath() {
            return this.searchPath;
        }

        public SearchGroup(@NotNull Set<? extends BasicTableOrView> tables, @NotNull LocalDataSource dataSource2, @Nullable SearchPath searchPath) {
            Intrinsics.checkNotNullParameter(tables, (String)"tables");
            Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
            this.tables = tables;
            this.dataSource = dataSource2;
            this.searchPath = searchPath;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0006\u0010\t\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/database/actions/FullTextSearchAction$CancellingDelegate;", "Lcom/intellij/openapi/progress/util/AbstractProgressIndicatorExBase;", "connection", "Lcom/intellij/database/dataSource/InterruptibleDatabaseConnection;", "enable", "", "(Lcom/intellij/database/dataSource/InterruptibleDatabaseConnection;Z)V", "cancel", "", "disable", "intellij.database.impl"})
    private static final class CancellingDelegate
    extends AbstractProgressIndicatorExBase {
        private final InterruptibleDatabaseConnection connection;
        private boolean enable;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            CancellingDelegate cancellingDelegate = this;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (cancellingDelegate) {
                boolean bl3 = false;
                if (this.enable) {
                    this.connection.interrupt();
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void disable() {
            CancellingDelegate cancellingDelegate = this;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (cancellingDelegate) {
                boolean bl3 = false;
                this.enable = false;
                Unit unit = Unit.INSTANCE;
            }
        }

        public CancellingDelegate(@NotNull InterruptibleDatabaseConnection connection2, boolean enable) {
            Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
            this.connection = connection2;
            this.enable = enable;
        }

        public /* synthetic */ CancellingDelegate(InterruptibleDatabaseConnection interruptibleDatabaseConnection, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = true;
            }
            this(interruptibleDatabaseConnection, bl);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J^\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J&\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0013H\u0002J\u0014\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010\u001fH\u0002JA\u0010#\u001a\u0014\u0012\u0004\u0012\u00020%\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0&0$2\u0006\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b-J\u0018\u0010.\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020\u00142\u0006\u0010/\u001a\u00020\u001bH\u0003J.\u00100\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00132\b\u00101\u001a\u0004\u0018\u000102J<\u00103\u001a\u00020\u00042\u0006\u00104\u001a\u0002052\u0006\u0010,\u001a\u00020\u00142\u0006\u00106\u001a\u00020!2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u00107\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u00108\u001a\u000209J\u0010\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u0019H\u0002J&\u0010=\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020>2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00040@H\u0002J\n\u0010A\u001a\u00020B*\u00020C\u00a8\u0006D"}, d2={"Lcom/intellij/database/actions/FullTextSearchAction$Companion;", "", "()V", "checkTables", "", "project", "Lcom/intellij/openapi/project/Project;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "processor", "Lcom/intellij/util/Processor;", "Lcom/intellij/usages/Usage;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "options", "Lcom/intellij/database/fulltextsearch/FullTextSearchOptions;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "tables", "", "Lcom/intellij/database/model/basic/BasicTableOrView;", "tablesCount", "", "currentTablesCount", "createFindModel", "Lcom/intellij/find/FindModel;", "text", "", "createSearcher", "Lcom/intellij/usages/UsageSearcher;", "targets", "Lcom/intellij/database/psi/DbElement;", "getDbDataSource", "Lcom/intellij/database/psi/DbDataSource;", "target", "getPredicates", "", "Lcom/intellij/database/data/types/ColumnRef;", "", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "dbms", "Lcom/intellij/database/Dbms;", "version", "Lcom/intellij/database/util/Version;", "table", "getPredicates$intellij_database_impl", "qualifyTable", "dataSourceName", "search", "listener", "Lcom/intellij/usages/UsageViewManager$UsageViewStateListener;", "searchStatement", "builder", "Lcom/intellij/database/util/DdlBuilder;", "dbDataSource", "predicates", "insertNewLines", "", "setupViewPresentation", "Lcom/intellij/usages/UsageViewPresentation;", "findModel", "withCancelling", "Lcom/intellij/database/dataSource/InterruptibleDatabaseConnection;", "action", "Lkotlin/Function0;", "toDecorator", "Lcom/intellij/database/util/DbImplUtil$StringLiteralDecorator;", "Lcom/intellij/database/fulltextsearch/FullTextSearchOptions$Location;", "intellij.database.impl"})
    public static final class Companion {
        public final void searchStatement(@NotNull DdlBuilder builder, @NotNull BasicTableOrView table, @NotNull DbDataSource dbDataSource, @NotNull FullTextSearchOptions options, @NotNull List<PredicatesHelper.PredicateProducer> predicates, boolean insertNewLines) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)dbDataSource, (String)"dbDataSource");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Intrinsics.checkNotNullParameter(predicates, (String)"predicates");
            DmlHelper ddlGenerator = (DmlHelper)DmlHelper.Companion.getEP().forDbms(dbDataSource.getDbms());
            SelectTask task = DmlTaskKt.allColumns(table).version(dbDataSource.getVersion()).limit(options.getMaxNumOfFetchedRows()).insertNewLines(insertNewLines).whereClause(new PredicatesWhereClause(predicates, "OR", null, 4, null)).build(builder);
            ddlGenerator.generate(task);
        }

        public final void search(@NotNull Project project, @NotNull FullTextSearchOptions options, @NotNull Collection<? extends DbElement> targets2, @Nullable UsageViewManager.UsageViewStateListener listener2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Intrinsics.checkNotNullParameter(targets2, (String)"targets");
            UsageViewManager usageViewManager = UsageViewManager.getInstance((Project)project);
            if (usageViewManager == null) {
                return;
            }
            UsageViewManager manager = usageViewManager;
            String string = options.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"options.text");
            FindModel findModel = this.createFindModel(project, string);
            DatabaseStringUsageTarget usageTarget = new DatabaseStringUsageTarget(project, findModel, options, targets2);
            UsageViewPresentation presentation = this.setupViewPresentation(findModel);
            FindUsagesProcessPresentation findUsagesProcessPresentation = FindInProjectUtil.setupProcessPresentation((Project)project, (UsageViewPresentation)presentation);
            Intrinsics.checkNotNullExpressionValue((Object)findUsagesProcessPresentation, (String)"FindInProjectUtil.setupP\u2026on(project, presentation)");
            FindUsagesProcessPresentation processPresentation = findUsagesProcessPresentation;
            manager.searchAndShowUsages(new UsageTarget[]{(UsageTarget)usageTarget}, (Factory)new Factory<UsageSearcher>(project, options, targets2){
                final /* synthetic */ Project $project;
                final /* synthetic */ FullTextSearchOptions $options;
                final /* synthetic */ Collection $targets;

                public final UsageSearcher create() {
                    return com.intellij.database.actions.FullTextSearchAction$Companion.access$createSearcher(FullTextSearchAction.Companion, this.$project, this.$options, this.$targets);
                }
                {
                    this.$project = project;
                    this.$options = fullTextSearchOptions;
                    this.$targets = collection;
                }
            }, processPresentation, presentation, listener2);
        }

        private final UsageViewPresentation setupViewPresentation(FindModel findModel) {
            UsageViewPresentation usageViewPresentation = FindInProjectUtil.setupViewPresentation((FindModel)findModel);
            Intrinsics.checkNotNullExpressionValue((Object)usageViewPresentation, (String)"FindInProjectUtil.setupViewPresentation(findModel)");
            UsageViewPresentation presentation = usageViewPresentation;
            presentation.setUsageTypeFilteringAvailable(false);
            return presentation;
        }

        private final FindModel createFindModel(Project project, String text2) {
            FindModel findModel = new FindModel();
            findModel.setStringToFind(text2);
            findModel.setCustomScope((SearchScope)GlobalSearchScope.everythingScope((Project)project));
            findModel.setCustomScope(true);
            return findModel;
        }

        private final UsageSearcher createSearcher(Project project, FullTextSearchOptions options, Collection<? extends DbElement> targets2) {
            return new UsageSearcher(targets2, project, options){
                final /* synthetic */ Collection $targets;
                final /* synthetic */ Project $project;
                final /* synthetic */ FullTextSearchOptions $options;

                public final void generate(@NotNull Processor<? super Usage> processor) {
                    Intrinsics.checkNotNullParameter(processor, (String)"processor");
                    ProgressManager progressManager = ProgressManager.getInstance();
                    Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
                    ProgressIndicator indicator = progressManager.getProgressIndicator();
                    AsyncUtil.withAsyncFriendly(indicator, (ThrowableComputable)new ThrowableComputable<Object, RuntimeException>(this, indicator, processor){
                        final /* synthetic */ createSearcher.1 this$0;
                        final /* synthetic */ ProgressIndicator $indicator;
                        final /* synthetic */ Processor $processor;

                        /*
                         * WARNING - void declaration
                         */
                        public final void compute() {
                            Ref.IntRef $this$fold$iv;
                            List<SearchGroup> groups = new TableGrouper(this.this$0.$targets).getGroups();
                            Iterable iterable = groups;
                            int initial$iv = 0;
                            boolean $i$f$fold = false;
                            int accumulator$iv2 = initial$iv;
                            for (T element$iv : $this$fold$iv) {
                                void g;
                                SearchGroup searchGroup = (SearchGroup)element$iv;
                                int tablesCount = accumulator$iv2;
                                boolean bl = false;
                                accumulator$iv2 = tablesCount + g.getTables().size();
                            }
                            int tablesCount = accumulator$iv2;
                            ProgressIndicator progressIndicator = this.$indicator;
                            Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"indicator");
                            progressIndicator.setFraction(0.0);
                            ProgressIndicator progressIndicator2 = this.$indicator;
                            Intrinsics.checkNotNullExpressionValue((Object)progressIndicator2, (String)"indicator");
                            progressIndicator2.setIndeterminate(false);
                            $this$fold$iv = new Ref.IntRef();
                            $this$fold$iv.element = 0;
                            for (SearchGroup searchGroup : groups) {
                                void tables;
                                Set<BasicTableOrView> accumulator$iv2 = searchGroup.component1();
                                LocalDataSource localDataSource = searchGroup.component2();
                                SearchPath searchPath = searchGroup.component3();
                                try {
                                    void currentTablesCount;
                                    void dataSource2;
                                    DatabaseSessionManager.facade(this.this$0.$project, (LocalDataSource)dataSource2, null, searchPath, false, null, DGDepartment.TEXT_SEARCH).runSync((Function1)new Function1<InterruptibleDatabaseConnection, Unit>(this, (LocalDataSource)dataSource2, (Set)tables, tablesCount, (Ref.IntRef)currentTablesCount){
                                        final /* synthetic */ Companion.createSearcher.1 this$0;
                                        final /* synthetic */ LocalDataSource $dataSource;
                                        final /* synthetic */ Set $tables;
                                        final /* synthetic */ int $tablesCount;
                                        final /* synthetic */ Ref.IntRef $currentTablesCount;

                                        public final void invoke(@NotNull InterruptibleDatabaseConnection connection2) {
                                            Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
                                            ProgressIndicator progressIndicator = this.this$0.$indicator;
                                            Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"indicator");
                                            com.intellij.database.actions.FullTextSearchAction$Companion.access$withCancelling(FullTextSearchAction.Companion, connection2, progressIndicator, (Function0)new Function0<Unit>(this, connection2){
                                                final /* synthetic */ Companion.createSearcher.1 this$0;
                                                final /* synthetic */ InterruptibleDatabaseConnection $connection;

                                                public final void invoke() {
                                                    Project project = this.this$0.this$0.this$0.$project;
                                                    DatabaseConnection databaseConnection = this.$connection;
                                                    Processor processor = this.this$0.this$0.$processor;
                                                    Intrinsics.checkNotNullExpressionValue((Object)processor, (String)"processor");
                                                    LocalDataSource localDataSource = this.this$0.$dataSource;
                                                    FullTextSearchOptions fullTextSearchOptions = this.this$0.this$0.this$0.$options;
                                                    ProgressIndicator progressIndicator = this.this$0.this$0.$indicator;
                                                    Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"indicator");
                                                    com.intellij.database.actions.FullTextSearchAction$Companion.access$checkTables(FullTextSearchAction.Companion, project, databaseConnection, processor, localDataSource, fullTextSearchOptions, progressIndicator, this.this$0.$tables, this.this$0.$tablesCount, this.this$0.$currentTablesCount.element);
                                                }
                                                {
                                                    this.this$0 = var1_1;
                                                    this.$connection = interruptibleDatabaseConnection;
                                                    super(0);
                                                }
                                            });
                                        }
                                        {
                                            this.this$0 = var1_1;
                                            this.$dataSource = localDataSource;
                                            this.$tables = set;
                                            this.$tablesCount = n;
                                            this.$currentTablesCount = intRef;
                                            super(1);
                                        }
                                    });
                                }
                                catch (RuntimeException runtimeException) {
                                    // empty catch block
                                }
                                currentTablesCount.element += tables.size();
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$indicator = progressIndicator;
                            this.$processor = processor;
                        }
                    });
                }
                {
                    this.$targets = collection;
                    this.$project = project;
                    this.$options = fullTextSearchOptions;
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void withCancelling(InterruptibleDatabaseConnection connection2, ProgressIndicator indicator, Function0<Unit> action2) {
            if (!(indicator instanceof ProgressIndicatorEx)) {
                action2.invoke();
                return;
            }
            CancellingDelegate delegate = new CancellingDelegate(connection2, false, 2, null);
            ((ProgressIndicatorEx)indicator).addStateDelegate((ProgressIndicatorEx)delegate);
            try {
                action2.invoke();
            }
            finally {
                delegate.disable();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void checkTables(Project project, DatabaseConnection connection2, Processor<? super Usage> processor, LocalDataSource dataSource2, FullTextSearchOptions options, ProgressIndicator indicator, Collection<? extends BasicTableOrView> tables, int tablesCount, int currentTablesCount) {
            DbDataSource dbDataSource = DbImplUtil.getDbDataSource(project, dataSource2);
            if (dbDataSource == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)dbDataSource, (String)"getDbDataSource(project, dataSource) ?: return");
            DbDataSource dbDataSource2 = dbDataSource;
            DatabaseDialectEx databaseDialectEx = DbImplUtil.getDatabaseDialect(dataSource2.getDbms());
            Intrinsics.checkNotNullExpressionValue((Object)databaseDialectEx, (String)"getDatabaseDialect(dataSource.dbms)");
            DatabaseDialectEx dialect = databaseDialectEx;
            BasicTableOrView currentTable = null;
            int i2 = 0;
            Sequence<Triple<List<PredicatesHelper.PredicateProducer>, BasicTableOrView, DbElement>> $this$forEach$iv = FtsUtilKt.chooseElementsIterator(tables, dbDataSource2, options);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DdlBuilder builder;
                void predicates;
                void table;
                Triple $dstr$predicates$table$element = (Triple)element$iv;
                boolean bl = false;
                List list = (List)$dstr$predicates$table$element.component1();
                BasicTableOrView basicTableOrView = (BasicTableOrView)$dstr$predicates$table$element.component2();
                DbElement element2 = (DbElement)$dstr$predicates$table$element.component3();
                indicator.checkCanceled();
                String string = dataSource2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dataSource.name");
                indicator.setText(Companion.qualifyTable((BasicTableOrView)table, string));
                if (Intrinsics.areEqual((Object)table, (Object)currentTable) ^ true) {
                    int n = i2;
                    i2 = n + 1;
                    currentTable = table;
                    indicator.setFraction((double)(i2 + currentTablesCount) / (double)tablesCount);
                }
                if (predicates.isEmpty()) continue;
                Intrinsics.checkNotNullExpressionValue((Object)new DdlBuilder().withDialect(dialect).qualifyReferences(true), (String)"DdlBuilder().withDialect\u2026).qualifyReferences(true)");
                Companion.searchStatement(builder, (BasicTableOrView)table, dbDataSource2, options, (List<PredicatesHelper.PredicateProducer>)predicates, false);
                SimpleSmartStatement simpleSmartStatement = SmartStatements.Companion.poweredBy(connection2).simple(Configuration.Companion.sourced(SmartStatements.Source.SYSTEM));
                String string2 = builder.getStatement();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"builder.statement");
                int count = ((Number)simpleSmartStatement.execute(string2, StandardResultsProcessors.linesCount(options.getMaxNumOfFetchedRows())).rightOr(0)).intValue();
                if (count <= 0) continue;
                processor.process((Object)FullTextSearchDbElementUsage.Companion.create(element2, count, options.getMaxNumOfFetchedRows(), (List<PredicatesHelper.PredicateProducer>)predicates));
            }
        }

        @NotNull
        public final Map<ColumnRef, List<PredicatesHelper.PredicateProducer>> getPredicates$intellij_database_impl(@NotNull Dbms dbms, @Nullable Version version, @NotNull BasicTableOrView table, @NotNull FullTextSearchOptions options) {
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Object[] objectArray = new PredicateOperation[3];
            objectArray[0] = new EqualsPredicateOperation(null, 1, null);
            objectArray[1] = ContainsInIndexedTextOperation.INSTANCE;
            FullTextSearchOptions.Location location = options.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)location), (String)"options.location");
            LikeOpType likeOpType = location.getLikeOpType();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)likeOpType), (String)"options.location.likeOpType");
            objectArray[2] = new LikePredicateOperation(likeOpType, options.isMatchCase(), false, 4, null);
            Set operations = SetsKt.setOf((Object[])objectArray);
            List list = DasUtil.getColumns((DasObject)table).map((Function)new Function<DasColumn, PredicateSpec>(options, operations){
                final /* synthetic */ FullTextSearchOptions $options;
                final /* synthetic */ Set $operations;

                public final PredicateSpec fun(DasColumn it2) {
                    DasColumn dasColumn = it2;
                    Intrinsics.checkNotNullExpressionValue((Object)dasColumn, (String)"it");
                    ColumnRef columnRef = new DasColumnRef(dasColumn);
                    String string = this.$options.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"options.text");
                    return new PredicateSpec(columnRef, new StringPredicateValue(string, false, 2, null), this.$operations);
                }
                {
                    this.$options = fullTextSearchOptions;
                    this.$operations = set;
                }
            }).toList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"DasUtil.getColumns(table\u2026ions) }\n        .toList()");
            List specs2 = list;
            PredicatesHelper predicatesHelper = PredicatesHelperKt.predicatesHelper(dbms);
            FullTextSearchOptions.SearchScope searchScope = options.getSearchScope();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)searchScope), (String)"options.searchScope");
            List<OperandType> list2 = searchScope.getTypes();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"options.searchScope.types");
            return predicatesHelper.getPredicateProducers(specs2, list2, null, version, false);
        }

        @NlsSafe
        private final String qualifyTable(BasicTableOrView table, String dataSourceName) {
            StringBuilder b2 = new StringBuilder();
            boolean first2 = true;
            for (BasicElement par = table.getParent(); par != null; par = par.getParent()) {
                String name;
                Intrinsics.checkNotNullExpressionValue((Object)par.getName(), (String)"par.name");
                CharSequence charSequence = name;
                boolean bl = false;
                if (!(!StringsKt.isBlank((CharSequence)charSequence))) continue;
                if (first2) {
                    first2 = false;
                } else {
                    b2.insert(0, ".");
                }
                b2.insert(0, name);
            }
            if (!first2) {
                b2.insert(0, ".");
            }
            b2.insert(0, dataSourceName);
            return table.getName() + " (" + b2 + ')';
        }

        @NotNull
        public final DbImplUtil.StringLiteralDecorator toDecorator(@NotNull FullTextSearchOptions.Location $this$toDecorator) {
            DbImplUtil.StringLiteralDecorator stringLiteralDecorator;
            Intrinsics.checkNotNullParameter((Object)((Object)$this$toDecorator), (String)"$this$toDecorator");
            switch (FullTextSearchAction$Companion$WhenMappings.$EnumSwitchMapping$0[$this$toDecorator.ordinal()]) {
                case 1: {
                    stringLiteralDecorator = DbImplUtil.StringLiteralDecorator.CONTAINS;
                    break;
                }
                case 2: {
                    stringLiteralDecorator = DbImplUtil.StringLiteralDecorator.STARTS_WITH;
                    break;
                }
                case 3: {
                    stringLiteralDecorator = DbImplUtil.StringLiteralDecorator.ENDS_WITH;
                    break;
                }
                case 4: {
                    stringLiteralDecorator = DbImplUtil.StringLiteralDecorator.PLAIN;
                    break;
                }
                case 5: {
                    stringLiteralDecorator = DbImplUtil.StringLiteralDecorator.MATCHES;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return stringLiteralDecorator;
        }

        private final DbDataSource getDbDataSource(DbElement target) {
            DbDataSource dbDataSource;
            if (target == null || target instanceof DbDataSource) {
                DbElement dbElement = target;
                if (dbElement == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.psi.DbDataSource");
                }
                dbDataSource = (DbDataSource)dbElement;
            } else {
                dbDataSource = this.getDbDataSource(target.getParent());
            }
            return dbDataSource;
        }

        private Companion() {
        }

        public static final /* synthetic */ UsageSearcher access$createSearcher(Companion $this, Project project, FullTextSearchOptions options, Collection targets2) {
            return $this.createSearcher(project, options, targets2);
        }

        public static final /* synthetic */ void access$withCancelling(Companion $this, InterruptibleDatabaseConnection connection2, ProgressIndicator indicator, Function0 action2) {
            $this.withCancelling(connection2, indicator, (Function0<Unit>)action2);
        }

        public static final /* synthetic */ void access$checkTables(Companion $this, Project project, DatabaseConnection connection2, Processor processor, LocalDataSource dataSource2, FullTextSearchOptions options, ProgressIndicator indicator, Collection tables, int tablesCount, int currentTablesCount) {
            $this.checkTables(project, connection2, (Processor<? super Usage>)processor, dataSource2, options, indicator, tables, tablesCount, currentTablesCount);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

