/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.DumpModelAction;
import com.intellij.database.model.ModelDescribing;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.RefreshAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.RightAlignedToolbarAction;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.DialogBuilder;
import icons.DatabaseIcons;
import java.awt.Dimension;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.Collection;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0016B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\u0006\u0010\u0014\u001a\u00020\u0012J\b\u0010\u0015\u001a\u00020\u0012H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/actions/DumpModelDialog;", "Lcom/intellij/openapi/Disposable;", "nodes", "", "Lcom/intellij/database/model/basic/BasicNode;", "(Ljava/util/Collection;)V", "document", "Lcom/intellij/openapi/editor/Document;", "editorFactory", "Lcom/intellij/openapi/editor/EditorFactory;", "ready", "", "text", "", "useSurrogates", "viewer", "Lcom/intellij/openapi/editor/Editor;", "copyTextToClipboard", "", "dispose", "doIt", "populateDocument", "RightDumbAwareAction", "intellij.database.impl"})
public final class DumpModelDialog
implements Disposable {
    private final EditorFactory editorFactory;
    private final Document document;
    private final Editor viewer;
    private boolean useSurrogates;
    private String text;
    private boolean ready;
    private final Collection<BasicNode> nodes;

    public final void doIt() {
        JComponent jComponent = this.viewer.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"viewer.component");
        JComponent viewerComponent = jComponent;
        viewerComponent.setMinimumSize(new Dimension(200, 200));
        viewerComponent.setPreferredSize(new Dimension(500, 500));
        ToggleAction withSurrogatesAction2 = new ToggleAction(this, DatabaseBundle.messagePointer((String)"action.with.synthetic.stuff.text", (Object[])new Object[0]), DatabaseBundle.messagePointer((String)"action.include.auto.generated.objects.names.description", (Object[])new Object[0]), DatabaseIcons.BinaryData){
            final /* synthetic */ DumpModelDialog this$0;

            public boolean isSelected(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                return DumpModelDialog.access$getUseSurrogates$p(this.this$0);
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                DumpModelDialog.access$setUseSurrogates$p(this.this$0, state);
                DumpModelDialog.access$populateDocument(this.this$0);
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }
        };
        RefreshAction refreshAction2 = new RefreshAction(this, DatabaseBundle.messagePointer((String)"action.DumpModelEntityDebugAction.local.db.exec.refresh.text", (Object[])new Object[0]), Presentation.NULL_STRING, AllIcons.Actions.Refresh){
            final /* synthetic */ DumpModelDialog this$0;

            public void update(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Presentation presentation = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
                presentation.setEnabled(DumpModelDialog.access$getReady$p(this.this$0));
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                DumpModelDialog.access$populateDocument(this.this$0);
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }
        };
        refreshAction2.registerShortcutOn(viewerComponent);
        Supplier supplier = DatabaseBundle.messagePointer((String)"action.DumpModelEntityDebugAction.copyText.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)supplier, (String)"messagePointer(\"action.D\u2026bugAction.copyText.text\")");
        Icon icon = AllIcons.Actions.Copy;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"AllIcons.Actions.Copy");
        RightDumbAwareAction copyTextAction2 = new RightDumbAwareAction(this, supplier, icon){
            final /* synthetic */ DumpModelDialog this$0;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean enabled() {
                if (!DumpModelDialog.access$getReady$p(this.this$0)) return false;
                CharSequence $this$isNotNullOrEmpty$iv = DumpModelDialog.access$getText$p(this.this$0);
                boolean $i$f$isNotNullOrEmpty = false;
                if ($this$isNotNullOrEmpty$iv == null) return false;
                CharSequence charSequence = $this$isNotNullOrEmpty$iv;
                boolean bl = false;
                if (charSequence.length() <= 0) return false;
                return true;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                DumpModelDialog.access$copyTextToClipboard(this.this$0);
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1, $super_call_param$2);
            }
        };
        DefaultActionGroup buttonsGroup = new DefaultActionGroup(new AnAction[]{(AnAction)withSurrogatesAction2, (AnAction)refreshAction2, (AnAction)copyTextAction2});
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("DbDump", (ActionGroup)buttonsGroup, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"ActionManager.getInstanc\u2026ump\", buttonsGroup, true)");
        ActionToolbar toolbar2 = actionToolbar;
        toolbar2.setTargetComponent(viewerComponent);
        DialogBuilder dialogBuilder = new DialogBuilder();
        boolean bl = false;
        boolean bl2 = false;
        DialogBuilder $this$apply = dialogBuilder;
        boolean bl3 = false;
        $this$apply.setTitle(DatabaseBundle.message((String)"dialog.title.database.model.dump", (Object[])new Object[0]));
        $this$apply.setNorthPanel(toolbar2.getComponent());
        $this$apply.setCenterPanel(viewerComponent);
        $this$apply.setPreferredFocusComponent(this.viewer.getContentComponent());
        $this$apply.addDisposable((Disposable)this);
        $this$apply.setDimensionServiceKey(DumpModelAction.class.getSimpleName());
        $this$apply.removeAllActions();
        DialogBuilder dia = dialogBuilder;
        dia.showNotModal();
        this.populateDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized void populateDocument() {
        this.ready = false;
        try {
            String text2;
            this.text = text2 = ModelDescribing.describeForest$default(this.nodes, this.useSurrogates, false, 2, null);
            ApplicationManager.getApplication().runWriteAction(new Runnable(this, text2){
                final /* synthetic */ DumpModelDialog this$0;
                final /* synthetic */ String $text;

                public final void run() {
                    DumpModelDialog.access$getDocument$p(this.this$0).setText((CharSequence)this.$text);
                }
                {
                    this.this$0 = dumpModelDialog;
                    this.$text = string;
                }
            });
        }
        finally {
            this.ready = true;
        }
    }

    private final void copyTextToClipboard() {
        String string = this.text;
        if (string == null) {
            return;
        }
        String text2 = string;
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(text2));
    }

    public void dispose() {
        this.editorFactory.releaseEditor(this.viewer);
    }

    public DumpModelDialog(@NotNull Collection<? extends BasicNode> nodes) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        this.nodes = nodes;
        EditorFactory editorFactory = EditorFactory.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)editorFactory, (String)"EditorFactory.getInstance()");
        this.editorFactory = editorFactory;
        Document document = this.editorFactory.createDocument((CharSequence)"");
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editorFactory.createDocument(\"\")");
        this.document = document;
        Editor editor = this.editorFactory.createViewer(this.document);
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"editorFactory.createViewer(document)");
        this.viewer = editor;
    }

    public static final /* synthetic */ boolean access$getUseSurrogates$p(DumpModelDialog $this) {
        return $this.useSurrogates;
    }

    public static final /* synthetic */ void access$setUseSurrogates$p(DumpModelDialog $this, boolean bl) {
        $this.useSurrogates = bl;
    }

    public static final /* synthetic */ void access$populateDocument(DumpModelDialog $this) {
        $this.populateDocument();
    }

    public static final /* synthetic */ boolean access$getReady$p(DumpModelDialog $this) {
        return $this.ready;
    }

    public static final /* synthetic */ void access$setReady$p(DumpModelDialog $this, boolean bl) {
        $this.ready = bl;
    }

    public static final /* synthetic */ String access$getText$p(DumpModelDialog $this) {
        return $this.text;
    }

    public static final /* synthetic */ void access$setText$p(DumpModelDialog $this, String string) {
        $this.text = string;
    }

    public static final /* synthetic */ void access$copyTextToClipboard(DumpModelDialog $this) {
        $this.copyTextToClipboard();
    }

    public static final /* synthetic */ Document access$getDocument$p(DumpModelDialog $this) {
        return $this.document;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH&J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/actions/DumpModelDialog$RightDumbAwareAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/openapi/actionSystem/RightAlignedToolbarAction;", "text", "Ljava/util/function/Supplier;", "", "icon", "Ljavax/swing/Icon;", "(Ljava/util/function/Supplier;Ljavax/swing/Icon;)V", "enabled", "", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.database.impl"})
    private static abstract class RightDumbAwareAction
    extends DumbAwareAction
    implements RightAlignedToolbarAction {
        public abstract boolean enabled();

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            presentation.setVisible(true);
            Presentation presentation2 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
            presentation2.setEnabled(this.enabled());
        }

        public RightDumbAwareAction(@NotNull Supplier<String> text2, @NotNull Icon icon) {
            Intrinsics.checkNotNullParameter(text2, (String)"text");
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            super(text2, icon);
        }
    }
}

