/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.actions.DiagnosticRefresh;
import com.intellij.database.actions.RefreshSchemaAction;
import com.intellij.database.dataSource.DataSourceSyncManager;
import com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService;
import com.intellij.database.introspection.IntrospectionLogRecord;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.view.DatabaseView;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import java.io.File;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.logging.FileHandler;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00072\u00020\u0001:\u0002\u0007\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/database/actions/DiagnosticRefresh;", "Lcom/intellij/database/actions/RefreshSchemaAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Companion", "DiagnosticFormatter", "intellij.database.impl"})
public final class DiagnosticRefresh
extends RefreshSchemaAction {
    private static final Logger LOG;
    private static final Set<DatabaseGlobalAuditService.BlockType> considerBlockTypes;
    @NotNull
    public static final String timeSpace = "  ";
    @NotNull
    public static final String timeIndent = "          ";
    @NotNull
    public static final Companion Companion;

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        JBIterable<DbElement> jBIterable = DatabaseView.getSelectedElementsNoGroups(e.getDataContext(), true);
        Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"DatabaseView.getSelected\u2026oups(e.dataContext, true)");
        JBIterable<DbElement> selection = jBIterable;
        DbDataSource dbDataSource = (DbDataSource)selection.map((Function)actionPerformed.dataSource.1.INSTANCE).first();
        if (dbDataSource == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)dbDataSource, (String)"selection.map { obj: DbE\u2026ource }.first() ?: return");
        DbDataSource dataSource2 = dbDataSource;
        Disposable disposable2 = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"Disposer.newDisposable()");
        Disposable disposable3 = disposable2;
        try {
            File file = FileUtil.createTempFile((File)FileUtil.createTempDirectory((String)"introspection", null), (String)"introspection", (String)".log");
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"FileUtil.createTempFile(\u2026 \"introspection\", \".log\")");
            File logFile = file;
            FileHandler handler = new FileHandler(logFile.getPath(), false);
            handler.setLevel(Level.ALL);
            handler.setFormatter(DiagnosticFormatter.INSTANCE);
            handler.setFilter(new Filter(dataSource2){
                final /* synthetic */ DbDataSource $dataSource;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean isLoggable(@Nullable LogRecord record) {
                    LogRecord logRecord = record;
                    if (logRecord == null) {
                        return false;
                    }
                    if (logRecord instanceof IntrospectionLogRecord) {
                        if (((IntrospectionLogRecord)record).getDataSource() != this.$dataSource.getDelegate()) return false;
                        return true;
                    }
                    if (!(logRecord instanceof DatabaseGlobalAuditService.DatabaseLogRecord)) return false;
                    if (((DatabaseGlobalAuditService.DatabaseLogRecord)record).getDataSource() != this.$dataSource.getDelegate()) return false;
                    DatabaseGlobalAuditService.Block[] blockArray = ((DatabaseGlobalAuditService.DatabaseLogRecord)record).getBlocks();
                    boolean bl = false;
                    DatabaseGlobalAuditService.Block[] blockArray2 = blockArray;
                    boolean bl2 = false;
                    if (blockArray2.length != 0) return true;
                    return false;
                }
                {
                    this.$dataSource = dbDataSource;
                }
            });
            DatabaseGlobalAuditService.Companion.attach(handler, disposable3);
            Level level = Level.ALL;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"Level.ALL");
            DatabaseGlobalAuditService.Companion.setRootLevel(level, disposable3);
            Set set = selection.filter((Condition)new Condition<DbElement>(dataSource2){
                final /* synthetic */ DbDataSource $dataSource;

                public final boolean value(@NotNull DbElement o) {
                    Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                    return o.getDataSource() == this.$dataSource;
                }
                {
                    this.$dataSource = dbDataSource;
                }
            }).toSet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"selection.filter { o: Db\u2026 === dataSource }.toSet()");
            Set elementsToRefresh2 = set;
            RefreshSchemaAction.refresh(dataSource2, elementsToRefresh2).whenComplete(null, new BiConsumer<DataSourceSyncManager.SyncResult, Throwable>(disposable3, logFile){
                final /* synthetic */ Disposable $disposable;
                final /* synthetic */ File $logFile;

                public final void accept(@Nullable DataSourceSyncManager.SyncResult $noName_0, @Nullable Throwable $noName_1) {
                    Disposer.dispose((Disposable)this.$disposable);
                    RevealFileAction.openFile((File)this.$logFile);
                }
                {
                    this.$disposable = disposable2;
                    this.$logFile = file;
                }
            });
        }
        catch (Throwable th) {
            LOG.error(th);
            Disposer.dispose((Disposable)disposable3);
        }
    }

    static {
        Companion = new Companion(null);
        Logger logger2 = Logger.getInstance(DiagnosticRefresh.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(DiagnosticRefresh::class.java)");
        LOG = logger2;
        EnumSet<Enum> enumSet = EnumSet.of((Enum)DatabaseGlobalAuditService.BlockType.STATEMENT, (Enum)DatabaseGlobalAuditService.BlockType.EXECUTION_DURATION, (Enum)DatabaseGlobalAuditService.BlockType.FETCHING_DURATION, (Enum)DatabaseGlobalAuditService.BlockType.WARNING, (Enum)DatabaseGlobalAuditService.BlockType.ERROR);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"EnumSet.of(\n        Bloc\u2026  BlockType.ERROR\n      )");
        considerBlockTypes = enumSet;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u001c\u0010\n\u001a\u00060\u000bj\u0002`\f*\u00060\u000bj\u0002`\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J0\u0010\u000f\u001a\u00060\u000bj\u0002`\f*\u00060\u000bj\u0002`\f2\u0006\u0010\u0010\u001a\u00020\u00042\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0012H\u0002J\f\u0010\u0014\u001a\u00020\u0004*\u00020\u0012H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/actions/DiagnosticRefresh$DiagnosticFormatter;", "Ljava/util/logging/Formatter;", "()V", "format", "", "record", "Ljava/util/logging/LogRecord;", "formatTime", "instant", "Ljava/time/Instant;", "appendTrimmed", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "str", "", "insertLinePrefix", "prefix", "fromIndex", "", "tillIndex", "toStr2", "intellij.database.impl"})
    public static final class DiagnosticFormatter
    extends Formatter {
        @NotNull
        public static final DiagnosticFormatter INSTANCE;

        @Override
        @NotNull
        public String format(@NotNull LogRecord record) {
            String string;
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            StringBuilder b2 = new StringBuilder();
            String timeStr = this.formatTime(record.getInstant());
            b2.append(timeStr).append(DiagnosticRefresh.timeSpace);
            boolean was = false;
            LogRecord logRecord = record;
            if (logRecord instanceof IntrospectionLogRecord) {
                String msg;
                String string2 = msg = ((IntrospectionLogRecord)record).getMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"msg");
                this.appendTrimmed(b2, string2);
                DiagnosticFormatter.insertLinePrefix$default(this, b2, DiagnosticRefresh.timeIndent, 0, 0, 6, null);
                b2.append('\n');
                CharSequence charSequence = msg;
                boolean bl = false;
                was = charSequence.length() > 0;
            } else if (logRecord instanceof DatabaseGlobalAuditService.DatabaseLogRecord) {
                int p1 = b2.length();
                for (DatabaseGlobalAuditService.Block block : ((DatabaseGlobalAuditService.DatabaseLogRecord)record).getBlocks()) {
                    String text2 = block.getText();
                    Object object = text2;
                    boolean bl = false;
                    if (object.length() == 0) continue;
                    object = block.getType();
                    if (object == DatabaseGlobalAuditService.BlockType.STATEMENT) {
                        b2.append("Executing query:");
                        b2.append("\n-- 8< --\n");
                        this.appendTrimmed(b2, text2);
                        b2.append("\n-- >8 --\n");
                        was = true;
                        continue;
                    }
                    if (!considerBlockTypes.contains(object)) continue;
                    this.appendTrimmed(b2, text2).append('\n');
                    was = true;
                }
                this.insertLinePrefix(b2, DiagnosticRefresh.timeIndent, p1, b2.length() - 1);
            }
            if (was) {
                String string3 = b2.toString();
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"b.toString()");
            } else {
                string = "";
            }
            return string;
        }

        private final String formatTime(Instant instant) {
            ZonedDateTime time;
            if (instant == null) {
                return "        ";
            }
            ZonedDateTime zonedDateTime = time = instant.atZone(ZoneId.systemDefault());
            Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"time");
            String h = this.toStr2(zonedDateTime.getHour());
            String m = this.toStr2(time.getMinute());
            String s2 = this.toStr2(time.getSecond());
            return h + ':' + m + ':' + s2;
        }

        private final StringBuilder appendTrimmed(StringBuilder $this$appendTrimmed, CharSequence str) {
            int n;
            int b2 = 0;
            for (n = str.length(); n > 0 && CharsKt.isWhitespace((char)str.charAt(n - 1)); --n) {
            }
            while (b2 < n && CharsKt.isWhitespace((char)str.charAt(b2))) {
                ++b2;
            }
            $this$appendTrimmed.append(str, b2, n);
            return $this$appendTrimmed;
        }

        /*
         * WARNING - void declaration
         */
        private final StringBuilder insertLinePrefix(StringBuilder $this$insertLinePrefix, String prefix, int fromIndex, int tillIndex) {
            int n = tillIndex - 1;
            int n2 = fromIndex;
            if (n >= n2) {
                while (true) {
                    void i2;
                    if ($this$insertLinePrefix.charAt((int)i2) == '\n') {
                        $this$insertLinePrefix.insert((int)(i2 + true), prefix);
                    }
                    if (i2 == n2) break;
                    --i2;
                }
            }
            return $this$insertLinePrefix;
        }

        static /* synthetic */ StringBuilder insertLinePrefix$default(DiagnosticFormatter diagnosticFormatter, StringBuilder stringBuilder, String string, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n = 0;
            }
            if ((n3 & 4) != 0) {
                n2 = stringBuilder.length();
            }
            return diagnosticFormatter.insertLinePrefix(stringBuilder, string, n, n2);
        }

        private final String toStr2(int $this$toStr2) {
            String string;
            if ($this$toStr2 < 10) {
                char c2 = '0';
                String string2 = String.valueOf($this$toStr2);
                boolean bl = false;
                string = String.valueOf(c2) + string2;
            } else {
                string = String.valueOf($this$toStr2);
            }
            return string;
        }

        private DiagnosticFormatter() {
        }

        static {
            DiagnosticFormatter diagnosticFormatter;
            INSTANCE = diagnosticFormatter = new DiagnosticFormatter();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/database/actions/DiagnosticRefresh$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "considerBlockTypes", "", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "timeIndent", "", "timeSpace", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

