/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.actions.FillDbFilesCacheInternalAction;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.NetUtils;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbProcessDebugInternalAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(DbProcessDebugInternalAction.class);

    public void update(@NotNull AnActionEvent e) {
        DbDataSourceImpl dbDataSource;
        LocalDataSource ds;
        if (e == null) {
            DbProcessDebugInternalAction.$$$reportNull$$$0(0);
        }
        boolean visible = (ds = DbImplUtil.getMaybeLocalDataSource((DasDataSource)(dbDataSource = FillDbFilesCacheInternalAction.getDataSource(e.getDataContext())))) != null;
        e.getPresentation().setVisible(visible);
        e.getPresentation().setEnabled(visible && !DbProcessDebugInternalAction.hasDebugOptions(dbDataSource));
    }

    private static boolean hasDebugOptions(@Nullable DbDataSource dbDataSource) {
        LocalDataSource ds = DbImplUtil.getMaybeLocalDataSource((DasDataSource)dbDataSource);
        if (ds == null || dbDataSource == null) {
            return false;
        }
        List<ConsoleRunConfiguration> configurations = JdbcDriverManager.getDriverManager(dbDataSource.getProject()).getActiveConfigurations(ds);
        return DbProcessDebugInternalAction.hasDebugOptions((ConsoleRunConfiguration)((Object)ContainerUtil.getFirstItem(configurations)));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        LocalDataSource ds;
        if (e == null) {
            DbProcessDebugInternalAction.$$$reportNull$$$0(1);
        }
        if ((ds = DbImplUtil.getMaybeLocalDataSource((DasDataSource)FillDbFilesCacheInternalAction.getDataSource(e.getDataContext()))) == null) {
            return;
        }
        final JdbcDriverManager dm = JdbcDriverManager.getDriverManager(e.getProject());
        new Task.Backgroundable(e.getProject(), StringUtil.notNullize((String)this.getTemplateText()), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    indicator.setText("Terminating existing processes");
                    dm.releaseDriver(ds, null).get();
                    ConsoleRunConfiguration configuration = dm.getDefaultRunConfiguration(ds, null);
                    DbProcessDebugInternalAction.setUpForDebug(configuration);
                    indicator.setText("Waiting for debugger to attach");
                    dm.getDriver(ds, configuration);
                }
                catch (Throwable th) {
                    LOG.error(th);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/actions/DbProcessDebugInternalAction$1", "run"));
            }
        }.queue();
    }

    public static void setUpForDebug(ConsoleRunConfiguration configuration) {
        if (DbProcessDebugInternalAction.hasDebugOptions(configuration)) {
            return;
        }
        try {
            int port = NetUtils.findAvailableSocketPort();
            configuration.VM_PARAMETERS = configuration.VM_PARAMETERS + " -agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=*:" + port;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static boolean hasDebugOptions(@Nullable ConsoleRunConfiguration configuration) {
        return configuration != null && configuration.VM_PARAMETERS.contains("jdwp");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/database/actions/DbProcessDebugInternalAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

