/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseDataKeysCore;
import com.intellij.database.Dbms;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.actions.ActionAvailability;
import com.intellij.database.actions.AddDataSourceFromPath;
import com.intellij.database.actions.AddDataSourceFromUrl;
import com.intellij.database.actions.BasicElementActionFun;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.LocalDataSourceManager;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbPsiFacadeImpl;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.database.view.ui.DataSourceManagerDialog;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.actions.DeleteAction;
import com.intellij.ide.actions.NonTrivialActionGroup;
import com.intellij.ide.ui.newItemPopup.NewItemPopupUtil;
import com.intellij.ide.ui.newItemPopup.NewItemSimplePopupPanel;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AlwaysVisibleActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Setter;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.popup.PopupState;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.EmptyIcon;
import icons.DatabaseIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DatabaseViewActions {
    private DatabaseViewActions() {
    }

    @NotNull
    public static ToggleAction toggle(@NotNull @Nls(capitalization=Nls.Capitalization.Title) String name, @NotNull Getter<Boolean> getter, @NotNull Setter<Boolean> setter) {
        if (name == null) {
            DatabaseViewActions.$$$reportNull$$$0(0);
        }
        if (getter == null) {
            DatabaseViewActions.$$$reportNull$$$0(1);
        }
        if (setter == null) {
            DatabaseViewActions.$$$reportNull$$$0(2);
        }
        return DatabaseViewActions.toggle(name, getter, setter, null, null);
    }

    @NotNull
    public static ToggleAction toggle(@NotNull @Nls(capitalization=Nls.Capitalization.Title) String name, @NotNull Getter<Boolean> getter, @NotNull Setter<Boolean> setter, @Nullable Runnable performer) {
        if (name == null) {
            DatabaseViewActions.$$$reportNull$$$0(3);
        }
        if (getter == null) {
            DatabaseViewActions.$$$reportNull$$$0(4);
        }
        if (setter == null) {
            DatabaseViewActions.$$$reportNull$$$0(5);
        }
        return DatabaseViewActions.toggle(name, getter, setter, performer, null);
    }

    @NotNull
    public static ToggleAction toggle(@NotNull @Nls(capitalization=Nls.Capitalization.Title) String name, final @NotNull Getter<Boolean> getter, final @NotNull Setter<Boolean> setter, final @Nullable Runnable performer, final @Nullable Consumer<Presentation> updater) {
        if (name == null) {
            DatabaseViewActions.$$$reportNull$$$0(6);
        }
        if (getter == null) {
            DatabaseViewActions.$$$reportNull$$$0(7);
        }
        if (setter == null) {
            DatabaseViewActions.$$$reportNull$$$0(8);
        }
        return new ToggleAction(name){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                return (Boolean)getter.get();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((Boolean)getter.get() != state) {
                    setter.set((Object)state);
                    if (performer != null) {
                        performer.run();
                    }
                }
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(2);
                }
                super.update(e);
                if (updater != null) {
                    updater.consume((Object)e.getPresentation());
                }
            }

            public boolean isDumbAware() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/database/actions/DatabaseViewActions$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    public static String getDbGroupName(@NotNull AnActionEvent e) {
        PsiElement selection;
        if (e == null) {
            DatabaseViewActions.$$$reportNull$$$0(9);
        }
        return (selection = (PsiElement)e.getData(CommonDataKeys.PSI_ELEMENT)) instanceof DatabaseStructure.DbGroup ? ((DatabaseStructure.DbGroup)selection).getQualifiedName() : null;
    }

    private static void onDataSourceCreated(@NotNull DbPsiFacade facade, @NotNull DataSourceManager<?> manager, @NotNull DasDataSource dataSource2) {
        if (facade == null) {
            DatabaseViewActions.$$$reportNull$$$0(10);
        }
        if (manager == null) {
            DatabaseViewActions.$$$reportNull$$$0(11);
        }
        if (dataSource2 == null) {
            DatabaseViewActions.$$$reportNull$$$0(12);
        }
        DbDataSource newElement = ((DbPsiFacadeImpl)facade).createDataSourceWrapperElement(dataSource2, manager);
        DataSourceManagerDialog.showDialog(facade, (Object)newElement, null);
    }

    public static void addToLRUNames(@NotNull Project project, int lruItems, @NotNull String key, @NotNull String name) {
        if (project == null) {
            DatabaseViewActions.$$$reportNull$$$0(13);
        }
        if (key == null) {
            DatabaseViewActions.$$$reportNull$$$0(14);
        }
        if (name == null) {
            DatabaseViewActions.$$$reportNull$$$0(15);
        }
        DatabaseViewActions.addToLRUNames(project, lruItems, key, Collections.singletonList(name));
    }

    public static void addToLRUNames(@NotNull Project project, int lruItems, @NotNull String key, @NotNull List<String> names) {
        if (project == null) {
            DatabaseViewActions.$$$reportNull$$$0(16);
        }
        if (key == null) {
            DatabaseViewActions.$$$reportNull$$$0(17);
        }
        if (names == null) {
            DatabaseViewActions.$$$reportNull$$$0(18);
        }
        PropertiesComponent props = PropertiesComponent.getInstance((Project)project);
        List list = (List)JBIterable.of((Object[])props.getValues(key)).unique().addAllTo(new ArrayList());
        list.removeAll(names);
        list.addAll(names);
        List lru = list.subList(Math.max(0, list.size() - lruItems), list.size());
        props.setValues(key, ArrayUtilRt.toStringArray(lru));
    }

    @NotNull
    public static List<String> getLRUNames(@NotNull Project project, @NotNull String key) {
        if (project == null) {
            DatabaseViewActions.$$$reportNull$$$0(19);
        }
        if (key == null) {
            DatabaseViewActions.$$$reportNull$$$0(20);
        }
        List list = JBIterable.of((Object[])PropertiesComponent.getInstance((Project)project).getValues(key)).toList();
        if (list == null) {
            DatabaseViewActions.$$$reportNull$$$0(21);
        }
        return list;
    }

    @NotNull
    private static JComponent createKindChooser(@NotNull DatabaseView databaseView) {
        if (databaseView == null) {
            DatabaseViewActions.$$$reportNull$$$0(22);
        }
        DatabaseViewOptions options = databaseView.getViewOptions();
        List dataSources = DbPsiFacade.getInstance((Project)databaseView.getProject()).getDataSources();
        ArrayList<ObjectKind> kinds = new ArrayList<ObjectKind>();
        if (dataSources.isEmpty()) {
            ObjectKind.getDatabaseKinds().addAllTo(kinds);
        } else {
            JBIterable.from((Iterable)dataSources).transform(ds -> DbImplUtil.getMetaModel(ds)).unique().flatten(mm -> mm.getKinds()).unique().addAllTo(kinds);
        }
        kinds.removeAll(Arrays.asList(ObjectKind.NONE, ObjectKind.UNKNOWN_OBJECT, ObjectKind.ROOT));
        kinds.sort(Comparator.comparing(ObjectKind::name));
        ElementsChooser<ObjectKind> chooser = new ElementsChooser<ObjectKind>(kinds, true){

            protected String getItemText(@NotNull ObjectKind value2) {
                if (value2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return StringUtil.capitalizeWords((String)DbPresentationCore.getPresentableName(value2, Dbms.UNKNOWN), (boolean)true);
            }

            protected Icon getItemIcon(@NotNull ObjectKind value2) {
                if (value2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                return (Icon)ObjectUtils.notNull((Object)DbPresentationCore.getIcon(value2), (Object)EmptyIcon.ICON_16);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "value";
                objectArray2[1] = "com/intellij/database/actions/DatabaseViewActions$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getItemText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getItemIcon";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        Iterator iterator = kinds.iterator();
        while (iterator.hasNext()) {
            ObjectKind kind;
            chooser.setElementMarked((Object)kind, !options.HIDDEN_KINDS.contains((kind = (ObjectKind)iterator.next()).code()));
        }
        chooser.addElementsMarkListener((element2, isMarked) -> {
            if (isMarked) {
                options.HIDDEN_KINDS.remove(element2.code());
            } else {
                options.HIDDEN_KINDS.add(element2.code());
            }
            DatabaseViewOptions.fireChanged(databaseView.getProject());
        });
        chooser.setFocusable(false);
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BoxLayout(panel2, 1));
        panel2.add((Component)chooser);
        JPanel buttons = new JPanel();
        JButton all = new JButton(DatabaseBundle.message((String)"kinds.filter.all", (Object[])new Object[0]));
        all.addActionListener(new ActionListener((ElementsChooser)chooser){
            final /* synthetic */ ElementsChooser val$chooser;
            {
                this.val$chooser = elementsChooser;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$chooser.setAllElementsMarked(true);
            }
        });
        buttons.add(all);
        JButton none = new JButton(DatabaseBundle.message((String)"kinds.filter.none", (Object[])new Object[0]));
        none.addActionListener(new ActionListener((ElementsChooser)chooser){
            final /* synthetic */ ElementsChooser val$chooser;
            {
                this.val$chooser = elementsChooser;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$chooser.setAllElementsMarked(false);
            }
        });
        buttons.add(none);
        JButton invert = new JButton(DatabaseBundle.message((String)"kinds.filter.invert", (Object[])new Object[0]));
        invert.addActionListener(new ActionListener((ElementsChooser)chooser){
            final /* synthetic */ ElementsChooser val$chooser;
            {
                this.val$chooser = elementsChooser;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$chooser.invertSelection();
            }
        });
        buttons.add(invert);
        panel2.add(buttons);
        JPanel jPanel = panel2;
        if (jPanel == null) {
            DatabaseViewActions.$$$reportNull$$$0(23);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 21: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 21: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getter";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 13: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/DatabaseViewActions";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/DatabaseViewActions";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getLRUNames";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createKindChooser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toggle";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDbGroupName";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "onDataSourceCreated";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addToLRUNames";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getLRUNames";
                break;
            }
            case 21: 
            case 23: {
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createKindChooser";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 21: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class FilterAction
    extends DumbAwareAction {
        private final PopupState<JBPopup> myPopupState = PopupState.forPopup();

        FilterAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            DatabaseView databaseView;
            if (e == null) {
                FilterAction.$$$reportNull$$$0(0);
            }
            boolean active = (databaseView = (DatabaseView)((Object)e.getData(DatabaseView.DATABASE_VIEW_KEY))) != null && !databaseView.getViewOptions().HIDDEN_KINDS.isEmpty();
            e.getPresentation().setEnabledAndVisible(databaseView != null);
            Icon icon = this.getTemplatePresentation().getIcon();
            e.getPresentation().setIcon(active ? ExecutionUtil.getLiveIndicator((Icon)icon) : icon);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                FilterAction.$$$reportNull$$$0(1);
            }
            if (this.myPopupState.isRecentlyHidden()) {
                return;
            }
            DatabaseView databaseView = (DatabaseView)((Object)e.getData(DatabaseView.DATABASE_VIEW_KEY));
            if (databaseView == null) {
                return;
            }
            Project project = databaseView.getProject();
            JComponent chooser = DatabaseViewActions.createKindChooser(databaseView);
            JBPopup popup2 = JBPopupFactory.getInstance().createComponentPopupBuilder(chooser, null).setFocusable(false).setRequestFocus(false).setResizable(true).setMinSize(new Dimension(200, 200)).setDimensionServiceKey(project, "DatabaseViewActions_Filter", false).createPopup();
            this.myPopupState.prepareToShow((Object)popup2);
            DbUIUtil.showPopup(popup2, (Editor)e.getData(CommonDataKeys.EDITOR), e);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/actions/DatabaseViewActions$FilterAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MoveToGroup
    extends DataSourceActionBase {
        @Override
        public void update(@NotNull AnActionEvent e) {
            boolean disable;
            if (e == null) {
                MoveToGroup.$$$reportNull$$$0(0);
            }
            if (disable = JBIterable.of((Object[])((PsiElement[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY))).filter(DbDataSource.class).isEmpty()) {
                e.getPresentation().setEnabledAndVisible(false);
            } else {
                super.update(e);
            }
        }

        @Override
        protected boolean isEnabledFor(@NotNull Project project, @NotNull DbDataSource source) {
            if (project == null) {
                MoveToGroup.$$$reportNull$$$0(1);
            }
            if (source == null) {
                MoveToGroup.$$$reportNull$$$0(2);
            }
            return source.getDelegate() instanceof AbstractDataSource;
        }

        @Override
        protected void performActionImpl(final @NotNull Project project, @NotNull List<DbDataSource> dataSources, @NotNull AnActionEvent e) {
            if (project == null) {
                MoveToGroup.$$$reportNull$$$0(3);
            }
            if (dataSources == null) {
                MoveToGroup.$$$reportNull$$$0(4);
            }
            if (e == null) {
                MoveToGroup.$$$reportNull$$$0(5);
            }
            JBIterable allDataSources = JBIterable.from((Iterable)DbPsiFacade.getInstance((Project)project).getDataSources()).map(DbDataSource::getDelegate).filter(AbstractDataSource.class).collect();
            List groups = (List)allDataSources.filterMap(o -> o.getGroupName()).flatMap(o -> JBIterable.generate((Object)o, o1 -> {
                int idx = o1.lastIndexOf("/");
                return idx < 0 ? null : o1.substring(0, idx);
            })).collect(new TreeSet(NaturalComparator.INSTANCE)).addAllTo(new ArrayList());
            String newGroup = new String(DatabaseBundle.message((String)"new.group", (Object[])new Object[0]));
            String topGroup = new String(DatabaseBundle.message((String)"root.group", (Object[])new Object[0]));
            final Consumer action2 = o -> {
                if (o == topGroup) {
                    MoveToGroup.assignGroup(project, null, dataSources);
                } else if (o != newGroup) {
                    MoveToGroup.assignGroup(project, o, dataSources);
                } else {
                    String initial = (String)JBIterable.from((Iterable)dataSources).filterMap(d2 -> StringUtil.nullize((String)((AbstractDataSource)d2.getDelegate()).getGroupName())).first();
                    MoveToGroup.askForGroupName(project, initial, (Consumer<String>)((Consumer)groupName -> {
                        if (groupName != null) {
                            MoveToGroup.assignGroup(project, groupName, dataSources);
                        }
                    }));
                }
            };
            if (groups.isEmpty()) {
                action2.consume((Object)newGroup);
                return;
            }
            groups.add(0, newGroup);
            groups.add(1, topGroup);
            BaseListPopupStep<String> step = new BaseListPopupStep<String>(DatabaseBundle.message((String)"move.to.group", (Object[])new Object[0]), groups){

                public boolean isSpeedSearchEnabled() {
                    return true;
                }

                @NotNull
                public String getTextFor(@NlsSafe String o) {
                    String string = o;
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                public Icon getIconFor(String value2) {
                    return DatabaseIcons.ObjectGroup;
                }

                public ListSeparator getSeparatorAbove(String value2) {
                    List values2 = this.getValues();
                    int index2 = values2.indexOf(value2);
                    return index2 == 2 ? new ListSeparator() : null;
                }

                public PopupStep onChosen(String o, boolean finalChoice) {
                    ApplicationManager.getApplication().invokeLater(() -> action2.consume((Object)o), ModalityState.current(), project.getDisposed());
                    return PopupStep.FINAL_CHOICE;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/DatabaseViewActions$MoveToGroup$1", "getTextFor"));
                }
            };
            ListPopup popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step, 20);
            DbUIUtil.showPopup((JBPopup)popup2, null, e);
        }

        public static void askForGroupName(@NotNull Project project, @Nullable String initial, @NotNull Consumer<String> consumer2) {
            if (project == null) {
                MoveToGroup.$$$reportNull$$$0(6);
            }
            if (consumer2 == null) {
                MoveToGroup.$$$reportNull$$$0(7);
            }
            String string = initial = StringUtil.isEmptyOrSpaces((String)(initial = StringUtil.notNullize((String)initial))) || StringUtil.endsWithChar((CharSequence)initial, (char)'/') ? initial : initial + "/";
            if (Experiments.getInstance().isFeatureEnabled("show.create.new.element.in.popup")) {
                MoveToGroup.createLightWeightPopup(initial, consumer2).showCenteredInCurrentWindow(project);
            } else {
                String name = Messages.showInputDialog((Project)project, null, (String)DatabaseBundle.message((String)"group.name.title", (Object[])new Object[0]), null, (String)initial, null, null, (String)DatabaseBundle.message((String)"group.name.message", (Object[])new Object[0]));
                consumer2.consume((Object)name);
            }
        }

        private static JBPopup createLightWeightPopup(@NotNull String initial, @NotNull Consumer<String> consumer2) {
            if (initial == null) {
                MoveToGroup.$$$reportNull$$$0(8);
            }
            if (consumer2 == null) {
                MoveToGroup.$$$reportNull$$$0(9);
            }
            NewItemSimplePopupPanel contentPanel = new NewItemSimplePopupPanel();
            JTextField nameField = contentPanel.getTextField();
            nameField.setText(initial);
            nameField.selectAll();
            JBPopup popup2 = NewItemPopupUtil.createNewItemPopup((String)DatabaseBundle.message((String)"group.name.title.2", (Object[])new Object[0]), (JComponent)contentPanel, (JComponent)nameField);
            popup2.setAdText(DatabaseBundle.message((String)"group.name.message", (Object[])new Object[0]), 2);
            contentPanel.setApplyAction(event -> {
                consumer2.consume((Object)nameField.getText());
                popup2.closeOk(event);
            });
            return popup2;
        }

        public static void assignGroup(@NotNull Project project, @Nullable String groupName, @NotNull List<DbDataSource> dataSources) {
            if (project == null) {
                MoveToGroup.$$$reportNull$$$0(10);
            }
            if (dataSources == null) {
                MoveToGroup.$$$reportNull$$$0(11);
            }
            for (DbDataSource dataSource2 : dataSources) {
                ((AbstractDataSource)dataSource2.getDelegate()).setGroupName(groupName);
            }
            DatabaseView.refreshViewAndSelect(project, dataSources);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: 
                case 3: 
                case 6: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 4: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSources";
                    break;
                }
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initial";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/DatabaseViewActions$MoveToGroup";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledFor";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performActionImpl";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "askForGroupName";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createLightWeightPopup";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "assignGroup";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class CopyAction
    extends DumbAwareAction {
        CopyAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            JBIterable elements;
            if (e == null) {
                CopyAction.$$$reportNull$$$0(0);
            }
            boolean enabled = (elements = JBIterable.of((Object[])((PsiElement[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY)))).size() == 1 && elements.first() instanceof DbDataSource;
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setVisible(enabled || !ActionPlaces.isPopupPlace((String)e.getPlace()));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DbPsiFacade facade;
            if (e == null) {
                CopyAction.$$$reportNull$$$0(1);
            }
            if ((facade = (DbPsiFacade)e.getData(DatabaseDataKeysCore.DB_PSI_FACADE)) == null) {
                return;
            }
            JBIterable elements = JBIterable.of((Object[])((PsiElement[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY)));
            PsiElement first2 = (PsiElement)elements.first();
            if (elements.size() != 1 || !(first2 instanceof DbDataSource)) {
                return;
            }
            DbDataSource element2 = (DbDataSource)first2;
            DatabaseView view2 = (DatabaseView)((Object)e.getData(DatabaseView.DATABASE_VIEW_KEY));
            if (view2 == null) {
                return;
            }
            String newName = DbUtil.generateUniqueDataSourceName((Project)facade.getProject(), (String)element2.getName());
            DataSourceManager dbManager = facade.getDataSourceManager(element2);
            DasDataSource dsCopy = dbManager.copyDataSource(newName, (DasDataSource)element2.getDelegate());
            DatabaseCredentials credentials = DatabaseCredentials.newUIInstance();
            DatabaseCredentials.getInstance().copyAllCredentials((DasDataSource)element2.getDelegate(), dsCopy, credentials);
            DbDataSource newElement = ((DbPsiFacadeImpl)facade).createDataSourceWrapperElement(dsCopy, dbManager);
            DataSourceManagerDialog.showDialog(facade, (Object)newElement, credentials);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/actions/DatabaseViewActions$CopyAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class DisconnectAction
    extends DataSourceActionBase {
        DisconnectAction() {
        }

        @Override
        protected boolean isEnabledFor(@NotNull Project project, @NotNull DbDataSource dataSource2) {
            if (project == null) {
                DisconnectAction.$$$reportNull$$$0(0);
            }
            if (dataSource2 == null) {
                DisconnectAction.$$$reportNull$$$0(1);
            }
            JdbcDriverManager manager = JdbcDriverManager.getDriverManager(project);
            DatabaseSystem delegate = dataSource2.getDelegate();
            LocalDataSource local = delegate instanceof LocalDataSource ? (LocalDataSource)delegate : null;
            return local != null && !manager.getActiveConfigurations(local).isEmpty();
        }

        @Override
        protected void performActionImpl(@NotNull Project project, @NotNull List<DbDataSource> dataSources, @NotNull AnActionEvent e) {
            if (project == null) {
                DisconnectAction.$$$reportNull$$$0(2);
            }
            if (dataSources == null) {
                DisconnectAction.$$$reportNull$$$0(3);
            }
            if (e == null) {
                DisconnectAction.$$$reportNull$$$0(4);
            }
            for (DbDataSource dataSource2 : dataSources) {
                LocalDataSource localDataSource = DbImplUtil.getLocalDataSource((DasDataSource)dataSource2);
                localDataSource.clearIntrospectionCache();
                List<DatabaseSession> sessions = DatabaseSessionManager.getSessions(project, localDataSource);
                if (sessions.isEmpty()) {
                    JdbcDriverManager.getDriverManager(project).releaseDriver(localDataSource, null);
                    return;
                }
                for (DatabaseSession session2 : sessions) {
                    SessionsUtil.disconnect(session2);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSources";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/DatabaseViewActions$DisconnectAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledFor";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performActionImpl";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static abstract class DataSourceActionBase
    extends DumbAwareAction {
        DataSourceActionBase() {
        }

        protected abstract boolean isEnabledFor(@NotNull Project var1, @NotNull DbDataSource var2);

        protected abstract void performActionImpl(@NotNull Project var1, @NotNull List<DbDataSource> var2, @NotNull AnActionEvent var3);

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                DataSourceActionBase.$$$reportNull$$$0(0);
            }
            Project project = DataSourceActionBase.getEventProject((AnActionEvent)e);
            JBIterable elements = JBIterable.of((Object[])((PsiElement[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY))).filter(DbElement.class);
            boolean enabled = false;
            boolean strict = false;
            if (project != null && !elements.isEmpty()) {
                HashSet<String> visited = new HashSet<String>();
                for (DbElement element2 : elements) {
                    DbDataSource dataSource2 = element2.getDataSource();
                    if (!visited.add(dataSource2.getUniqueId())) continue;
                    strict |= element2 == dataSource2;
                    if (enabled || !this.isEnabledFor(project, dataSource2)) continue;
                    enabled = true;
                }
            }
            boolean inPopup = ActionPlaces.isPopupPlace((String)e.getPlace());
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setVisible(!inPopup || strict);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                DataSourceActionBase.$$$reportNull$$$0(1);
            }
            Project project = DataSourceActionBase.getEventProject((AnActionEvent)e);
            JBIterable elements = JBIterable.of((Object[])((PsiElement[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY))).filter(DbElement.class);
            if (project == null || elements.isEmpty()) {
                return;
            }
            ArrayList<DbDataSource> dataSources = new ArrayList<DbDataSource>();
            HashSet<String> visited = new HashSet<String>();
            for (DbElement element2 : elements) {
                DbDataSource dataSource2 = element2.getDataSource();
                if (!visited.add(dataSource2.getUniqueId()) || !this.isEnabledFor(project, dataSource2)) continue;
                dataSources.add(dataSource2);
            }
            this.performActionImpl(project, dataSources, e);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/actions/DatabaseViewActions$DataSourceActionBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DiagnosticsGroup
    extends NonTrivialActionGroup
    implements DumbAware {
        public boolean canBePerformed(@NotNull DataContext context) {
            if (context == null) {
                DiagnosticsGroup.$$$reportNull$$$0(0);
            }
            return true;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                DiagnosticsGroup.$$$reportNull$$$0(1);
            }
            ActionAvailability availability = DiagnosticsGroup.checkAvailability(e);
            BasicElementActionFun.setAvailability(e, availability);
        }

        private static ActionAvailability checkAvailability(@NotNull AnActionEvent e) {
            DatabaseView databaseView;
            if (e == null) {
                DiagnosticsGroup.$$$reportNull$$$0(2);
            }
            if ((databaseView = (DatabaseView)((Object)e.getData(DatabaseView.DATABASE_VIEW_KEY))) == null) {
                return ActionAvailability.ACTION_HIDDEN;
            }
            String place = e.getPlace();
            if (!place.equals("DatabaseViewPopup") && !ActionPlaces.isMainMenuOrActionSearch((String)place)) {
                return ActionAvailability.ACTION_HIDDEN;
            }
            try {
                JBIterable<BasicNode> nodes = BasicElementActionFun.iterateActionNodes(e, true);
                if (nodes.isEmpty()) {
                    return ActionAvailability.ACTION_HIDDEN;
                }
                return ActionAvailability.ACTION_ENABLED;
            }
            catch (ProcessCanceledException pce) {
                return ActionAvailability.ACTION_HIDDEN;
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                DiagnosticsGroup.$$$reportNull$$$0(3);
            }
            ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(DatabaseBundle.message((String)"group.DatabaseView.Diagnostics.text", (Object[])new Object[0]), (ActionGroup)this, e.getDataContext(), JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING, false, null, 20, null, "DatabaseViewPopup");
            popup2.showInBestPositionFor(e.getDataContext());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/DatabaseViewActions$DiagnosticsGroup";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canBePerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkAvailability";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ToolsPopupGroup
    extends NonTrivialActionGroup
    implements DumbAware {
        public boolean canBePerformed(@NotNull DataContext context) {
            if (context == null) {
                ToolsPopupGroup.$$$reportNull$$$0(0);
            }
            return true;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ToolsPopupGroup.$$$reportNull$$$0(1);
            }
            boolean enabled = e.getData(DatabaseView.DATABASE_VIEW_KEY) != null;
            boolean visible = enabled && ("DatabaseViewPopup".equals(e.getPlace()) || ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace()));
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setVisible(visible);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ToolsPopupGroup.$$$reportNull$$$0(2);
            }
            ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(DatabaseBundle.message((String)"group.DatabaseView.Tools.text", (Object[])new Object[0]), (ActionGroup)this, e.getDataContext(), JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING, false, null, 20, null, "DatabaseViewPopup");
            popup2.showInBestPositionFor(e.getDataContext());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/DatabaseViewActions$ToolsPopupGroup";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canBePerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class AddDriverAndDataSource
    extends DumbAwareAction {
        AddDriverAndDataSource() {
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                AddDriverAndDataSource.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabledAndVisible(e.getProject() != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                AddDriverAndDataSource.$$$reportNull$$$0(1);
            }
            if ((project = e.getProject()) == null) {
                return;
            }
            Collection<? extends DatabaseDriver> existing = DatabaseDriverManager.getInstance().getDrivers();
            DatabaseDriver driver = DataSourceUiUtil.createDefaultDatabaseDriver(existing);
            LocalDataSource dataSource2 = driver.createDataSource(null);
            LocalDataSourceManager defaultManager = LocalDataSourceManager.getInstance(project);
            DbPsiFacade facade = DbPsiFacade.getInstance((Project)project);
            DbDataSource newElement = ((DbPsiFacadeImpl)facade).createDataSourceWrapperElement(dataSource2, defaultManager);
            DataSourceManagerDialog.showDialog(facade, (Object)JBIterable.of((Object[])new Iconable[]{newElement, driver}), null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/actions/DatabaseViewActions$AddDriverAndDataSource";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class AddDriver
    extends DumbAwareAction {
        AddDriver() {
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                AddDriver.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabledAndVisible(e.getProject() != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                AddDriver.$$$reportNull$$$0(1);
            }
            if ((project = e.getProject()) == null) {
                return;
            }
            Collection<? extends DatabaseDriver> existing = DatabaseDriverManager.getInstance().getDrivers();
            DatabaseDriver driver = DataSourceUiUtil.createDefaultDatabaseDriver(existing);
            DataSourceManagerDialog.showDialog(DbPsiFacade.getInstance((Project)project), (Object)driver, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/actions/DatabaseViewActions$AddDriver";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class AddDataSourceFromThatAction
    extends AddDataSourceFromPath.FromThat {
        AddDataSourceFromThatAction() {
            super((x$0, x$1, x$2) -> DatabaseViewActions.onDataSourceCreated(x$0, x$1, x$2));
        }
    }

    static class AddDataSourceHereAction
    extends AddDataSourceFromPath.Here {
        AddDataSourceHereAction() {
            super((x$0, x$1, x$2) -> DatabaseViewActions.onDataSourceCreated(x$0, x$1, x$2));
        }
    }

    static class AddDataSourceFromPathAction
    extends AddDataSourceFromPath.FromDialog {
        AddDataSourceFromPathAction() {
            super((x$0, x$1, x$2) -> DatabaseViewActions.onDataSourceCreated(x$0, x$1, x$2));
        }
    }

    static class AddDataSourceFromUrlAction
    extends AddDataSourceFromUrl {
        AddDataSourceFromUrlAction() {
            super((x$0, x$1, x$2) -> DatabaseViewActions.onDataSourceCreated(x$0, x$1, x$2));
        }
    }

    public static interface DataSourceFactory {
        public void create(@NotNull DbPsiFacade var1, @NotNull DataSourceManager<LocalDataSource> var2, @NotNull LocalDataSource var3);
    }

    public static class AddDataSourcesGroup
    extends DefaultActionGroup
    implements DumbAware,
    AlwaysVisibleActionGroup {
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                AddDataSourcesGroup.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabledAndVisible(e.getProject() != null);
        }

        public boolean canBePerformed(@NotNull DataContext context) {
            if (context == null) {
                AddDataSourcesGroup.$$$reportNull$$$0(1);
            }
            return true;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                AddDataSourcesGroup.$$$reportNull$$$0(2);
            }
            if ((project = e.getProject()) == null) {
                return;
            }
            ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(this.getTemplateText(), (ActionGroup)new DefaultActionGroup(this.getActions(project, DatabaseViewActions.getDbGroupName(e), true)), e.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false, null, 20, null, e.getPlace());
            popup2.showInBestPositionFor(e.getDataContext());
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            Project project;
            Project project2 = project = e == null ? null : e.getProject();
            if (project == null) {
                AnAction[] anActionArray = super.getChildren(e);
                if (anActionArray == null) {
                    AddDataSourcesGroup.$$$reportNull$$$0(3);
                }
                return anActionArray;
            }
            AnAction[] anActionArray = this.getActions(project, DatabaseViewActions.getDbGroupName(e), false).toArray(EMPTY_ARRAY);
            if (anActionArray == null) {
                AddDataSourcesGroup.$$$reportNull$$$0(4);
            }
            return anActionArray;
        }

        @NotNull
        List<AnAction> getActions(@NotNull Project project, @Nullable String groupName, boolean standalone) {
            if (project == null) {
                AddDataSourcesGroup.$$$reportNull$$$0(5);
            }
            List list = JBIterable.from((Iterable)DataSourceManager.getManagers((Project)project)).filterMap(manager -> {
                AnAction action2 = manager.getCreateDataSourceAction(d2 -> {
                    ((AbstractDataSource)((Object)((Object)d2))).setGroupName(groupName);
                    DatabaseViewActions.onDataSourceCreated(DbPsiFacade.getInstance((Project)project), manager, d2);
                });
                if (standalone && action2 instanceof ActionGroup) {
                    ActionGroup actionGroup = (ActionGroup)action2;
                    actionGroup.setPopup(false);
                    return new DefaultActionGroup(new AnAction[]{actionGroup, Separator.getInstance()});
                }
                return action2;
            }).append((Object[])super.getChildren(null)).toList();
            if (list == null) {
                AddDataSourcesGroup.$$$reportNull$$$0(6);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/DatabaseViewActions$AddDataSourcesGroup";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/DatabaseViewActions$AddDataSourcesGroup";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "canBePerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getActions";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class NewGroup
    extends DefaultActionGroup
    implements DumbAware {
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                NewGroup.$$$reportNull$$$0(0);
            }
            e.getPresentation().setVisible(e.getProject() != null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/DatabaseViewActions$NewGroup", "update"));
        }
    }

    public static class AddActionGroupPopup
    extends DefaultActionGroup
    implements DumbAware {
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                AddActionGroupPopup.$$$reportNull$$$0(0);
            }
            e.getPresentation().setIcon(e.isFromActionToolbar() ? IconUtil.getAddIcon() : AllIcons.General.Add);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/DatabaseViewActions$AddActionGroupPopup", "update"));
        }
    }

    public static class DropAction
    extends DeleteAction {
        @Nullable
        protected DeleteProvider getDeleteProvider(DataContext dataContext) {
            return (DeleteProvider)DatabaseView.DROP_ELEMENT_PROVIDER.getData(dataContext);
        }
    }
}

