/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.access;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.credentialStore.keePass.InMemoryCredentialStore;
import com.intellij.database.access.DbCredentialManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.concurrency.AppExecutorUtil;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0005\u0019\u001a\u001b\u001c\u001dB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0014J&\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\"\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J.\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0017\u0082\u0001\u0003\u001e\u001f \u00a8\u0006!"}, d2={"Lcom/intellij/database/access/DbCredentialManager;", "", "()V", "createCredentialAttributes", "Lcom/intellij/credentialStore/CredentialAttributes;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "prefix", "", "getImpl", "Lcom/intellij/credentialStore/Credentials;", "attributes", "getPassword", "Lcom/intellij/credentialStore/OneTimeString;", "storage", "Lcom/intellij/database/dataSource/LocalDataSource$Storage;", "getPasswordSafe", "Lcom/intellij/ide/passwordSafe/PasswordSafe;", "setImpl", "", "credentials", "useMasterKey", "", "setPassword", "password", "DbCredentialsException", "Global", "GlobalStrict", "Local", "OneTime", "Lcom/intellij/database/access/DbCredentialManager$Global;", "Lcom/intellij/database/access/DbCredentialManager$GlobalStrict;", "Lcom/intellij/database/access/DbCredentialManager$Local;", "intellij.database.impl"})
public abstract class DbCredentialManager {
    @Nullable
    public OneTimeString getPassword(@NotNull LocalDataSource dataSource2, @NotNull LocalDataSource.Storage storage, @Nullable String prefix) {
        Credentials credentials;
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)((Object)storage), (String)"storage");
        if (storage.isOneTime()) {
            return null;
        }
        Credentials credentials2 = credentials = this.getImpl(this.createCredentialAttributes(dataSource2, prefix));
        return credentials2 != null ? credentials2.getPassword() : null;
    }

    public static /* synthetic */ OneTimeString getPassword$default(DbCredentialManager dbCredentialManager, LocalDataSource localDataSource, LocalDataSource.Storage storage, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getPassword");
        }
        if ((n & 4) != 0) {
            string = null;
        }
        return dbCredentialManager.getPassword(localDataSource, storage, string);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @JvmOverloads
    public void setPassword(@NotNull LocalDataSource dataSource, @Nullable OneTimeString password, @NotNull LocalDataSource.Storage storage, @Nullable String prefix) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        v0 = this;
        v1 = this.createCredentialAttributes(dataSource, prefix);
        v2 /* !! */  = password;
        if (v2 /* !! */  == null) ** GOTO lbl-1000
        var5_5 = v2 /* !! */ ;
        var6_6 = false;
        var7_7 = false;
        var8_8 = var5_5;
        var11_9 = v1;
        var10_10 = v0;
        $i$a$-takeIf-DbCredentialManager$setPassword$1 = false;
        var12_12 = storage.isOneTime() == false;
        v0 = var10_10;
        v1 = var11_9;
        v2 /* !! */  = var12_12 != false ? var5_5 : null;
        if (v2 /* !! */  != null) {
            var5_5 = v2 /* !! */ ;
            var6_6 = false;
            var7_7 = false;
            it = var5_5;
            var11_9 = v1;
            var10_10 = v0;
            $i$a$-let-DbCredentialManager$setPassword$2 = false;
            var12_13 = new Credentials(null, it);
            v0 = var10_10;
            v1 = var11_9;
            v3 = var12_13;
        } else lbl-1000:
        // 2 sources

        {
            v3 = null;
        }
        v0.setImpl(v1, v3, storage.isPersisted());
    }

    public static /* synthetic */ void setPassword$default(DbCredentialManager dbCredentialManager, LocalDataSource localDataSource, OneTimeString oneTimeString, LocalDataSource.Storage storage, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setPassword");
        }
        if ((n & 8) != 0) {
            string = null;
        }
        dbCredentialManager.setPassword(localDataSource, oneTimeString, storage, string);
    }

    @JvmOverloads
    public final void setPassword(@NotNull LocalDataSource dataSource2, @Nullable OneTimeString password, @NotNull LocalDataSource.Storage storage) {
        DbCredentialManager.setPassword$default(this, dataSource2, password, storage, null, 8, null);
    }

    @Nullable
    protected Credentials getImpl(@NotNull CredentialAttributes attributes2) {
        Intrinsics.checkNotNullParameter((Object)attributes2, (String)"attributes");
        return this.getPasswordSafe().get(attributes2);
    }

    protected void setImpl(@NotNull CredentialAttributes attributes2, @Nullable Credentials credentials, boolean useMasterKey) {
        Intrinsics.checkNotNullParameter((Object)attributes2, (String)"attributes");
        this.getPasswordSafe().set(attributes2, credentials, !useMasterKey);
    }

    @NotNull
    protected PasswordSafe getPasswordSafe() {
        return PasswordSafe.Companion.getInstance();
    }

    private final CredentialAttributes createCredentialAttributes(LocalDataSource dataSource2, String prefix) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = prefix;
        if (string == null) {
            string = "";
        }
        String serviceName = CredentialAttributesKt.generateServiceName((String)"DB", (String)stringBuilder.append(string).append(dataSource2.getUniqueId()).toString());
        return new CredentialAttributes(serviceName, null, null, false, false, 12, null);
    }

    private DbCredentialManager() {
    }

    public /* synthetic */ DbCredentialManager(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/access/DbCredentialManager$DbCredentialsException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "msg", "", "(Ljava/lang/String;)V", "intellij.database.impl"})
    public static final class DbCredentialsException
    extends RuntimeException {
        public DbCredentialsException(@NotNull String msg) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            super(msg);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0014\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/access/DbCredentialManager$Global;", "Lcom/intellij/database/access/DbCredentialManager;", "()V", "getPasswordSafe", "Lcom/intellij/ide/passwordSafe/PasswordSafe;", "intellij.database.impl"})
    public static final class Global
    extends DbCredentialManager {
        @NotNull
        public static final Global INSTANCE;

        @Override
        @NotNull
        protected PasswordSafe getPasswordSafe() {
            return PasswordSafe.Companion.getInstance();
        }

        private Global() {
            super(null);
        }

        static {
            Global global;
            INSTANCE = global = new Global();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\b\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lcom/intellij/database/access/DbCredentialManager$GlobalStrict;", "Lcom/intellij/database/access/DbCredentialManager;", "()V", "getImpl", "Lcom/intellij/credentialStore/Credentials;", "attributes", "Lcom/intellij/credentialStore/CredentialAttributes;", "getPasswordSafe", "Lcom/intellij/ide/passwordSafe/PasswordSafe;", "intellij.database.impl"})
    public static final class GlobalStrict
    extends DbCredentialManager {
        @NotNull
        public static final GlobalStrict INSTANCE;

        @Override
        @NotNull
        protected PasswordSafe getPasswordSafe() {
            return PasswordSafe.Companion.getInstance();
        }

        @Override
        @Nullable
        protected Credentials getImpl(@NotNull CredentialAttributes attributes2) {
            Credentials credentials;
            Intrinsics.checkNotNullParameter((Object)attributes2, (String)"attributes");
            Credentials credentials2 = super.getImpl(attributes2);
            if (credentials2 != null) {
                Credentials credentials3 = credentials2;
                boolean bl = false;
                boolean bl2 = false;
                Credentials it2 = credentials3;
                boolean bl3 = false;
                if (it2 == CredentialStoreKt.getCANNOT_UNLOCK_KEYCHAIN()) {
                    throw (Throwable)new DbCredentialsException("Unable to unlock keychain");
                }
                if (it2 == CredentialStoreKt.getACCESS_TO_KEY_CHAIN_DENIED()) {
                    throw (Throwable)new ProcessCanceledException();
                }
                credentials = it2;
            } else {
                credentials = null;
            }
            return credentials;
        }

        private GlobalStrict() {
            super(null);
        }

        static {
            GlobalStrict globalStrict;
            INSTANCE = globalStrict = new GlobalStrict();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0019\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000*\u0001\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0014R\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005\u00a8\u0006\b"}, d2={"Lcom/intellij/database/access/DbCredentialManager$Local;", "Lcom/intellij/database/access/DbCredentialManager;", "()V", "safe", "com/intellij/database/access/DbCredentialManager$Local$safe$1", "Lcom/intellij/database/access/DbCredentialManager$Local$safe$1;", "getPasswordSafe", "Lcom/intellij/ide/passwordSafe/PasswordSafe;", "intellij.database.impl"})
    public static class Local
    extends DbCredentialManager {
        private final safe.1 safe = new PasswordSafe(){
            private final InMemoryCredentialStore store;

            public void set(@NotNull CredentialAttributes attributes2, @Nullable Credentials credentials, boolean memoryOnly) {
                Intrinsics.checkNotNullParameter((Object)attributes2, (String)"attributes");
                this.set(attributes2, credentials);
            }

            public void set(@NotNull CredentialAttributes attributes2, @Nullable Credentials credentials) {
                Intrinsics.checkNotNullParameter((Object)attributes2, (String)"attributes");
                this.store.set(attributes2, credentials);
            }

            @Nullable
            public Credentials get(@NotNull CredentialAttributes attributes2) {
                Intrinsics.checkNotNullParameter((Object)attributes2, (String)"attributes");
                return this.store.get(attributes2);
            }

            @NotNull
            public Promise<Credentials> getAsync(@NotNull CredentialAttributes attributes2) {
                Intrinsics.checkNotNullParameter((Object)attributes2, (String)"attributes");
                boolean $i$f$runAsync = false;
                AsyncPromise promise$iv = new AsyncPromise();
                AppExecutorUtil.getAppExecutorService().execute(new Runnable(promise$iv, this, attributes2){
                    final /* synthetic */ AsyncPromise $promise;
                    final /* synthetic */ safe.1 this$0;
                    final /* synthetic */ CredentialAttributes $attributes$inlined;
                    {
                        this.$promise = asyncPromise;
                        this.this$0 = var2_2;
                        this.$attributes$inlined = credentialAttributes;
                    }

                    public final void run() {
                        Credentials credentials;
                        try {
                            boolean bl = false;
                            credentials = this.this$0.get(this.$attributes$inlined);
                        }
                        catch (Throwable e) {
                            this.$promise.setError(e);
                            return;
                        }
                        Credentials result = credentials;
                        this.$promise.setResult((Object)result);
                    }
                });
                return (Promise)promise$iv;
            }

            public boolean isPasswordStoredOnlyInMemory(@NotNull CredentialAttributes attributes2, @NotNull Credentials credentials) {
                Intrinsics.checkNotNullParameter((Object)attributes2, (String)"attributes");
                Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
                return true;
            }

            public boolean isRememberPasswordByDefault() {
                return PasswordSafe.Companion.getInstance().isRememberPasswordByDefault();
            }

            public void setRememberPasswordByDefault(boolean value2) {
                PasswordSafe.Companion.getInstance().setRememberPasswordByDefault(value2);
            }

            public boolean isMemoryOnly() {
                return true;
            }
            {
                this.store = new InMemoryCredentialStore();
            }
        };

        @Override
        @NotNull
        protected PasswordSafe getPasswordSafe() {
            return this.safe;
        }

        public Local() {
            super(null);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J,\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/access/DbCredentialManager$OneTime;", "Lcom/intellij/database/access/DbCredentialManager$Local;", "backend", "Lcom/intellij/database/access/DbCredentialManager;", "(Lcom/intellij/database/access/DbCredentialManager;)V", "getBackend", "()Lcom/intellij/database/access/DbCredentialManager;", "getPassword", "Lcom/intellij/credentialStore/OneTimeString;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "storage", "Lcom/intellij/database/dataSource/LocalDataSource$Storage;", "prefix", "", "setPassword", "", "password", "intellij.database.impl"})
    public static final class OneTime
    extends Local {
        @NotNull
        private final DbCredentialManager backend;

        @Override
        public void setPassword(@NotNull LocalDataSource dataSource2, @Nullable OneTimeString password, @NotNull LocalDataSource.Storage storage, @Nullable String prefix) {
            Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
            Intrinsics.checkNotNullParameter((Object)((Object)storage), (String)"storage");
            if (storage.isOneTime()) {
                super.setPassword(dataSource2, password, LocalDataSource.Storage.MEMORY, prefix);
            }
            this.backend.setPassword(dataSource2, password, storage, prefix);
        }

        @Override
        @Nullable
        public OneTimeString getPassword(@NotNull LocalDataSource dataSource2, @NotNull LocalDataSource.Storage storage, @Nullable String prefix) {
            Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
            Intrinsics.checkNotNullParameter((Object)((Object)storage), (String)"storage");
            OneTimeString oneTimeString = super.getPassword(dataSource2, LocalDataSource.Storage.MEMORY, prefix);
            if (oneTimeString == null) {
                oneTimeString = this.backend.getPassword(dataSource2, storage, prefix);
            }
            return oneTimeString;
        }

        @NotNull
        public final DbCredentialManager getBackend() {
            return this.backend;
        }

        public OneTime(@NotNull DbCredentialManager backend) {
            Intrinsics.checkNotNullParameter((Object)backend, (String)"backend");
            this.backend = backend;
        }
    }
}

