/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.util;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.intellij.indexing.shared.download.SharedIndexCompression;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.PathKt;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001aJ\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00032\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"downloadUrlWithValidation", "", "url", "", "targetFile", "Ljava/nio/file/Path;", "expectedSize", "expectedSha256", "headers", "", "compression", "Lcom/intellij/indexing/shared/download/SharedIndexCompression;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.indexing.shared"})
public final class DownloadUtilKt {
    public static final long downloadUrlWithValidation(@NotNull String url, @NotNull Path targetFile, long expectedSize, @NotNull String expectedSha256, @NotNull Map<String, String> headers, @NotNull SharedIndexCompression compression, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        Intrinsics.checkNotNullParameter((Object)expectedSha256, (String)"expectedSha256");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)((Object)compression), (String)"compression");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        boolean bl = expectedSize > 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        indicator.setIndeterminate(false);
        indicator.setFraction(0.0);
        try {
            HttpRequests.request((String)url).productNameAsUserAgent().tuner(new HttpRequests.ConnectionTuner(headers){
                final /* synthetic */ Map $headers;

                /*
                 * WARNING - void declaration
                 */
                public final void tune(@NotNull URLConnection tuner) {
                    Intrinsics.checkNotNullParameter((Object)tuner, (String)"tuner");
                    Map $this$forEach$iv = this.$headers;
                    boolean $i$f$forEach = false;
                    Map map = $this$forEach$iv;
                    boolean bl = false;
                    Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        void k;
                        Map.Entry<K, V> element$iv;
                        Map.Entry<K, V> $dstr$k$v = element$iv = iterator.next();
                        boolean bl2 = false;
                        Map.Entry<K, V> entry = $dstr$k$v;
                        boolean bl3 = false;
                        String string2 = (String)entry.getKey();
                        entry = $dstr$k$v;
                        bl3 = false;
                        String v = (String)entry.getValue();
                        tuner.addRequestProperty((String)k, v);
                    }
                }
                {
                    this.$headers = map;
                }
            }).accept("application/octet-stream, application/xz").throwStatusCodeException(true).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<Unit>(targetFile, compression, indicator, expectedSize, expectedSha256){
                final /* synthetic */ Path $targetFile;
                final /* synthetic */ SharedIndexCompression $compression;
                final /* synthetic */ ProgressIndicator $indicator;
                final /* synthetic */ long $expectedSize;
                final /* synthetic */ String $expectedSha256;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void process(@NotNull HttpRequests.Request it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Path path = this.$targetFile.getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"targetFile.parent");
                    PathKt.createDirectories((Path)path);
                    InputStream countingStream2 = new InputStream(it){
                        @NotNull
                        private final BufferedInputStream networkStream;
                        private final Hasher hasher;
                        private long bytesRead;
                        final /* synthetic */ HttpRequests.Request $it;

                        @NotNull
                        public final BufferedInputStream getNetworkStream() {
                            return this.networkStream;
                        }

                        public final Hasher getHasher() {
                            return this.hasher;
                        }

                        public final long getBytesRead() {
                            return this.bytesRead;
                        }

                        public final void setBytesRead(long l) {
                            this.bytesRead = l;
                        }

                        public int read() {
                            byte[] tmp = new byte[1];
                            if (this.read(tmp, 0, 1) != 1) {
                                return -1;
                            }
                            return tmp[0] & 0xFF;
                        }

                        public int read(@NotNull byte[] b, int off, int len) {
                            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                            int sz = this.networkStream.read(b, off, len);
                            if (sz > 0) {
                                this.bytesRead += (long)sz;
                                this.hasher.putBytes(b, off, sz);
                            }
                            return sz;
                        }

                        public void close() {
                            this.networkStream.close();
                        }
                        {
                            this.$it = $captured_local_variable$0;
                            HttpRequests.Request request = $captured_local_variable$0;
                            Intrinsics.checkNotNullExpressionValue((Object)request, (String)"it");
                            InputStream inputStream = request.getInputStream();
                            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"it.inputStream");
                            InputStream inputStream2 = inputStream;
                            int n = 0x100000;
                            boolean bl = false;
                            this.networkStream = inputStream2 instanceof BufferedInputStream ? (BufferedInputStream)inputStream2 : new BufferedInputStream(inputStream2, n);
                            this.hasher = Hashing.sha256().newHasher();
                        }
                    };
                    Closeable closeable = this.$compression.createUnpackingStream(countingStream2);
                    boolean bl = false;
                    boolean bl2 = false;
                    Throwable throwable = null;
                    try {
                        InputStream input = (InputStream)closeable;
                        boolean bl3 = false;
                        Closeable closeable2 = PathKt.outputStream((Path)this.$targetFile);
                        int n = 0x100000;
                        boolean bl4 = false;
                        closeable2 = closeable2 instanceof BufferedOutputStream ? (BufferedOutputStream)closeable2 : new BufferedOutputStream((OutputStream)closeable2, n);
                        n = 0;
                        bl4 = false;
                        Throwable throwable2 = null;
                        try {
                            BufferedOutputStream output = (BufferedOutputStream)closeable2;
                            boolean bl5 = false;
                            byte[] buff = new byte[0x100000];
                            while (true) {
                                this.$indicator.checkCanceled();
                                int off = input.read(buff);
                                if (off < 0) break;
                                this.$indicator.checkCanceled();
                                if (off <= 0) continue;
                                output.write(buff, 0, off);
                                if (countingStream2.getBytesRead() > this.$expectedSize) {
                                    throw (Throwable)new RuntimeException("Connection is not closed at byte " + countingStream2.getBytesRead() + ". Expected " + this.$expectedSize + " bytes");
                                }
                                double d = 1.0;
                                double d2 = (double)countingStream2.getBytesRead() / (double)this.$expectedSize;
                                boolean bl6 = false;
                                this.$indicator.setFraction(Math.min(d, d2));
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    if (countingStream2.getBytesRead() < this.$expectedSize) {
                        throw (Throwable)new RuntimeException("Connection closed at byte " + countingStream2.getBytesRead() + ". Expected " + this.$expectedSize + " bytes");
                    }
                    String string2 = countingStream2.getHasher().hash().toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"countingStream.hasher.hash().toString()");
                    String actualHashCode = string2;
                    if (!StringsKt.equals((String)actualHashCode, (String)this.$expectedSha256, (boolean)true)) {
                        throw (Throwable)new RuntimeException("SHA-256 checksums does not match. Actual value is " + actualHashCode + ", expected " + this.$expectedSha256);
                    }
                }
                {
                    this.$targetFile = path;
                    this.$compression = sharedIndexCompression;
                    this.$indicator = progressIndicator;
                    this.$expectedSize = l;
                    this.$expectedSha256 = string2;
                }
            });
            return Files.size(targetFile);
        }
        catch (Throwable e) {
            FileUtil.delete((Path)targetFile);
            throw e;
        }
    }
}

