/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.indexing.shared.platform.api.MutableSharedIndexStorage;
import com.intellij.indexing.shared.platform.api.SharedIndexStorage;
import com.intellij.indexing.shared.platform.api.SharedIndexStorageProvider;
import com.intellij.indexing.shared.platform.impl.BundledSharedIndexesResolver;
import com.intellij.indexing.shared.platform.impl.SharedIndexChunkConfigurationImpl;
import com.intellij.indexing.shared.platform.impl.SharedIndexMainZipStorage;
import com.intellij.indexing.shared.platform.impl.SharedIndexZipCompositeStorage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.IOUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/indexing/shared/platform/impl/SharedIndexZipStorageProvider;", "Lcom/intellij/indexing/shared/platform/api/SharedIndexStorageProvider;", "Lcom/intellij/indexing/shared/platform/api/MutableSharedIndexStorage;", "()V", "MAIN_STORAGE_NAME", "", "MAIN_STORAGE_OLD_NAME", "tryOpenOrResetIfFailed", "corruptionHandler", "Ljava/lang/Runnable;", "intellij.indexing.shared"})
public final class SharedIndexZipStorageProvider
implements SharedIndexStorageProvider<MutableSharedIndexStorage> {
    private static final String MAIN_STORAGE_OLD_NAME = "chunks.zip";
    @NotNull
    public static final String MAIN_STORAGE_NAME = "shared-index.chunks";
    @NotNull
    public static final SharedIndexZipStorageProvider INSTANCE;

    @Override
    @NotNull
    public MutableSharedIndexStorage tryOpenOrResetIfFailed(@NotNull Runnable corruptionHandler) throws IOException {
        Intrinsics.checkNotNullParameter((Object)corruptionHandler, (String)"corruptionHandler");
        Path oldStoragePath = SharedIndexChunkConfigurationImpl.getSharedIndexConfigurationRoot().resolve(MAIN_STORAGE_OLD_NAME);
        Path newStoragePath = SharedIndexChunkConfigurationImpl.getSharedIndexConfigurationRoot().resolve(MAIN_STORAGE_NAME);
        SharedIndexMainZipStorage mutableStorage2 = (SharedIndexMainZipStorage)IOUtil.openCleanOrResetBroken((ThrowableComputable)((ThrowableComputable)new ThrowableComputable<SharedIndexMainZipStorage, IOException>(oldStoragePath, newStoragePath){
            final /* synthetic */ Path $oldStoragePath;
            final /* synthetic */ Path $newStoragePath;

            public final SharedIndexMainZipStorage compute() {
                Path path = this.$oldStoragePath;
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"oldStoragePath");
                Path path2 = this.$newStoragePath;
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"newStoragePath");
                return new SharedIndexMainZipStorage(path, path2, "shared index central storage");
            }
            {
                this.$oldStoragePath = path;
                this.$newStoragePath = path2;
            }
        }), (Runnable)new Runnable(corruptionHandler, oldStoragePath, newStoragePath){
            final /* synthetic */ Runnable $corruptionHandler;
            final /* synthetic */ Path $oldStoragePath;
            final /* synthetic */ Path $newStoragePath;

            public final void run() {
                this.$corruptionHandler.run();
                if (Files.exists(this.$oldStoragePath, new LinkOption[0])) {
                    FileUtil.delete((Path)this.$oldStoragePath);
                }
                if (Files.exists(this.$newStoragePath, new LinkOption[0])) {
                    FileUtil.delete((Path)this.$newStoragePath);
                }
            }
            {
                this.$corruptionHandler = runnable;
                this.$oldStoragePath = path;
                this.$newStoragePath = path2;
            }
        });
        boolean $i$f$service = false;
        Class<BundledSharedIndexesResolver> serviceClass$iv = BundledSharedIndexesResolver.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
        }
        List<SharedIndexStorage> bundledIndexes = ((BundledSharedIndexesResolver)object).openBundledStorages();
        if (bundledIndexes.isEmpty()) {
            SharedIndexMainZipStorage sharedIndexMainZipStorage = mutableStorage2;
            Intrinsics.checkNotNullExpressionValue((Object)sharedIndexMainZipStorage, (String)"mutableStorage");
            return sharedIndexMainZipStorage;
        }
        SharedIndexMainZipStorage sharedIndexMainZipStorage = mutableStorage2;
        Intrinsics.checkNotNullExpressionValue((Object)sharedIndexMainZipStorage, (String)"mutableStorage");
        return new SharedIndexZipCompositeStorage(sharedIndexMainZipStorage, bundledIndexes);
    }

    private SharedIndexZipStorageProvider() {
    }

    static {
        SharedIndexZipStorageProvider sharedIndexZipStorageProvider;
        INSTANCE = sharedIndexZipStorageProvider = new SharedIndexZipStorageProvider();
    }
}

