/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.indexing.shared.metadata.SharedIndexMetadata;
import com.intellij.indexing.shared.platform.api.ChunkDescriptor;
import com.intellij.indexing.shared.platform.api.IdeIndexInfrastructureVersion;
import com.intellij.indexing.shared.platform.impl.SharedIndexChunkConfiguration;
import com.intellij.indexing.shared.platform.impl.SharedIndexesFusCollector;
import com.intellij.indexing.shared.util.zipFs.UncompressedZipFileSystem;
import com.intellij.indexing.shared.util.zipFs.UncompressedZipFileSystemProvider;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.io.PathKt;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OnDiskSharedIndexChunkLocator
implements StartupActivity.DumbAware {
    private static final Logger LOG = Logger.getInstance(OnDiskSharedIndexChunkLocator.class);
    private static final String LOCAL_SHARED_INDEX_DIR = "shared-index";
    public static final String ROOT_PROP = "on.disk.shared.index.root";

    public void runActivity(@NotNull Project project) {
        if (project == null) {
            OnDiskSharedIndexChunkLocator.$$$reportNull$$$0(0);
        }
        OnDiskSharedIndexChunkLocator.scanAndAttachLocalSharedIndexes(project);
    }

    private static void scanAndAttachLocalSharedIndexes(@NotNull Project project) {
        if (project == null) {
            OnDiskSharedIndexChunkLocator.$$$reportNull$$$0(1);
        }
        Path root = OnDiskSharedIndexChunkLocator.getSharedIndexRoot();
        LOG.debug("Scanning " + root + " for manually prepared shared indexes...");
        for (Path ijxPath : OnDiskSharedIndexChunkLocator.listIndexFiles(root)) {
            ChunkDescriptor chunk = OnDiskSharedIndexChunkLocator.tryLoadCompatibleSharedIndex(ijxPath, IdeIndexInfrastructureVersion.getIdeVersion());
            if (chunk == null) continue;
            try {
                SharedIndexChunkConfiguration.getInstance().downloadChunk(chunk, project, (ProgressIndicator)new ProgressIndicatorBase());
            }
            catch (Throwable t) {
                if (t instanceof ControlFlowException) {
                    ExceptionUtil.rethrow((Throwable)t);
                }
                LOG.error("Failed to preload shared index: " + chunk + ". " + t.getMessage(), t);
            }
        }
    }

    /*
     * Loose catch block
     */
    @NotNull
    private static List<Path> listIndexFiles(@NotNull Path root) {
        if (root == null) {
            OnDiskSharedIndexChunkLocator.$$$reportNull$$$0(2);
        }
        if (Files.isRegularFile(root, new LinkOption[0])) {
            List<Path> list = Collections.singletonList(root);
            if (list == null) {
                OnDiskSharedIndexChunkLocator.$$$reportNull$$$0(3);
            }
            return list;
        }
        if (Files.isDirectory(root, new LinkOption[0])) {
            List<Path> list;
            Stream<Path> pathStream;
            block14: {
                pathStream = Files.walk(root, 1, new FileVisitOption[0]);
                list = pathStream.filter(f -> f.getFileName().toString().endsWith(".ijx")).collect(Collectors.toList());
                if (pathStream == null) break block14;
                pathStream.close();
            }
            List<Path> list2 = list;
            if (list2 == null) {
                OnDiskSharedIndexChunkLocator.$$$reportNull$$$0(4);
            }
            return list2;
            {
                catch (Throwable throwable) {
                    try {
                        if (pathStream != null) {
                            try {
                                pathStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        LOG.error("Failed to scan share index file home from " + root + ". " + e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        List<Path> list = Collections.emptyList();
        if (list == null) {
            OnDiskSharedIndexChunkLocator.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    private static Path getSharedIndexRoot() {
        String indexRoot = System.getProperty(ROOT_PROP, FileUtil.join((String[])new String[]{PathManager.getSystemPath(), LOCAL_SHARED_INDEX_DIR}));
        Path path = Paths.get(indexRoot, new String[0]);
        if (path == null) {
            OnDiskSharedIndexChunkLocator.$$$reportNull$$$0(6);
        }
        return path;
    }

    @Nullable
    private static ChunkDescriptor tryLoadCompatibleSharedIndex(@NotNull Path filePath, @NotNull IdeIndexInfrastructureVersion ideVersion) {
        SharedIndexMetadata version;
        if (filePath == null) {
            OnDiskSharedIndexChunkLocator.$$$reportNull$$$0(7);
        }
        if (ideVersion == null) {
            OnDiskSharedIndexChunkLocator.$$$reportNull$$$0(8);
        }
        if (!Files.isRegularFile(filePath, new LinkOption[0])) {
            return null;
        }
        LOG.info("Checking local shared index " + filePath);
        try {
            version = Objects.requireNonNull(OnDiskSharedIndexChunkLocator.getVersion(filePath), "Shared index " + filePath + " contains incompatible metadata");
        }
        catch (Throwable e) {
            LOG.error("Can't fetch shared index version for " + filePath + ". " + e.getMessage(), e);
            return null;
        }
        if (!version.getSharedIndexInfo().getBases().isEmpty()) {
            LOG.warn("The shared index refers to bases versions which are not supported for " + filePath);
            return null;
        }
        String fileSize = "(no file size)";
        try {
            fileSize = StringUtil.formatFileSize((long)Files.size(filePath));
        }
        catch (Exception e) {
            LOG.warn("Can't get size of shared index file " + filePath + ". " + e.getMessage(), (Throwable)e);
        }
        if (!ideVersion.isSuitableVersion(version.getIndexInfrastructureVersion())) {
            LOG.warn("Local shared index " + filePath + " is incompatible with current IDE version:\n IDE Version: " + ideVersion + "\nIndex Version: " + version);
            return null;
        }
        LOG.warn("Detected local shared index " + filePath + ", size " + fileSize + ", IDE Version " + ideVersion + ", Index Version " + version);
        return new MyChunkDescriptor(filePath, version);
    }

    @Nullable
    private static SharedIndexMetadata getVersion(@NotNull Path indexZip) throws IOException {
        if (indexZip == null) {
            OnDiskSharedIndexChunkLocator.$$$reportNull$$$0(9);
        }
        try (UncompressedZipFileSystem fs = UncompressedZipFileSystemProvider.INSTANCE.newFileSystem(indexZip);){
            SharedIndexMetadata sharedIndexMetadata = SharedIndexMetadata.readIndexesVersion(fs.getRootDirectory());
            return sharedIndexMetadata;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/indexing/shared/platform/impl/OnDiskSharedIndexChunkLocator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideVersion";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexZip";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/indexing/shared/platform/impl/OnDiskSharedIndexChunkLocator";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "listIndexFiles";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSharedIndexRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runActivity";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "scanAndAttachLocalSharedIndexes";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "listIndexFiles";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadCompatibleSharedIndex";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getVersion";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyChunkDescriptor
    implements ChunkDescriptor {
        private final Path myIndexZip;
        @NotNull
        private final SharedIndexMetadata myVersion;

        private MyChunkDescriptor(@NotNull Path indexZip, @NotNull SharedIndexMetadata version) {
            if (indexZip == null) {
                MyChunkDescriptor.$$$reportNull$$$0(0);
            }
            if (version == null) {
                MyChunkDescriptor.$$$reportNull$$$0(1);
            }
            this.myIndexZip = indexZip;
            this.myVersion = version;
        }

        @Override
        @NotNull
        public String getChunkUniqueId() {
            String string2 = "local-" + this.myIndexZip.getFileName().toString();
            if (string2 == null) {
                MyChunkDescriptor.$$$reportNull$$$0(2);
            }
            return string2;
        }

        @Override
        @NotNull
        public String getKind() {
            String string2 = this.myVersion.getIndexKind();
            if (string2 == null) {
                MyChunkDescriptor.$$$reportNull$$$0(3);
            }
            return string2;
        }

        @Override
        public boolean downloadChunk(@NotNull Path targetFile, @Nullable Project project, @NotNull ProgressIndicator indicator) {
            if (targetFile == null) {
                MyChunkDescriptor.$$$reportNull$$$0(4);
            }
            if (indicator == null) {
                MyChunkDescriptor.$$$reportNull$$$0(5);
            }
            indicator.setText(SharedIndexesBundle.message("configuring.shared.indexes", new Object[0]));
            indicator.setIndeterminate(true);
            LOG.warn("Shared Index " + this.myIndexZip + " is requested by the IDE");
            try {
                PathKt.copy((Path)this.myIndexZip, (Path)targetFile);
                long size = Files.size(targetFile);
                SharedIndexesFusCollector.INSTANCE.reportLocalIndexLoaded(project, "project", this.getChunkUniqueId(), size);
                return true;
            }
            catch (Throwable t) {
                if (t instanceof ControlFlowException) {
                    ExceptionUtil.rethrow((Throwable)t);
                }
                LOG.warn("Failed to copy shared index from " + this.myIndexZip + " to " + targetFile);
                return false;
            }
        }

        public String toString() {
            return "Shared Index (" + this.myVersion + ") from " + this.myIndexZip;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indexZip";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/indexing/shared/platform/impl/OnDiskSharedIndexChunkLocator$MyChunkDescriptor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetFile";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/indexing/shared/platform/impl/OnDiskSharedIndexChunkLocator$MyChunkDescriptor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChunkUniqueId";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "downloadChunk";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

