/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.indexing.shared.platform.api.AttachChunkResult;
import com.intellij.indexing.shared.platform.impl.ChunkManagerKt;
import com.intellij.indexing.shared.platform.impl.FileContentHashIndexExtension;
import com.intellij.indexing.shared.platform.impl.SharedIndexChunk;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.indexing.IndexedFile;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00142\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\n\u001a\u00020\u0005J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cR*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/indexing/shared/platform/impl/ChunkManager;", "", "()V", "myChunkEnumerators", "Ljava/util/HashMap;", "", "Lcom/intellij/indexing/shared/platform/impl/SharedIndexChunk;", "Lkotlin/collections/HashMap;", "attachChunk", "", "chunkId", "chunkRootPath", "Ljava/nio/file/Path;", "indexAttachChunkResult", "Lcom/intellij/indexing/shared/platform/api/AttachChunkResult;", "attachProjectToChunk", "project", "Lcom/intellij/openapi/project/Project;", "disposeChunks", "", "", "getIndexAttachResult", "getOpenChunkIds", "isProjectAttachedToChunk", "", "tryEnumerateContentHash", "", "fileContent", "Lcom/intellij/util/indexing/IndexedFile;", "intellij.indexing.shared"})
public final class ChunkManager {
    private final HashMap<Integer, SharedIndexChunk> myChunkEnumerators;

    /*
     * WARNING - void declaration
     */
    public final long tryEnumerateContentHash(@NotNull IndexedFile fileContent) throws IOException {
        Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
        Map map = this.myChunkEnumerators;
        boolean bl = false;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            void chunkId;
            int internalHashId;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            boolean bl2 = false;
            int n = ((Number)entry2.getKey()).intValue();
            entry2 = entry;
            bl2 = false;
            SharedIndexChunk chunk = (SharedIndexChunk)entry2.getValue();
            if (!chunk.getAttachedProjects().contains(fileContent.getProject()) || (internalHashId = chunk.tryEnumerate(fileContent)) == 0) continue;
            return FileContentHashIndexExtension.getHashId(internalHashId, (int)chunkId);
        }
        return FileContentHashIndexExtension.NULL_HASH_ID;
    }

    @NotNull
    public final Set<Integer> getOpenChunkIds() {
        Set<Integer> set = this.myChunkEnumerators.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"myChunkEnumerators.keys");
        return set;
    }

    public final void attachChunk(int chunkId, @NotNull Path chunkRootPath, @NotNull AttachChunkResult indexAttachChunkResult) {
        Intrinsics.checkNotNullParameter((Object)chunkRootPath, (String)"chunkRootPath");
        Intrinsics.checkNotNullParameter((Object)indexAttachChunkResult, (String)"indexAttachChunkResult");
        ((Map)this.myChunkEnumerators).put(chunkId, new SharedIndexChunk(chunkRootPath, indexAttachChunkResult));
    }

    public final void attachProjectToChunk(int chunkId, @NotNull Project project) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            SharedIndexChunk sharedIndexChunk = this.myChunkEnumerators.get(chunkId);
            if (sharedIndexChunk == null) break block0;
            sharedIndexChunk.attachProject(project);
        }
    }

    @Nullable
    public final AttachChunkResult getIndexAttachResult(int chunkId) {
        SharedIndexChunk sharedIndexChunk = this.myChunkEnumerators.get(chunkId);
        return sharedIndexChunk != null ? sharedIndexChunk.getIndexAttachChunkResult() : null;
    }

    public final boolean isProjectAttachedToChunk(int chunkId, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = this.myChunkEnumerators.get(chunkId);
        return object != null && (object = ((SharedIndexChunk)object).getAttachedProjects()) != null ? ((HashSet)object).contains(project) : false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Integer> disposeChunks(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        boolean bl = false;
        ArrayList closedChunkIds = new ArrayList();
        Map map = this.myChunkEnumerators;
        boolean bl2 = false;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            void chunkId;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            boolean bl3 = false;
            int n = ((Number)entry2.getKey()).intValue();
            entry2 = entry;
            bl3 = false;
            SharedIndexChunk enumerator = (SharedIndexChunk)entry2.getValue();
            enumerator.detachProject(project);
            if (!enumerator.getAttachedProjects().isEmpty()) continue;
            try {
                Disposer.dispose((Disposable)enumerator);
            }
            catch (Exception e) {
                ChunkManagerKt.access$getLOG$p().info((Throwable)e);
            }
            Collection e = closedChunkIds;
            Integer n2 = (int)chunkId;
            boolean bl4 = false;
            e.add(n2);
        }
        Iterable $this$forEach$iv = closedChunkIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it = ((Number)element$iv).intValue();
            boolean bl5 = false;
            this.myChunkEnumerators.remove(it);
        }
        return closedChunkIds;
    }

    @NotNull
    public final Set<Integer> disposeChunks() {
        for (SharedIndexChunk enumerator : this.myChunkEnumerators.values()) {
            try {
                Disposer.dispose((Disposable)enumerator);
            }
            catch (Exception e) {
                ChunkManagerKt.access$getLOG$p().info((Throwable)e);
            }
        }
        Set<Integer> set = this.myChunkEnumerators.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"myChunkEnumerators.keys");
        HashSet chunkIds = CollectionsKt.toHashSet((Iterable)set);
        this.myChunkEnumerators.clear();
        return chunkIds;
    }

    public ChunkManager() {
        boolean bl = false;
        this.myChunkEnumerators = new HashMap();
    }
}

