/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.hash;

import com.intellij.util.hash.ContentHashEnumerator;
import java.io.IOException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentEnumerators;", "", "()V", "hashFileName", "", "getHashEnumeratorPath", "Ljava/nio/file/Path;", "chunkRootPath", "isRelatedToEnumerator", "", "path", "newEnumeratorForGenerator", "Lcom/intellij/util/hash/ContentHashEnumerator;", "openEnumeratorForAttachedSharedIndex", "intellij.indexing.shared"})
public final class SharedIndexContentEnumerators {
    private static final String hashFileName = "hashes";
    @NotNull
    public static final SharedIndexContentEnumerators INSTANCE;

    public final boolean isRelatedToEnumerator(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return StringsKt.startsWith$default((String)path, (String)hashFileName, (boolean)false, (int)2, null);
    }

    @NotNull
    public final Path getHashEnumeratorPath(@NotNull Path chunkRootPath) {
        Intrinsics.checkNotNullParameter((Object)chunkRootPath, (String)"chunkRootPath");
        Path path = chunkRootPath.resolve(hashFileName);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"chunkRootPath.resolve(hashFileName)");
        return path;
    }

    @NotNull
    public final ContentHashEnumerator openEnumeratorForAttachedSharedIndex(@NotNull Path chunkRootPath) {
        Intrinsics.checkNotNullParameter((Object)chunkRootPath, (String)"chunkRootPath");
        return new ContentHashEnumerator(this, chunkRootPath, this.getHashEnumeratorPath(chunkRootPath)){
            private volatile boolean corrupted;
            final /* synthetic */ SharedIndexContentEnumerators this$0;
            final /* synthetic */ Path $chunkRootPath;

            protected void markCorrupted() {
                this.corrupted = true;
            }

            public boolean isCorrupted() {
                return this.corrupted;
            }

            public int enumerate(@Nullable byte[] value) {
                throw (Throwable)new UnsupportedOperationException("Enumerator is read-only");
            }

            public int tryEnumerate(@Nullable byte[] value) {
                try {
                    return super.tryEnumerate((Object)value);
                }
                catch (IOException e) {
                    if (this.isCorrupted()) {
                        return 0;
                    }
                    throw (Throwable)e;
                }
            }
            {
                this.this$0 = this$0;
                this.$chunkRootPath = $captured_local_variable$1;
                super($super_call_param$2);
            }
        };
    }

    @NotNull
    public final ContentHashEnumerator newEnumeratorForGenerator(@NotNull Path chunkRootPath) {
        Intrinsics.checkNotNullParameter((Object)chunkRootPath, (String)"chunkRootPath");
        return new ContentHashEnumerator(this.getHashEnumeratorPath(chunkRootPath));
    }

    private SharedIndexContentEnumerators() {
    }

    static {
        SharedIndexContentEnumerators sharedIndexContentEnumerators;
        INSTANCE = sharedIndexContentEnumerators = new SharedIndexContentEnumerators();
    }
}

