/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.api;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.intellij.indexing.shared.platform.api.IndexInfrastructureCapability;
import com.intellij.indexing.shared.platform.api.IndexInfrastructureFileBasedIndexVersionInfo;
import com.intellij.indexing.shared.platform.api.IndexInfrastructureOs;
import com.intellij.openapi.util.text.StringUtil;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.jetbrains.annotations.NotNull;

public final class IndexInfrastructureVersion {
    public static final String SHARED_INDEXES_VERSIONS_FORMAT_VERSION = String.valueOf(6);
    private final SortedMap<String, String> myBaseIndexes;
    private final SortedMap<String, IndexInfrastructureFileBasedIndexVersionInfo> myFileBasedIndexVersions;
    private final SortedMap<String, String> myStubIndexVersions;
    private final SortedMap<String, String> myStubFileElementTypeVersions;
    private final SortedMap<IndexInfrastructureCapability, Map<String, String>> myCapabilities;
    private final SortedSet<IndexInfrastructureOs> mySupportedOs;
    private final SortedMap<String, String> myHashProviderVersions;

    public IndexInfrastructureVersion(@NotNull Map<IndexInfrastructureCapability, Map<String, String>> capabilities, @NotNull Set<IndexInfrastructureOs> supportedOs, @NotNull Map<String, String> baseIndexes, @NotNull Map<String, IndexInfrastructureFileBasedIndexVersionInfo> fileBasedIndexVersions, @NotNull Map<String, String> stubIndexVersions, @NotNull Map<String, String> stubFileElementTypeVersions, @NotNull Map<String, String> hashProviderVersions) {
        if (capabilities == null) {
            IndexInfrastructureVersion.$$$reportNull$$$0(0);
        }
        if (supportedOs == null) {
            IndexInfrastructureVersion.$$$reportNull$$$0(1);
        }
        if (baseIndexes == null) {
            IndexInfrastructureVersion.$$$reportNull$$$0(2);
        }
        if (fileBasedIndexVersions == null) {
            IndexInfrastructureVersion.$$$reportNull$$$0(3);
        }
        if (stubIndexVersions == null) {
            IndexInfrastructureVersion.$$$reportNull$$$0(4);
        }
        if (stubFileElementTypeVersions == null) {
            IndexInfrastructureVersion.$$$reportNull$$$0(5);
        }
        if (hashProviderVersions == null) {
            IndexInfrastructureVersion.$$$reportNull$$$0(6);
        }
        this.myBaseIndexes = ImmutableSortedMap.copyOf(baseIndexes);
        this.myFileBasedIndexVersions = ImmutableSortedMap.copyOf(fileBasedIndexVersions);
        this.myStubIndexVersions = ImmutableSortedMap.copyOf(stubIndexVersions);
        this.myStubFileElementTypeVersions = ImmutableSortedMap.copyOf(stubFileElementTypeVersions);
        this.mySupportedOs = ImmutableSortedSet.copyOf(supportedOs);
        this.myHashProviderVersions = ImmutableSortedMap.copyOf(hashProviderVersions);
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (Map.Entry<IndexInfrastructureCapability, Map<String, String>> entry : capabilities.entrySet()) {
            builder.put((Object)entry.getKey(), (Object)ImmutableSortedMap.copyOf(entry.getValue()));
        }
        this.myCapabilities = builder.build();
    }

    public String toString() {
        return "IndexInfrastructureVersion{base=" + this.myBaseIndexes + ", capabilities=" + this.myCapabilities + ", fileIndex=" + this.myFileBasedIndexVersions + ", stubIndex=" + this.myStubIndexVersions + ", stubFilesElementTypeVersions=" + this.myStubFileElementTypeVersions + ", supportedOs=" + this.mySupportedOs + "}";
    }

    @NotNull
    public String getWeakVersionHash() {
        return IndexInfrastructureVersion.computeWeakHash(Arrays.asList(this.getBaseIndexes(), this.getFileBasedIndexVersions(), this.getStubIndexVersions(), this.getStubFileElementTypeVersions()));
    }

    @NotNull
    public String getWeakBaseVersionHash() {
        return IndexInfrastructureVersion.computeWeakHash(Collections.singletonList(this.myBaseIndexes));
    }

    @NotNull
    private static String computeWeakHash(@NotNull List<Map<String, String>> maps) {
        if (maps == null) {
            IndexInfrastructureVersion.$$$reportNull$$$0(7);
        }
        Hasher hasher = Hashing.sha256().newHasher();
        for (Map<String, String> versions : maps) {
            for (Map.Entry entry : ImmutableMap.copyOf(versions).entrySet()) {
                hasher.putString((CharSequence)entry.getKey(), StandardCharsets.UTF_8);
                hasher.putString((CharSequence)entry.getValue(), StandardCharsets.UTF_8);
            }
        }
        String string2 = StringUtil.first((String)hasher.hash().toString(), (int)12, (boolean)false);
        if (string2 == null) {
            IndexInfrastructureVersion.$$$reportNull$$$0(8);
        }
        return string2;
    }

    @NotNull
    public Map<String, String> getBaseIndexes() {
        SortedMap<String, String> sortedMap = this.myBaseIndexes;
        if (sortedMap == null) {
            IndexInfrastructureVersion.$$$reportNull$$$0(9);
        }
        return sortedMap;
    }

    @NotNull
    public Map<String, String> getFileBasedIndexVersions() {
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (Map.Entry<String, IndexInfrastructureFileBasedIndexVersionInfo> e : this.myFileBasedIndexVersions.entrySet()) {
            builder.put((Object)e.getKey(), (Object)e.getValue().getVersion());
        }
        ImmutableSortedMap immutableSortedMap = builder.build();
        if (immutableSortedMap == null) {
            IndexInfrastructureVersion.$$$reportNull$$$0(10);
        }
        return immutableSortedMap;
    }

    @NotNull
    public Map<String, Boolean> getFileBasedIndexThatNeedsForwardIndex() {
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (Map.Entry<String, IndexInfrastructureFileBasedIndexVersionInfo> e : this.myFileBasedIndexVersions.entrySet()) {
            builder.put((Object)e.getKey(), (Object)e.getValue().getNeedsForwardIndex());
        }
        ImmutableSortedMap immutableSortedMap = builder.build();
        if (immutableSortedMap == null) {
            IndexInfrastructureVersion.$$$reportNull$$$0(11);
        }
        return immutableSortedMap;
    }

    @NotNull
    public Map<String, IndexInfrastructureFileBasedIndexVersionInfo> getFileBasedIndexVersionInfos() {
        SortedMap<String, IndexInfrastructureFileBasedIndexVersionInfo> sortedMap = this.myFileBasedIndexVersions;
        if (sortedMap == null) {
            IndexInfrastructureVersion.$$$reportNull$$$0(12);
        }
        return sortedMap;
    }

    @NotNull
    public Map<String, String> getStubIndexVersions() {
        SortedMap<String, String> sortedMap = this.myStubIndexVersions;
        if (sortedMap == null) {
            IndexInfrastructureVersion.$$$reportNull$$$0(13);
        }
        return sortedMap;
    }

    @NotNull
    public Map<String, String> getStubFileElementTypeVersions() {
        SortedMap<String, String> sortedMap = this.myStubFileElementTypeVersions;
        if (sortedMap == null) {
            IndexInfrastructureVersion.$$$reportNull$$$0(14);
        }
        return sortedMap;
    }

    @NotNull
    public Map<IndexInfrastructureCapability, Map<String, String>> getCapabilities() {
        SortedMap<IndexInfrastructureCapability, Map<String, String>> sortedMap = this.myCapabilities;
        if (sortedMap == null) {
            IndexInfrastructureVersion.$$$reportNull$$$0(15);
        }
        return sortedMap;
    }

    @NotNull
    public Set<IndexInfrastructureOs> getSupportedOs() {
        SortedSet<IndexInfrastructureOs> sortedSet = this.mySupportedOs;
        if (sortedSet == null) {
            IndexInfrastructureVersion.$$$reportNull$$$0(16);
        }
        return sortedSet;
    }

    @NotNull
    public Map<String, String> getHashProviderVersions() {
        SortedMap<String, String> sortedMap = this.myHashProviderVersions;
        if (sortedMap == null) {
            IndexInfrastructureVersion.$$$reportNull$$$0(17);
        }
        return sortedMap;
    }

    @NotNull
    public IndexInfrastructureVersion withCapability(@NotNull IndexInfrastructureCapability capability, @NotNull Map<String, String> versions) {
        if (capability == null) {
            IndexInfrastructureVersion.$$$reportNull$$$0(18);
        }
        if (versions == null) {
            IndexInfrastructureVersion.$$$reportNull$$$0(19);
        }
        ImmutableSortedMap caps = ImmutableSortedMap.naturalOrder().putAll(this.myCapabilities).put((Object)capability, (Object)ImmutableSortedMap.copyOf(versions)).build();
        return new IndexInfrastructureVersion((Map<IndexInfrastructureCapability, Map<String, String>>)caps, this.mySupportedOs, this.myBaseIndexes, this.myFileBasedIndexVersions, this.myStubIndexVersions, this.myStubFileElementTypeVersions, this.myHashProviderVersions);
    }

    @NotNull
    public IndexInfrastructureVersion withStubFileElementTypes(@NotNull Map<String, String> versions) {
        if (versions == null) {
            IndexInfrastructureVersion.$$$reportNull$$$0(20);
        }
        return new IndexInfrastructureVersion(this.myCapabilities, this.mySupportedOs, this.myBaseIndexes, this.myFileBasedIndexVersions, this.myStubIndexVersions, versions, this.myHashProviderVersions);
    }

    @NotNull
    public IndexInfrastructureVersion withHashProviderVersions(@NotNull Map<String, String> hashProviderVersions) {
        if (hashProviderVersions == null) {
            IndexInfrastructureVersion.$$$reportNull$$$0(21);
        }
        return new IndexInfrastructureVersion(this.myCapabilities, this.mySupportedOs, this.myBaseIndexes, this.myFileBasedIndexVersions, this.myStubIndexVersions, this.myStubFileElementTypeVersions, hashProviderVersions);
    }

    @NotNull
    public IndexInfrastructureVersion withSupportedOs(@NotNull Collection<IndexInfrastructureOs> osToAdd) {
        if (osToAdd == null) {
            IndexInfrastructureVersion.$$$reportNull$$$0(22);
        }
        ImmutableSet newSupportedOs = ImmutableSet.builder().addAll(this.mySupportedOs).addAll(osToAdd).build();
        return new IndexInfrastructureVersion(this.myCapabilities, (Set<IndexInfrastructureOs>)newSupportedOs, this.myBaseIndexes, this.myFileBasedIndexVersions, this.myStubIndexVersions, this.myStubFileElementTypeVersions, this.myHashProviderVersions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexInfrastructureVersion version = (IndexInfrastructureVersion)o;
        return this.myBaseIndexes.equals(version.myBaseIndexes) && this.myFileBasedIndexVersions.equals(version.myFileBasedIndexVersions) && this.myStubIndexVersions.equals(version.myStubIndexVersions) && this.myStubFileElementTypeVersions.equals(version.myStubFileElementTypeVersions) && this.myCapabilities.equals(version.myCapabilities) && this.mySupportedOs.equals(version.mySupportedOs);
    }

    public int hashCode() {
        return Objects.hash(this.myBaseIndexes, this.myFileBasedIndexVersions, this.myStubIndexVersions, this.myCapabilities, this.mySupportedOs, this.myStubFileElementTypeVersions);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "capabilities";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedOs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseIndexes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileBasedIndexVersions";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubIndexVersions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubFileElementTypeVersions";
                break;
            }
            case 6: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashProviderVersions";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maps";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/indexing/shared/platform/api/IndexInfrastructureVersion";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "capability";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versions";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "osToAdd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/indexing/shared/platform/api/IndexInfrastructureVersion";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "computeWeakHash";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseIndexes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileBasedIndexVersions";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileBasedIndexThatNeedsForwardIndex";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileBasedIndexVersionInfos";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubIndexVersions";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubFileElementTypeVersions";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getCapabilities";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedOs";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getHashProviderVersions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "computeWeakHash";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "withCapability";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "withStubFileElementTypes";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "withHashProviderVersions";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "withSupportedOs";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

