/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.api;

import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.intellij.indexing.shared.platform.api.IndexInfrastructureCapability;
import com.intellij.indexing.shared.platform.api.IndexInfrastructureFileBasedIndexVersionInfo;
import com.intellij.indexing.shared.platform.api.IndexInfrastructureOs;
import com.intellij.indexing.shared.platform.api.IndexInfrastructureVersion;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHash;
import com.intellij.indexing.shared.platform.hash.SharedIndexHashProviders;
import com.intellij.indexing.shared.platform.impl.SharedIndexExtension;
import com.intellij.indexing.shared.platform.impl.StubSharedIndexExtension;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.psi.stubs.StubIndexExtension;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.hash.ContentHashEnumerator;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.IndexedHashesSupport;
import com.intellij.util.io.PersistentEnumerator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class IdeIndexesState {
    private static final Logger LOG = Logger.getInstance(IdeIndexesState.class);
    public final List<FileBasedIndexExtension<?, ?>> exportableFileBasedIndexExtensions;
    public final List<StubIndexExtension<?, ?>> exportableStubIndexExtensions;
    private final AtomicBoolean myIsFrozen = new AtomicBoolean(false);
    private IndexInfrastructureVersion myIndexVersion;

    public IdeIndexesState() {
        this.exportableFileBasedIndexExtensions = FileBasedIndexExtension.EXTENSION_POINT_NAME.extensions().filter(FileBasedIndexExtension::dependsOnFileContent).filter(FileBasedIndexExtension::canBeShared).filter(ex -> !(ex instanceof StubUpdatingIndex)).collect(Collectors.toList());
        this.exportableStubIndexExtensions = StubIndexExtension.EP_NAME.getExtensionList();
        ImmutableSortedMap.Builder global = ImmutableSortedMap.naturalOrder();
        global.put((Object)"shared_indexes_format", (Object)IndexInfrastructureVersion.SHARED_INDEXES_VERSIONS_FORMAT_VERSION);
        global.put((Object)"vfs_version", (Object)String.valueOf(FSRecords.getVersion()));
        global.put((Object)"persistent_enumerator_version", (Object)String.valueOf(PersistentEnumerator.getVersion()));
        global.put((Object)"use_btree", (Object)String.valueOf(true));
        global.put((Object)"hashes_enumerator_version", (Object)String.valueOf(ContentHashEnumerator.getVersion()));
        global.put((Object)"hashes_algorithm_version", (Object)String.valueOf(IndexedHashesSupport.getVersion()));
        global.put((Object)"inverted_index_version", (Object)String.valueOf(0));
        global.put((Object)"product_version", (Object)IdeIndexesState.getProductVersion());
        List<SharedIndexContentHash> allHashProviders = SharedIndexHashProviders.getSharedIndexHashingProvidersForMetadata();
        this.myIndexVersion = new IndexInfrastructureVersion(Collections.emptyMap(), (Set<IndexInfrastructureOs>)ImmutableSortedSet.of((Comparable)IndexInfrastructureOs.getOs()), (Map<String, String>)global.build(), IdeIndexesState.filedBasedIndexVersions(this.exportableFileBasedIndexExtensions), IdeIndexesState.stubIndexVersions(this.exportableStubIndexExtensions), IdeIndexesState.stubFileElementTypeVersions(IdeIndexesState.getAllStubFileElementTypes()), IdeIndexesState.hashProviderVersions(allHashProviders));
    }

    public void addSupportedOs(@NotNull Collection<IndexInfrastructureOs> osToAdd) {
        if (osToAdd == null) {
            IdeIndexesState.$$$reportNull$$$0(0);
        }
        this.assertIsNotFrozen();
        this.myIndexVersion = this.myIndexVersion.withSupportedOs(osToAdd);
    }

    public void registerCapability(@NotNull IndexInfrastructureCapability capability, @NotNull Map<String, String> versions) {
        if (capability == null) {
            IdeIndexesState.$$$reportNull$$$0(1);
        }
        if (versions == null) {
            IdeIndexesState.$$$reportNull$$$0(2);
        }
        this.assertIsNotFrozen();
        this.myIndexVersion = this.myIndexVersion.withCapability(capability, versions);
    }

    public void withStubFileTypeElements(@NotNull Set<IFileElementType> fileElementTypes) {
        if (fileElementTypes == null) {
            IdeIndexesState.$$$reportNull$$$0(3);
        }
        this.assertIsNotFrozen();
        this.myIndexVersion = this.myIndexVersion.withStubFileElementTypes(IdeIndexesState.stubFileElementTypeVersions(fileElementTypes));
    }

    public void withActualHashGeneratorVersions(@NotNull Collection<SharedIndexContentHash> providers) {
        if (providers == null) {
            IdeIndexesState.$$$reportNull$$$0(4);
        }
        this.assertIsNotFrozen();
        this.myIndexVersion = this.myIndexVersion.withHashProviderVersions(IdeIndexesState.hashProviderVersions(providers));
    }

    @NotNull
    public IndexInfrastructureVersion getIndexVersion() {
        this.myIsFrozen.set(true);
        IndexInfrastructureVersion indexInfrastructureVersion = this.myIndexVersion;
        if (indexInfrastructureVersion == null) {
            IdeIndexesState.$$$reportNull$$$0(5);
        }
        return indexInfrastructureVersion;
    }

    @NotNull
    private static String getProductVersion() {
        ApplicationInfo info = ApplicationInfo.getInstance();
        String string2 = info.getMajorVersion() + "." + info.getMinorVersionMainPart();
        if (string2 == null) {
            IdeIndexesState.$$$reportNull$$$0(6);
        }
        return string2;
    }

    @NotNull
    private static Map<String, IndexInfrastructureFileBasedIndexVersionInfo> filedBasedIndexVersions(@NotNull List<FileBasedIndexExtension<?, ?>> fileBasedIndexExtensions) {
        if (fileBasedIndexExtensions == null) {
            IdeIndexesState.$$$reportNull$$$0(7);
        }
        HashMap<String, IndexInfrastructureFileBasedIndexVersionInfo> builder = new HashMap<String, IndexInfrastructureFileBasedIndexVersionInfo>();
        for (FileBasedIndexExtension<?, ?> fileBasedIndexExtension : fileBasedIndexExtensions) {
            IndexInfrastructureFileBasedIndexVersionInfo newValue;
            SharedIndexExtension<?, ?> sharedIndexExtension = SharedIndexExtension.findExtension(fileBasedIndexExtension);
            String name = fileBasedIndexExtension.getName().getName();
            IndexInfrastructureFileBasedIndexVersionInfo oldValue = builder.put(name, newValue = new IndexInfrastructureFileBasedIndexVersionInfo(fileBasedIndexExtension.getVersion() + ":" + sharedIndexExtension.getVersion(), fileBasedIndexExtension.needsForwardIndexWhenSharing()));
            if (oldValue == null || oldValue.equals(newValue)) continue;
            LOG.warn("Multiple declarations of the same file based index: " + name + ", old value " + oldValue + ", new value: " + newValue);
        }
        HashMap<String, IndexInfrastructureFileBasedIndexVersionInfo> hashMap = builder;
        if (hashMap == null) {
            IdeIndexesState.$$$reportNull$$$0(8);
        }
        return hashMap;
    }

    @NotNull
    private static Map<String, String> stubIndexVersions(@NotNull List<StubIndexExtension<?, ?>> stubIndexExtensions) {
        if (stubIndexExtensions == null) {
            IdeIndexesState.$$$reportNull$$$0(9);
        }
        HashMap<String, String> builder = new HashMap<String, String>();
        FileBasedIndexExtension stubUpdatingIndex = (FileBasedIndexExtension)FileBasedIndexExtension.EXTENSION_POINT_NAME.findFirstSafe(ex -> ex.getName().equals((Object)StubUpdatingIndex.INDEX_ID));
        if (stubUpdatingIndex == null) {
            throw new RuntimeException("Failed to find " + StubUpdatingIndex.INDEX_ID);
        }
        String commonPrefix = stubUpdatingIndex.getVersion() + ":";
        for (StubIndexExtension<?, ?> ex2 : stubIndexExtensions) {
            String newValue;
            String name = ex2.getKey().getName();
            String oldValue = builder.put(name, newValue = commonPrefix + ex2.getVersion());
            if (oldValue == null || oldValue.equals(newValue)) continue;
            LOG.warn("Multiple declarations of the same stub based index: " + name + ", old value " + oldValue + ", new value: " + newValue);
        }
        HashMap<String, String> hashMap = builder;
        if (hashMap == null) {
            IdeIndexesState.$$$reportNull$$$0(10);
        }
        return hashMap;
    }

    @NotNull
    private static Map<String, String> hashProviderVersions(@NotNull Collection<SharedIndexContentHash> providers) {
        if (providers == null) {
            IdeIndexesState.$$$reportNull$$$0(11);
        }
        HashMap<String, String> builder = new HashMap<String, String>();
        for (SharedIndexContentHash provider : providers) {
            String newValue;
            String name = provider.getProviderId();
            String oldValue = builder.put(name, newValue = provider.getVersion());
            if (oldValue == null || oldValue.equals(newValue)) continue;
            LOG.warn("Multiple declarations of the same stub based index: " + name + ", old value " + oldValue + ", new value: " + newValue);
        }
        HashMap<String, String> hashMap = builder;
        if (hashMap == null) {
            IdeIndexesState.$$$reportNull$$$0(12);
        }
        return hashMap;
    }

    @NotNull
    private static Collection<IFileElementType> getAllStubFileElementTypes() {
        Collection collection = Arrays.stream(FileTypeManager.getInstance().getRegisteredFileTypes()).filter(type -> type instanceof LanguageFileType).map(type -> ((LanguageFileType)type).getLanguage()).map(arg_0 -> ((LanguageParserDefinitions)LanguageParserDefinitions.INSTANCE).forLanguage(arg_0)).filter(Objects::nonNull).map(ParserDefinition::getFileNodeType).collect(Collectors.toList());
        if (collection == null) {
            IdeIndexesState.$$$reportNull$$$0(13);
        }
        return collection;
    }

    @NotNull
    private static Map<String, String> stubFileElementTypeVersions(Collection<IFileElementType> fileElementTypes) {
        HashMap<String, String> builder = new HashMap<String, String>();
        for (IFileElementType fileNodeType : fileElementTypes) {
            String newValue;
            if (!(fileNodeType instanceof IStubFileElementType)) continue;
            int stubVersion = StubSharedIndexExtension.getStubFileElementBaseVersion((IStubFileElementType)fileNodeType);
            String name = StubSharedIndexExtension.getStubFileElementTypeKey(fileNodeType);
            String oldValue = builder.put(name, newValue = Integer.toString(stubVersion));
            if (oldValue == null || oldValue.equals(newValue)) continue;
            LOG.warn("Multiple declarations of the same IFileElementType: " + name + ", old value " + oldValue + ", new value: " + newValue);
        }
        HashMap<String, String> hashMap = builder;
        if (hashMap == null) {
            IdeIndexesState.$$$reportNull$$$0(14);
        }
        return hashMap;
    }

    private void assertIsNotFrozen() {
        if (this.myIsFrozen.get()) {
            throw new IllegalStateException("getIndexVersion() has already been executed, it's too late to change IndexInfrastructureVersion");
        }
    }

    @NotNull
    public Set<FileType> getNoSizeLimitApplicableFileTypes() {
        Set<FileType> set = this.exportableFileBasedIndexExtensions.stream().flatMap(g -> g.getFileTypesWithSizeLimitNotApplicable().stream()).collect(Collectors.toSet());
        if (set == null) {
            IdeIndexesState.$$$reportNull$$$0(15);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "osToAdd";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "capability";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versions";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileElementTypes";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/indexing/shared/platform/api/IdeIndexesState";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileBasedIndexExtensions";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubIndexExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/indexing/shared/platform/api/IdeIndexesState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexVersion";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProductVersion";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "filedBasedIndexVersions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "stubIndexVersions";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "hashProviderVersions";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllStubFileElementTypes";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "stubFileElementTypeVersions";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getNoSizeLimitApplicableFileTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addSupportedOs";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerCapability";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withStubFileTypeElements";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "withActualHashGeneratorVersions";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "filedBasedIndexVersions";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "stubIndexVersions";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hashProviderVersions";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

