/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.download;

import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a?\u0010\u0000\u001a\u0004\u0018\u0001H\u0001\"\u0004\b\u0000\u0010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00010\tH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\n\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u000b"}, d2={"handleHttpDownloadExceptions", "T", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "request", "", "url", "", "action", "Lkotlin/Function0;", "(Lcom/intellij/openapi/diagnostic/Logger;Ljava/lang/Object;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.indexing.shared"})
public final class SharedIndexesNetworkKt {
    @Nullable
    public static final <T> T handleHttpDownloadExceptions(@NotNull Logger LOG, @NotNull Object request, @NotNull String url, @NotNull Function0<? extends T> action) {
        int $i$f$handleHttpDownloadExceptions = 0;
        Intrinsics.checkNotNullParameter((Object)LOG, (String)"LOG");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        try {
            return (T)action.invoke();
        }
        catch (ConnectException e) {
            LOG.debug("Cannot connect to the host for " + url + " for " + request + ". " + e.getMessage());
        }
        catch (UnknownHostException e) {
            LOG.debug("Cannot resolve host for " + url + " for " + request + ". " + e.getMessage());
        }
        catch (SocketTimeoutException e) {
            LOG.debug("Connection expired by timeout at " + url + " for " + request + ". " + e.getMessage());
        }
        catch (HttpRequests.HttpStatusException e) {
            if (e.getStatusCode() < 500) {
                LOG.debug("No data available for " + url + " for " + request + ". " + e.getStatusCode());
            } else {
                LOG.info("No data available for " + url + " for " + request + ". " + e.getStatusCode());
            }
        }
        catch (IOException e) {
            LOG.debug("Failed to download " + url + " for " + request + ". " + e.getMessage());
        }
        catch (Throwable t) {
            if (t instanceof ControlFlowException) {
                throw t;
            }
            LOG.warn("Failed to download " + url + " for " + request + ". " + t.getMessage());
        }
        return null;
    }
}

