/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.download;

import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.intellij.indexing.shared.download.DownloadTaskContext;
import com.intellij.indexing.shared.download.IndexDownloadConsentService;
import com.intellij.indexing.shared.download.SharedIndexAuthLifetimeHolder;
import com.intellij.indexing.shared.download.SharedIndexDownloadAuthExtension;
import com.intellij.indexing.shared.download.SharedIndexDownloadAuthExtensionKt;
import com.intellij.indexing.shared.download.SharedIndexDownloadConsentStore;
import com.intellij.indexing.shared.download.SharedIndexDownloadExecutor;
import com.intellij.indexing.shared.download.SharedIndexDownloadHistoryStore;
import com.intellij.indexing.shared.download.SharedIndexDownloadInfo;
import com.intellij.indexing.shared.download.SharedIndexDownloadNotifications;
import com.intellij.indexing.shared.download.SharedIndexDownloadService;
import com.intellij.indexing.shared.download.SharedIndexDownloadService$downloadAndInstallIndexes$;
import com.intellij.indexing.shared.download.SharedIndexDownloadServiceKt;
import com.intellij.indexing.shared.download.SharedIndexId;
import com.intellij.indexing.shared.download.SharedIndexLookup;
import com.intellij.indexing.shared.download.SharedIndexLookupRequest;
import com.intellij.indexing.shared.download.SharedIndexLookupResult;
import com.intellij.indexing.shared.download.SharedIndexLookupResultKt;
import com.intellij.indexing.shared.download.SharedIndexPerProjectTaskExpiration;
import com.intellij.indexing.shared.download.SharedIndexSuggestion;
import com.intellij.indexing.shared.download.SharedIndexSuggestionService;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.indexing.shared.platform.api.ChunkDescriptor;
import com.intellij.indexing.shared.platform.api.IdeIndexInfrastructureVersion;
import com.intellij.indexing.shared.platform.impl.DownloadIndexResult;
import com.intellij.indexing.shared.platform.impl.SharedIndexChunkConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorForCollections;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ0\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00130\u00120\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J4\u0010\u0017\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0018\u0010\u0018\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00130\u00120\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0019\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ<\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0018\u0010\u0018\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00130\u00120\u000fH\u0002J$\u0010\u001d\u001a\u00020\u000b*\u00020\u001e2\b\u0010\f\u001a\u0004\u0018\u00010\r2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J8\u0010 \u001a\u00020\u000b*\u00020\u001e2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0018\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u001bH\u0002J\u0018\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\b\u0012\u0004\u0012\u00020\u00100\"H\u0002J$\u0010#\u001a\u00020\u000b*\u00020\u001e2\b\u0010\f\u001a\u0004\u0018\u00010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006$"}, d2={"Lcom/intellij/indexing/shared/download/SharedIndexDownloadService;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "executor", "Lcom/intellij/indexing/shared/download/SharedIndexDownloadExecutor;", "getExecutor", "()Lcom/intellij/indexing/shared/download/SharedIndexDownloadExecutor;", "applySuggestions", "", "project", "Lcom/intellij/openapi/project/Project;", "suggestions", "", "Lcom/intellij/indexing/shared/download/SharedIndexSuggestion;", "collectRequests", "Lkotlin/Pair;", "Lcom/intellij/indexing/shared/download/SharedIndexLookupRequest;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "collectSuggestionsSuitableForDownload", "initiateAuthIfNeeded", "requests", "rescanNow", "resolveIndexes", "", "Lcom/intellij/indexing/shared/download/SharedIndexLookupResult;", "doDownloadSharedIndexes", "Lcom/intellij/indexing/shared/download/DownloadTaskContext;", "actualSuggestions", "downloadAndInstallIndexes", "mergeSameSuggestions", "", "processSuggestions", "intellij.indexing.shared"})
public final class SharedIndexDownloadService {
    private final Logger LOG;

    private final SharedIndexDownloadExecutor getExecutor() {
        boolean $i$f$service = false;
        Class<SharedIndexDownloadExecutor> serviceClass$iv = SharedIndexDownloadExecutor.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
        }
        return (SharedIndexDownloadExecutor)object;
    }

    public final void rescanNow(@Nullable Project project) {
        if (!SharedIndexDownloadServiceKt.access$isEnabled() || project == null) {
            return;
        }
        SharedIndexPerProjectTaskExpiration.Token expiration = SharedIndexPerProjectTaskExpiration.Companion.registerNewTask(project);
        this.getExecutor().submitPreProgressSync(project, (Function1<? super DownloadTaskContext, Unit>)((Function1)new Function1<DownloadTaskContext, Unit>(this, expiration, project){
            final /* synthetic */ SharedIndexDownloadService this$0;
            final /* synthetic */ SharedIndexPerProjectTaskExpiration.Token $expiration;
            final /* synthetic */ Project $project;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull DownloadTaskContext $this$submitPreProgressSync) {
                boolean $i$f$service;
                List list;
                SharedIndexDownloadService sharedIndexDownloadService;
                Intrinsics.checkNotNullParameter((Object)$this$submitPreProgressSync, (String)"$receiver");
                if (this.$expiration.isExpired()) {
                    return;
                }
                SharedIndexDownloadService sharedIndexDownloadService2 = this.this$0;
                try {
                    sharedIndexDownloadService = sharedIndexDownloadService2;
                    list = SharedIndexDownloadService.access$collectSuggestionsSuitableForDownload(this.this$0, this.$project);
                }
                catch (Throwable throwable) {
                    void t;
                    SharedIndexDownloadService sharedIndexDownloadService3 = sharedIndexDownloadService2;
                    if (t instanceof ControlFlowException) {
                        throw t;
                    }
                    SharedIndexDownloadService.access$getLOG$p(this.this$0).warn("Failed to collect suggested shared indexes. " + t.getMessage(), (Throwable)t);
                    return;
                }
                List suggestions = SharedIndexDownloadService.access$mergeSameSuggestions(sharedIndexDownloadService, list);
                if (suggestions.isEmpty()) {
                    return;
                }
                if (!ProjectUtil.isNotificationSilentMode((Project)this.$project)) {
                    Project $this$service$iv = this.$project;
                    $i$f$service = false;
                    Object object = $this$service$iv.getService(IndexDownloadConsentService.class);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
                    ((IndexDownloadConsentService)object).askForMoreDownloads(suggestions);
                }
                $i$f$service = false;
                Class<SharedIndexDownloadConsentStore> serviceClass$iv = SharedIndexDownloadConsentStore.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
                }
                List<SharedIndexSuggestion> actualSuggestions = ((SharedIndexDownloadConsentStore)((Object)object)).filterAllowed(suggestions);
                if (actualSuggestions.isEmpty()) {
                    return;
                }
                $this$submitPreProgressSync.queueChildTask((Function0<Unit>)((Function0)new Function0<Unit>(this, actualSuggestions){
                    final /* synthetic */ rescanNow.1 this$0;
                    final /* synthetic */ List $actualSuggestions;

                    public final void invoke() {
                        this.this$0.this$0.applySuggestions(this.this$0.$project, this.$actualSuggestions);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$actualSuggestions = list;
                        super(0);
                    }
                }));
            }
            {
                this.this$0 = sharedIndexDownloadService;
                this.$expiration = token;
                this.$project = project;
                super(1);
            }
        }));
    }

    public final void applySuggestions(@Nullable Project project, @NotNull List<? extends SharedIndexSuggestion> suggestions) {
        Intrinsics.checkNotNullParameter(suggestions, (String)"suggestions");
        if (!SharedIndexDownloadServiceKt.access$isEnabled() || suggestions.isEmpty()) {
            return;
        }
        this.getExecutor().submitPreProgressSync(project, (Function1<? super DownloadTaskContext, Unit>)((Function1)new Function1<DownloadTaskContext, Unit>(this, project, suggestions){
            final /* synthetic */ SharedIndexDownloadService this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ List $suggestions;

            public final void invoke(@NotNull DownloadTaskContext $this$submitPreProgressSync) {
                Intrinsics.checkNotNullParameter((Object)$this$submitPreProgressSync, (String)"$receiver");
                SharedIndexDownloadService.access$doDownloadSharedIndexes(this.this$0, $this$submitPreProgressSync, this.$project, SharedIndexDownloadService.access$mergeSameSuggestions(this.this$0, this.$suggestions));
            }
            {
                this.this$0 = sharedIndexDownloadService;
                this.$project = project;
                this.$suggestions = list;
                super(1);
            }
        }));
    }

    private final void doDownloadSharedIndexes(DownloadTaskContext $this$doDownloadSharedIndexes, Project project, List<? extends SharedIndexSuggestion> actualSuggestions) {
        this.processSuggestions($this$doDownloadSharedIndexes, project, actualSuggestions);
    }

    /*
     * WARNING - void declaration
     */
    private final List<SharedIndexSuggestion> mergeSameSuggestions(Collection<? extends SharedIndexSuggestion> $this$mergeSameSuggestions) {
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = $this$mergeSameSuggestions;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            SharedIndexSuggestion sharedIndexSuggestion = (SharedIndexSuggestion)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            SharedIndexId sharedIndexId = it.getSharedIndexId();
            map.put(sharedIndexId, element$iv$iv);
        }
        return CollectionsKt.toList((Iterable)destination$iv$iv.values());
    }

    /*
     * WARNING - void declaration
     */
    private final List<SharedIndexSuggestion> collectSuggestionsSuitableForDownload(Project project) {
        List list;
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Iterable $this$service$iv;
        boolean $i$f$service = false;
        Project serviceClass$iv = SharedIndexDownloadHistoryStore.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
        }
        SharedIndexDownloadHistoryStore history = (SharedIndexDownloadHistoryStore)((Object)object);
        serviceClass$iv = project;
        boolean $i$f$service2 = false;
        Object object2 = $this$service$iv.getService(SharedIndexSuggestionService.class);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getService(T::class.java)");
        $this$service$iv = ((SharedIndexSuggestionService)object2).resolveSuggestions();
        boolean $i$f$groupBy = false;
        void var6_8 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object3;
            SharedIndexSuggestion it = (SharedIndexSuggestion)element$iv$iv;
            boolean bl = false;
            Boolean key$iv$iv = SharedIndexDownloadHistoryStore.isDownloadMakeSenseFor$default(history, it.getSharedIndexId(), false, 2, null);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object3 = answer$iv$iv$iv;
            } else {
                object3 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object3;
            list$iv$iv.add(element$iv$iv);
        }
        Map allSuggestions = destination$iv$iv;
        List list2 = (List)allSuggestions.get(false);
        if (list2 != null) {
            List list3 = list2;
            boolean bl = false;
            boolean bl3 = false;
            List it = list3;
            boolean bl4 = false;
            this.LOG.info("There is no need to download shared indexes for " + CollectionsKt.joinToString$default((Iterable)it, null, null, null, (int)0, null, null, (int)63, null) + ". Similar compatible shared indexes are available locally.");
        }
        if ((list = (List)allSuggestions.get(true)) == null) {
            boolean bl = false;
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final void processSuggestions(DownloadTaskContext $this$processSuggestions, Project project, List<? extends SharedIndexSuggestion> suggestions) {
        List<Pair<SharedIndexSuggestion, SharedIndexLookupRequest>> requests = this.collectRequests($this$processSuggestions.getIndicator(), suggestions);
        if (requests.isEmpty()) {
            return;
        }
        this.initiateAuthIfNeeded(project, requests, $this$processSuggestions.getIndicator());
        Map<SharedIndexLookupResult, List<SharedIndexSuggestion>> indexes = this.resolveIndexes($this$processSuggestions.getIndicator(), requests);
        if (indexes.isEmpty()) {
            return;
        }
        $this$processSuggestions.showBackgroundableProgress();
        this.downloadAndInstallIndexes($this$processSuggestions, project, $this$processSuggestions.getIndicator(), indexes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final List<Pair<SharedIndexSuggestion, SharedIndexLookupRequest>> collectRequests(ProgressIndicator indicator, List<? extends SharedIndexSuggestion> suggestions) {
        indicator.setText(SharedIndexesBundle.message("progress.text.resolving.shared.indexes.requests", new Object[0]));
        Collection $this$mapWithProgress$iv = suggestions;
        boolean $i$f$mapWithProgress = false;
        indicator.checkCanceled();
        boolean bl = false;
        List result$iv = new ArrayList();
        Collection $this$forEachWithProgress$iv$iv = $this$mapWithProgress$iv;
        boolean $i$f$forEachWithProgress = false;
        ProgressIndicator $this$withPushPop$iv$iv$iv = indicator;
        boolean $i$f$withPushPop = false;
        boolean wasIndeterminate$iv$iv$iv = $this$withPushPop$iv$iv$iv.isIndeterminate();
        $this$withPushPop$iv$iv$iv.pushState();
        try {
            boolean bl2 = false;
            indicator.setIndeterminate(false);
            indicator.checkCanceled();
            double size$iv$iv = $this$forEachWithProgress$iv$iv.size();
            boolean bl3 = false;
            for (Object y$iv$iv : (Iterable)$this$forEachWithProgress$iv$iv) {
                Pair pair;
                Collection collection;
                String prevText2$iv$iv;
                String prevText$iv$iv;
                void i$iv$iv;
                block8: {
                    Pair pair2;
                    void it$iv;
                    indicator.checkCanceled();
                    double lowerBound$iv$iv = (double)i$iv$iv / size$iv$iv;
                    double upperBound$iv$iv = (double)(i$iv$iv + true) / size$iv$iv;
                    indicator.setFraction(lowerBound$iv$iv);
                    prevText$iv$iv = indicator.getText();
                    prevText2$iv$iv = indicator.getText2();
                    ProgressIndicator progressIndicator = ProgressIndicatorForCollections.scaleFraction((ProgressIndicator)indicator, (double)lowerBound$iv$iv, (double)upperBound$iv$iv);
                    Object y$iv = y$iv$iv;
                    boolean bl4 = false;
                    collection = result$iv;
                    void var27_27 = it$iv;
                    SharedIndexSuggestion it = (SharedIndexSuggestion)y$iv;
                    boolean bl5 = false;
                    try {
                        void subIndicator;
                        SharedIndexLookupRequest request = it.resolveRequest((ProgressIndicator)subIndicator);
                        if (request == null) {
                            pair = null;
                            break block8;
                        }
                        pair2 = TuplesKt.to((Object)it, (Object)request);
                    }
                    catch (Throwable e) {
                        if (e instanceof ControlFlowException) {
                            throw e;
                        }
                        this.LOG.warn("Failed to create for shared index request for " + it + ". " + e.getMessage(), e);
                        pair2 = null;
                    }
                    pair = pair2;
                }
                Pair pair3 = pair;
                boolean bl6 = false;
                collection.add(pair3);
                indicator.setText(prevText$iv$iv);
                indicator.setText2(prevText2$iv$iv);
                ++i$iv$iv;
            }
            indicator.setFraction(1.0);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$withPushPop$iv$iv$iv.setIndeterminate(wasIndeterminate$iv$iv$iv);
            $this$withPushPop$iv$iv$iv.popState();
        }
        indicator.checkCanceled();
        return CollectionsKt.filterNotNull((Iterable)CollectionsKt.toList((Iterable)result$iv));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void initiateAuthIfNeeded(Project project, List<? extends Pair<? extends SharedIndexSuggestion, ? extends SharedIndexLookupRequest>> requests, ProgressIndicator indicator) {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Pair it$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        indicator.checkCanceled();
        Iterable iterable = requests;
        boolean $i$f$mapNotNull = false;
        void var7_6 = $this$mapNotNull$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            SharedIndexDownloadAuthExtension auth;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Pair it = (Pair)element$iv$iv;
            boolean bl2 = false;
            if ((SharedIndexDownloadAuthExtensionKt.resolveIndexDownloadAuthExtension(((SharedIndexLookupRequest)it.getSecond()).getAuthId()) == null ? null : TuplesKt.to((Object)auth, (Object)it.getFirst())) == null) continue;
            pair = pair;
            boolean bl3 = false;
            boolean bl4 = false;
            it$iv$iv = pair;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$mapNotNullTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it;
            Object object;
            Pair it2 = (Pair)element$iv$iv;
            boolean $i$a$-groupBy-SharedIndexDownloadService$initiateAuthIfNeeded$auths$42 = false;
            SharedIndexDownloadAuthExtension key$iv$iv = (SharedIndexDownloadAuthExtension)it2.getFirst();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            Pair $i$a$-groupBy-SharedIndexDownloadService$initiateAuthIfNeeded$auths$42 = (Pair)element$iv$iv;
            List list = list$iv$iv;
            boolean bl = false;
            SharedIndexSuggestion sharedIndexSuggestion = (SharedIndexSuggestion)it.getSecond();
            list.add(sharedIndexSuggestion);
        }
        Object auths = destination$iv$iv;
        if (auths.isEmpty()) {
            return;
        }
        indicator.setText(SharedIndexesBundle.message("progress.text.auth", new Object[0]));
        Collection $this$forEachWithProgress$iv = auths.entrySet();
        boolean $i$f$forEachWithProgress = false;
        ProgressIndicator $this$withPushPop$iv$iv = indicator;
        boolean $i$f$withPushPop = false;
        boolean wasIndeterminate$iv$iv = $this$withPushPop$iv$iv.isIndeterminate();
        $this$withPushPop$iv$iv.pushState();
        try {
            boolean bl = false;
            indicator.setIndeterminate(false);
            indicator.checkCanceled();
            double size$iv = $this$forEachWithProgress$iv.size();
            boolean it = false;
            for (Object y$iv : (Iterable)$this$forEachWithProgress$iv) {
                void auth;
                void i$iv;
                indicator.checkCanceled();
                double lowerBound$iv = (double)i$iv / size$iv;
                double upperBound$iv = (double)(i$iv + true) / size$iv;
                indicator.setFraction(lowerBound$iv);
                String prevText$iv = indicator.getText();
                String prevText2$iv = indicator.getText2();
                it$iv$iv = ProgressIndicatorForCollections.scaleFraction((ProgressIndicator)indicator, (double)lowerBound$iv, (double)upperBound$iv);
                Map.Entry $dstr$auth$suggestions = (Map.Entry)y$iv;
                boolean bl6 = false;
                Map.Entry entry = $dstr$auth$suggestions;
                boolean bl7 = false;
                SharedIndexDownloadAuthExtension sharedIndexDownloadAuthExtension = (SharedIndexDownloadAuthExtension)entry.getKey();
                entry = $dstr$auth$suggestions;
                bl7 = false;
                List suggestions = (List)entry.getValue();
                try {
                    void subProgress;
                    subProgress.setText2(auth.getPresentableName());
                    String string2 = SharedIndexesBundle.message("auth.presentable.text", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SharedIndexesBundle.mess\u2026(\"auth.presentable.text\")");
                    auth.checkAuthenticated(string2, (ProgressIndicator)subProgress, SharedIndexAuthLifetimeHolder.Companion.getNextDisposable(project), (Function0<Unit>)((Function0)new Function0<Unit>(suggestions, this, project){
                        final /* synthetic */ List $suggestions;
                        final /* synthetic */ SharedIndexDownloadService this$0;
                        final /* synthetic */ Project $project$inlined;
                        {
                            this.$suggestions = list;
                            this.this$0 = sharedIndexDownloadService;
                            this.$project$inlined = project;
                            super(0);
                        }

                        public final void invoke() {
                            this.this$0.applySuggestions(this.$project$inlined, this.$suggestions);
                        }
                    }));
                }
                catch (Throwable t) {
                    if (t instanceof ControlFlowException) {
                        throw t;
                    }
                    this.LOG.warn("Failed to check for authentication with " + auth + ". " + t.getMessage(), t);
                }
                indicator.setText(prevText$iv);
                indicator.setText2(prevText2$iv);
                ++i$iv;
            }
            indicator.setFraction(1.0);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$withPushPop$iv$iv.setIndeterminate(wasIndeterminate$iv$iv);
            $this$withPushPop$iv$iv.popState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Map<SharedIndexLookupResult, List<SharedIndexSuggestion>> resolveIndexes(ProgressIndicator indicator, List<? extends Pair<? extends SharedIndexSuggestion, ? extends SharedIndexLookupRequest>> requests) {
        ProgressIndicator $this$withPushPop$iv = indicator;
        boolean $i$f$withPushPop = false;
        boolean wasIndeterminate$iv = $this$withPushPop$iv.isIndeterminate();
        $this$withPushPop$iv.pushState();
        try {
            void $this$mapValuesTo$iv$iv;
            void $this$mapValues$iv;
            void $this$groupByTo$iv$iv;
            Map $this$groupBy$iv;
            SharedIndexLookupResult lookupResult;
            Iterable lookupRequest;
            List suggestions;
            SharedIndexSuggestion sharedIndexSuggestion;
            Object object;
            Object list$iv$iv;
            Iterable answer$iv$iv$iv;
            Object key$iv$iv;
            Object element$iv$iv;
            void $this$groupByTo$iv$iv2;
            void $this$groupBy$iv2;
            boolean bl = false;
            IdeIndexInfrastructureVersion ideIndexInfrastructureVersion = IdeIndexInfrastructureVersion.getIdeVersion();
            Intrinsics.checkNotNullExpressionValue((Object)ideIndexInfrastructureVersion, (String)"IdeIndexInfrastructureVersion.getIdeVersion()");
            IdeIndexInfrastructureVersion ideVersion = ideIndexInfrastructureVersion;
            indicator.setText(SharedIndexesBundle.message("progress.text.resolving.shared.indexes.checking", new Object[0]));
            indicator.setIndeterminate(false);
            Iterable iterable = requests;
            boolean $i$f$groupBy = false;
            void var10_11 = $this$groupBy$iv2;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            Object object2 = $this$groupByTo$iv$iv2.iterator();
            while (object2.hasNext()) {
                void it;
                Object object3;
                element$iv$iv = object2.next();
                Pair it2 = (Pair)element$iv$iv;
                boolean $i$a$-groupBy-SharedIndexDownloadService$resolveIndexes$1$uniqueRequests$32 = false;
                key$iv$iv = (SharedIndexLookupRequest)it2.getSecond();
                Map $this$getOrPut$iv$iv$iv2 = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv2.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv2.put(key$iv$iv, answer$iv$iv$iv);
                    object3 = answer$iv$iv$iv;
                } else {
                    object3 = value$iv$iv$iv;
                }
                list$iv$iv = (List)object3;
                Pair $i$a$-groupBy-SharedIndexDownloadService$resolveIndexes$1$uniqueRequests$32 = (Pair)element$iv$iv;
                object = list$iv$iv;
                boolean bl3 = false;
                sharedIndexSuggestion = (SharedIndexSuggestion)it.getFirst();
                object.add(sharedIndexSuggestion);
            }
            Set uniqueRequests = destination$iv$iv.entrySet();
            boolean $i$f$service = false;
            Class<SharedIndexLookup> serviceClass$iv = SharedIndexLookup.class;
            Object object4 = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object4 == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
            }
            SharedIndexLookup indexLookup = (SharedIndexLookup)object4;
            SetMultimap responses = MultimapBuilder.linkedHashKeys().linkedHashSetValues().build();
            ArrayDeque basesToProcess = new ArrayDeque();
            double processed = 0.0;
            element$iv$iv = uniqueRequests.iterator();
            while (element$iv$iv.hasNext()) {
                void lookupRequest2;
                key$iv$iv = object2 = (Map.Entry)element$iv$iv.next();
                boolean $this$getOrPut$iv$iv$iv2 = false;
                list$iv$iv = (SharedIndexLookupRequest)key$iv$iv.getKey();
                key$iv$iv = object2;
                $this$getOrPut$iv$iv$iv2 = false;
                suggestions = (List)key$iv$iv.getValue();
                double d = processed;
                processed = d + 1.0;
                indicator.setFraction(d / (double)(basesToProcess.size() + uniqueRequests.size()));
                try {
                    void $this$mapTo$iv$iv;
                    SharedIndexLookupResult lookupResult2;
                    if (indexLookup.lookupSharedIndex((SharedIndexLookupRequest)lookupRequest2, ideVersion, indicator) == null) {
                        continue;
                    }
                    responses.putAll((Object)lookupResult2, (Iterable)suggestions);
                    Collection $this$getOrPut$iv$iv$iv2 = (Collection)basesToProcess;
                    Iterable $this$map$iv = lookupResult2.resolveBaseRequests();
                    boolean $i$f$map2 = false;
                    answer$iv$iv$iv = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                        void it;
                        SharedIndexLookupRequest sharedIndexLookupRequest = (SharedIndexLookupRequest)item$iv$iv2;
                        object = destination$iv$iv2;
                        boolean bl4 = false;
                        sharedIndexSuggestion = TuplesKt.to((Object)it, (Object)suggestions);
                        object.add(sharedIndexSuggestion);
                    }
                    $this$map$iv = (List)destination$iv$iv2;
                    $i$f$map2 = false;
                    CollectionsKt.addAll((Collection)$this$getOrPut$iv$iv$iv2, (Iterable)$this$map$iv);
                }
                catch (Throwable e) {
                    if (e instanceof ControlFlowException) {
                        throw e;
                    }
                    this.LOG.warn("Failed to lookup for shared index " + lookupRequest2 + " (" + suggestions + "). " + e.getMessage(), e);
                }
            }
            int totalItems = basesToProcess.size() + uniqueRequests.size();
            while (true) {
                void $this$mapTo$iv$iv;
                element$iv$iv = (Collection)basesToProcess;
                boolean lookupRequest2 = false;
                if (!(!element$iv$iv.isEmpty())) break;
                double d = processed;
                processed = d + 1.0;
                indicator.setFraction(d / (double)totalItems);
                if ((Pair)basesToProcess.removeFirstOrNull() == null) {
                    break;
                }
                element$iv$iv = (SharedIndexLookupRequest)suggestions.component1();
                List suggestions2 = (List)suggestions.component2();
                if (indexLookup.lookupSharedIndex((SharedIndexLookupRequest)((Object)lookupRequest), ideVersion, indicator) == null) {
                    continue;
                }
                if (responses.containsKey((Object)lookupResult)) continue;
                responses.putAll((Object)lookupResult, (Iterable)suggestions2);
                Collection e = (Collection)basesToProcess;
                Iterable $this$map$iv = lookupResult.resolveBaseRequests();
                boolean $i$f$map = false;
                Iterable $i$f$map2 = $this$map$iv;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Object item$iv$iv2;
                    item$iv$iv2 = (SharedIndexLookupRequest)item$iv$iv;
                    object = destination$iv$iv3;
                    boolean bl5 = false;
                    sharedIndexSuggestion = TuplesKt.to((Object)it, (Object)suggestions2);
                    object.add(sharedIndexSuggestion);
                }
                $this$map$iv = (List)destination$iv$iv3;
                $i$f$map = false;
                CollectionsKt.addAll((Collection)e, (Iterable)$this$map$iv);
            }
            Set set = responses.entries();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"responses.entries()");
            lookupRequest = set;
            boolean $i$f$groupBy2 = false;
            lookupResult = $this$groupBy$iv;
            Map destination$iv$iv4 = new LinkedHashMap();
            boolean $i$f$groupByTo2 = false;
            for (Object element$iv$iv2 : $this$groupByTo$iv$iv) {
                void it;
                Object object5;
                Map.Entry it3 = (Map.Entry)element$iv$iv2;
                boolean $i$a$-groupBy-SharedIndexDownloadService$resolveIndexes$1$52 = false;
                SharedIndexLookupResult key$iv$iv2 = (SharedIndexLookupResult)it3.getKey();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv4;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv2);
                if (value$iv$iv$iv == null) {
                    boolean bl6 = false;
                    List answer$iv$iv$iv2 = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv2, answer$iv$iv$iv2);
                    object5 = answer$iv$iv$iv2;
                } else {
                    object5 = value$iv$iv$iv;
                }
                List list$iv$iv2 = (List)object5;
                Map.Entry $i$a$-groupBy-SharedIndexDownloadService$resolveIndexes$1$52 = (Map.Entry)element$iv$iv2;
                object = list$iv$iv2;
                boolean bl7 = false;
                sharedIndexSuggestion = (SharedIndexSuggestion)it.getValue();
                object.add(sharedIndexSuggestion);
            }
            $this$groupBy$iv = destination$iv$iv4;
            boolean $i$f$mapValues = false;
            $this$groupByTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv4 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry key$iv$iv2 = (Map.Entry)element$iv$iv$iv;
                Map map = destination$iv$iv4;
                boolean bl8 = false;
                Object k = it$iv$iv.getKey();
                Map.Entry answer$iv$iv$iv2 = (Map.Entry)element$iv$iv$iv;
                sharedIndexSuggestion = k;
                object = map;
                boolean bl9 = false;
                List<SharedIndexSuggestion> list = this.mergeSameSuggestions((Collection)it.getValue());
                object.put(sharedIndexSuggestion, list);
            }
            Map map = destination$iv$iv4;
            return map;
        }
        finally {
            $this$withPushPop$iv.setIndeterminate(wasIndeterminate$iv);
            $this$withPushPop$iv.popState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void downloadAndInstallIndexes(DownloadTaskContext $this$downloadAndInstallIndexes, Project project, ProgressIndicator indicator, Map<SharedIndexLookupResult, ? extends List<? extends SharedIndexSuggestion>> requests) {
        Collection $this$sortedBy$iv;
        indicator.setText(SharedIndexesBundle.message("progress.text.resolving.shared.indexes.installing", new Object[0]));
        boolean bl = false;
        List infos = new ArrayList();
        Iterable iterable = requests.entrySet();
        boolean $i$f$sortedBy = false;
        boolean bl2 = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Map.Entry $dstr$lookupResult = (Map.Entry)a;
                boolean bl2 = false;
                Map.Entry entry = $dstr$lookupResult;
                boolean bl3 = false;
                SharedIndexLookupResult lookupResult = (SharedIndexLookupResult)entry.getKey();
                $dstr$lookupResult = (Map.Entry)b;
                Comparable comparable = Long.valueOf(lookupResult.getSize());
                bl2 = false;
                entry = $dstr$lookupResult;
                bl3 = false;
                lookupResult = (SharedIndexLookupResult)entry.getKey();
                Long l = lookupResult.getSize();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)l);
            }
        });
        boolean $i$f$forEachWithProgress = false;
        ProgressIndicator $this$withPushPop$iv$iv = indicator;
        boolean $i$f$withPushPop = false;
        boolean wasIndeterminate$iv$iv = $this$withPushPop$iv$iv.isIndeterminate();
        $this$withPushPop$iv$iv.pushState();
        try {
            void $this$forEachWithProgress$iv;
            boolean bl3 = false;
            indicator.setIndeterminate(false);
            indicator.checkCanceled();
            double size$iv = $this$forEachWithProgress$iv.size();
            boolean bl4 = false;
            for (Object y$iv : (Iterable)$this$forEachWithProgress$iv) {
                void lookupResult;
                void i$iv;
                indicator.checkCanceled();
                double lowerBound$iv = (double)i$iv / size$iv;
                double upperBound$iv = (double)(i$iv + true) / size$iv;
                indicator.setFraction(lowerBound$iv);
                String prevText$iv = indicator.getText();
                String prevText2$iv = indicator.getText2();
                ProgressIndicator progressIndicator = ProgressIndicatorForCollections.scaleFraction((ProgressIndicator)indicator, (double)lowerBound$iv, (double)upperBound$iv);
                Map.Entry $dstr$lookupResult$suggestions = (Map.Entry)y$iv;
                boolean bl5 = false;
                Map.Entry entry = $dstr$lookupResult$suggestions;
                boolean bl6 = false;
                SharedIndexLookupResult sharedIndexLookupResult = (SharedIndexLookupResult)entry.getKey();
                entry = $dstr$lookupResult$suggestions;
                bl6 = false;
                List suggestions = (List)entry.getValue();
                try {
                    DownloadIndexResult hadDownloadedSomething;
                    void subIndicator;
                    this.LOG.info("Fetching shared index: " + lookupResult + " (" + suggestions + ')');
                    ChunkDescriptor chunkDescriptorToDownload = new ChunkDescriptor((SharedIndexLookupResult)lookupResult, this, $this$downloadAndInstallIndexes, project, infos){
                        @NotNull
                        private final String chunkUniqueId;
                        @NotNull
                        private final String kind;
                        final /* synthetic */ SharedIndexLookupResult $lookupResult;
                        final /* synthetic */ SharedIndexDownloadService this$0;
                        final /* synthetic */ DownloadTaskContext $this_downloadAndInstallIndexes$inlined;
                        final /* synthetic */ Project $project$inlined;
                        final /* synthetic */ List $infos$inlined;
                        {
                            this.$lookupResult = $captured_local_variable$1;
                            this.this$0 = sharedIndexDownloadService;
                            this.$this_downloadAndInstallIndexes$inlined = downloadTaskContext;
                            this.$project$inlined = project;
                            this.$infos$inlined = list;
                            this.chunkUniqueId = $captured_local_variable$1.getChunkUniqueId();
                            this.kind = $captured_local_variable$1.getRequest().getKind();
                        }

                        @NotNull
                        public String getChunkUniqueId() {
                            return this.chunkUniqueId;
                        }

                        @NotNull
                        public String getKind() {
                            return this.kind;
                        }

                        public boolean downloadChunk(@NotNull Path targetFile, @Nullable Project project, @NotNull ProgressIndicator indicator) {
                            Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
                            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                            return (Boolean)this.$this_downloadAndInstallIndexes$inlined.suspendIndexingIfNeeded((Function0)new Function0<Boolean>(this, targetFile, project, indicator){
                                final /* synthetic */ downloadAndInstallIndexes$$inlined$forEachWithProgress$lambda$1 this$0;
                                final /* synthetic */ Path $targetFile;
                                final /* synthetic */ Project $project;
                                final /* synthetic */ ProgressIndicator $indicator;
                                {
                                    this.this$0 = var1_1;
                                    this.$targetFile = path;
                                    this.$project = project;
                                    this.$indicator = progressIndicator;
                                    super(0);
                                }

                                public final boolean invoke() {
                                    return SharedIndexLookupResultKt.downloadChunk(this.this$0.$lookupResult, this.$targetFile, this.$project, this.$indicator);
                                }
                            });
                        }

                        @NotNull
                        public String toString() {
                            return this.getChunkUniqueId();
                        }
                    };
                    boolean $i$f$measureTimeMillis = false;
                    boolean bl7 = false;
                    long start$iv = System.currentTimeMillis();
                    boolean bl8 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)SharedIndexChunkConfiguration.getInstance().downloadChunk(chunkDescriptorToDownload, project, (ProgressIndicator)subIndicator)), (String)"SharedIndexChunkConfigur\u2026d, project, subIndicator)");
                    if (hadDownloadedSomething == DownloadIndexResult.JUST_DOWNLOADED) {
                        Collection<SharedIndexId> collection;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        long downloadTime = System.currentTimeMillis() - start$iv;
                        boolean $i$f$service22 = false;
                        Class<SharedIndexDownloadHistoryStore> serviceClass$iv = SharedIndexDownloadHistoryStore.class;
                        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                        if (object == null) {
                            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
                        }
                        Iterable $i$f$service22 = suggestions;
                        SharedIndexDownloadHistoryStore sharedIndexDownloadHistoryStore = (SharedIndexDownloadHistoryStore)((Object)object);
                        boolean $i$f$map = false;
                        void var39_45 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            SharedIndexSuggestion sharedIndexSuggestion = (SharedIndexSuggestion)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl9 = false;
                            SharedIndexId sharedIndexId = it.getSharedIndexId();
                            collection.add(sharedIndexId);
                        }
                        collection = (List)destination$iv$iv;
                        sharedIndexDownloadHistoryStore.updateLastDownload((List<SharedIndexId>)collection, lookupResult.getChunkUniqueId(), lookupResult.getSize());
                        Collection collection2 = infos;
                        SharedIndexDownloadInfo sharedIndexDownloadInfo = new SharedIndexDownloadInfo(suggestions, lookupResult.getSize(), downloadTime);
                        boolean bl10 = false;
                        collection2.add(sharedIndexDownloadInfo);
                    }
                }
                catch (Throwable e) {
                    if (e instanceof ControlFlowException) {
                        throw e;
                    }
                    this.LOG.warn("Failed to download shared index " + lookupResult + " (" + suggestions + "). " + e.getMessage(), e);
                }
                indicator.setText(prevText$iv);
                indicator.setText2(prevText2$iv);
                ++i$iv;
            }
            indicator.setFraction(1.0);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$withPushPop$iv$iv.setIndeterminate(wasIndeterminate$iv$iv);
            $this$withPushPop$iv$iv.popState();
        }
        boolean $i$f$service = false;
        Class<SharedIndexDownloadNotifications> serviceClass$iv = SharedIndexDownloadNotifications.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
        }
        ((SharedIndexDownloadNotifications)object).notifySharedIndexInstalled(project, infos);
    }

    public SharedIndexDownloadService() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SharedIndexDownloadService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        this.LOG = logger;
    }

    public static final /* synthetic */ List access$mergeSameSuggestions(SharedIndexDownloadService $this, Collection $this$access_u24mergeSameSuggestions) {
        return $this.mergeSameSuggestions($this$access_u24mergeSameSuggestions);
    }

    public static final /* synthetic */ List access$collectSuggestionsSuitableForDownload(SharedIndexDownloadService $this, Project project) {
        return $this.collectSuggestionsSuitableForDownload(project);
    }

    public static final /* synthetic */ Logger access$getLOG$p(SharedIndexDownloadService $this) {
        return $this.LOG;
    }

    public static final /* synthetic */ void access$doDownloadSharedIndexes(SharedIndexDownloadService $this, DownloadTaskContext $this$access_u24doDownloadSharedIndexes, Project project, List actualSuggestions) {
        $this.doDownloadSharedIndexes($this$access_u24doDownloadSharedIndexes, project, actualSuggestions);
    }
}

